/*
 
  Copyright 2007-2022 by
 
  Laboratoire de l'Informatique du Parallelisme,
  UMR CNRS - ENS Lyon - UCB Lyon 1 - INRIA 5668,
 
  LORIA (CNRS, INPL, INRIA, UHP, U-Nancy 2),
 
  Laboratoire d'Informatique de Paris 6, equipe PEQUAN,
  UPMC Universite Paris 06 - CNRS - UMR 7606 - LIP6, Paris, France,
 
  Laboratoire d'Informatique de Paris 6 - Équipe PEQUAN
  Sorbonne Universités
  UPMC Univ Paris 06
  UMR 7606, LIP6
  Boîte Courrier 169
  4, place Jussieu
  F-75252 Paris Cedex 05
  France,
 
  Sorbonne Université
  CNRS, Laboratoire d'Informatique de Paris 6, LIP6
  F - 75005 Paris
  France,
 
  Centre de recherche INRIA Sophia Antipolis Mediterranee,
  Equipes APICS, FACTAS,
  Sophia Antipolis, France
 
  and by
 
  Department of Computer Science & Engineering
  UAA College of Engineering
  University of Alaska Anchorage.
 
  Contributors Ch. Lauter, S. Chevillard, M. Joldes
 
  christoph.lauter@christoph-lauter.org
  sylvain.chevillard@ens-lyon.org
  joldes@laas.fr
 
  This software is a computer program whose purpose is to provide an
  environment for safe floating-point code development. It is
  particularly targeted to the automated implementation of
  mathematical floating-point libraries (libm). Amongst other features,
  it offers a certified infinity norm, an automatic polynomial
  implementer and a fast Remez algorithm.
 
  This software is governed by the CeCILL-C license under French law and
  abiding by the rules of distribution of free software.  You can  use,
  modify and/ or redistribute the software under the terms of the CeCILL-C
  license as circulated by CEA, CNRS and INRIA at the following URL
  "http://www.cecill.info".
 
  As a counterpart to the access to the source code and  rights to copy,
  modify and redistribute granted by the license, users are provided only
  with a limited warranty  and the software's author,  the holder of the
  economic rights,  and the successive licensors  have only  limited
  liability.
 
  In this respect, the user's attention is drawn to the risks associated
  with loading,  using,  modifying and/or developing or reproducing the
  software by the user in light of its specific status of free software,
  that may mean  that it is complicated to manipulate,  and  that  also
  therefore means  that it is reserved for developers  and  experienced
  professionals having in-depth computer knowledge. Users are therefore
  encouraged to load and test the software's suitability as regards their
  requirements in conditions enabling the security of their systems and/or
  data to be ensured and,  more generally, to use and operate it in the
  same conditions as regards security.
 
  The fact that you are presently reading this means that you have had
  knowledge of the CeCILL-C license and that you accept its terms.
 
  This program is distributed WITHOUT ANY WARRANTY; without even the
  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 
*/
 
#ifndef HELP_H
#define HELP_H
#define HELP_PRINTFLOAT_TEXT "Name: printsingle\n==> prints a constant value as a hexadecimal single precision number\n\nUsage: \n   printsingle({constant}) : constant -> void\n\nParameters: \n   {constant} represents a constant\n\nDescription: \n   * Prints a constant value as a hexadecimal number on 8 hexadecimal\n   digits. The hexadecimal number represents the integer equivalent to\n   the 32 bit memory representation of the constant considered as a\n   single precision number.\n    \n   If the constant value does not hold on a single precision number, it\n   is first rounded to the nearest single precision number before it is\n   displayed. A warning is displayed in this case.\n\nExample 1: \n   > printsingle(3);\n   0x40400000\n\nExample 2: \n   > prec=100!;\n   > verbosity = 1!;\n   > printsingle(exp(5));\n   Warning: the given expression is not a constant but an expression to evaluate. A faithful evaluation will be used.\n   Warning: rounding down occurred before printing a value as a simple.\n   0x431469c5\n\nSee also: printdouble, single\n"
#define HELP_PRINTHEXA_TEXT "Name: printdouble\n==> prints a constant value as a hexadecimal double precision number\n\nUsage: \n   printdouble({constant}) : constant -> void\n\nParameters: \n   {constant} represents a constant\n\nDescription: \n   * Prints a constant value as a hexadecimal number on 16 hexadecimal\n   digits. The hexadecimal number represents the integer equivalent to\n   the 64 bit memory representation of the constant considered as a\n   double precision number.\n    \n   If the constant value does not hold on a double precision number, it\n   is first rounded to the nearest double precision number before\n   displayed. A warning is displayed in this case.\n\nExample 1: \n   > printdouble(3);\n   0x4008000000000000\n\nExample 2: \n   > prec=100!;\n   > verbosity = 1!;\n   > printdouble(exp(5));\n   Warning: the given expression is not a constant but an expression to evaluate. A faithful evaluation will be used.\n   Warning: rounding down occurred before printing a value as a double.\n   0x40628d389970338f\n\nSee also: printsingle, printexpansion, double\n"
#define HELP_ABSOLUTE_TEXT "Name: absolute\n==> indicates an absolute error for externalplot, fpminimax or supnorm\n\nLibrary names:\n   sollya_obj_t sollya_lib_absolute()\n   int sollya_lib_is_absolute(sollya_obj_t)\n\nUsage: \n   absolute : absolute|relative\n\nDescription: \n   * The use of absolute in the command externalplot indicates that during\n   plotting in externalplot an absolute error is to be considered.\n    \n   See externalplot for details.\n\n   * Used with fpminimax, absolute indicates that fpminimax must try to minimize\n   the absolute error.\n    \n   See fpminimax for details.\n\n   * When given in argument to supnorm, absolute indicates that an absolute error\n   is to be considered for supremum norm computation.\n    \n   See supnorm for details.\n\nExample 1: \n   > bashexecute(\"gcc -fPIC -c externalplotexample.c\");\n   > bashexecute(\"gcc -shared -o externalplotexample externalplotexample.o -lgmp -lmpfr\");\n   > externalplot(\"./externalplotexample\",absolute,exp(x),[-1/2;1/2],12,perturb);\n\nSee also: externalplot, fpminimax, relative, bashexecute, supnorm\n"
#define HELP_ABS_TEXT "Name: abs\n==> the absolute value.\n\nLibrary names:\n   sollya_obj_t sollya_lib_abs(sollya_obj_t)\n   sollya_obj_t sollya_lib_build_function_abs(sollya_obj_t)\n   #define SOLLYA_ABS(x) sollya_lib_build_function_abs(x)\n\nDescription: \n   * abs is the absolute value function. abs(x)=x if x>0 and -x otherwise.\n\n"
#define HELP_ACCURATEINFNORM_TEXT "Name: accurateinfnorm\n==> computes a faithful rounding of the infinity norm of a function \n\nUsage: \n   accurateinfnorm({function},{range},{constant}) : (function, range, constant) -> constant\n   accurateinfnorm({function},{range},{constant},{exclusion range 1},...,{exclusion range n}) : (function, range, constant, range, ..., range) -> constant\n\nParameters: \n   {function} represents the function whose infinity norm is to be computed\n   {range} represents the infinity norm is to be considered on\n   {constant} represents the number of bits in the significant of the result\n   {exclusion range 1} through {exclusion range n} represent ranges to be excluded \n\nDescription: \n   * The command accurateinfnorm computes an upper bound to the infinity norm of\n   function {function} in {range}. This upper bound is the least\n   floating-point number greater than the value of the infinity norm that\n   lies in the set of dyadic floating point numbers having {constant}\n   significant mantissa bits. This means the value accurateinfnorm evaluates to\n   is at the time an upper bound and a faithful rounding to {constant}\n   bits of the infinity norm of function {function} on range {range}.\n    \n   If given, the fourth and further arguments of the command accurateinfnorm,\n   {exclusion range 1} through {exclusion range n} the infinity norm of\n   the function {function} is not to be considered on.\n\n   * The command accurateinfnorm is now considered DEPRECATED in Sollya.\n   Users should be aware about the fact that the algorithm behind\n   accurateinfnorm is highly inefficient and that other, better suited\n   algorithms, such as supnorm, are available inside Sollya. As a\n   matter of fact, while accurateinfnorm is maintained for compatibility reasons\n   with legacy Sollya codes, users are advised to avoid using accurateinfnorm\n   in new Sollya scripts and to replace it, where possible, by the\n   supnorm command.\n\nExample 1: \n   > p = remez(exp(x), 5, [-1;1]);\n   > accurateinfnorm(p - exp(x), [-1;1], 20);\n   4.52055246569216251373291015625e-5\n   > accurateinfnorm(p - exp(x), [-1;1], 30);\n   4.5205513970358879305422306060791015625e-5\n   > accurateinfnorm(p - exp(x), [-1;1], 40);\n   4.520551396713923253400935209356248378753662109375e-5\n\nExample 2: \n   > p = remez(exp(x), 5, [-1;1]);\n   > midpointmode = on!;\n   > infnorm(p - exp(x), [-1;1]);\n   0.45205~5/7~e-4\n   > accurateinfnorm(p - exp(x), [-1;1], 40);\n   4.520551396713923253400935209356248378753662109375e-5\n\nSee also: infnorm, dirtyinfnorm, supnorm, checkinfnorm, remez, diam\n"
#define HELP_ACOSH_TEXT "Name: acosh\n==> the arg-hyperbolic cosine function.\n\nLibrary names:\n   sollya_obj_t sollya_lib_acosh(sollya_obj_t)\n   sollya_obj_t sollya_lib_build_function_acosh(sollya_obj_t)\n   #define SOLLYA_ACOSH(x) sollya_lib_build_function_acosh(x)\n\nDescription: \n   * acosh is the inverse of the function cosh: acosh(y) is the unique number \n   x in [0; +Inf] such that cosh(x)=y.\n\n   * It is defined only for y in [0; +Inf].\n\nSee also: cosh\n"
#define HELP_ACOS_TEXT "Name: acos\n==> the arccosine function.\n\nLibrary names:\n   sollya_obj_t sollya_lib_acos(sollya_obj_t)\n   sollya_obj_t sollya_lib_build_function_acos(sollya_obj_t)\n   #define SOLLYA_ACOS(x) sollya_lib_build_function_acos(x)\n\nDescription: \n   * acos is the inverse of the function cos: acos(y) is the unique number \n   x in [0; Pi] such that cos(x)=y.\n\n   * It is defined only for y in [-1; 1].\n\nSee also: cos\n"
#define HELP_AND_TEXT "Name: &&\n==> boolean AND operator\n\nLibrary name:\n   sollya_obj_t sollya_lib_and(sollya_obj_t, sollya_obj_t)\n\nUsage: \n   {expr1} && {expr2} : (boolean, boolean) -> boolean\n\nParameters: \n   {expr1} and {expr2} represent boolean expressions\n\nDescription: \n   * && evaluates to the boolean AND of the two\n   boolean expressions {expr1} and {expr2}. && evaluates to \n   true iff both {expr1} and {expr2} evaluate to true.\n\nExample 1: \n   > true && false;\n   false\n\nExample 2: \n   > (1 == exp(0)) && (0 == log(1));\n   true\n\nSee also: ||, !\n"
#define HELP_ANNOTATEFUNCTION_TEXT "Name: annotatefunction\n==> Annotates a Sollya function object with an approximation that is faster to evaluate\n\nLibrary names:\n   sollya_obj_t sollya_lib_annotatefunction(sollya_obj_t, sollya_obj_t,\n                                            sollya_obj_t, sollya_obj_t, ...);\n   sollya_obj_t sollya_lib_v_annotatefunction(sollya_obj_t, sollya_obj_t,\n                                              sollya_obj_t, sollya_obj_t,\n                                              va_list);\n\nUsage: \n   annotatefunction({f}, {g}, {I}, {d}) : (function, function, range, range) -> function\n   annotatefunction({f}, {g}, {I}, {d}, {x0}) : (function, function, range, range, constant) -> function\n\nParameters: \n   {f} is a function.\n   {g} is a function, in most cases a polynomial.\n   {I} is an interval.\n   {d} is an interval.\n   {x0} is a constant (default value is 0 when not provided).\n\nDescription: \n   * When a given function {f} is to be evaluated at several points of a given\n   interval {I} to a given precision, it might be useful to precompute a good\n   approximant {g} of {f} and further evaluate it instead of {f} when the\n   approximation is good enough to provide the desire precision. If {f} is a\n   complicated expression, whereas {g} is, e.g., a polynomial of low degree,\n   the cost of precomputing {g} can be well compensated by the gain of time in\n   each subsequent evaluation. The purpose of annotatefunction is to provide\n   such a mechanism to the user.\n\n   * When using annotatefunction({f}, {g}, {I}, {d}, {x0}),\n   resp. annotatefunction({f}, {g}, {I}, {d}) (where {x0} is assumed to be\n   zero), it is assumed that\n    \n                   forall x in I, f(x) - g(x - x0) in d.\n    \n   It is the user responsibility to ensure this property. Otherwise, any\n   subsequent use of {f} on points of {I} might lead to incorrect values.\n\n   * A call to annotatefunction({f}, {g}, {I}, {d}, {x0}) annotates the given\n   Sollya function object {f} with the approximation {g}. In further use, when\n   asked to evaluate {f} on a point x of {I}, Sollya will first evaluate {g}\n   on x-x0 and check if the result is accurate enough in the given context\n   (accounting for the fact that the error of approximation between the true\n   value and g(x-x0) belongs to {d}). If not (and only in this case), an\n   evaluation of the expression of {f} on x is performed.\n\n   * The approximation {g} can be any Sollya function but particular\n   performance is expected when {g} is a polynomial. Upon annotation with a\n   polynomial, precomputations are performed to analyze certain properties of\n   the given approximation polynomial.\n\n   * annotatefunction updates the internal representation of {f} so as to\n   persistently keep this information attached with the Sollya object\n   representing {f}. In particular, the annotation is persistent through copy\n   or use of {f} as a subexpression to build up bigger expressions. Notice\n   however, that there is no way of deducing an annotation for the derivative\n   of {f} from an annotation of {f}. So, in general, it should not be expected\n   that diff({f}) will be automatically annotated (notice, however that {f}\n   might be a subexpression of its derivative, e.g., for {f}=exp or {f}=tan, in\n   which case the corresponding subexpressions of the derivative could inherit\n   the annotations from {f}. It is currently not specified whether Sollya does\n   this automatically or not).\n\n   * annotatefunction really is an imperative statement that modifies the\n   internal representation of {f}. However, for convenience annotatefunction\n   returns {f} itself.\n\n   * Sollya function objects can be annotated more than once with different\n   approximations on different domains, that do not need to be disjoint. Upon\n   evaluation of the annotated function object, Sollya chooses an\n   approximation annotation (if any) that provides for sufficient accuracy at\n   the evaluation point. It is not specified in which order Sollya tries\n   different possible annotations when several are available for a given\n   point {x}.\n\nExample 1: \n   > verbosity=1!;\n   > procedure EXP(X,n,p) {\n               var res, oldPrec;\n               oldPrec = prec;\n               prec = p!;\n               \"Using procedure function exponential with X=\" @ X @ \", n=\" @ n @ \", and p=\" @ p;\n               res = exp(X);\n               prec = oldPrec!;\n               return res;\n          };\n   > g = function(EXP);\n   > p = 46768052394588893382516870161332864698044514954899b-165 + x * (23384026197294446691258465802074096632225783601255b-164 + x * (5846006549323611672948426613035653821819225877423b-163 + x * (3897337699549074448627696490806815137319821946501b-164 + x * (7794675399098148717422744621371434831048848817417b-167 + x * (24942961277114075921122941174178849425809856036737b-171 + x * (8314320425704876115613838900105097456456371179471b-172 + x * (19004160973039701371579356991645932289422670402995b-176 + x * (19004160972669324148912122254449912156003926801563b-179 + x * (33785175062542597526738679493857229456702396042255b-183 + x * (6757035113643674378393625988264926886191860669891b-184 + x * (9828414707511252769908089206114262766633532289937b-188 + x * (26208861108003813314724515233584738706961162212965b-193 + x * (32257064253325954315953742396999456577223350602741b-197 + x * (578429089657689569703509185903214676926704485495b-195 + x * 2467888542176675658523627105540996778984959471957b-201))))))))))))));\n   > h = annotatefunction(g, p, [-1/2;1/2], [-475294848522543b-124;475294848522543b-124]);\n   > h == g;\n   true\n   > prec = 24;\n   The precision has been set to 24 bits.\n   > h(0.25);\n   Warning: rounding has happened. The value displayed is a faithful rounding to 24 bits of the true result.\n   Warning: For at least 1 of the constants displayed in decimal, rounding has happened.\n   1.2840254\n   > prec = 165;\n   The precision has been set to 165 bits.\n   > h(0.25);\n   Using procedure function exponential with X=[0.25;0.25], n=0, and p=185\n   Warning: rounding has happened. The value displayed is a faithful rounding to 165 bits of the true result.\n   Warning: For at least 1 of the constants displayed in decimal, rounding has happened.\n   1.28402541668774148407342056806243645833628086528147\n\nSee also: chebyshevform, taylorform, remez, supnorm, infnorm\n"
#define HELP_APPEND_TEXT "Name: :.\n==> add an element at the end of a list.\n\nLibrary name:\n   sollya_obj_t sollya_lib_append(sollya_obj_t, sollya_obj_t)\n\nUsage: \n   {L}:.{x} : (list, any type) -> list\n\nParameters: \n   {L} is a list (possibly empty).\n   {x} is an object of any type.\n\nDescription: \n   * :. adds the element {x} at the end of the list {L}.\n\n   * Note that since {x} may be of any type, it can in particular be a list.\n\nExample 1: \n   > [|2,3,4|]:.5;\n   [|2, 3, 4, 5|]\n\nExample 2: \n   > [|1,2,3|]:.[|4,5,6|];\n   [|1, 2, 3, [|4, 5, 6|]|]\n\nExample 3: \n   > [||]:.1;\n   [|1|]\n\nSee also: .:, @\n"
#define HELP_APPROX_TEXT "Name: ~\n==> floating-point evaluation of a constant expression\n\nLibrary name:\n   sollya_obj_t sollya_lib_approx(sollya_obj_t)\n\nUsage: \n   ~ {expression} : function -> constant\n   ~ {something} : any type -> any type\n\nParameters: \n   {expression} stands for an expression that is a constant\n   {something} stands for some language element that is not a constant expression\n\nDescription: \n   * ~ {expression} evaluates the {expression} that is a constant\n   term to a floating-point constant. The evaluation may involve a\n   rounding. If {expression} is not a constant, the evaluated constant is\n   a faithful rounding of {expression} with precision bits, unless the\n   {expression} is exactly 0 as a result of cancellation. In the\n   latter case, a floating-point approximation of some (unknown) accuracy\n   is returned.\n\n   * ~ does not do anything on all language elements that are not a\n   constant expression.  In other words, it behaves like the identity\n   function on any type that is not a constant expression. It can hence\n   be used in any place where one wants to be sure that expressions are\n   simplified using floating-point computations to constants of a known\n   precision, regardless of the type of actual language elements.\n\n   * ~ error evaluates to error and provokes a warning.\n\n   * ~ is a prefix operator not requiring parentheses. Its\n   precedence is the same as for the unary + and -\n   operators. It cannot be repeatedly used without brackets.\n\nExample 1: \n   > print(exp(5));\n   exp(5)\n   > print(~ exp(5));\n   148.41315910257660342111558004055227962348766759388\n\nExample 2: \n   > autosimplify = off!;\n\nExample 3: \n   > print(~sin(5 * pi));\n   0\n\nExample 4: \n   > print(~exp(x));\n   exp(x)\n   > print(~ \"Hello\");\n   Hello\n\nExample 5: \n   > print(~exp(x*5*Pi));\n   exp((pi) * 5 * x)\n   > print(exp(x* ~(5*Pi)));\n   exp(x * 15.7079632679489661923132169163975144209858469968757)\n\nExample 6: \n   > print(~exp(5)*x);\n   148.41315910257660342111558004055227962348766759388 * x\n   > print( (~exp(5))*x);\n   148.41315910257660342111558004055227962348766759388 * x\n   > print(~(exp(5)*x));\n   exp(5) * x\n\nSee also: evaluate, prec, error\n"
#define HELP_ASCIIPLOT_TEXT "Name: asciiplot\n==> plots a function in a range using ASCII characters\n\nLibrary name:\n   void sollya_lib_asciiplot(sollya_obj_t, sollya_obj_t)\n\nUsage: \n   asciiplot({function}, {range}) : (function, range) -> void\n\nParameters: \n   {function} represents a function to be plotted\n   {range} represents a range the function is to be plotted in \n\nDescription: \n   * asciiplot plots the function {function} in range {range} using ASCII\n   characters.  On systems that provide the necessary \n   TIOCGWINSZ ioctl, Sollya determines the size of the\n   terminal for the plot size if connected to a terminal. If it is not\n   connected to a terminal or if the test is not possible, the plot is of\n   fixed size 77x25 characters.  The function is\n   evaluated on a number of points equal to the number of columns\n   available. Its value is rounded to the next integer in the range of\n   lines available. A letter \"x\" is written at this place. If zero is in\n   the hull of the image domain of the function, an x-axis is\n   displayed. If zero is in range, a y-axis is displayed.  If the\n   function is constant or if the range is reduced to one point, the\n   function is evaluated to a constant and the constant is displayed\n   instead of a plot.\n\nExample 1: \n   > asciiplot(exp(x),[1;2]);\n                                                                             xx\n                                                                           xx  \n                                                                         xx    \n                                                                       xx      \n                                                                     xx        \n                                                                  xxx          \n                                                                xx             \n                                                             xxx               \n                                                           xx                  \n                                                        xxx                    \n                                                     xxx                       \n                                                  xxx                          \n                                               xxx                             \n                                            xxx                                \n                                        xxxx                                   \n                                     xxx                                       \n                                 xxxx                                          \n                             xxxx                                              \n                         xxxx                                                  \n                     xxxx                                                      \n                xxxxx                                                          \n           xxxxx                                                               \n      xxxxx                                                                    \n   xxx                                                                         \n\nExample 2: \n   > asciiplot(expm1(x),[-1;2]);\n                            |                                                 x\n                            |                                                x \n                            |                                               x  \n                            |                                              x   \n                            |                                            xx    \n                            |                                           x      \n                            |                                          x       \n                            |                                        xx        \n                            |                                       x          \n                            |                                     xx           \n                            |                                   xx             \n                            |                                 xx               \n                            |                               xx                 \n                            |                             xx                   \n                            |                           xx                     \n                            |                        xxx                       \n                            |                     xxx                          \n                            |                 xxxx                             \n                            |             xxxx                                 \n                            |         xxxx                                     \n                            |   xxxxxx                                         \n   ---------------------xxxxxxxx-----------------------------------------------\n            xxxxxxxxxxxx    |                                                  \n   xxxxxxxxx                |                                                  \n\nExample 3: \n   > asciiplot(5,[-1;1]);\n   5\n\nExample 4: \n   > asciiplot(exp(x),[1;1]);\n   2.7182818284590452353602874713526624977572470937\n\nSee also: plot, externalplot\n"
#define HELP_ASINH_TEXT "Name: asinh\n==> the arg-hyperbolic sine function.\n\nLibrary names:\n   sollya_obj_t sollya_lib_asinh(sollya_obj_t)\n   sollya_obj_t sollya_lib_build_function_asinh(sollya_obj_t)\n   #define SOLLYA_ASINH(x) sollya_lib_build_function_asinh(x)\n\nDescription: \n   * asinh is the inverse of the function sinh: asinh(y) is the unique number \n   x in [-Inf; +Inf] such that sinh(x)=y.\n\n   * It is defined for every real number y.\n\nSee also: sinh\n"
#define HELP_ASIN_TEXT "Name: asin\n==> the arcsine function.\n\nLibrary names:\n   sollya_obj_t sollya_lib_asin(sollya_obj_t)\n   sollya_obj_t sollya_lib_build_function_asin(sollya_obj_t)\n   #define SOLLYA_ASIN(x) sollya_lib_build_function_asin(x)\n\nDescription: \n   * asin is the inverse of the function sin: asin(y) is the unique number \n   x in [-Pi/2; Pi/2] such that sin(x)=y.\n\n   * It is defined only for y in [-1; 1].\n\nSee also: sin\n"
#define HELP_ATANH_TEXT "Name: atanh\n==> the hyperbolic arctangent function.\n\nLibrary names:\n   sollya_obj_t sollya_lib_atanh(sollya_obj_t)\n   sollya_obj_t sollya_lib_build_function_atanh(sollya_obj_t)\n   #define SOLLYA_ATANH(x) sollya_lib_build_function_atanh(x)\n\nDescription: \n   * atanh is the inverse of the function tanh: atanh(y) is the unique number \n   x in [-Inf; +Inf] such that tanh(x)=y.\n\n   * It is defined only for y in [-1; 1].\n\nSee also: tanh\n"
#define HELP_ATAN_TEXT "Name: atan\n==> the arctangent function.\n\nLibrary names:\n   sollya_obj_t sollya_lib_atan(sollya_obj_t)\n   sollya_obj_t sollya_lib_build_function_atan(sollya_obj_t)\n   #define SOLLYA_ATAN(x) sollya_lib_build_function_atan(x)\n\nDescription: \n   * atan is the inverse of the function tan: atan(y) is the unique number \n   x in [-Pi/2; Pi/2] such that tan(x)=y.\n\n   * It is defined for every real number y.\n\nSee also: tan\n"
#define HELP_AUTODIFF_TEXT "Name: autodiff\n==> Computes the first n derivatives of a function at a point or over an interval.\n\nLibrary name:\n   sollya_obj_t sollya_lib_autodiff(sollya_obj_t, sollya_obj_t, sollya_obj_t)\n\nUsage: \n   autodiff({f}, {n}, {x0}) : (function, integer, constant) -> list\n   autodiff({f}, {n}, {I}) : (function, integer, range) -> list\n\nParameters: \n   {f} is the function to be differentiated.\n   {n} is the order of differentiation.\n   {x0} is the point at which the function is differentiated.\n   {I} is the interval over which the function is differentiated.\n\nDescription: \n   * autodiff computes the first n derivatives of f at point x0. The computation\n   is performed numerically, without symbolically differentiating the expression\n   of f. Yet, the computation is safe since small interval enclosures are\n   produced. More precisely, autodiff returns a list [f_0, ..., f_n] such that,\n   for each i, f_i is a small interval enclosing the exact value of f^(i)(x0).\n\n   * Since it does not perform any symbolic differentiation, autodiff is much \n   more efficient than diff and should be preferred when only numerical values\n   are necessary.\n\n   * If an interval I is provided instead of a point x0, the list returned by\n   autodiff satisfies: for each i, f^(i)(I) is included in f_i. A particular use\n   is when one wants to know the successive derivatives of a function at a non\n   representable point such as pi. In this case, it suffices to call autodiff\n   with the (almost) point interval I = [pi].\n\n   * When I is almost a point interval, the returned enclosures f_i are also\n   almost point intervals. However, when the interval I begins to be fairly\n   large, the enclosures can be deeply overestimated due to the dependency\n   phenomenon present with interval arithmetic.\n\n   * As a particular case, f_0 is an enclosure of the image of f over I.\n   However, since the algorithm is not specially designed for this purpose it is\n   not very efficient for this particular task. In particular, it is not able to\n   return a finite enclosure for functions with removable singularities\n   (e.g. sin(x)/x at 0). The command evaluate is much more efficient for\n   computing an accurate enclosure of the image of a function over an interval.\n\nExample 1: \n   > L = autodiff(exp(cos(x))+sin(exp(x)), 5, 0);\n   > midpointmode = on!;\n   > for f_i in L do f_i;\n   0.3559752813266941742012789792982961497379810154498~2/4~e1\n   0.5403023058681397174009366074429766037323104206179~0/3~\n   -0.3019450507398802024611853185539984893647499733880~6/2~e1\n   -0.252441295442368951995750696489089699886768918239~6/4~e1\n   0.31227898756481033145214529184139729746320579069~1/3~e1\n   -0.16634307959006696033484053579339956883955954978~3/1~e2\n\nExample 2: \n   > f = log(cos(x)+x);\n   > L = autodiff(log(cos(x)+x), 5, [2,4]);\n   > L[0];\n   [0;1.27643852425465597132446653114905059102580436018893]\n   > evaluate(f, [2,4]);\n   [0.45986058925497069206106494332976097408234056912429;1.20787210589964169595901037621103012113048821362855]\n   > fprime = diff(f);\n   > L[1];\n   [2.53086745013099407167484456656211083053393118778677e-2;1.7568024953079282513726390945118290941359128873365]\n   > evaluate(fprime,[2,4]);\n   [2.71048755415961996452136364304380881763456815673085e-2;1.1091953066394329083739722578862353140555843127995]\n\nExample 3: \n   > L = autodiff(sin(x)/x, 0, [-1,1]);\n   > L[0];\n   [NaN;NaN]\n   > evaluate(sin(x)/x, [-1,1]);\n   [0.5403023058681397174009366074429766037323104206179;1]\n\nSee also: diff, evaluate\n"
#define HELP_AUTOSIMPLIFY_TEXT "Name: autosimplify\n==> activates, deactivates or inspects the value of the automatic simplification state variable\n\nLibrary names:\n   void sollya_lib_set_autosimplify_and_print(sollya_obj_t)\n   void sollya_lib_set_autosimplify(sollya_obj_t)\n   sollya_obj_t sollya_lib_get_autosimplify()\n\nUsage: \n   autosimplify = {activation value} : on|off -> void\n   autosimplify = {activation value} ! : on|off -> void\n   autosimplify : on|off\n\nParameters: \n   {activation value} represents on or off, i.e. activation or deactivation\n\nDescription: \n   * An assignment autosimplify = {activation value}, where {activation value}\n   is one of on or off, activates respectively deactivates the\n   automatic safe simplification of expressions of functions generated by\n   the evaluation of commands or in argument of other commands.\n    \n   Sollya commands like remez, taylor or rationalapprox sometimes\n   produce expressions that can be simplified. Constant subexpressions\n   can be evaluated to dyadic floating-point numbers, monomials with\n   coefficients 0 can be eliminated. Further, expressions\n   indicated by the user perform better in many commands when simplified\n   before being passed in argument to a command. When the automatic\n   simplification of expressions is activated, Sollya automatically\n   performs a safe (not value changing) simplification process on such\n   expressions.\n    \n   The automatic generation of subexpressions can be annoying, in\n   particular if it takes too much time for not enough benefit. Further the\n   user might want to inspect the structure of the expression tree\n   returned by a command. In this case, the automatic simplification\n   should be deactivated.\n    \n   If the assignment autosimplify = {activation value} is followed by an\n   exclamation mark, no message indicating the new state is\n   displayed. Otherwise the user is informed of the new state of the\n   global mode by an indication.\n\nExample 1: \n   > autosimplify = on !;\n   > print(x - x);\n   0\n   > autosimplify = off ;\n   Automatic pure tree simplification has been deactivated.\n   > print(x - x);\n   x - x\n\nExample 2: \n   > autosimplify = on !; \n   > print(rationalapprox(sin(pi/5.9),7));\n   33 / 65\n   > autosimplify = off !; \n   > print(rationalapprox(sin(pi/5.9),7));\n   33 / 65\n\nSee also: print, ==, !=, prec, points, diam, display, verbosity, canonical, taylorrecursions, timing, fullparentheses, midpointmode, hopitalrecursions, remez, rationalapprox, taylor\n"
#define HELP_BASHEVALUATE_TEXT "Name: bashevaluate\n==> executes a shell command and returns its output as a string\n\nLibrary names:\n   sollya_obj_t sollya_lib_bashevaluate(sollya_obj_t, ...)\n   sollya_obj_t sollya_lib_v_bashevaluate(sollya_obj_t, va_list)\n\nUsage: \n   bashevaluate({command}) : string -> string\n   bashevaluate({command},{input}) : (string, string) -> string\n\nParameters: \n   {command} is a command to be interpreted by the shell.\n   {input} is an optional character sequence to be fed to the command.\n\nDescription: \n   * bashevaluate({command}) will execute the shell command {command} in a shell.\n   All output on the command's standard output is collected and returned \n   as a character sequence.\n\n   * If an additional argument {input} is given in a call to\n   bashevaluate({command},{input}), this character sequence is written to the\n   standard input of the command {command} that gets executed.\n\n   * All characters output by {command} are included in the character\n   sequence to which bashevaluate evaluates but two exceptions. Every NULL\n   character ('\\0') in the output is replaced with\n   '?' as Sollya is unable to handle character sequences containing that\n   character. Additionally, if the output ends in a newline character\n   ('\\n'), this character is stripped off. Other\n   newline characters which are not at the end of the output are left as\n   such.\n\nExample 1: \n   > bashevaluate(\"LANG=C date\");\n   Mon Feb 21 12:19:47 CET 2022\n\nExample 2: \n   > [| bashevaluate(\"echo Hello\") |];\n   [|\"Hello\"|]\n\nExample 3: \n   > a = bashevaluate(\"sed -e 's/a/e/g;'\", \"Hallo\");\n   > a;\n   Hello\n\nSee also: bashexecute\n"
#define HELP_BASHEXECUTE_TEXT "Name: bashexecute\n==> executes a shell command.\n\nLibrary name:\n   void sollya_lib_bashexecute(sollya_obj_t)\n\nUsage: \n   bashexecute({command}) : string -> void\n\nParameters: \n   {command} is a command to be interpreted by the shell.\n\nDescription: \n   * bashexecute({command}) lets the shell interpret {command}. It is useful to execute\n   some external code within Sollya.\n\n   * bashexecute does not return anything. It just executes its argument. However, if\n   {command} produces an output in a file, this result can be imported in Sollya\n   with help of commands like execute, readfile and parse.\n\nExample 1: \n   > bashexecute(\"LANG=C date\");\n   Mon Feb 21 12:19:59 CET 2022\n\nSee also: execute, readfile, parse, bashevaluate\n"
#define HELP_BEZOUT_TEXT "Name: bezout\n==> Computes the gcd as well as the co-factors (Bezout coefficients)\n\nLibrary name:\n   sollya_obj_t sollya_lib_bezout(sollya_obj_t, sollya_obj_t)\n\nUsage: \n   bezout({p}, {q}) : (function, function) -> structure\n\nParameters: \n   {p} is a constant or a polynomial.\n   {q} is a constant or a polynomial.\n\nDescription: \n   * When both {p} and {q} are integers, bezout({p},{q}) computes the greatest\n   common divisor g of these two integers, i.e., the greatest non-negative\n   integer g dividing both {p} and {q}, as well as co-factors (Bezout\n   coefficients), i.e., a and b such that a * p + b * q = g.\n\n   * bezout always returns a structure containing four elements, g, r, a and b.\n   These four elements always satisfy the following two properties:\n   gcd(g,r) = gcd(p,q) and a * p + b * q = g. In addition, the tool tries to\n   ensure r = 0. This latter property cannot always be ensured, in particular,\n   it cannot be ensured for constant expression such that r becomes zero but\n   the tool is unable to prove this fact. bezout ensures that g is the greatest\n   common divisor of {p} and {q} only if r ends up being zero.\n\n   * When both {p} and {q} are rational numbers, say s/t and u/v,\n   bezout({p},{q}) computes the greatest common divisor of s * v and u * t,\n   divided by the product of the denominators, t * v, as well as co-factors,\n   still satisfying a * p + b * q = g.\n\n   * When both {p} and {q} are constants but at least one of them is no rational\n   number, bezout does not run the extended Euclidian algorithm to reduce\n   gcd(p,q), i.e., the two elements g, r of the returned structure contain\n   copies of the inputs {p} and {q}. The elements a and b are set to 0 and 1\n   accordingly. bezout differs from the gcd command in this point.\n\n   * When both {p} and {q} are polynomials with at least one being non-constant,\n   bezout({p},{q}) returns the polynomial of greatest degree dividing both {p}\n   and {q}, and whose leading coefficient is the greatest common divisor of the\n   leading coefficients of {p} and {q}. Polynomial co-factors (Bezout\n   coefficients), i.e., a and b such that a * p + b * q = g, are returned as\n   well.\n\n   * Similarly to the cases documented for div and mod, bezout may fail to\n   return the unique polynomial of largest degree dividing both {p} and {q} in\n   cases when certain coefficients of either {p} or {q} are constant expressions\n   for which the tool is unable to determine whether they are zero or not. These\n   cases typically involve polynomials whose leading coefficient is zero but the\n   tool is unable to detect this fact. In contrast to the gcd command, the\n   bezout command is completely safe in this respect, as it returns not only\n   an alleged greatest common divisor g but also the final remainder r obtained\n   in the extended Euclidian algorithm. The two properties gcd(g,r) = gcd(p,q)\n   and a * p + b * q = g are always satisfied for the four elements of the\n   returned structure.\n\n   * When at least one of {p} or {q} is a function that is no polynomial, bezout\n   does not run the extended Euclidian algorithm to reduce gcd(p,q), i.e., the\n   two elements g, r of the returned structure contain copies of the inputs {p}\n   and {q}. The elements a and b are set to 0 and 1 accordingly. bezout differs\n   from the gcd command in this point.\n\nExample 1: \n   > bezout(1001, 231);\n   { .b = -4, .a = 1, .r = 0, .g = 77 }\n   > bezout(13, 17);\n   { .b = -3, .a = 4, .r = 0, .g = 1 }\n   > bezout(-210, 462);\n   { .b = 1, .a = 2, .r = 0, .g = 42 }\n\nExample 2: \n   > rationalmode = on!;\n   > bezout(6/7, 33/13);\n   { .b = -1, .a = 3, .r = 0, .g = 3 / 91 }\n\nExample 3: \n   > bezout(exp(13),sin(17));\n   { .b = 0, .a = 1, .r = -0.96139749187955685726163694486915609849206725405894, .g = 4.4241339200892050332610277594908828178439130606059e5 }\n\nExample 4: \n   > bezout(24 + 68 * x + 74 * x^2 + 39 * x^3 + 10 * x^4 + x^5, 480 + 776 * x + 476 * x^2 + 138 * x^3 + 19 * x^4 + x^5);\n   { .b = 9.1666666666666666666666666666666666666666666666665e-2 + x * (0.125 + x * 5e-2), .a = -1.6666666666666666666666666666666666666666666666667 + x * (-0.575 + x * (-5e-2)), .r = 0, .g = 4 + x * (4 + x) }\n   > bezout(1001 * x^2, 231 * x);\n   { .b = 0.33333333333333333333333333333333333333333333333333, .a = 0, .r = 0, .g = x * 77 }\n\nExample 5: \n   > bezout(exp(x), x^2);\n   { .b = 0, .a = 1, .r = x^2, .g = exp(x) }\n\nSee also: gcd, div, mod, numberroots\n"
#define HELP_BINARY_TEXT "Name: binary\n==> special value for global state display\n\nLibrary names:\n   sollya_obj_t sollya_lib_binary()\n   int sollya_lib_is_binary(sollya_obj_t)\n\nDescription: \n   * binary is a special value used for the global state display.  If\n   the global state display is equal to binary, all data will be\n   output in binary notation.\n    \n   As any value it can be affected to a variable and stored in lists.\n\nSee also: decimal, dyadic, powers, hexadecimal, display\n"
#define HELP_BIND_TEXT "Name: bind\n==> partially applies a procedure to an argument, returning a procedure with one argument less\n\nUsage: \n   bind({proc}, {ident}, {obj}) : (procedure, identifier type, any type) -> procedure\n\nParameters: \n   {proc} is a procedure to be partially applied to an argument\n   {ident} is one of the formal arguments of {proc}\n   {obj} is any Sollya object {ident} is to be bound to\n\nDescription: \n   * bind allows a formal parameter {ident} of a procedure {proc} to \n   be bound to an object {obj}, hence {proc} to be partially applied.\n   The result of this curryfied application, returned by bind, is \n   a procedure with one argument less. This way, bind permits \n   specialization of a generic procedure, parameterized e.g. by a function\n   or range.\n\n   * In the case when {proc} does not have a formal parameter named \n   {ident}, bind prints a warning and returns the procedure \n   {proc} unmodified. \n\n   * bind always returns a procedure, even if {proc} only has one \n   argument, which gets bound to {ident}. In this case, bind\n   returns a procedure which does not take any argument. Hence \n   evaluation, which might provoke side effects, is only performed\n   once the procedure gets used.\n\n   * If bind is used on a procedure with an arbitrary number of\n   arguments, no check is performed whether the procedure actually\n   has a parameter of name {ident}. bind returns a procedure\n   with an arbitrary number of arguments whose argument has the\n   same name as the original procedure {proc}. That returned procedure\n   binds {ident} to {obj} and then runs {proc} within this context,\n   applying it to its original argument. The execution of bind\n   fails for procedures with an arbitrary number of arguments if\n   the original procedure's argument has the same name as {ident}.\n   In this case, the procedure is returned unmodified.\n\nExample 1: \n   > procedure add(X,Y) { return X + Y; };\n   > succ = bind(add,X,1);\n   > succ(5);\n   6\n   > succ;\n   proc(Y)\n   {\n   nop;\n   return (proc(X, Y)\n   {\n   nop;\n   return (X) + (Y);\n   })(1, Y);\n   }\n\nExample 2: \n   > procedure add(X,Y) { return X + Y; };\n   > succ = bind(add,X,1);\n   > five = bind(succ,Y,4);\n   > five();\n   5\n   > five;\n   proc()\n   {\n   nop;\n   return (proc(Y)\n   {\n   nop;\n   return (proc(X, Y)\n   {\n   nop;\n   return (X) + (Y);\n   })(1, Y);\n   })(4);\n   }\n\nExample 3: \n   > verbosity = 1!;\n   > procedure add(X,Y) { return X + Y; };\n   > foo = bind(add,R,1);\n   Warning: the given procedure has no argument named \"R\". The procedure is returned unchanged.\n   > foo;\n   proc(X, Y)\n   {\n   nop;\n   return (X) + (Y);\n   }\n\nExample 4: \n   > procedure sum_times(l=...) { var s, i; s = 0; for i in l do s = s + i; return c * s; };\n   > foo = bind(sum_times, c, 17);\n   > foo;\n   proc(l = ...)\n   {\n   var c;\n   c = 17;\n   return (proc(l = ...)\n   {\n   var s, i;\n   s = 0;\n   for i in l do\n   s = (s) + (i);\n   return (c) * (s);\n   }) @ (l);\n   }\n   > foo(1, 2, 3);\n   102\n\nSee also: procedure, proc, function, @\n"
#define HELP_BOOLEAN_TEXT "Name: boolean\n==> keyword representing a boolean type \n\nLibrary name:\n   SOLLYA_EXTERNALPROC_TYPE_BOOLEAN\n\nUsage: \n   boolean : type type\n\nDescription: \n   * boolean represents the boolean type for declarations\n   of external procedures by means of externalproc.\n    \n   Remark that in contrast to other indicators, type indicators like\n   boolean cannot be handled outside the externalproc context.  In\n   particular, they cannot be assigned to variables.\n\nSee also: externalproc, constant, function, integer, list of, range, string, object\n"
#define HELP_CANONICAL_TEXT "Name: canonical\n==> brings all polynomial subexpressions of an expression to canonical form or activates, deactivates or checks canonical form printing\n\nLibrary names:\n   void sollya_lib_set_canonical_and_print(sollya_obj_t)\n   void sollya_lib_set_canonical(sollya_obj_t)\n   sollya_obj_t sollya_lib_canonical(sollya_obj_t)\n   sollya_obj_t sollya_lib_get_canonical()\n\nUsage: \n   canonical({function}) : function -> function\n   canonical = {activation value} : on|off -> void\n   canonical = {activation value} ! : on|off -> void\n\nParameters: \n   {function} represents the expression to be rewritten in canonical form\n   {activation value} represents on or off, i.e. activation or deactivation\n\nDescription: \n   * The command canonical rewrites the expression representing the function\n   {function} in a way such that all polynomial subexpressions (or the\n   whole expression itself, if it is a polynomial) are written in\n   canonical form, i.e. as a sum of monomials in the canonical base. The\n   canonical base is the base of the integer powers of the global free\n   variable. The command canonical does not endanger the safety of\n   computations even in Sollya's floating-point environment: the\n   function returned is mathematically equal to the function {function}.\n\n   * An assignment canonical = {activation value}, where {activation value}\n   is one of on or off, activates respectively deactivates the\n   automatic printing of polynomial expressions in canonical form,\n   i.e. as a sum of monomials in the canonical base. If automatic\n   printing in canonical form is deactivated, automatic printing yields to\n   displaying polynomial subexpressions in Horner form.\n    \n   If the assignment canonical = {activation value} is followed by an\n   exclamation mark, no message indicating the new state is\n   displayed. Otherwise the user is informed of the new state of the\n   global mode by an indication.\n\nExample 1: \n   > print(canonical(1 + x * (x + 3 * x^2)));\n   1 + x^2 + 3 * x^3\n   > print(canonical((x + 1)^7));\n   1 + 7 * x + 21 * x^2 + 35 * x^3 + 35 * x^4 + 21 * x^5 + 7 * x^6 + x^7\n\nExample 2: \n   > print(canonical(exp((x + 1)^5) - log(asin(((x + 2) + x)^4 * (x + 1)) + x)));\n   exp(1 + 5 * x + 10 * x^2 + 10 * x^3 + 5 * x^4 + x^5) - log(asin(16 + 80 * x + 160 * x^2 + 160 * x^3 + 80 * x^4 + 16 * x^5) + x)\n\nExample 3: \n   > canonical;\n   off\n   > (x + 2)^9;\n   512 + x * (2304 + x * (4608 + x * (5376 + x * (4032 + x * (2016 + x * (672 + x * (144 + x * (18 + x))))))))\n   > canonical = on;\n   Canonical automatic printing output has been activated.\n   > (x + 2)^9;\n   512 + 2304 * x + 4608 * x^2 + 5376 * x^3 + 4032 * x^4 + 2016 * x^5 + 672 * x^6 + 144 * x^7 + 18 * x^8 + x^9\n   > canonical;\n   on\n   > canonical = off!;\n   > (x + 2)^9;\n   512 + x * (2304 + x * (4608 + x * (5376 + x * (4032 + x * (2016 + x * (672 + x * (144 + x * (18 + x))))))))\n\nSee also: horner, print, autosimplify\n"
#define HELP_CEIL_TEXT "Name: ceil\n==> the usual function ceil.\n\nLibrary names:\n   sollya_obj_t sollya_lib_ceil(sollya_obj_t)\n   sollya_obj_t sollya_lib_build_function_ceil(sollya_obj_t)\n   #define SOLLYA_CEIL(x) sollya_lib_build_function_ceil(x)\n\nDescription: \n   * ceil is defined as usual: ceil(x) is the smallest integer y such that y >= x.\n\n   * It is defined for every real number x.\n\nSee also: floor, nearestint, round, RU\n"
#define HELP_CHEBYSHEVFORM_TEXT "Name: chebyshevform\n==> computes a rigorous polynomial approximation\n\nLibrary name:\n   sollya_obj_t sollya_lib_chebyshevform(sollya_obj_t, sollya_obj_t,\n                                         sollya_obj_t);\n\nUsage: \n   chebyshevform({f}, {n}, {I}) : (function, integer, range) -> list\n\nParameters: \n   {f} is the function to be approximated.\n   {n} is the degree of the polynomial that must approximate {f}.\n   {I} is the interval over which the function is to be approximated. This interval cannot be a point interval, i.e. its endpoints have to be different.\n\nDescription: \n   * WARNING: chebyshevform is a certified command, not difficult to use but not\n   completely straightforward to use either. In order to be sure to use it\n   correctly, the reader is invited to carefully read this documentation\n   entirely.\n\n   * chebyshevform computes an approximation polynomial and an interval error\n   bound for a given function f.\n    \n   More precisely, it returns a list L=[p, coeffErrors, Delta, chebCoeffs]\n   where: \n     - p is an approximation polynomial of degree n which is roughly speaking a\n   numerical Chebyshev interpolation polynomial of f over I represented in\n   monomial basis.\n     - coeffsErrors is a list of n+1 intervals. Each interval coeffsErrors[i]\n   contains an enclosure of all the errors accumulated when computing the i-th\n   coefficient of p.\n     - Delta is an interval that provides a bound for the approximation error\n   between p and f. See details below.\n     - chebCoeffs is a list of n+1 intervals. These are the interval\n   coefficients obtained for the representation of interpolation polynomial\n   considered in Chebyshev basis. See details below. \n\n   * The polynomial p and the bound Delta are obtained using Chebyshev Models\n   principles.\n\n   * More formally, the mathematical property ensured by the algorithm may be\n   stated as follows:\n    \n   Using monomial basis representation given by p: there exist (small) values\n   eps[i] in coeffsErrors[i] such that:\n   for all x in I, there exists delta in Delta such that\n                   f(x) - p(x) = sum{i=0...n} eps[i]*x^i + delta.\n    \n   Using Chebyshev basis representation given by chebCoeffs: there exist values\n   alpha[i] in chebCoeffs[i] such that:\n   for all x in I, there exists delta in Delta such that\n                   f(x) - sum{i=0...n} alpha[i]*T_i(y) = delta,\n   where [a,b]=I, y=(2*x-b-a)/(b-a) and T_i(y) is the i-th Chebyshev polynomial\n   over [-1,1].\n\n   * The algorithm does not guarantee that by increasing the degree of the\n   approximation, the remainder bound will become smaller. Moreover, it may even\n   become larger due to the dependency phenomenon present with interval\n   arithmetic. In order to reduce this phenomenon, a possible solution is to\n   split the definition domain I into several smaller intervals.\n\nExample 1: \n   > TL=chebyshevform(exp(x), 10, [-1,1]);\n   > p=TL[0];\n   > Delta=TL[2];\n   > p; Delta;\n   1.00000000000000000000000000000000000000000000000017 + x * (1.0000000002738981919773953471453626764777115166417 + x * (0.50000000002276754368023326882542097365411870042312 + x * (0.166666661190450656168988993421371510533693281444003 + x * (4.1666666211440433973188799509591566161569698904644e-2 + x * (8.3333639749825520034240517636254576844423981913793e-3 + x * (1.38889143636148090706862105537216777944219976325265e-3 + x * (1.98342776066472142284727329700227389403558111865906e-4 + x * (2.47957727598277888282218067965324267955768146489014e-5 + x * (2.8254033440982477266316370012542019511804700836066e-6 + x * 2.8136983333718843135828091163040197490633045592362e-7)))))))))\n   [-2.71406412827174505775085010461449926572460824320373e-11;2.71406412827174505775085010461449926572460824320373e-11]\n\nSee also: taylorform, diff, autodiff, taylor, remez\n"
#define HELP_CHECKINFNORM_TEXT "Name: checkinfnorm\n==> checks whether the infinity norm of a function is bounded by a value\n\nLibrary name:\n   sollya_obj_t sollya_lib_checkinfnorm(sollya_obj_t, sollya_obj_t,\n                                        sollya_obj_t)\n\nUsage: \n   checkinfnorm({function},{range},{constant}) : (function, range, constant) -> boolean\n\nParameters: \n   {function} represents the function whose infinity norm is to be checked\n   {range} represents the infinity norm is to be considered on\n   {constant} represents the upper bound the infinity norm is to be checked to\n\nDescription: \n   * The command checkinfnorm checks whether the infinity norm of the given\n   function {function} in the range {range} can be proven (by Sollya) to\n   be less than the given bound {bound}. This means, if checkinfnorm\n   evaluates to true, the infinity norm has been proven (by Sollya's\n   interval arithmetic) to be less than the bound. If checkinfnorm evaluates\n   to false, there are two possibilities: either the bound is less than\n   or equal to the infinity norm of the function or the bound is greater\n   than the infinity norm but Sollya could not conclude using its\n   internal interval arithmetic.\n    \n   checkinfnorm is sensitive to the global variable diam. The smaller diam,\n   the more time Sollya will spend on the evaluation of checkinfnorm in\n   order to prove the bound before returning false although the infinity\n   norm is bounded by the bound. If diam is equal to 0, Sollya will\n   eventually spend infinite time on instances where the given bound\n   {bound} is less or equal to the infinity norm of the function\n   {function} in range {range}. In contrast, with diam being zero,\n   checkinfnorm evaluates to true iff the infinity norm of the function in\n   the range is bounded by the given bound.\n\nExample 1: \n   > checkinfnorm(sin(x),[0;1.75], 1);\n   true\n   > checkinfnorm(sin(x),[0;1.75], 1/2); checkinfnorm(sin(x),[0;20/39],1/2);\n   false\n   true\n\nExample 2: \n   > p = remez(exp(x), 5, [-1;1]);\n   > b = dirtyinfnorm(p - exp(x), [-1;1]);\n   > checkinfnorm(p - exp(x), [-1;1], b);\n   false\n   > b1 = round(b, 15, RU);\n   > checkinfnorm(p - exp(x), [-1;1], b1);\n   true\n   > b2 = round(b, 25, RU);\n   > checkinfnorm(p - exp(x), [-1;1], b2);\n   false\n   > diam = 1b-20!;\n   > checkinfnorm(p - exp(x), [-1;1], b2);\n   true\n\nSee also: infnorm, dirtyinfnorm, supnorm, accurateinfnorm, remez, diam\n"
#define HELP_COEFF_TEXT "Name: coeff\n==> gives the coefficient of degree n of a polynomial\n\nLibrary name:\n   sollya_obj_t sollya_lib_coeff(sollya_obj_t, sollya_obj_t)\n\nUsage: \n   coeff({f},{n}) : (function, integer) -> constant\n\nParameters: \n   {f} is a function (usually a polynomial).\n   {n} is an integer\n\nDescription: \n   * If {f} is a polynomial, coeff({f}, {n}) returns the coefficient of\n   degree {n} in {f}.\n\n   * If {f} is a function that is not a polynomial, coeff({f}, {n}) returns 0.\n\nExample 1: \n   > coeff((1+x)^5,3);\n   10\n\nExample 2: \n   > coeff(sin(x),0);\n   0\n\nSee also: degree, roundcoefficients, subpoly\n"
#define HELP_COMPOSEPOLYNOMIALS_TEXT "Name: composepolynomials\n==> computes an approximation to the composition of two polynomials and bounds the error\n\nLibrary name:\n   sollya_obj_t sollya_lib_composepolynomials(sollya_obj_t, sollya_obj_t)\n\nUsage: \n   composepolynomials({p},{q}) : (function, function) -> structure\n\nParameters: \n   {p} and {q} are polynomials\n\nDescription: \n   * Given two polynomials p and q, composepolynomials({p}, {q}) computes an \n   approximation r to the polynomial (p o q) and bounds the\n   error polynomial r - (p o q) using interval arithmetic.\n\n   * composepolynomials always returns a structure containing two elements,\n   poly and radii.  The element\n   poly is contains the approximate composed polynomial\n   r. The element radii contains a list of n + 1 \n   intervals ai bounding the coefficients of the\n   error polynomial, which is of the same degree n as is the\n   composed polynomial (p o q).  This is, there exist\n   alphai in ai such that \n   sum_i alphai * x^i = r(x) - (p o q)(x).\n\n   * In the case when either of p or q is not a polynomial, composepolynomials\n   behaves like substitute used in a literate structure. The list of intervals\n   bounding the coefficients of the error polynomial is returned empty.\n\nExample 1: \n   > composepolynomials(1 + 2 * x + 3 * x^2 + 4 * x^3, 5 + 6 * x + 7 * x^2);\n   { .radii = [|[0;0], [0;0], [0;0], [0;0], [0;0], [0;0], [0;0]|], .poly = 586 + x * (1992 + x * (4592 + x * (6156 + x * (6111 + x * (3528 + x * 1372))))) }\n\nExample 2: \n   > print(composepolynomials(1/5 * x + exp(17) + log(2) * x^2, x^4 + 1/3 * x^2));\n   { .radii = [|[-3.5873240686715317015647477332221852960774705712039e-43;3.5873240686715317015647477332221852960774705712039e-43], [0;0], [-2.672764710092195646140536467151481878815196880105e-51;2.672764710092195646140536467151481878815196880105e-51], [0;0], [-1.069105884036878258456214586860592751526078752042e-50;1.069105884036878258456214586860592751526078752042e-50], [0;0], [-2.138211768073756516912429173721185503052157504084e-50;2.138211768073756516912429173721185503052157504084e-50], [0;0], [-1.069105884036878258456214586860592751526078752042e-50;1.069105884036878258456214586860592751526078752042e-50]|], .poly = 2.41549527535752982147754351803858238798675673527228e7 + x^2 * (6.6666666666666666666666666666666666666666666666666e-2 + x^2 * (0.2770163533955494788241369023842418408972777927067 + x^2 * (0.46209812037329687294482141430545104538366675624017 + x^2 * 0.69314718055994530941723212145817656807550013436026))) }\n\nExample 3: \n   > composepolynomials(sin(x),x + x^2);\n   { .radii = [| |], .poly = sin(x * (1 + x)) }\n\nSee also: substitute\n"
#define HELP_CONCAT_TEXT "Name: @\n==> concatenates two lists or strings or applies a list as arguments to a procedure\n\nLibrary name:\n   sollya_obj_t sollya_lib_concat(sollya_obj_t, sollya_obj_t)\n\nUsage: \n   {L1}@{L2} : (list, list) -> list\n   {string1}@{string2} : (string, string) -> string\n   {proc}@{L1} : (procedure, list) -> any type\n\nParameters: \n   {L1} and {L2} are two lists.\n   {string1} and {string2} are two strings.\n   {proc} is a procedure or an external procedure.\n\nDescription: \n   * In its first usage form, @ concatenates two lists or strings.\n\n   * In its second usage form, @ applies the elements of a list as\n   arguments to a procedure or an external procedure. In the case when {proc} is\n   a procedure or external procedure with a fixed number of arguments, a check\n   is done if the number of elements in the list corresponds to the number of\n   formal parameters of {proc}. An empty list can therefore be applied only to a\n   procedure that does not take any argument. In the case when {proc} accepts an\n   arbitrary number of arguments, no such check is performed.\n\nExample 1: \n   > [|1,...,3|]@[|7,8,9|];\n   [|1, 2, 3, 7, 8, 9|]\n\nExample 2: \n   > \"Hello \"@\"World!\";\n   Hello World!\n\nExample 3: \n   > procedure cool(a,b,c) { \n     write(a,\", \", b,\" and \",c,\" are cool guys.\\n\");\n     };\n   > cool @ [| \"Christoph\", \"Mioara\", \"Sylvain\" |];\n   Christoph, Mioara and Sylvain are cool guys.\n\nExample 4: \n   > procedure sayhello() { \n     \"Hello! how are you?\";\n     };\n   > sayhello();\n   Hello! how are you?\n   > sayhello @ [||];\n   Hello! how are you?\n\nExample 5: \n   > bashexecute(\"gcc -fPIC -Wall -c externalprocexample.c\");\n   > bashexecute(\"gcc -fPIC -shared -o externalprocexample externalprocexample.o\");\n   > externalproc(foo, \"./externalprocexample\", (integer, integer) -> integer);\n   > foo;\n   foo\n   > foo @ [|5, 6|];\n   11\n\nExample 6: \n   > procedure add(L = ...) {\n     var acc, i;\n     acc = 0;\n     for i in L do acc = i + acc;\n     return acc;\n     };\n   > add(1,2);\n   3\n   > add(1,2,3);\n   6\n   > add @ [|1, 2|];\n   3\n   > add @ [|1, 2, 3|];\n   6\n   > add @ [||];\n   0\n\nSee also: .:, :., procedure, externalproc, proc, bind, getbacktrace\n"
#define HELP_CONSTANT_TEXT "Name: constant\n==> keyword representing a constant type \n\nLibrary name:\n   SOLLYA_EXTERNALPROC_TYPE_CONSTANT\n\nUsage: \n   constant : type type\n\nDescription: \n   * constant represents the constant type for declarations\n   of external procedures externalproc.\n    \n   Remark that in contrast to other indicators, type indicators like\n   constant cannot be handled outside the externalproc context.  In\n   particular, they cannot be assigned to variables.\n\nSee also: externalproc, boolean, function, integer, list of, range, string, object\n"
#define HELP_COSH_TEXT "Name: cosh\n==> the hyperbolic cosine function.\n\nLibrary names:\n   sollya_obj_t sollya_lib_cosh(sollya_obj_t)\n   sollya_obj_t sollya_lib_build_function_cosh(sollya_obj_t)\n   #define SOLLYA_COSH(x) sollya_lib_build_function_cosh(x)\n\nDescription: \n   * cosh is the usual hyperbolic function: cosh(x) = (exp(x)+exp(-x))/2.\n\n   * It is defined for every real number x.\n\nSee also: acosh, sinh, tanh, exp\n"
#define HELP_COS_TEXT "Name: cos\n==> the cosine function.\n\nLibrary names:\n   sollya_obj_t sollya_lib_cos(sollya_obj_t)\n   sollya_obj_t sollya_lib_build_function_cos(sollya_obj_t)\n   #define SOLLYA_COS(x) sollya_lib_build_function_cos(x)\n\nDescription: \n   * cos is the usual cosine function.\n\n   * It is defined for every real number x.\n\nSee also: acos, sin, tan\n"
#define HELP_DD_TEXT "Name: DD\n==> short form for doubledouble\n\nSee also: doubledouble\n"
#define HELP_DECIMAL_TEXT "Name: decimal\n==> special value for global state display\n\nLibrary names:\n   sollya_obj_t sollya_lib_decimal()\n   int sollya_lib_is_decimal(sollya_obj_t)\n\nDescription: \n   * decimal is a special value used for the global state display.\n   If the global state display is equal to decimal, all data will\n   be output in decimal notation.\n    \n   As any value it can be affected to a variable and stored in lists.\n\nSee also: dyadic, powers, hexadecimal, binary, display\n"
#define HELP_DEFAULT_TEXT "Name: default\n==> default value for some commands.\n\nLibrary names:\n   sollya_obj_t sollya_lib_default()\n   int sollya_lib_is_default(sollya_obj_t)\n\nDescription: \n   * default is a special value and is replaced by something depending on the \n   context where it is used. It can often be used as a joker, when you want to \n   specify one of the optional parameters of a command and not the others: set \n   the value of uninteresting parameters to default.\n\n   * Global variables can be reset by affecting them the special value default.\n\nExample 1: \n   > p = remez(exp(x),5,[0;1],default,1e-5);\n   > q = remez(exp(x),5,[0;1],1,1e-5);\n   > p==q;\n   true\n\nExample 2: \n   > prec;\n   165\n   > prec=200;\n   The precision has been set to 200 bits.\n\n"
#define HELP_DEGREE_TEXT "Name: degree\n==> gives the degree of a polynomial.\n\nLibrary name:\n   sollya_obj_t sollya_lib_degree(sollya_obj_t)\n\nUsage: \n   degree({f}) : function -> integer\n\nParameters: \n   {f} is a function (usually a polynomial).\n\nDescription: \n   * If {f} is a polynomial, degree({f}) returns the degree of {f}.\n\n   * Contrary to the usage, Sollya considers that the degree of the null polynomial\n   is 0.\n\n   * If {f} is a function that is not a polynomial, degree({f}) returns -1.\n\nExample 1: \n   > degree((1+x)*(2+5*x^2));\n   3\n   > degree(0);\n   0\n\nExample 2: \n   > degree(sin(x));\n   -1\n\nSee also: coeff, subpoly, roundcoefficients\n"
#define HELP_DENOMINATOR_TEXT "Name: denominator\n==> gives the denominator of an expression\n\nLibrary name:\n   sollya_obj_t sollya_lib_denominator(sollya_obj_t)\n\nUsage: \n   denominator({expr}) : function -> function\n\nParameters: \n   {expr} represents an expression\n\nDescription: \n   * If {expr} represents a fraction {expr1}/{expr2}, denominator({expr})\n   returns the denominator of this fraction, i.e. {expr2}.\n    \n   If {expr} represents something else, denominator({expr}) \n   returns 1.\n    \n   Note that for all expressions {expr}, numerator({expr}) / denominator({expr})\n   is equal to {expr}.\n\nExample 1: \n   > denominator(5/3);\n   3\n\nExample 2: \n   > denominator(exp(x));\n   1\n\nExample 3: \n   > a = 5/3;\n   > b = numerator(a)/denominator(a);\n   > print(a);\n   5 / 3\n   > print(b);\n   5 / 3\n\nExample 4: \n   > a = exp(x/3);\n   > b = numerator(a)/denominator(a);\n   > print(a);\n   exp(x / 3)\n   > print(b);\n   exp(x / 3)\n\nSee also: numerator, rationalmode\n"
#define HELP_DE_TEXT "Name: DE\n==> short form for doubleextended\n\nSee also: doubleextended\n"
#define HELP_DIAM_TEXT "Name: diam\n==> parameter used in safe algorithms of Sollya and controlling the maximal length of the involved intervals.\n\nLibrary names:\n   void sollya_lib_set_diam_and_print(sollya_obj_t)\n   void sollya_lib_set_diam(sollya_obj_t)\n   sollya_obj_t sollya_lib_get_diam()\n\nUsage: \n   diam = {width} : constant -> void\n   diam = {width} ! : constant -> void\n   diam : constant\n\nParameters: \n   {width} represents the maximal relative width of the intervals used\n\nDescription: \n   * diam is a global variable. Its value represents the maximal width allowed\n   for intervals involved in safe algorithms of Sollya (namely infnorm,\n   checkinfnorm, accurateinfnorm, integral, findzeros, supnorm).\n\n   * More precisely, diam is relative to the width of the input interval of\n   the command. For instance, suppose that diam=1e-5: if infnorm is called\n   on interval [0;1], the maximal width of an interval will be 1e-5. But if it\n   is called on interval [0;1e-3], the maximal width will be 1e-8.\n\nSee also: infnorm, checkinfnorm, accurateinfnorm, integral, findzeros, supnorm\n"
#define HELP_DIEONERRORMODE_TEXT "Name: dieonerrormode\n==> global variable controlling if Sollya is exited on an error or not.\n\nLibrary names:\n   void sollya_lib_set_dieonerrormode_and_print(sollya_obj_t)\n   void sollya_lib_set_dieonerrormode(sollya_obj_t)\n   sollya_obj_t sollya_lib_get_dieonerrormode()\n\nUsage: \n   dieonerrormode = {activation value} : on|off -> void\n   dieonerrormode = {activation value} ! : on|off -> void\n   dieonerrormode : on|off\n\nParameters: \n   {activation value} controls if Sollya is exited on an error or not.\n\nDescription: \n   * dieonerrormode is a global variable. When its value is off, which is the default,\n   Sollya will not exit on any syntax, typing, side-effect errors. These\n   errors will be caught by the tool, even if a memory might be leaked at \n   that point. On evaluation, the error special value will be produced.\n\n   * When the value of the dieonerrormode variable is on, Sollya will exit\n   on any syntax, typing, side-effect errors. A warning message will\n   be printed in these cases at appropriate verbosity levels. \n\nExample 1: \n   > verbosity = 1!;\n   > dieonerrormode = off;\n   Die-on-error mode has been deactivated.\n   > for i from true to false do i + \"Salut\";\n   Warning: one of the arguments of the for loop does not evaluate to a constant.\n   The for loop will not be executed.\n   > exp(17);\n   Warning: rounding has happened. The value displayed is a faithful rounding to 165 bits of the true result.\n   Warning: For at least 1 of the constants displayed in decimal, rounding has happened.\n   2.41549527535752982147754351803858238798675673527224e7\n\nExample 2: \n   > verbosity = 1!;\n   > dieonerrormode = off!;\n   > 5 */  4;\n   Warning: syntax error.\n   The last symbol read has been \"/\".\n   Will skip input until next semicolon after the unexpected token. May leak memory.\n     exp(17);\n   Warning: rounding has happened. The value displayed is a faithful rounding to 165 bits of the true result.\n   Warning: For at least 1 of the constants displayed in decimal, rounding has happened.\n   2.41549527535752982147754351803858238798675673527224e7\n\nExample 3: \n   > verbosity = 1!;\n   > dieonerrormode;\n   off\n   > dieonerrormode = on!;\n   > dieonerrormode;\n   on\n   > for i from true to false do i + \"Salut\";\n   Warning: one of the arguments of the for loop does not evaluate to a constant.\n   The for loop will not be executed.\n   Warning: some syntax, typing or side-effect error has occurred.\n   As the die-on-error mode is activated, the tool will be exited.\n\nExample 4: \n   > verbosity = 1!;\n   > dieonerrormode = on!;\n   > 5 */  4;\n   Warning: syntax error.\n   The last symbol read has been \"/\".\n   Will skip input until next semicolon after the unexpected token. May leak memory.\n   Warning: some syntax, typing or side-effect error has occurred.\n   As the die-on-error mode is activated, the tool will be exited.\n\nExample 5: \n   > verbosity = 0!;\n   > dieonerrormode = on!;\n   > 5 */  4;\n\nSee also: on, off, verbosity, error\n"
#define HELP_DIFF_TEXT "Name: diff\n==> differentiation operator\n\nLibrary name:\n   sollya_obj_t sollya_lib_diff(sollya_obj_t)\n\nUsage: \n   diff({function}) : function -> function\n\nParameters: \n   {function} represents a function\n\nDescription: \n   * diff({function}) returns the symbolic derivative of the function\n   {function} by the global free variable.\n    \n   If {function} represents a function symbol that is externally bound\n   to some code by library, the derivative is performed as a symbolic\n   annotation to the returned expression tree.\n\nExample 1: \n   > diff(sin(x));\n   cos(x)\n\nExample 2: \n   > diff(x);\n   1\n\nExample 3: \n   > diff(x^x);\n   x^x * (1 + log(x))\n\nSee also: library, autodiff, taylor, taylorform\n"
#define HELP_DIRTYFINDZEROS_TEXT "Name: dirtyfindzeros\n==> gives a list of numerical values listing the zeros of a function on an interval.\n\nLibrary name:\n   sollya_obj_t sollya_lib_dirtyfindzeros(sollya_obj_t, sollya_obj_t)\n\nUsage: \n   dirtyfindzeros({f},{I}) : (function, range) -> list\n\nParameters: \n   {f} is a function.\n   {I} is an interval.\n\nDescription: \n   * dirtyfindzeros({f},{I}) returns a list containing some zeros of {f} in the\n   interval {I}. The values in the list are numerical approximation of the exact\n   zeros. The precision of these approximations is approximately the precision\n   stored in prec. If {f} does not have two zeros very close to each other, it \n   can be expected that all zeros are listed. However, some zeros may be\n   forgotten. This command should be considered as a numerical algorithm and\n   should not be used if safety is critical.\n\n   * More precisely, the algorithm relies on global variables prec and points and it performs the following steps: \n   let n be the value of variable points and t be the value\n   of variable prec.\n    \n      - Evaluate |f| at n evenly distributed points in the interval I.\n        The working precision to be used is automatically chosen in order to ensure that the sign\n        is correct.\n      - Whenever f changes its sign for two consecutive points,\n        find an approximation x of its zero with precision t using\n        Newton's algorithm. The number of steps in Newton's iteration depends on t:\n        the precision of the approximation is supposed to be doubled at each step.\n      - Add this value to the list.\n    \n\n   * The user should be aware that the list returned by dirtyfindzeros may\n   contain a certain floating-point number twice. These repetitions\n   reflect the existence of different zeros of the function the value of\n   which rounds to the same floating-point number in the current working\n   precision. In this case, increasing the working precision will end up\n   making the two zeros distinguishable even in rounded floating-point\n   arithmetic.\n\nExample 1: \n   > dirtyfindzeros(sin(x),[-5;5]);\n   [|-3.1415926535897932384626433832795028841971693993751, 0, 3.1415926535897932384626433832795028841971693993751|]\n\nExample 2: \n   > L1=dirtyfindzeros(x^2*sin(1/x),[0;1]);\n   > points=1000!;\n   > L2=dirtyfindzeros(x^2*sin(1/x),[0;1]);\n   > length(L1); length(L2);\n   18\n   25\n\nSee also: prec, points, findzeros, dirtyinfnorm, numberroots\n"
#define HELP_DIRTYINFNORM_TEXT "Name: dirtyinfnorm\n==> computes a numerical approximation of the infinity norm of a function on an interval.\n\nLibrary name:\n   sollya_obj_t sollya_lib_dirtyinfnorm(sollya_obj_t, sollya_obj_t)\n\nUsage: \n   dirtyinfnorm({f},{I}) : (function, range) -> constant\n\nParameters: \n   {f} is a function.\n   {I} is an interval.\n\nDescription: \n   * dirtyinfnorm({f},{I}) computes an approximation of the infinity norm of the \n   given function f on the interval I, e.g. max {|f(x)|, x in I}.\n\n   * The interval must be bound. If the interval contains one of -Inf or +Inf, the \n   result of dirtyinfnorm is NaN.\n\n   * The result of this command depends on the global variables prec and points.\n   Therefore, the returned result is generally a good approximation of the exact\n   infinity norm, with precision prec. However, the result is generally \n   underestimated and should not be used when safety is critical.\n   Use infnorm instead.\n\n   * The following algorithm is used: let n be the value of variable points\n   and t be the value of variable prec.\n    \n      - Evaluate |f| at n evenly distributed points in the\n        interval I. The evaluation are faithful roundings of the exact\n        results at precision t.\n      - Whenever the derivative of f changes its sign for two consecutive \n        points, find an approximation x of its zero with precision t.\n        Then compute a faithful rounding of |f(x)| at precision t.\n      - Return the maximum of all computed values.\n    \n\nExample 1: \n   > dirtyinfnorm(sin(x),[-10;10]);\n   1\n\nExample 2: \n   > prec=15!;\n   > dirtyinfnorm(exp(cos(x))*sin(x),[0;5]);\n   1.45856\n   > prec=40!;\n   > dirtyinfnorm(exp(cos(x))*sin(x),[0;5]);\n   1.458528537136\n   > prec=100!;\n   > dirtyinfnorm(exp(cos(x))*sin(x),[0;5]);\n   1.458528537136237644438147455025\n   > prec=200!;\n   > dirtyinfnorm(exp(cos(x))*sin(x),[0;5]);\n   1.458528537136237644438147455023841718299214087993682374094153\n\nExample 3: \n   > dirtyinfnorm(x^2, [log(0);log(1)]);\n   NaN\n\nSee also: prec, points, infnorm, checkinfnorm, supnorm\n"
#define HELP_DIRTYINTEGRAL_TEXT "Name: dirtyintegral\n==> computes a numerical approximation of the integral of a function on an interval.\n\nLibrary name:\n   sollya_obj_t sollya_lib_dirtyintegral(sollya_obj_t, sollya_obj_t)\n\nUsage: \n   dirtyintegral({f},{I}) : (function, range) -> constant\n\nParameters: \n   {f} is a function.\n   {I} is an interval.\n\nDescription: \n   * dirtyintegral({f},{I}) computes an approximation of the integral of {f} on {I}.\n\n   * The interval must be bound. If the interval contains one of -Inf or +Inf, the \n   result of dirtyintegral is NaN, even if the integral has a meaning.\n\n   * The result of this command depends on the global variables prec and points.\n   The method used is the trapezium rule applied at n evenly distributed\n   points in the interval, where n is the value of global variable points.\n\n   * This command computes a numerical approximation of the exact value of the \n   integral. It should not be used if safety is critical. In this case, use\n   command integral instead.\n\n   * Warning: this command is currently known to be unsatisfactory. If you really\n   need to compute integrals, think of using another tool or report a feature\n   request to sylvain.chevillard@ens-lyon.org.\n\nExample 1: \n   > sin(10);\n   -0.54402111088936981340474766185137728168364301291622\n   > dirtyintegral(cos(x),[0;10]);\n   -0.54400304905152629822448058882475382036536298356282\n   > points=2000!;\n   > dirtyintegral(cos(x),[0;10]);\n   -0.54401997751158321972222697312583199035995837926893\n\nSee also: prec, points, integral\n"
#define HELP_DIRTYSIMPLIFY_TEXT "Name: dirtysimplify\n==> simplifies an expression representing a function\n\nLibrary name:\n   sollya_obj_t sollya_lib_dirtysimplify(sollya_obj_t)\n\nUsage: \n   dirtysimplify({function}) : function -> function\n\nParameters: \n   {function} represents the expression to be simplified\n\nDescription: \n   * The command dirtysimplify simplifies constant subexpressions of the\n   expression given in argument representing the function\n   {function}. Those constant subexpressions are evaluated using\n   floating-point arithmetic with the global precision prec.\n\nExample 1: \n   > print(dirtysimplify(sin(pi * x)));\n   sin(3.1415926535897932384626433832795028841971693993751 * x)\n   > print(dirtysimplify(erf(exp(3) + x * log(4))));\n   erf(20.0855369231876677409285296545817178969879078385544 + x * 1.3862943611198906188344642429163531361510002687205)\n\nExample 2: \n   > prec = 20!;\n   > t = erf(0.5);\n   > s = dirtysimplify(erf(0.5));\n   > prec = 200!;\n   > t;\n   0.520499877813046537682746653891964528736451575757963700058806\n   > s;\n   0.52050018310546875\n\nSee also: simplify, autosimplify, prec, evaluate, horner, rationalmode\n"
#define HELP_DISPLAY_TEXT "Name: display\n==> sets or inspects the global variable specifying number notation\n\nLibrary names:\n   void sollya_lib_set_display_and_print(sollya_obj_t)\n   void sollya_lib_set_display(sollya_obj_t)\n   sollya_obj_t sollya_lib_get_display()\n\nUsage: \n   display = {notation value} : decimal|binary|dyadic|powers|hexadecimal -> void\n   display = {notation value} ! : decimal|binary|dyadic|powers|hexadecimal -> void\n   display : decimal|binary|dyadic|powers|hexadecimal\n\nParameters: \n   {notation value} represents a variable of type decimal|binary|dyadic|powers|hexadecimal\n\nDescription: \n   * An assignment display = {notation value}, where {notation value} is\n   one of decimal, dyadic, powers, binary or hexadecimal, activates\n   the corresponding notation for output of values in print, write or\n   at the Sollya prompt.\n    \n   If the global notation variable display is decimal, all numbers will\n   be output in scientific decimal notation.  If the global notation\n   variable display is dyadic, all numbers will be output as dyadic\n   numbers with Gappa notation.  If the global notation variable display\n   is powers, all numbers will be output as dyadic numbers with a\n   notation compatible with Maple and PARI/GP.  If the global notation\n   variable display is binary, all numbers will be output in binary\n   notation.  If the global notation variable display is hexadecimal,\n   all numbers will be output in C99/ IEEE754-2008 notation.  All output\n   notations can be parsed back by Sollya, inducing no error if the input\n   and output precisions are the same (see prec).\n    \n   If the assignment display = {notation value} is followed by an\n   exclamation mark, no message indicating the new state is\n   displayed. Otherwise the user is informed of the new state of the\n   global mode by an indication.\n\nExample 1: \n   > display = decimal;\n   Display mode is decimal numbers.\n   > a = evaluate(sin(pi * x), 0.25);\n   > a;\n   0.70710678118654752440084436210484903928483593768847\n   > display = binary;\n   Display mode is binary numbers.\n   > a;\n   1.01101010000010011110011001100111111100111011110011001001000010001011001011111011000100110110011011101010100101010111110100111110001110101101111011000001011101010001_2 * 2^(-1)\n   > display = hexadecimal;\n   Display mode is hexadecimal numbers.\n   > a;\n   0x1.6a09e667f3bcc908b2fb1366ea957d3e3adec1751p-1\n   > display = dyadic;\n   Display mode is dyadic numbers.\n   > a;\n   33070006991101558613323983488220944360067107133265b-165\n   > display = powers;\n   Display mode is dyadic numbers in integer-power-of-2 notation.\n   > a;\n   33070006991101558613323983488220944360067107133265 * 2^(-165)\n\nSee also: print, write, decimal, dyadic, powers, binary, hexadecimal, prec\n"
#define HELP_DIVEUCL_TEXT "Name: div\n==> Computes the euclidian division of polynomials or numbers and returns the quotient\n\nLibrary name:\n   sollya_obj_t sollya_lib_euclidian_div(sollya_obj_t, sollya_obj_t)\n\nUsage: \n   div({a}, {b}) : (function, function) -> function\n\nParameters: \n   {a} is a constant or a polynomial.\n   {b} is a constant or a polynomial.\n\nDescription: \n   * When both {a} and {b} are constants, div({a},{b}) computes\n   floor({a} / {b}). In other words, it returns the quotient of the Euclidian\n   division of {a} by {b}.\n\n   * When both {a} and {b} are polynomials with at least one being non-constant,\n   div({a},{b}) computes a polynomial {q} such that the polynomial {r} equal to\n   {a} - {q} * {b} is of degree strictly smaller than the degree of {b} (see\n   exception below). In order to recover {r}, use the mod command.\n\n   * div works on polynomials whose coefficients are constant\n   expressions that cannot be simplified (by the tool) to rational\n   numbers. In most cases, the tool is able to perform the Euclidian\n   polynomial division for such polynomials and stop the Euclidian\n   division algorithm only when {r} is of degree strictly smaller than\n   the degree of {b}. In certain cases, when the polynomials involve\n   coefficients given as constant expressions that are mathematically\n   zero but for which the tool is unable to detect this fact, the tool\n   may be unable to correctly determine that {r} is actually of degree\n   stricly smaller than the degree of {b}. The issue arises in particular\n   for polynomials whose leading coefficient is a constant expression\n   which is zero without the tool being able to detect this. In these\n   cases, div, together with mod, just guarantee that {q} and\n   {r}, as returned by the two commands, satisfy that {r} added to the\n   product of {q} and {b} yields {a}, and that {r} is of the smallest\n   degree the tool can admit. However, there might exist another pair of\n   a quotient and remainder polynomial for which the remainder polynomial\n   is of a degree less than the one of {r}.\n\n   * When at least one of {a} or {b} is a function that is no polynomial,\n   div({a},{b}) returns 0.\n\nExample 1: \n   > div(1001, 231);\n   4\n   > div(13, 17);\n   0\n   > div(-14, 15);\n   -1\n   > div(-213, -5);\n   42\n   > div(23/13, 11/17);\n   2\n   > div(exp(13),-sin(17));\n   460177\n\nExample 2: \n   > div(24 + 68 * x + 74 * x^2 + 39 * x^3 + 10 * x^4 + x^5, 4 + 4 * x + x^2);\n   6 + x * (11 + x * (6 + x))\n   > div(24 + 68 * x + 74 * x^2 + 39 * x^3 + 10 * x^4 + x^5, 2 * x^3);\n   19.5 + x * (5 + x * 0.5)\n   > div(x^2, x^3);\n   0\n\nExample 3: \n   > div(exp(x), x^2);\n   0\n\nSee also: gcd, mod, bezout, numberroots\n"
#define HELP_DIVIDE_TEXT "Name: /\n==> division function\n\nLibrary names:\n   sollya_obj_t sollya_lib_div(sollya_obj_t, sollya_obj_t)\n   sollya_obj_t sollya_lib_build_function_div(sollya_obj_t, sollya_obj_t)\n   #define SOLLYA_DIV(x,y) sollya_lib_build_function_div((x), (y))\n\nUsage: \n   {function1} / {function2} : (function, function) -> function\n   {interval1} / {interval2} : (range, range) -> range\n   {interval1} / {constant} : (range, constant) -> range\n   {interval1} / {constant} : (constant, range) -> range\n\nParameters: \n   {function1} and {function2} represent functions\n   {interval1} and {interval2} represent intervals (ranges)\n   {constant} represents a constant or constant expression\n\nDescription: \n   * / represents the division (function) on reals. \n   The expression {function1} / {function2} stands for\n   the function composed of the division function and the two\n   functions {function1} and {function2}, where {function1} is\n   the numerator and {function2} the denominator.\n\n   * / can be used for interval arithmetic on intervals\n   (ranges). / will evaluate to an interval that safely\n   encompasses all images of the division function with arguments\n   varying in the given intervals. If the intervals given contain points\n   where the division function is not defined, infinities and NaNs will be\n   produced in the output interval.  Any combination of intervals with\n   intervals or constants (resp. constant expressions) is\n   supported. However, it is not possible to represent families of\n   functions using an interval as one argument and a function (varying in\n   the free variable) as the other one.\n\nExample 1: \n   > 5 / 2;\n   2.5\n\nExample 2: \n   > x / 2;\n   x * 0.5\n\nExample 3: \n   > x / x;\n   1\n\nExample 4: \n   > 3 / 0;\n   NaN\n\nExample 5: \n   > diff(sin(x) / exp(x));\n   (exp(x) * cos(x) - sin(x) * exp(x)) / exp(x)^2\n\nExample 6: \n   > [1;2] / [3;4];\n   [0.25;0.66666666666666666666666666666666666666666666666668]\n   > [1;2] / 17;\n   [5.8823529411764705882352941176470588235294117647059e-2;0.11764705882352941176470588235294117647058823529412]\n   > -13 / [4;17];\n   [-3.25;-0.76470588235294117647058823529411764705882352941175]\n\nSee also: +, -, *, ^\n"
#define HELP_DOUBLEDOUBLE_TEXT "Names: doubledouble, DD\n==> represents a number as the sum of two IEEE doubles.\n\nLibrary names:\n   sollya_obj_t sollya_lib_double_double(sollya_obj_t)\n   sollya_obj_t sollya_lib_double_double_obj()\n   int sollya_lib_is_double_double_obj(sollya_obj_t)\n   sollya_obj_t sollya_lib_build_function_double_double(sollya_obj_t)\n   #define SOLLYA_DD(x) sollya_lib_build_function_double_double(x)\n\nDescription: \n   * doubledouble is both a function and a constant.\n\n   * As a function, it rounds its argument to the nearest number that can be written\n   as the sum of two double precision numbers.\n\n   * The algorithm used to compute doubledouble(x) is the following: let xh = double(x)\n   and let xl = double(x - xh). Return the number xh + xl. Note that if the current \n   precision is not sufficient to exactly represent xh + xl, a rounding will occur\n   and the result of doubledouble(x) will be useless.\n\n   * As a constant, it symbolizes the double-double precision format. It is used in \n   contexts when a precision format is necessary, e.g. in the commands \n   round, roundcoefficients and implementpoly.\n   See the corresponding help pages for examples.\n\nExample 1: \n   > verbosity=1!;\n   > a = 1+ 2^(-100);\n   > DD(a);\n   Warning: For at least 1 of the constants displayed in decimal, rounding has happened.\n   1.0000000000000000000000000000007888609052210118054\n   > prec=50!;\n   > DD(a);\n   1.0000000000000000000000000000007888609052210118054117285652827862296732064351090230047702789306640625\n\nSee also: halfprecision, single, double, doubleextended, quad, tripledouble, roundcoefficients, implementpoly, round\n"
#define HELP_DOUBLEEXTENDED_TEXT "Names: doubleextended, DE\n==> computes the nearest number with 64 bits of mantissa.\n\nLibrary names:\n   sollya_obj_t sollya_lib_doubleextended(sollya_obj_t)\n   sollya_obj_t sollya_lib_doubleextended_obj()\n   int sollya_lib_is_doubleextended_obj(sollya_obj_t)\n   sollya_obj_t sollya_lib_build_function_doubleextended(sollya_obj_t)\n   #define SOLLYA_DE(x) sollya_lib_build_function_doubleextended(x)\n\nDescription: \n   * doubleextended is a function that computes the nearest floating-point number with\n   64 bits of mantissa to a given number. Since it is a function, it can be\n   composed with other Sollya functions such as exp, sin, etc.\n\n   * doubleextended now does handle subnormal numbers for a presumed exponent width\n   of the double-extended format of 15 bits. This means, with respect to \n   rounding, doubleextended behaves as a IEEE 754-2008 binary79 with a 64 bit \n   significand (with a hidden bit normal range), one sign bit and a \n   15 bit exponent field would behave. This behavior may be different\n   from the one observed on Intel-based IA32/Intel64 processors (or compatible\n   versions from other vendors). However it is the one seen on HP/Intel \n   Itanium when the precision specifier is double-extended and pseudo-denormals\n   are activated.\n\n   * Since it is a function and not a command, its behavior is a bit different from \n   the behavior of round(x,64,RN) even if the result is exactly the same.\n   round(x,64,RN) is immediately evaluated whereas doubleextended(x) can be composed \n   with other functions (and thus be plotted and so on).\n\nExample 1: \n   > display=binary!;\n   > DE(0.1);\n   1.100110011001100110011001100110011001100110011001100110011001101_2 * 2^(-4)\n   > round(0.1,64,RN);\n   1.100110011001100110011001100110011001100110011001100110011001101_2 * 2^(-4)\n\nExample 2: \n   > D(2^(-2000));\n   0\n   > DE(2^(-20000));\n   0\n\nExample 3: \n   > verbosity=1!;\n   > f = sin(DE(x));\n   > f(pi);\n   Warning: rounding has happened. The value displayed is a faithful rounding to 165 bits of the true result.\n   Warning: For at least 1 of the constants displayed in decimal, rounding has happened.\n   -5.016557612668332023557327080330757013831561670255e-20\n   > g = sin(round(x,64,RN));\n   Warning: at least one of the given expressions or a subexpression is not correctly typed\n   or its evaluation has failed because of some error on a side-effect.\n\nSee also: roundcoefficients, halfprecision, single, double, doubledouble, quad, tripledouble, round\n"
#define HELP_DOUBLE_TEXT "Names: double, D\n==> rounding to the nearest IEEE 754 double (binary64).\n\nLibrary names:\n   sollya_obj_t sollya_lib_double(sollya_obj_t)\n   sollya_obj_t sollya_lib_double_obj()\n   int sollya_lib_is_double_obj(sollya_obj_t)\n   sollya_obj_t sollya_lib_build_function_double(sollya_obj_t)\n   #define SOLLYA_D(x) sollya_lib_build_function_double(x)\n\nDescription: \n   * double is both a function and a constant.\n\n   * As a function, it rounds its argument to the nearest IEEE 754 double precision (i.e. IEEE754-2008 binary64) number.\n   Subnormal numbers are supported as well as standard numbers: it is the real\n   rounding described in the standard.\n\n   * As a constant, it symbolizes the double precision format. It is used in \n   contexts when a precision format is necessary, e.g. in the commands \n   round, roundcoefficients and implementpoly.\n   See the corresponding help pages for examples.\n\nExample 1: \n   > display=binary!;\n   > D(0.1);\n   1.100110011001100110011001100110011001100110011001101_2 * 2^(-4)\n   > D(4.17);\n   1.000010101110000101000111101011100001010001111010111_2 * 2^(2)\n   > D(1.011_2 * 2^(-1073));\n   1.1_2 * 2^(-1073)\n\nSee also: halfprecision, single, doubleextended, doubledouble, quad, tripledouble, roundcoefficients, implementpoly, round, printdouble\n"
#define HELP_D_TEXT "Name: D\n==> short form for double\n\nSee also: double\n"
#define HELP_DYADIC_TEXT "Name: dyadic\n==> special value for global state display\n\nLibrary names:\n   sollya_obj_t sollya_lib_dyadic()\n   int sollya_lib_is_dyadic(sollya_obj_t)\n\nDescription: \n   * dyadic is a special value used for the global state display.\n   If the global state display is equal to dyadic, all data will\n   be output in dyadic notation with numbers displayed in Gappa format.\n    \n   As any value it can be affected to a variable and stored in lists.\n\nSee also: decimal, powers, hexadecimal, binary, display\n"
#define HELP_EQUAL_TEXT "Name: ==\n==> equality test operator\n\nLibrary name:\n   sollya_obj_t sollya_lib_cmp_equal(sollya_obj_t, sollya_obj_t)\n\nUsage: \n   {expr1} == {expr2} : (any type, any type) -> boolean\n\nParameters: \n   {expr1} and {expr2} represent expressions\n\nDescription: \n   * The test {expr1} == {expr2} returns true when {expr1} and {expr2} are\n   syntactically equal and different from error, @NaN@ and [@NaN@, @NaN].\n   Conversely if {expr1} and {expr2} are objects that are mathematically\n   different and Sollya manages to figure it out, the test returns false.\n   In between these two cases, there is the grey zone of expressions that are\n   not syntactically equal but are mathematically equal. In such a case,\n   Sollya normally tries to determine if the expressions are mathematically\n   equal and if it manages to prove it, it returns true, without a warning. In\n   the case when {expr1} and {expr2} are two constant expressions, Sollya will\n   in particular try to evaluate their difference: in the case when the\n   difference is 0 or is so small that Sollya does not manage to obtain a\n   faithful rounding of the real value, it will return true (with a warning if\n   it has not been possible to actually prove that the real value is 0). In any\n   other case, when both expressions are not syntactically equal and Sollya\n   has not been able to prove that they are mathematically equal, it\n   returns false.\n\n   * The level of simplifications performed by Sollya to determine if\n   expressions are mathematically equal depends on the value of autosimplify.\n   If it is off, no formal simplification is performed, hence expression trees\n   as simple as x+1 and 1+x will be considered not equal. Conversely, if\n   autosimplify is set to on, polynomial subexpressions that are\n   mathematically equal will in general be recognized as being equal.\n\n   * The user should always keep in mind that a litteral constant written in\n   decimal arithmetic (such as 0.1 for instance) is not considered as an exact\n   constant by Sollya (unless it is exactly representable in binary without\n   requiring too much precision) and is first correctly rounded at precision\n   prec, prior to any other operation. Of course, this leads to a rounding\n   warning, but it is important to remember that this is done before the\n   expression trees are compared, possibly leading to two expressions comparing\n   equal, while they are obviously mathematically different, just because they\n   contain different constants that have been rounded to the same value at\n   precision prec. As a general rule, to avoid this behavior, the user should\n   represent constants in an exact format such as hexadecimal or represent\n   decimal constants as integer fractions (e.g., 0.1 represented by the constant\n   expression 1/10).\n\n   * Notice that @NaN@, [@NaN, @NaN@] and error share the property that they\n   compare not equal to anything, including themselves. This means if a variable\n   {a} contains @NaN@, [@NaN, @NaN@] or error and whatever the content of\n   variable {b} is, the test {a} == {b} returns false. The traditional way of\n   testing if {a} contains @NaN@, [@NaN@, @NaN@] or error is indeed to check if\n   {a} == {a} returns false. error can be distinguished from @NaN@ and\n   [@NaN@, @NaN@] using the != operator. In order to distinguish @NaN@ from\n   [@NaN@, @NaN@], a match ... with ... construct must be used. In general,\n   match ... with ... constructs work on all of @NaN@, [@NaN, @NaN@] and error\n   and are able to distinguish between all of these.\n\nExample 1: \n   > \"Hello\" == \"Hello\";\n   true\n   > \"Hello\" == \"Salut\";\n   false\n   > \"Hello\" == 5;\n   false\n   > 5 + x == 5 + x;\n   true\n\nExample 2: \n   > verbosity = 1!;\n   > asin(1) * 2 == pi;\n   true\n   > cos(3)^2 == 1 - sin(3)^2;\n   Warning: the tool is unable to decide an equality test by evaluation even though faithful evaluation of the terms has been possible. The terms will be considered to be equal.\n   true\n   > exp(5) == log(4);\n   false\n\nExample 3: \n   > autosimplify=off;\n   Automatic pure tree simplification has been deactivated.\n   > exp(1+x) == exp(x+1);\n   false\n   > autosimplify=on;\n   Automatic pure tree simplification has been activated.\n   > exp(1+x) == exp(x+1);\n   false\n   > (1/3+x)^2 == x^2 + 1/9 + (5-3)*x/3;\n   true\n   > log(x)/log(10) == log10(x);\n   false\n\nExample 4: \n   > prec = 12;\n   The precision has been set to 12 bits.\n   > verbosity = 1!;\n   > 16384.1 == 16385.1;\n   Warning: Rounding occurred when converting the constant \"16384.1\" to floating-point with 12 bits.\n   If safe computation is needed, try to increase the precision.\n   Warning: Rounding occurred when converting the constant \"16385.1\" to floating-point with 12 bits.\n   If safe computation is needed, try to increase the precision.\n   true\n   > 16384 == 16384.25;\n   false\n   > 0.1 == 1/10;\n   Warning: Rounding occurred when converting the constant \"0.1\" to floating-point with 12 bits.\n   If safe computation is needed, try to increase the precision.\n   false\n   > 0.1 == round(1/10, prec, RN);\n   Warning: Rounding occurred when converting the constant \"0.1\" to floating-point with 12 bits.\n   If safe computation is needed, try to increase the precision.\n   true\n\nExample 5: \n   > error == error;\n   false\n   > error != error;\n   false\n   > @NaN@ == @NaN@;\n   false\n   > @NaN@ != @NaN@;\n   true\n   > [@NaN@,@NaN@] == [@NaN@,@NaN@];\n   false\n   > [@NaN@,@NaN@] != [@NaN@,@NaN@];\n   true\n   > error == @NaN@;\n   false\n   > error != @NaN@;\n   false\n   > a = error;\n   > match a with\n      @NaN@ : (\"a contains @NaN@\")\n      [@NaN@, @NaN@] : (\"a contains [@NaN@, @NaN@]\")\n      default:(\"a contains something else\");\n   a contains something else\n   > a = @NaN@;\n   > match a with\n      @NaN@ : (\"a contains @NaN@\")\n      [@NaN@, @NaN@] : (\"a contains [@NaN@, @NaN@]\")\n      default:(\"a contains something else\");\n   a contains @NaN@\n   > a = [@NaN@, @NaN@];\n   > match a with\n      @NaN@ : (\"a contains @NaN@\")\n      [@NaN@, @NaN@] : (\"a contains [@NaN@, @NaN@]\")\n      default:(\"a contains something else\");\n   a contains [@NaN@, @NaN@]\n\nSee also: !=, >, >=, <=, <, in, !, &&, ||, error, prec, autosimplify\n"
#define HELP_ERFC_TEXT "Name: erfc\n==> the complementary error function.\n\nLibrary names:\n   sollya_obj_t sollya_lib_erfc(sollya_obj_t)\n   sollya_obj_t sollya_lib_build_function_erfc(sollya_obj_t)\n   #define SOLLYA_ERFC(x) sollya_lib_build_function_erfc(x)\n\nDescription: \n   * erfc is the complementary error function defined by erfc(x) = 1 - erf(x).\n\n   * It is defined for every real number x.\n\nSee also: erf\n"
#define HELP_ERF_TEXT "Name: erf\n==> the error function.\n\nLibrary names:\n   sollya_obj_t sollya_lib_erf(sollya_obj_t)\n   sollya_obj_t sollya_lib_build_function_erf(sollya_obj_t)\n   #define SOLLYA_ERF(x) sollya_lib_build_function_erf(x)\n\nDescription: \n   * erf is the error function defined by:\n   erf(x) = (2/sqrt(Pi)) * integral(exp(-t^2), [0;x])\n\n   * It is defined for every real number x.\n\nSee also: erfc, exp\n"
#define HELP_ERROR_TEXT "Name: error\n==> expression representing an input that is wrongly typed or that cannot be executed\n\nLibrary names:\n   sollya_obj_t sollya_lib_error()\n   int sollya_lib_obj_is_error(sollya_obj_t)\n\nUsage: \n   error : error\n\nDescription: \n   * The variable error represents an input during the evaluation of\n   which a type or execution error has been detected or is to be\n   detected. Inputs that are syntactically correct but wrongly typed\n   evaluate to error at some stage.  Inputs that are correctly typed\n   but containing commands that depend on side-effects that cannot be\n   performed or inputs that are wrongly typed at meta-level (cf. parse),\n   evaluate to error.\n    \n   Remark that in contrast to all other elements of the Sollya language,\n   error compares neither equal nor unequal to itself. This provides a\n   means of detecting syntax errors inside the Sollya language itself\n   without introducing issues of two different wrongly typed inputs being\n   equal.\n\nExample 1: \n   > print(5 + \"foo\");\n   error\n\nExample 2: \n   > error;\n   error\n\nExample 3: \n   > error == error;\n   false\n   > error != error;\n   false\n\nExample 4: \n   > correct = 5 + 6;\n   > incorrect = 5 + \"foo\";\n   > correct == correct;\n   true\n   > incorrect == incorrect;\n   false\n   > errorhappened = !(incorrect == incorrect);\n   > errorhappened;\n   true\n\nSee also: void, parse, ==, !=\n"
#define HELP_EVALUATE_TEXT "Name: evaluate\n==> evaluates a function at a constant point or in a range\n\nLibrary name:\n   sollya_obj_t sollya_lib_evaluate(sollya_obj_t, sollya_obj_t)\n\nUsage: \n   evaluate({function}, {constant}) : (function, constant) -> constant | range\n   evaluate({function}, {range}) : (function, range) -> range\n   evaluate({function}, {function2}) : (function, function) -> function\n\nParameters: \n   {function} represents a function\n   {constant} represents a constant point\n   {range} represents a range\n   {function2} represents a function that is not constant\n\nDescription: \n   * If its second argument is a constant {constant}, evaluate evaluates\n   its first argument {function} at the point indicated by\n   {constant}. This evaluation is performed in a way that the result is a\n   faithful rounding of the real value of the {function} at {constant} to\n   the current global precision. If such a faithful rounding is not\n   possible, evaluate returns a range surely encompassing the real value\n   of the function {function} at {constant}. If even interval evaluation\n   is not possible because the expression is undefined or numerically\n   unstable, NaN will be produced.\n\n   * If its second argument is a range {range}, evaluate evaluates its\n   first argument {function} by interval evaluation on this range\n   {range}. This ensures that the image domain of the function {function}\n   on the preimage domain {range} is surely enclosed in the returned\n   range.\n\n   * In the case when the second argument is a range that is reduced to a\n   single point (such that [1;1] for instance), the evaluation\n   is performed in the same way as when the second argument is a constant but\n   it produces a range as a result: evaluate automatically adjusts the precision\n   of the intern computations and returns a range that contains at most three floating-point\n   consecutive numbers in precision prec. This corresponds to the same accuracy\n   as a faithful rounding of the actual result. If such a faithful rounding\n   is not possible, evaluate has the same behavior as in the case when the\n   second argument is a constant.\n\n   * If its second argument is a function {function2} that is not a\n   constant, evaluate replaces all occurrences of the free variable in\n   function {function} by function {function2}.\n\nExample 1: \n   > midpointmode=on!;\n   > print(evaluate(sin(pi * x), 2.25));\n   0.70710678118654752440084436210484903928483593768847\n   > print(evaluate(sin(pi * x), [2.25; 2.25]));\n   0.707106781186547524400844362104849039284835937688~4/5~\n\nExample 2: \n   > print(evaluate(sin(pi * x), 2));\n   [-3.100365765139897619749121887390789523854170596558e-13490;5.3002401585857127605350842426029223241500776302528e-13489]\n\nExample 3: \n   > print(evaluate(sin(pi * x), [2, 2.25]));\n   [-5.143390272677254630046998919961912407349224165421e-50;0.70710678118654752440084436210484903928483593768866]\n\nExample 4: \n   > print(evaluate(sin(pi * x), 2 + 0.25 * x));\n   sin((pi) * 2 + x * (pi) * 0.25)\n\nExample 5: \n   > print(evaluate(sin(pi * 1/x), 0));\n   [-1;1]\n\nSee also: isevaluable\n"
#define HELP_EXECUTE_TEXT "Name: execute\n==> executes the content of a file\n\nLibrary name:\n   void sollya_lib_execute(sollya_obj_t)\n\nUsage: \n   execute({filename}) : string -> void\n\nParameters: \n   {filename} is a string representing a file name\n\nDescription: \n   * execute opens the file indicated by {filename}, and executes the sequence of \n   commands it contains. This command is evaluated at execution time: this way you\n   can modify the file {filename} (for instance using bashexecute) and execute it\n   just after.\n\n   * If {filename} contains a command execute, it will be executed recursively.\n\n   * If {filename} contains a call to restart, it will be neglected.\n\n   * If {filename} contains a call to quit, the commands following quit\n   in {filename} will be neglected.\n\nExample 1: \n   > a=2;\n   > a;\n   2\n   > print(\"a=1;\") > \"example.sollya\";\n   > execute(\"example.sollya\"); \n   > a;\n   1\n\nExample 2: \n   > verbosity=1!;\n   > print(\"a=1; restart; a=2;\") > \"example.sollya\";\n   > execute(\"example.sollya\"); \n   Warning: a restart command has been used in a file read into another.\n   This restart command will be neglected.\n   > a;\n   2\n\nExample 3: \n   > verbosity=1!;\n   > print(\"a=1; quit; a=2;\") > \"example.sollya\";\n   > execute(\"example.sollya\"); \n   Warning: the execution of a file read by execute demanded stopping the interpretation but it is not stopped.\n   > a;\n   1\n\nSee also: parse, readfile, write, print, bashexecute, quit, restart\n"
#define HELP_EXPAND_TEXT "Name: expand\n==> expands polynomial subexpressions\n\nLibrary name:\n   sollya_obj_t sollya_lib_expand(sollya_obj_t)\n\nUsage: \n   expand({function}) : function -> function\n\nParameters: \n   {function} represents a function\n\nDescription: \n   * expand({function}) expands all polynomial subexpressions in function\n   {function} as far as possible. Factors of sums are multiplied out,\n   power operators with constant positive integer exponents are replaced\n   by multiplications.\n\nExample 1: \n   > print(expand(x^3));\n   x * x * x\n\nExample 2: \n   > print(expand((x + 2)^3 + 2 * x));\n   8 + 12 * x + 6 * x * x + x * x * x + 2 * x\n\nExample 3: \n   > print(expand(exp((x + (x + 3))^5)));\n   exp(243 + 405 * x + 270 * x * x + 90 * x * x * x + 15 * x * x * x * x + x * x * x * x * x + x * 405 + 108 * x * 5 * x + 54 * x * x * 5 * x + 12 * x * x * x * 5 * x + x * x * x * x * 5 * x + x * x * 270 + 27 * x * x * x * 10 + 9 * x * x * x * x * 10 + x * x * x * x * x * 10 + x * x * x * 90 + 6 * x * x * x * x * 10 + x * x * x * x * x * 10 + x * x * x * x * 5 * x + 15 * x * x * x * x + x * x * x * x * x)\n\nSee also: dirtysimplify, simplify, horner, coeff, degree\n"
#define HELP_EXPM1_TEXT "Name: expm1\n==> shifted exponential function.\n\nLibrary names:\n   sollya_obj_t sollya_lib_expm1(sollya_obj_t)\n   sollya_obj_t sollya_lib_build_function_expm1(sollya_obj_t)\n   #define SOLLYA_EXPM1(x) sollya_lib_build_function_expm1(x)\n\nDescription: \n   * expm1 is defined by expm1(x) = exp(x)-1.\n\n   * It is defined for every real number x.\n\nSee also: exp\n"
#define HELP_EXPONENT_TEXT "Name: exponent\n==> returns the scaled binary exponent of a number.\n\nLibrary name:\n   sollya_obj_t sollya_lib_exponent(sollya_obj_t)\n\nUsage: \n   exponent({x}) : constant -> integer\n\nParameters: \n   {x} is a dyadic number.\n\nDescription: \n   * exponent(x) is by definition 0 if x is one of 0, NaN, or Inf.\n\n   * If {x} is not zero, it can be uniquely written as x = m*2^e where\n   m is an odd integer and e is an integer. exponent(x) returns e. \n\nExample 1: \n   > a=round(Pi,20,RN);\n   > e=exponent(a);\n   > e;\n   -17\n   > m=mantissa(a);\n   > a-m*2^e;\n   0\n\nSee also: mantissa, precision\n"
#define HELP_EXP_TEXT "Name: exp\n==> the exponential function.\n\nLibrary names:\n   sollya_obj_t sollya_lib_exp(sollya_obj_t)\n   sollya_obj_t sollya_lib_build_function_exp(sollya_obj_t)\n   #define SOLLYA_EXP(x) sollya_lib_build_function_exp(x)\n\nDescription: \n   * exp is the usual exponential function defined as the solution of the\n   ordinary differential equation y' = y with y(0)=1.\n\n   * exp(x) is defined for every real number x.\n\nSee also: exp, log\n"
#define HELP_EXTERNALDATA_TEXT "Name: externaldata\n==> binds an external data symbol to a Sollya identifier\n\nLibrary name:\n       sollya_obj_t sollya_lib_externaldata(char *, void *, void (*)(void *));\n\nUsage: \n   externaldata({identifier}, {filename}) : (identifier type, string) -> void\n\nParameters: \n   {identifier} represents the identifier the external symbol is to be bound to\n   {filename} of type string represents the name of the object file where the external symbol can be found\n\nDescription: \n   * externaldata allows for binding the Sollya identifier {identifier} to an\n   external symbol, looked up in a dynamically linked library. After this\n   binding, Sollya can retrieve the bound object in its own symbol\n   table, can copy it, can assign it to other variables, pass is as\n   arguments to procedures and externalprocedures, compare it\n   etc. However, Sollya stays agnostic of the symbol's meaning and\n   type. Due to this reason, the use of externaldata makes no sense but in\n   conjuction with the use of externalproc, where an external procedure\n   is bound to Sollya. This external procedure may know the type and\n   meaning of the object bound with externaldata and display it, handle it,\n   execute it etc. The same functionality may also be used for tools that\n   use Sollya thru its library interface to bind their own objects to\n   Sollya, pass them thru Sollya code and retrieve them eventually.\n\nExample 1: \n   > bashexecute(\"gcc -fPIC -Wall -I.. -I. -c externaldataexample.c\");\n   > bashexecute(\"gcc -fPIC -shared -o externaldataexample externaldataexample.o\");\n   > externaldata(magic, \"./externaldataexample\");\n   > magic;\n   magic\n   > print(magic);\n   magic\n   > magic == magic;\n   true\n   > magic == 17;\n   false\n   > zauberei = magic;\n   > zauberei;\n   magic\n   > zauberei == magic;\n   true\n\nExample 2: \n   > bashexecute(\"gcc -fPIC -Wall -I.. -I. -c externaldataexample.c\");\n   > bashexecute(\"gcc -fPIC -shared -o externaldataexample externaldataexample.o\");\n   > externaldata(magic, \"./externaldataexample\");\n   > externalproc(printMagic, \"./externaldataexample\", object -> void);\n   > zauberei = magic;\n   > printMagic;\n   printMagic\n   > printMagic(magic);\n   The magic is 17\n   > printMagic(magic);\n   The magic is 18\n   > printMagic(zauberei);\n   The magic is 19\n   > procedure magicAsParameter(m) {\n     \t  m;\n     \t  printMagic(m);\n     \t  m;\n     };\n   > magicAsParameter(magic);\n   magic\n   The magic is 20\n   magic\n   > magicAsParameter(zauberei);\n   magic\n   The magic is 21\n   magic\n\nSee also: library, libraryconstant, externalproc, externalplot, bashexecute, void, constant, function, range, integer, string, boolean, list of, object\n"
#define HELP_EXTERNALPLOT_TEXT "Name: externalplot\n==> plots the error of an external code with regard to a function\n\nLibrary names:\n   void sollya_lib_externalplot(sollya_obj_t, sollya_obj_t, sollya_obj_t,\n                                sollya_obj_t, sollya_obj_t, ...)\n   void sollya_lib_v_externalplot(sollya_obj_t, sollya_obj_t, sollya_obj_t,\n                                  sollya_obj_t, sollya_obj_t, va_list)\n\nUsage: \n   externalplot({filename}, {mode}, {function}, {range}, {precision}) : (string, absolute|relative, function, range, integer) -> void\n   externalplot({filename}, {mode}, {function}, {range}, {precision}, {perturb}) : (string, absolute|relative, function, range, integer, perturb) -> void\n   externalplot({filename}, {mode}, {function}, {range}, {precision}, {plot mode}, {result filename}) : (string, absolute|relative, function, range, integer, file|postscript|postscriptfile, string) -> void\n   externalplot({filename}, {mode}, {function}, {range}, {precision}, {perturb}, {plot mode}, {result filename}) : (string, absolute|relative, function, range, integer, perturb, file|postscript|postscriptfile, string) -> void\n\nDescription: \n   * The command externalplot plots the error of an external function\n   evaluation code sequence implemented in the object file named\n   {filename} with regard to the function {function}.  If {mode}\n   evaluates to {absolute}, the difference of both functions is\n   considered as an error function; if {mode} evaluates to {relative},\n   the difference is divided by the function {function}. The resulting\n   error function is plotted on all floating-point numbers with\n   {precision} significant mantissa bits in the range {range}. \n    \n   If the sixth argument of the command externalplot is given and evaluates to\n   perturb, each of the floating-point numbers the function is evaluated at gets perturbed by a\n   random value that is uniformly distributed in +/-1 ulp\n   around the original {precision} bit floating-point variable.\n    \n   If a sixth and seventh argument, respectively a seventh and eighth\n   argument in the presence of perturb as a sixth argument, are given\n   that evaluate to a variable of type file|postscript|postscriptfile respectively to a\n   character sequence of type string, externalplot will plot\n   (additionally) to a file in the same way as the command plot\n   does. See plot for details.\n    \n   The external function evaluation code given in the object file name\n   {filename} is supposed to define a function name f as\n   follows (here in C syntax): void f(mpfr_t rop, mpfr_t op). \n   This function is supposed to evaluate op with an accuracy corresponding\n   to the precision of rop and assign this value to\n   rop.\n\nExample 1: \n   > bashexecute(\"gcc -fPIC -c externalplotexample.c\");\n   > bashexecute(\"gcc -shared -o externalplotexample externalplotexample.o -lgmp -lmpfr\");\n   > externalplot(\"./externalplotexample\",relative,exp(x),[-1/2;1/2],12,perturb);\n\nSee also: plot, asciiplot, perturb, absolute, relative, file, postscript, postscriptfile, bashexecute, externalproc, library\n"
#define HELP_EXTERNALPROC_TEXT "Name: externalproc\n==> binds an external code to a Sollya procedure\n\nLibrary names:\n     sollya_obj_t sollya_lib_externalprocedure(sollya_externalprocedure_type_t, \n                                               sollya_externalprocedure_type_t *,\n                                               int, char *, void *);\n     sollya_obj_t sollya_lib_externalprocedure_with_data(\n                                               sollya_externalprocedure_type_t, \n                                               sollya_externalprocedure_type_t *,\n                                               int, char *, void *, void *,\n                                               void (*)(void *));\n\nUsage: \n   externalproc({identifier}, {filename}, {argumenttype} -> {resulttype}) : (identifier type, string, type type, type type) -> void\n\nParameters: \n   {identifier} represents the identifier the code is to be bound to\n   {filename} of type string represents the name of the object file where the code of procedure can be found\n   {argumenttype} represents a definition of the types of the arguments of the Sollya procedure and the external code\n   {resulttype} represents a definition of the result type of the external code\n\nDescription: \n   * externalproc allows for binding the Sollya identifier {identifier} to an\n   external code. After this binding, when Sollya encounters {identifier}\n   applied to a list of actual parameters, it will evaluate these parameters and\n   call the external code with these parameters. If the external code indicated\n   success, it will receive the result produced by the external code, transform\n   it to Sollya's internal representation and return it.\n    \n   In order to allow correct evaluation and typing of the data in parameter and\n   in result to be passed to and received from the external code, externalproc\n   has a third parameter {argumenttype} -> {resulttype}. Both {argumenttype} and\n   {resulttype} are one of void, constant, function, object, range, integer,\n   string, boolean, list of constant, list of function, list of object,\n   list of range, list of integer, list of string, list of boolean.\n    \n   It is worth mentioning that the difference between the data and\n   result type function and the type object is minimal and due to\n   support of legacy Sollya code. Both Sollya functions and Sollya\n   objects are transferred from and to the external procedure thru the C\n   type sollya_obj_t. The difference is that\n   Sollya will check that a certain object is a mathematical function\n   when function is used as a type, and will skip this test if the\n   object type is used. Similarly, Sollya relies on an object produced\n   by the external procedure to be a mathematical function when function\n   is used and will not make this assumption for object.\n    \n   If upon a usage of a procedure bound to an external procedure the type of the\n   actual parameters given or its number is not correct, Sollya produces a type\n   error. An external function not applied to arguments represents itself and\n   prints out with its argument and result types.\n    \n   The external function is supposed to return an integer indicating success. It\n   returns its result depending on its Sollya result type as follows. Here, the\n   external procedure is assumed to be implemented as a C function. \n      - If the Sollya result type is void, the C function has no pointer\n        argument for the result.\n      - If the Sollya result type is constant, the first argument of the\n        C function is of C type mpfr_t *, the result is returned by affecting\n        the MPFR variable.\n      - If the Sollya result type is function, the first argument of the\n        C function is of C type sollya_obj_t *, the result is returned by\n        affecting the sollya_obj_t variable.\n      - If the Sollya result type is object, the first argument of the\n        C function is of C type sollya_obj_t *, the result is returned by\n        affecting the sollya_obj_t variable.\n      - If the Sollya result type is range, the first argument of the C function\n        is of C type mpfi_t *, the result is returned by affecting the MPFI\n        variable.\n      - If the Sollya result type is integer, the first argument of the\n        C function is of C type int *, the result is returned by affecting the\n        int variable.\n      - If the Sollya result type is string, the first argument of the\n        C function is of C type char **, the result is returned by the char *\n        pointed with a new char *.\n      - If the Sollya result type is boolean, the first argument of the\n        C function is of C type int *, the result is returned by affecting the\n        int variable with a boolean value.\n      - If the Sollya result type is list of type, the first argument of the\n        C function is of a C type depending on the Sollya return type: \n          - For a list of constant: sollya_constant_list_t *\n          - For a list of function: sollya_obj_list_t *\n          - For a list of object: sollya_obj_list_t *\n          - For a list of range: sollya_constant_list_t *\n          - For a list of integer: sollya_int_list_t *\n          - For a list of string: sollya_string_list_t *\n          - For a list of boolean: sollya_boolean_list_t *  \n    \n   The external procedure affects its possible pointer argument if and only if\n   it succeeds. This means, if the function returns an integer indicating\n   failure, it does not leak any memory to the encompassing environment.\n    \n   The external procedure receives its arguments as follows: If the Sollya\n   argument type is void, no argument array is given. Otherwise the C function\n   receives a C void ** argument representing an array of size equal to the\n   arity of the function where each entry (of C type void *) represents a value\n   with a C type depending on the corresponding Sollya type. \n      - If the Sollya type is constant, the void * is to be cast to mpfr_t *.\n      - If the Sollya type is function, the void * is to be cast to\n        sollya_obj_t.\n      - If the Sollya type is object, the void * is to be cast to sollya_obj_t.\n      - If the Sollya type is range, the void * is to be cast to mpfi_t *.\n      - If the Sollya type is integer, the void * is to be cast to int *.\n      - If the Sollya type is string, the void * is to be cast to char *.\n      - If the Sollya type is boolean, the void * is to be cast to int *.\n      - If the Sollya type is list of type, the void * is to be cast to a list\n        of a type depending on the type of the list argument: \n          - For a list of constant: sollya_constant_list_t\n          - For a list of function: sollya_obj_list_t\n          - For a list of object: sollya_obj_list_t\n          - For a list of range: sollya_interval_list_t\n          - For a list of integer: sollya_int_list_t\n          - For a list of string: sollya_string_list_t\n          - For a list of boolean: sollya_boolean_list_t  \n    \n   The external procedure is not supposed to alter the memory pointed by its\n   array argument void **.\n    \n   In both directions (argument and result values), empty lists are represented\n   by NULL pointers.\n    \n   Similarly to internal procedures, externally bounded procedures can be\n   considered to be objects inside Sollya that can be assigned to other\n   variables, stored in list etc.\n\n   * The user should be aware that they may use the Sollya library in external\n   codes to be dynamically bound to Sollya using externalproc. On most systems,\n   it suffices to include the header of the Sollya library into the source code\n   of the external procedure. Linking with the actual Sollya library is not\n   necessary on most systems; as the interactive Sollya executable contains a\n   superset of the Sollya library functions. On some systems, linking with the\n   Sollya library or some of its dependencies may be necessary.\n    \n   In particular, the Sollya library -- and, of course, its header file --\n   contain a certain set of functions to manipulate lists with elements of\n   certain types, such as sollya_constant_list_t, sollya_obj_list_t and so on.\n   As explained above, these types are passed in argument to (and received back\n   thru a reference from) an external procedure. These list manipulation\n   functions are not strictly necessary to the use of the Sollya library in\n   free-standing applications that do not use the functionality provided with\n   externalproc. They are therefore provided as-is without any further\n   documentation, besides the comments given in the Sollya library header file.\n\n   * The dynamic object file whose name is given to externalproc for binding of\n   an external procedure may also define a destructor function\n   int sollya_external_lib_close(void). If Sollya finds such a destructor\n   function in the dynamic object file, it will call that function when closing\n   the dynamic object file again. This happens when Sollya is terminated or when\n   the current Sollya session is restarted using restart. The purpose of the\n   destructor function is to allow the dynamically bound code to free any memory\n   that it might have allocated before Sollya is terminated or restarted.\n    \n   The dynamic object file is not necessarily needed to define a destructor\n   function. This ensure backward compatibility with older Sollya external\n   library function object files.\n    \n   When defined, the destructor function is supposed to return an integer\n   value indicating if an error has happened. Upon success, the destructor\n   functions is to return a zero value, upon error a non-zero value.\n\nExample 1: \n   > bashexecute(\"gcc -fPIC -Wall -c externalprocexample.c\");\n   > bashexecute(\"gcc -fPIC -shared -o externalprocexample externalprocexample.o\");\n   > externalproc(foo, \"./externalprocexample\", (integer, integer) -> integer);\n   > foo;\n   foo\n   > foo(5, 6);\n   11\n   > verbosity = 1!;\n   > foo();\n   Warning: at least one of the given expressions or a subexpression is not correctly typed\n   or its evaluation has failed because of some error on a side-effect.\n   error\n   > a = foo;\n   > a(5,6);\n   11\n\nSee also: library, libraryconstant, externaldata, externalplot, bashexecute, void, constant, function, range, integer, string, boolean, list of, object\n"
#define HELP_FALSE_TEXT "Name: false\n==> the boolean value representing the false.\n\nLibrary names:\n   sollya_obj_t sollya_lib_false()\n   int sollya_lib_is_false(sollya_obj_t)\n\nDescription: \n   * false is the usual boolean value.\n\nExample 1: \n   > true && false;\n   false\n   > 2<1;\n   false\n\nSee also: true, &&, ||\n"
#define HELP_FILE_TEXT "Name: file\n==> special value for commands plot and externalplot\n\nLibrary names:\n   sollya_obj_t sollya_lib_file()\n   int sollya_lib_is_file(sollya_obj_t)\n\nDescription: \n   * file is a special value used in commands plot and externalplot to save\n   the result of the command in a data file.\n\n   * As any value it can be affected to a variable and stored in lists.\n\nExample 1: \n   > savemode=file;\n   > name=\"plotSinCos\";\n   > plot(sin(x),0,cos(x),[-Pi,Pi],savemode, name);\n\nSee also: externalplot, plot, postscript, postscriptfile\n"
#define HELP_FINDZEROS_TEXT "Name: findzeros\n==> gives a list of intervals containing all zeros of a function on an interval.\n\nLibrary name:\n   sollya_obj_t sollya_lib_findzeros(sollya_obj_t, sollya_obj_t)\n\nUsage: \n   findzeros({f},{I}) : (function, range) -> list\n\nParameters: \n   {f} is a function.\n   {I} is an interval.\n\nDescription: \n   * findzeros({f},{I}) returns a list of intervals {I1}, ... ,{In} such that, for \n   every zero z of f, there exists some k such that z is in Ik.\n\n   * The list may contain intervals {Ik} that do not contain any zero of {f}.\n   An interval {Ik} may contain many zeros of {f}.\n\n   * This command is meant for cases when safety is critical. If you want to be sure\n   not to forget any zero, use findzeros. However, if you just want to know \n   numerical values for the zeros of {f}, dirtyfindzeros should be quite \n   satisfactory and a lot faster.\n\n   * If d denotes the value of global variable diam, the algorithm ensures\n   that for each k, |Ik| < d*|I|.\n\n   * The algorithm used is basically a bisection algorithm. It is the same algorithm\n   that the one used for infnorm. See the help page of this command for more \n   details. In short, the behavior of the algorithm depends on global variables\n   prec, diam, taylorrecursions and hopitalrecursions.\n\nExample 1: \n   > findzeros(sin(x),[-5;5]);\n   [|[-3.14208984375;-3.140869140625], [-1.220703125e-3;1.220703125e-3], [3.140869140625;3.14208984375]|]\n   > diam=1e-10!;\n   > findzeros(sin(x),[-5;5]);\n   [|[-3.14159265370108187198638916015625;-3.141592652536928653717041015625], [-1.16415321826934814453125e-9;1.16415321826934814453125e-9], [3.141592652536928653717041015625;3.14159265370108187198638916015625]|]\n\nSee also: dirtyfindzeros, infnorm, prec, diam, taylorrecursions, hopitalrecursions, numberroots\n"
#define HELP_FIXED_TEXT "Name: fixed\n==> indicates that fixed-point formats should be used for fpminimax\n\nLibrary names:\n   sollya_obj_t sollya_lib_fixed()\n   int sollya_lib_is_fixed(sollya_obj_t)\n\nUsage: \n   fixed : fixed|floating\n\nDescription: \n   * The use of fixed in the command fpminimax indicates that the list of\n   formats given as argument is to be considered to be a list of fixed-point\n   formats.\n   See fpminimax for details.\n\nExample 1: \n   > fpminimax(cos(x),6,[|32,32,32,32,32,32,32|],[-1;1],fixed);\n   0.9999997480772435665130615234375 + x^2 * (-0.4999928693287074565887451171875 + x^2 * (4.163351492024958133697509765625e-2 + x^2 * (-1.338223926723003387451171875e-3)))\n\nSee also: fpminimax, floating\n"
#define HELP_FLOATING_TEXT "Name: floating\n==> indicates that floating-point formats should be used for fpminimax\n\nLibrary names:\n   sollya_obj_t sollya_lib_floating()\n   int sollya_lib_is_floating(sollya_obj_t)\n\nUsage: \n   floating : fixed|floating\n\nDescription: \n   * The use of floating in the command fpminimax indicates that the list of\n   formats given as argument is to be considered to be a list of floating-point\n   formats.\n   See fpminimax for details.\n\nExample 1: \n   > fpminimax(cos(x),6,[|D...|],[-1;1],floating);\n   0.99999974816012215939053930924274027347564697265625 + x * (-2.795931796958502334440230695107655659202089892465e-15 + x * (-0.49999286980201401719980935922649223357439041137695 + x * (4.0484539189054105169841244454207387920433372507922e-14 + x * (4.1633515528919168291466235132247675210237503051758e-2 + x * (-4.015858818743733758578949218474363725507386355118e-14 + x * (-1.3382240885483781024645200119493892998434603214264e-3))))))\n\nSee also: fpminimax, fixed\n"
#define HELP_FLOOR_TEXT "Name: floor\n==> the usual function floor.\n\nLibrary names:\n   sollya_obj_t sollya_lib_floor(sollya_obj_t)\n   sollya_obj_t sollya_lib_build_function_floor(sollya_obj_t)\n   #define SOLLYA_FLOOR(x) sollya_lib_build_function_floor(x)\n\nDescription: \n   * floor is defined as usual: floor(x) is the greatest integer y such that y <= x.\n\n   * It is defined for every real number x.\n\nSee also: ceil, nearestint, round, RD\n"
#define HELP_FPMINIMAX_TEXT "Name: fpminimax\n==> computes a good polynomial approximation with fixed-point or floating-point coefficients\n\nLibrary names:\n   sollya_obj_t sollya_lib_fpminimax(sollya_obj_t, sollya_obj_t, sollya_obj_t,\n                                     sollya_obj_t, ...)\n   sollya_obj_t sollya_lib_v_fpminimax(sollya_obj_t, sollya_obj_t,\n                                       sollya_obj_t, sollya_obj_t, va_list)\n\nUsage: \n   fpminimax({f}, {n}, {formats}, {range}, {indic1}, {indic2}, {indic3}, {P}) : (function, integer, list, range, absolute|relative | fixed|floating | function, absolute|relative | fixed|floating | function, absolute|relative | fixed|floating | function, function) -> function\n   fpminimax({f}, {monomials}, {formats}, {range}, {indic1}, {indic2}, {indic3}, {P}) : (function, list, list, range,  absolute|relative | fixed|floating | function, absolute|relative | fixed|floating | function, absolute|relative | fixed|floating | function, function) -> function\n   fpminimax({f}, {n}, {formats}, {L}, {indic1}, {indic2}, {indic3}, {P}) : (function, integer, list, list,  absolute|relative | fixed|floating | function, absolute|relative | fixed|floating | function, absolute|relative | fixed|floating | function, function) -> function\n   fpminimax({f}, {monomials}, {formats}, {L}, {indic1}, {indic2}, {indic3}, {P}) : (function, list, list, list,  absolute|relative | fixed|floating | function, absolute|relative | fixed|floating | function, absolute|relative | fixed|floating | function, function) -> function\n   fpminimax({f}, {n}, {formats}, {range}, {indic1}, {indic2}, {indic3}, {Lcoeffs}) : (function, integer, list, range, absolute|relative | fixed|floating | function, absolute|relative | fixed|floating | function, absolute|relative | fixed|floating | function, list) -> function\n   fpminimax({f}, {monomials}, {formats}, {range}, {indic1}, {indic2}, {indic3}, {Lcoeffs}) : (function, list, list, range,  absolute|relative | fixed|floating | function, absolute|relative | fixed|floating | function, absolute|relative | fixed|floating | function, list) -> function\n   fpminimax({f}, {n}, {formats}, {L}, {indic1}, {indic2}, {indic3}, {Lcoeffs}) : (function, integer, list, list,  absolute|relative | fixed|floating | function, absolute|relative | fixed|floating | function, absolute|relative | fixed|floating | function, list) -> function\n   fpminimax({f}, {monomials}, {formats}, {L}, {indic1}, {indic2}, {indic3}, {Lcoeffs}) : (function, list, list, list,  absolute|relative | fixed|floating | function, absolute|relative | fixed|floating | function, absolute|relative | fixed|floating | function, list) -> function\n\nParameters: \n   {f} is the function to be approximated\n   {n} is the degree of the polynomial that must approximate {f}\n   {monomials} is a list of integers or a list of function. It indicates the basis for the approximation of {f}\n   {formats} is a list indicating the formats that the coefficients of the polynomial must have\n   {range} is the interval where the function must be approximated\n   {L} is a list of interpolation points used by the method\n   {indic1} (optional) is one of the optional indication parameters. See the detailed description below.\n   {indic2} (optional) is one of the optional indication parameters. See the detailed description below.\n   {indic3} (optional) is one of the optional indication parameters. See the detailed description below.\n   {P} (optional) is the minimax polynomial to be considered for solving the problem.\n   {Lcoeffs} (optional) is a list containing the coefficients of the minimax polynomial to be considered for solving the problem.\n\nDescription: \n   * fpminimax uses a heuristic (but practically efficient) method to find a\n   good polynomial approximation of a function {f} on an interval {range}. It\n   implements the method published in the article: \n   Efficient polynomial L^\\infty - approximations\n   Nicolas Brisebarre and Sylvain Chevillard \n   Proceedings of the 18th IEEE Symposium on Computer Arithmetic (ARITH 18) \n   pp. 169-176\n\n   * The basic usage of this command is fpminimax({f}, {n}, {formats}, {range}).\n   It computes a polynomial approximation of f with degree at most n\n   on the interval {range}. {formats} is a list of integers or format types\n   (such as double, doubledouble, etc.). The polynomial returned by the\n   command has its coefficients that fit the formats indications. For\n   instance, if formats[0] is 35, the coefficient of degree 0 of the\n   polynomial will fit a floating-point format of 35 bits. If formats[1]\n   is D, the coefficient of degree 1 will be representable by a floating-point\n   number with a precision of 53 bits (which is not necessarily an IEEE 754\n   double precision number. See the remark below), etc.\n\n   * In its most general form, fpminimax takes a function {f} to be\n   approximated, a list of basis functions g0, ..., gn, a list of points {L},\n   and a constrained part q. It returns an expression p of the form\n   p = q+a0*g0+...+an*gn such that (p-f) or (p-f)/f (depending whether the\n   error to be considered is the absolute of relative error) is as small as\n   possible on the points of {L} and with coefficients a0, ..., an fitting on\n   given formats. fpminimax admits several syntaxes listed above and described\n   below to conveniently handle usual cases (such as when g0, ..., gn is the\n   standard monomial basis X^0, ..., X^n) and to automatically compute a\n   suitable list of points {L} on a given range.\n\n   * The second argument may be either an integer, a list of integers or a list\n   of functions. An integer indicates the degree of the desired polynomial\n   approximation. A list of integers indicates the list of desired monomials.\n   For instance, the list [|0,2,4,6|] indicates that the polynomial must be\n   even and of degree at most 6. Giving an integer n as second argument is\n   equivalent as giving [|0,...,n|].\n   Finally, a list of function g_k indicates that the desired approximation\n   must be a linear combination of the g_k. \n   The list of formats is interpreted with respect to the list of monomials. For\n   instance, if the list of monomials is [|0,2,4,6|] and the list\n   of formats is [|161,107,53,24|], the coefficients of degree 0 is\n   searched as a floating-point number with precision 161, the coefficient of\n   degree 2 is searched as a number of precision 107, and so on.\n\n   * The list of formats may contain either integers or format types\n   (halfprecision, single, double, doubledouble, tripledouble, doubleextended\n   and quad). The list may be too large or even infinite. Only the first\n   indications will be considered. For instance, for a degree n polynomial,\n   formats[n+1] and above will be discarded. This lets one use elliptical\n   indications for the last coefficients. For historical reasons, and as opposed\n   to the general rule within Sollya, the case of an end-elliptic list whose\n   last defined element is numeric is interpreted as the infinite list where the\n   last defined element is repeated: therefore, e.g., [|24...|] is a perfect\n   synonym for [|SG...|]. Because this behavior can be confusing, using for the\n   formats an end-elliptic list whose last defined element is numeric is\n   deprecated and will be forbidden in a future release.\n\n   * The floating-point coefficients considered by fpminimax do not have an\n   exponent range. In particular, in the format list, double is an exact synonym\n   for 53. Currently, fpminimax only ensures that the corresponding coefficient\n   has at most 53 bits of mantissa. It does not imply that it is an\n   IEEE-754 double.\n\n   * By default, the list of formats is interpreted as a list of floating-point\n   formats. This may be changed by passing fixed as an optional argument (see\n   below). Let us take an example: fpminimax(f, 2, [|107, DD, 53|], [0;1]).\n   Here the optional argument is missing (we could have set it to floating).\n   Thus, fpminimax will search for a polynomial of degree 2 with a constant\n   coefficient that is a 107 bits floating-point number, etc. \n   Currently, doubledouble is just a synonym for 107 and tripledouble a\n   synonym for 161. This behavior may change in the future (taking into\n   account the fact that some double-doubles are not representable with\n   107 bits). \n   Second example: fpminimax(f, 2, [|25, 18, 30|], [0;1], fixed).\n   In this case, fpminimax will search for a polynomial of degree 2 with a\n   constant coefficient of the form m/2^25 where m is an\n   integer. In other words, it is a fixed-point number with 25 bits after\n   the point. Note that even with argument fixed, the formats list is\n   allowed to contain halfprecision, single, double, doubleextended,\n   doubledouble, quad or tripledouble. In this this case, it is just\n   a synonym for 11, 24, 53, 64, 107, 113 or 161. This is deprecated and\n   may change in the future.\n\n   * The fourth argument may be a range or a list. Lists are for advanced users\n   that know what they are doing. The core of the  method is a kind of\n   approximated interpolation. The list given here is a list of points that\n   must be considered for the interpolation. It must contain at least as\n   many points as unknown coefficients. If you give a list, it is also\n   recommended that you provide the minimax polynomial as last argument.\n   If you give a range, the list of points will be automatically computed.\n\n   * The fifth, sixth and seventh arguments are optional. By default, fpminimax\n   will approximate f while optimizing the relative error, and interpreting\n   the list of formats as a list of floating-point formats. \n   This default behavior may be changed with these optional arguments. You\n   may provide zero, one, two or three of the arguments in any order.\n   This lets the user indicate only the non-default arguments. \n   The three possible arguments are:  \n       - relative or absolute: the error to be optimized;\n       - floating or fixed: formats of the coefficients;\n       - a constrained part q.\n    \n   The constrained part lets the user assign in advance some of the\n   coefficients. For instance, for approximating exp(x), it may\n   be interesting to search for a polynomial p of the form\n                   p = 1 + x + x^2/2 + a3 x^3 + a4 x^4.\n   Thus, there is a constrained part q = 1 + x + x^2/2 and the unknown\n   polynomial should be considered in the monomial basis [|3, 4|].\n   Calling fpminimax with monomial basis [|3,4|] and constrained\n   part q, will return a polynomial with the right form.\n    \n   Notice that it is perfectly allowed that the monomial basis contains\n   monomials also present in the constrained part. This can be useful for\n   instance to fix the upper part of a doubledouble and look only for the\n   second double of the expansion. For instance, in the previous example, we\n   could use the same constrained part q = 1 + x + x^2/2 but with the full\n   monomial basis [|0,..., 4|]. The resulting polynomial will be of the form\n   p = 1 + x + x^2/2 + a0 + a1 x + a2 x^2 + a3 x^3 + a4 x^4, or equivalently\n   (1+a0) + (1+a1) x + (1/2 + a2) x^2 + a3 x^3 + a4 x^4. Therefore, if for\n   instance the coefficients a0 to a4 are asked to be double, the resulting\n   polynomial p has its three first coefficients that are doubledouble with\n   fixed upper parts.\n\n   * The last argument is for advanced users. It is the minimax polynomial that\n   approximates the function f in the given basis. If it is not given\n   this polynomial will be automatically computed by fpminimax.\n    \n   This minimax polynomial is used to compute the list of interpolation\n   points required by the method. It is also used, when floating-point\n   coefficients are desired, to give an initial assumption for the\n   exponents of the coeffcients. In general, you do not have to provide this\n   argument. But if you want to obtain several polynomials of the same degree\n   that approximate the same function on the same range, just changing the\n   formats, you should probably consider computing only once the minimax\n   polynomial and the list of points instead of letting fpminimax recompute\n   them each time.\n    \n   Note that in the case when a constrained part is given, the minimax\n   polynomial must take that into account. For instance, in the previous\n   example, the minimax would be obtained by the following command:\n          P = remez(1-(1+x+x^2/2)/exp(x), [|3,4|], range, 1/exp(x));\n   Note that the constrained part is not to be added to P.\n    \n   In the case when the second argument is an integer or a list of integers,\n   there is no restriction for P, as long as it is a polynomial.\n   However, when the second argument is a list of functions, and even if these\n   functions are all polynomials, P must be expanded in the given basis.\n   For instance, if the second argument is 2 or [|0, 1, 2|], P can be given\n   in Horner form. However, if the second argument is [|1, x, x^2|], P must\n   be written as a linear combination of 1, x and x^2, otherwise, the algorithm\n   will fail to recover the coefficients of P and will fail with an error\n   message.\n    \n   Please also note that recovering the coefficients of P in an arbitrary\n   basis is performed heuristically and no verification is performed to check\n   that P does not contain other functions than the functions of the basis.\n    \n   For all these reasons, it is sometimes useful to provide a list of\n   coefficients Lcoeffs instead of P. In this case, the convention is that the\n   i-th element of Lcoeffs is the coefficient of the i-th basis function in the\n   minimax polynomial. Lcoeffs might contain more elements than there are basis\n   functions, in which case the extra elements will be ignored.\n\n   * For historical reasons, fpminimax and remez have different syntaxes.\n   Indeed, the syntax of fpminimax has been designed to be higher level and\n   closer to usual customer needs. However, the reader's attention is drawn on\n   the fact that this could be confusing: the argument f in fpminimax is always\n   the function to be approximated, regardless of the mode (absolute or\n   relative) which is passed as a separate argument, while remez takes two\n   arguments f and w and looks for the approximation p that minimizes f-p*w\n   (with w=1 by default). Therefore, in remez looking for the approximation p\n   that minimizes the relative error with respect to a given function g is\n   performed by taking f=1 and w=1/g.\n    \n   It may seem at first sight that the syntax of remez is more powerful\n   than fpminimax as one can imagine to simultaneously use a non trivial f and a\n   non trivial w, hence performing a weighted approximation. The same result can\n   actually be achieved with fpminimax (to the price of a slightly more involved\n   syntax) by approximating f in the customed monomial basis formed of w,\n   w(x)*x, w(x)*x^2, ..., w(x)*x^j, etc.\n\n   * Note that fpminimax internally computes a minimax polynomial (using\n   the same algorithm as remez command). Thus fpminimax may encounter\n   the same problems as remez. In particular, it may be very slow\n   when Haar condition is not fulfilled. Another consequence is that\n   currently fpminimax has to be run with a sufficiently high working precision.\n\nExample 1: \n   > P = fpminimax(cos(x),6,[|DD, DD, D...|],[-1b-5;1b-5]);\n   > printexpansion(P);\n   (0x3ff0000000000000 + 0xbc09fda15e029b00) + x * ((0x3af9eb57163024a8 + 0x37942c2f3f3e3839) + x * (0xbfdfffffffffff98 + x * (0xbbd1693f9c028849 + x * (0x3fa5555555145337 + x * (0x3c7a25f610ad9ebc + x * 0xbf56c138142da5b0)))))\n\nExample 2: \n   > P = fpminimax(sin(x),6,[|32...|],[-1b-5;1b-5], fixed, absolute);\n   > display = powers!;\n   > P;\n   x * (1 + x^2 * (-357913941 * 2^(-31) + x^2 * (35789873 * 2^(-32))))\n\nExample 3: \n   > P = fpminimax(exp(x), [|3,4|], [|D,24|], [-1/256; 1/246], 1+x+x^2/2);\n   > display = powers!;\n   > P;\n   1 + x * (1 + x * (1 * 2^(-1) + x * (375300225001191 * 2^(-51) + x * (5592621 * 2^(-27)))))\n\nExample 4: \n   > print(\"Weighted approximation: look for p such that (p-f)*w is small\");\n   Weighted approximation: look for p such that (p-f)*w is small\n   > n = 3;\n   > f = exp(x);\n   > w = sqrt(1-x^2);\n   > monomials = [||];\n   > for i from 0 to n do { monomials = monomials :. x^i*sqrt(1-x^2); };\n   > q = fpminimax(f*w, monomials, [|D...|], [-99/100,99/100],absolute);\n   > display = dyadic!;\n   > print(q);\n   3194834406077049b-54 * x^3 * sqrt(1 - x^2) + 4792048811386295b-53 * x^2 * sqrt(1 - x^2) + 8982938415377717b-53 * x * sqrt(1 - x^2) + 561436817847349b-49 * sqrt(1 - x^2)\n   > leadingcoeff = proc(expr) {\n       var res;\n       match(expr) with\n         a*b+c : {res = [|a,c|]; }\n         a*b : {res = [|a,0|]; }\n         default: {res = error; };\n       return res;\n     };\n   > p = 0;\n   > for i from n to 0 by -1 do {\n       L = leadingcoeff(q);\n       p = p + L[0]*x^i;\n       q = L[1];\n     };\n   > print(p);\n   3194834406077049b-54 * x^3 + 4792048811386295b-53 * x^2 + 8982938415377717b-53 * x + 561436817847349b-49 * x^0\n   > display=decimal!;\n   > dirtyinfnorm((p-f)*w, [-1,1]);\n   2.7416001717508988167160223812127007458632536307517e-3\n   > r = remez(f*w,n,[-99/100,99/100],w);\n   > dirtyinfnorm((r-f)*w, [-1,1]);\n   2.7416001717508734413506680717675258974378965304354e-3\n\nExample 5: \n   > I = [-1b-20,  1b-22];\n   > P0 = fpminimax(exp(x), 4, [|DD,DD,DD,D,SG|], I);\n   > P1 = fpminimax(exp(x), 4, [|D,D,D,D,SG|], I, 1+x+x^2/2);\n   > for k from 0 to 2 do { DD(coeff(P0,k)) == coeff(P0,k); };\n   true\n   true\n   true\n   > for k from 0 to 2 do { DD(coeff(P1,k)) == coeff(P1,k); };\n   true\n   true\n   true\n   > dirtyinfnorm(P0/exp(x)-1, I);\n   6.2744565211592155928616387674345117702132844508175e-35\n   > dirtyinfnorm(P1/exp(x)-1, I);\n   5.8284777124834959383794298527146965060524845952998e-35\n\nExample 6: \n   > f = cos(exp(x));\n   > pstar = remez(f, 5, [-1b-7;1b-7]);\n   > listpoints = dirtyfindzeros(f-pstar, [-1b-7; 1b-7]);\n   > P1 = fpminimax(f, 5, [|DD...|], listpoints, absolute, default, default, pstar);\n   > P2 = fpminimax(f, 5, [|D...|], listpoints, absolute, default, default, pstar);\n   > P3 = fpminimax(f, 5, [|D, D, D, 24...|], listpoints, absolute, default, default, pstar);\n   > print(\"Error of pstar: \", dirtyinfnorm(f-pstar, [-1b-7; 1b-7]));\n   Error of pstar:  7.9048441259903026332577436001060063099817726177425e-16\n   > print(\"Error of P1:    \", dirtyinfnorm(f-P1, [-1b-7; 1b-7]));\n   Error of P1:     7.9048441259903026580081299123420463921479618202064e-16\n   > print(\"Error of P2:    \", dirtyinfnorm(f-P2, [-1b-7; 1b-7]));\n   Error of P2:     8.2477144579950871737109573536791331686347620955985e-16\n   > print(\"Error of P3:    \", dirtyinfnorm(f-P3, [-1b-7; 1b-7]));\n   Error of P3:     1.08454277156993282593701156841863009789063333951055e-15\n\nExample 7: \n   > L = [|exp(x), sin(x), cos(x)-1, sin(x^3)|];\n   > g = (2^x-1)/x;\n   > p = fpminimax(g, L, [|D...|], [-1/16;1/16],absolute);\n   > display = powers!;\n   > p;\n   -3267884797436153 * 2^(-54) * sin(x^3) + 5247089102535885 * 2^(-53) * (cos(x) - 1) + -8159095033730771 * 2^(-54) * sin(x) + 6243315658446641 * 2^(-53) * exp(x)\n\nExample 8: \n   > n = 9;\n   > T = [|1, x|];\n   > for i from 2 to n do T[i] = canonical(2*x*T[i-1]-T[i-2]);\n   > g = (2^x-1)/x;\n   > PCheb = fpminimax(g, T, [|DD,DE...|], [-1/16;1/16],absolute);\n   > display = dyadic!;\n   > print(PCheb);\n   112469560253864905423137861008261b-107 + x * (76130818934358736339243350051b-98 + x * (34355379230514621195759363b-89 + x * (381013348011182609334519067b-95 + x * (825307274780189286345649b-89 + x * (3050983523250669954220137b-94 + x * (1180123116639845252291b-86 + x * (6543992088039485657053b-92 + x * (15750497046710770365b-87 + x * 8733930098894247371b-90))))))))\n\nExample 9: \n   > d = [46768052394588893382517914646921056628989841b-165;1b-7];\n   > n = 4; f = 1; w = sqrt(x)/acos(1-x);\n   > p = remez(f, n, d, w);\n   > monomials = [||]; Lcoeffs = [||];\n   > for i from 0 to n do {\n        monomials = monomials :. x^i*sqrt(x);\n        Lcoeffs = Lcoeffs :. coeff(p, i);\n     };\n   > pf = fpminimax(acos(1-x), monomials, [|D...|], d, relative, floating, 0, Lcoeffs);\n   > display = dyadic!;\n   > print(pf);\n   6237591828287231b-61 * x^4 * sqrt(x) + 1137310727877715b-57 * x^3 * sqrt(x) + 7642862123083659b-58 * x^2 * sqrt(x) + 1061508612083747b-53 * x * sqrt(x) + 6369051672525773b-52 * sqrt(x)\n\nSee also: remez, dirtyfindzeros, absolute, relative, fixed, floating, default, halfprecision, single, double, doubleextended, doubledouble, quad, tripledouble, implementpoly, coeff, degree, roundcoefficients, guessdegree\n"
#define HELP_FULLPARENTHESES_TEXT "Name: fullparentheses\n==> activates, deactivates or inspects the state variable controlling output with full parenthesising\n\nLibrary names:\n   void sollya_lib_set_fullparentheses_and_print(sollya_obj_t);\n   void sollya_lib_set_fullparentheses(sollya_obj_t);\n   sollya_obj_t sollya_lib_get_fullparentheses();\n\nUsage: \n   fullparentheses = {activation value} : on|off -> void\n   fullparentheses = {activation value} ! : on|off -> void\n\nParameters: \n   {activation value} represents on or off, i.e. activation or deactivation\n\nDescription: \n   * An assignment fullparentheses = {activation value}, where {activation value}\n   is one of on or off, activates respectively deactivates the output\n   of expressions with full parenthesising. In full parenthesising mode,\n   Sollya commands like print, write and the implicit command when an\n   expression is given at the prompt will output expressions with\n   parenthesising at all places where it is necessary for expressions\n   containing infix operators to be parsed back with the same\n   result. Otherwise parentheses around associative operators are\n   omitted.\n    \n   If the assignment fullparentheses = {activation value} is followed by an\n   exclamation mark, no message indicating the new state is\n   displayed. Otherwise the user is informed of the new state of the\n   global mode by an indication.\n\nExample 1: \n   > autosimplify = off!;\n   > fullparentheses = off;\n   Full parentheses mode has been deactivated.\n   > print(1 + 2 + 3);\n   1 + 2 + 3\n   > fullparentheses = on;\n   Full parentheses mode has been activated.\n   > print(1 + 2 + 3);\n   (1 + 2) + 3\n\nSee also: print, write, autosimplify\n"
#define HELP_FUNCTION_TEXT "Name: function\n==> keyword for declaring a procedure-based function or a keyword representing a function type \n\nLibrary names:\n   sollya_obj_t sollya_lib_procedurefunction(sollya_obj_t, sollya_obj_t)\n   sollya_obj_t sollya_lib_build_function_procedurefunction(sollya_obj_t,\n                                                            sollya_obj_t)\n   SOLLYA_EXTERNALPROC_TYPE_FUNCTION\n\nUsage: \n   function({procedure})  : procedure -> function\n   function : type type\n\nParameters: \n   {procedure} is a procedure of type (range, integer, integer) -> range\n\nDescription: \n   * For the sake of safety and mathematical consistency, Sollya\n   distinguishes clearly between functions, seen in the mathematical\n   sense of the term, i.e. mappings, and procedures, seen in the sense\n   Computer Science gives to functions, i.e. pieces of code that compute\n   results for arguments following an algorithm. In some cases however,\n   it is interesting to use such Computer Science procedures as\n   realisations of mathematical functions, e.g. in order to plot them or\n   even to perform polynomial approximation on them. The function keyword\n   allows for such a transformation of a Sollya procedure into a Sollya\n   function. \n\n   * The procedure to be used as a function through function({procedure})\n   must be of type (range, integer, integer)\n   -> range. This means it must take in argument\n   an interval X, a degree of differentiation n and a\n   working precision p. It must return in result an interval\n   Y encompassing the image f^(n)(X) of the\n   n-th derivative of the implemented function f,\n   i.e. f^(n)(X) c Y. In order to allow\n   Sollya's algorithms to work properly, the procedure must ensure that,\n   whenever (p, diam(X)) tends to (infinity, 0),\n   the computed over-estimated bounding Y tends to the actual image f^(n)(X).\n\n   * The user must be aware that they are responsible of the correctness\n   of the procedure. If, for some n and X, {procedure} returns an interval Y\n   such that f^n(X) is not included in Y, function will successfully\n   return a function without any complain, but this function might behave\n   inconsistently in further computations.\n\n   * For cases when the procedure does not have the correct signature or\n   does not return a finite interval as a result function({procedure})\n   evaluates to Not-A-Number (resp. to an interval of Not-A-Numbers for\n   interval evaluation).\n\n   * function also represents the function type for declarations\n   of external procedures by means of externalproc.\n    \n   Remark that in contrast to other indicators, type indicators like\n   function cannot be handled outside the externalproc context.  In\n   particular, they cannot be assigned to variables.\n\nExample 1: \n   > procedure EXP(X,n,p) {\n     \t  var res, oldPrec;\n     \t  oldPrec = prec;\n     \t  prec = p!;\n     \t  \n     \t  res = exp(X);\n     \t  \n     \t  prec = oldPrec!;\n     \t  return res;\n     };\n   > f = function(EXP);\n   > f(1);\n   2.7182818284590452353602874713526624977572470937\n   > exp(1);\n   2.7182818284590452353602874713526624977572470937\n   > f(x + 3);\n   (function(proc(X, n, p)\n   {\n   var res, oldPrec;\n   oldPrec = prec;\n   prec = p!;\n   res = exp(X);\n   prec = oldPrec!;\n   return res;\n   }))(3 + x)\n   > diff(f);\n   diff(function(proc(X, n, p)\n   {\n   var res, oldPrec;\n   oldPrec = prec;\n   prec = p!;\n   res = exp(X);\n   prec = oldPrec!;\n   return res;\n   }))\n   > (diff(f))(0);\n   1\n   > g = f(sin(x));\n   > g(17);\n   0.38235816999386683402690554641655641359573458342088\n   > diff(g);\n   (diff(function(proc(X, n, p)\n   {\n   var res, oldPrec;\n   oldPrec = prec;\n   prec = p!;\n   res = exp(X);\n   prec = oldPrec!;\n   return res;\n   })))(sin(x)) * cos(x)\n   > (diff(g))(1);\n   1.25338076749344683697237458088447611474812675164344\n   > p = remez(f,3,[-1/2;1/2]);\n   > p;\n   0.99967120901420646830315493949039176881764871951833 + x * (0.99973702983571140134762682913614052309208076875596 + x * (0.510497293602826249216227216546435103583073053437 + x * 0.169814324607133287588897694747370380479108785868016))\n\nSee also: proc, library, procedure, externalproc, boolean, constant, integer, list of, range, string, object\n"
#define HELP_GCD_TEXT "Name: gcd\n==> Computes the greatest common divisor of polynomials or numbers.\n\nLibrary name:\n   sollya_obj_t sollya_lib_gcd(sollya_obj_t, sollya_obj_t)\n\nUsage: \n   gcd({p}, {q}) : (function, function) -> function\n\nParameters: \n   {p} is a constant or a polynomial.\n   {q} is a constant or a polynomial.\n\nDescription: \n   * When both {p} and {q} are integers, gcd({p},{q}) computes the greatest\n   common divisor of these two integers, i.e. the greatest non-negative integer\n   dividing both {p} and {q}.\n\n   * When both {p} and {q} are rational numbers, say a/b and c/d,\n   gcd({p},{q}) computes the greatest common divisor of a * d and b * c,\n   divided by the product of the denominators, b * d.\n\n   * When both {p} and {q} are constants but at least one of them is no rational\n   number, gcd({p},{q}) returns 1.\n\n   * When both {p} and {q} are polynomials with at least one being non-constant,\n   gcd({p},{q}) returns the polynomial of greatest degree dividing both {p} and\n   {q}, and whose leading coefficient is the greatest common divisor of the\n   leading coefficients of {p} and {q}.\n\n   * Similarly to the cases documented for div and mod, gcd\n   may fail to return the unique polynomial of largest degree dividing\n   both {p} and {q} in cases when certain coefficients of either {p} or\n   {q} are constant expressions for which the tool is unable to determine\n   whether they are zero or not. These cases typically involve\n   polynomials whose leading coefficient is zero but the tool is unable\n   to detect this fact.\n\n   * When at least one of {p} or {q} is a function that is no polynomial,\n   gcd({p},{q}) returns 1.\n\nExample 1: \n   > gcd(1001, 231);\n   77\n   > gcd(13, 17);\n   1\n   > gcd(-210, 462);\n   42\n\nExample 2: \n   > rationalmode = on!;\n   > gcd(6/7, 33/13);\n   3 / 91\n\nExample 3: \n   > gcd(exp(13),sin(17));\n   1\n\nExample 4: \n   > gcd(24 + 68 * x + 74 * x^2 + 39 * x^3 + 10 * x^4 + x^5, 480 + 776 * x + 476 * x^2 + 138 * x^3 + 19 * x^4 + x^5);\n   4 + x * (4 + x)\n   > gcd(1001 * x^2, 231 * x);\n   x * 77\n\nExample 5: \n   > gcd(exp(x), x^2);\n   1\n\nSee also: bezout, div, mod, numberroots\n"
#define HELP_GE_TEXT "Name: >=\n==> greater-than-or-equal-to operator\n\nLibrary name:\n   sollya_obj_t sollya_lib_cmp_greater_equal(sollya_obj_t, sollya_obj_t)\n\nUsage: \n   {expr1} >= {expr2} : (constant, constant) -> boolean\n\nParameters: \n   {expr1} and {expr2} represent constant expressions\n\nDescription: \n   * The operator >= evaluates to true iff its operands {expr1} and\n   {expr2} evaluate to two floating-point numbers a1\n   respectively a2 with the global precision prec and\n   a1 is greater than or equal to a2. The user should\n   be aware of the fact that because of floating-point evaluation, the\n   operator >= is not exactly the same as the mathematical\n   operation \"greater-than-or-equal-to\".\n\nExample 1: \n   > 5 >= 4;\n   true\n   > 5 >= 5;\n   true\n   > 5 >= 6;\n   false\n   > exp(2) >= exp(1);\n   true\n   > log(1) >= exp(2);\n   false\n\nExample 2: \n   > prec = 12;\n   The precision has been set to 12 bits.\n   > 16384.1 >= 16385.1;\n   true\n\nSee also: ==, !=, >, <=, <, in, !, &&, ||, prec, max, min\n"
#define HELP_GETBACKTRACE_TEXT "Name: getbacktrace\n==> returns the list of Sollya procedures currently run\n\nLibrary name:\n   sollya_obj_t sollya_lib_getbacktrace();\n\nUsage: \n   getbacktrace() : void -> list\n\nDescription: \n   * The getbacktrace command allows the stack of Sollya procedures that are\n   currently run to be inspected. When called, getbacktrace returns an\n   ordered list of structures, each of which contains an element\n   passed_args and an element called_proc. The element called_proc\n   contains the Sollya object representing the procedure being run. The\n   element passed_args contains an ordered list of all effective\n   arguments passed to the procedure when it was called. The procedure called\n   last (i.e., on top of the stack) comes first in the list returned\n   by getbacktrace. When any of the procedure called takes no arguments, the\n   passed_arg element of the corresponding structure evaluates to an empty\n   list.\n\n   * When called from outside any procedure (at toplevel), getbacktrace returns\n   an empty list.\n\n   * When called for a stack containing a call to a variadic procedure that was\n   called with an infinite number of effective arguments, the corresponding\n   passed_args element evaluates to an end-elliptic list.\n\nExample 1: \n   > procedure testA() {\n     \t  \"Current backtrace:\";\n     \t  getbacktrace();\n     };\n   > procedure testB(X) {\n     \t  \"X = \", X;\n     \t  testA();\n     };\n   > procedure testC(X, Y) {\n     \t  \"X = \", X, \", Y = \", Y;\n     \t  testB(Y);\n     };\n   > testC(17, 42);\n   X = 17, Y = 42\n   X = 42\n   Current backtrace:\n   [|{ .passed_args = [| |], .called_proc = proc()\n   {\n   \"Current backtrace:\";\n   getbacktrace();\n   return void;\n   } }, { .passed_args = [|42|], .called_proc = proc(X)\n   {\n   \"X = \", X;\n   testA();\n   return void;\n   } }, { .passed_args = [|17, 42|], .called_proc = proc(X, Y)\n   {\n   \"X = \", X, \", Y = \", Y;\n   testB(Y);\n   return void;\n   } }|]\n\nExample 2: \n   > getbacktrace();\n   [| |]\n\nExample 3: \n   > procedure printnumargs(X) {\n     \t  var L, t;\n     \t  \"number of arguments: \", X;\n     \t  L = getbacktrace();\n     \t  \"Backtrace:\";\n     \t  for t in L do {\n     \t    \"  \" @ objectname(t.called_proc) @ \", \", t.passed_args;\n     \t  };\n     };\n   > procedure numargs(l = ...) {\n     \t  \"l[17] = \", l[17];\n     \t  printnumargs(length(l));\n     };\n   > procedure test() {\n     \t  numargs @ [|25, 26, 27 ...|];\n     };\n   > test();\n   l[17] = 42\n   number of arguments: infty\n   Backtrace:\n     printnumargs, [|infty|]\n     numargs, [|25, 26, 27...|]\n     test, [| |]\n\nSee also: proc, procedure, objectname, bind, @\n"
#define HELP_GETSUPPRESSEDMESSAGES_TEXT "Name: getsuppressedmessages\n==> returns a list of numbers of messages that have been suppressed from message output\n\nLibrary name:\n   sollya_obj_t sollya_lib_getsuppressedmessages();\n\nUsage: \n   getsuppressedmessages()   : void -> list\n\nDescription: \n   * The getsuppressedmessages command allows the user to inspect the state of warning\n   and information message suppression. When called, getsuppressedmessages returns a\n   list of integers numbers that stand for the warning and information\n   messages that have been suppressed.  If no message is suppressed,\n   getsuppressedmessages returns an empty list.\n\n   * Every Sollya warning or information message (that is not fatal to the\n   tool's execution) has a message number. By default, these numbers are\n   not displayed when a message is output. When message number displaying\n   is activated using showmessagenumbers, the message numbers are\n   displayed together with the message. This allows the user to match the\n   numbers returned in a list by getsuppressedmessages with the actual warning and\n   information messages.\n\n   * The list of message numbers returned by getsuppressedmessages is suitable to be fed\n   into the unsuppressmessage command. This way, the user may unsuppress\n   all warning and information messages that have been suppressed.\n\nExample 1: \n   > verbosity = 1;\n   The verbosity level has been set to 1.\n   > 0.1;\n   Warning: Rounding occurred when converting the constant \"0.1\" to floating-point with 165 bits.\n   If safe computation is needed, try to increase the precision.\n   Warning: For at least 1 of the constants displayed in decimal, rounding has happened.\n   0.1\n   > suppressmessage(174);\n   > 0.1;\n   Warning: For at least 1 of the constants displayed in decimal, rounding has happened.\n   0.1\n   > suppressmessage(407);\n   > 0.1;\n   Warning: For at least 1 of the constants displayed in decimal, rounding has happened.\n   0.1\n   > getsuppressedmessages();\n   [|174, 407|]\n   > suppressmessage(207, 196);\n   > getsuppressedmessages();\n   [|174, 196, 207, 407|]\n\nExample 2: \n   > suppressmessage(174, 209, 13, 24, 196);\n   > suppressmessage([| 16, 17 |]);\n   > suppressmessage(19);\n   > unsuppressmessage([| 13, 17 |]);\n   > getsuppressedmessages();\n   [|16, 19, 24, 174, 196, 209|]\n   > unsuppressmessage(getsuppressedmessages());\n   > getsuppressedmessages();\n   [| |]\n\nExample 3: \n   > verbosity = 12;\n   The verbosity level has been set to 12.\n   > suppressmessage(174);\n   > exp(x * 0.1);\n   Information: no Horner simplification will be performed because the given tree is already in Horner form.\n   Warning: For at least 1 of the constants displayed in decimal, rounding has happened.\n   exp(x * 0.1)\n   > getsuppressedmessages();\n   [|174|]\n   > verbosity = 0;\n   The verbosity level has been set to 0.\n   > exp(x * 0.1);\n   exp(x * 0.1)\n   > getsuppressedmessages();\n   [|174|]\n\nSee also: getsuppressedmessages, suppressmessage, unsuppressmessage, verbosity, roundingwarnings\n"
#define HELP_GT_TEXT "Name: >\n==> greater-than operator\n\nLibrary name:\n   sollya_obj_t sollya_lib_cmp_greater(sollya_obj_t, sollya_obj_t)\n\nUsage: \n   {expr1} > {expr2} : (constant, constant) -> boolean\n\nParameters: \n   {expr1} and {expr2} represent constant expressions\n\nDescription: \n   * The operator > evaluates to true iff its operands {expr1} and\n   {expr2} evaluate to two floating-point numbers a1\n   respectively a2 with the global precision prec and\n   a1 is greater than a2. The user should\n   be aware of the fact that because of floating-point evaluation, the\n   operator > is not exactly the same as the mathematical\n   operation \"greater-than\".\n\nExample 1: \n   > 5 > 4;\n   true\n   > 5 > 5;\n   false\n   > 5 > 6;\n   false\n   > exp(2) > exp(1);\n   true\n   > log(1) > exp(2);\n   false\n\nExample 2: \n   > prec = 12;\n   The precision has been set to 12 bits.\n   > 16385.1 > 16384.1;\n   false\n\nSee also: ==, !=, >=, <=, <, in, !, &&, ||, prec, max, min\n"
#define HELP_GUESSDEGREE_TEXT "Name: guessdegree\n==> returns the minimal degree needed for a polynomial to approximate a function with a certain error on an interval.\n\nLibrary names:\n   sollya_obj_t sollya_lib_guessdegree(sollya_obj_t, sollya_obj_t,\n                                       sollya_obj_t, ...)\n   sollya_obj_t sollya_lib_v_guessdegree(sollya_obj_t, sollya_obj_t,\n                                         sollya_obj_t, va_list)\n\nUsage: \n   guessdegree({f},{I},{eps},{w},{bound}) : (function, range, constant, function, constant) -> range\n\nParameters: \n   {f} is the function to be approximated.\n   {I} is the interval where the function must be approximated.\n   {eps} is the maximal acceptable error.\n   {w} (optional) is a weight function. Default is 1.\n   {bound} (optional) is a bound on the degree. Default is currently 128.\n\nDescription: \n   * guessdegree tries to find the minimal degree needed to approximate {f}\n   on {I} by a polynomial with an error err=p*w-f whose infinity norm not\n   greater than {eps}. More precisely, it finds n minimal such that there exists\n   a polynomial p of degree n such that ||p*w-f|| < eps.\n\n   * guessdegree returns an interval: for common cases, this interval is reduced\n   to a single number (i.e. the minimal degree). But in certain cases,\n   guessdegree does not succeed in finding the minimal degree. In such cases the\n   returned interval is of the form [n,p] such that:\n      - no polynomial of degree n-1 gives an error less than {eps}.\n      - there exists a polynomial of degree p giving an error less than {eps}.\n\n   * The fifth optional argument {bound} is used to prevent guessdegree from\n   trying to find too large degrees. If guessdegree does not manage to find a\n   degree n satisfying the error and such that n<=bound, an interval of the\n   form [*, +Inf] is returned. Note that {bound} must be a positive integer.\n\nExample 1: \n   > guessdegree(exp(x),[-1;1],1e-10);\n   [10;10]\n\nExample 2: \n   > guessdegree(exp(x),[-1;1],1e-10,default, 9);\n   [10;infty]\n\nExample 3: \n   > guessdegree(1, [-1;1], 1e-8, 1/exp(x));\n   [8;9]\n\nSee also: dirtyinfnorm, remez, fpminimax, degree\n"
#define HELP_HALFPRECISION_TEXT "Names: halfprecision, HP\n==> rounding to the nearest IEEE 754 half-precision number (binary16).\n\nLibrary names:\n   sollya_obj_t sollya_lib_halfprecision(sollya_obj_t)\n   sollya_obj_t sollya_lib_halfprecision_obj()\n   int sollya_lib_is_halfprecision_obj(sollya_obj_t)\n   sollya_obj_t sollya_lib_build_function_halfprecision(sollya_obj_t)\n   #define SOLLYA_HP(x) sollya_lib_build_function_halfprecision(x)\n\nDescription: \n   * halfprecision is both a function and a constant.\n\n   * As a function, it rounds its argument to the nearest IEEE 754 half-precision (i.e. IEEE754-2008 binary16) number.\n   Subnormal numbers are supported as well as standard numbers: it is the real\n   rounding described in the standard.\n\n   * As a constant, it symbolizes the half-precision format. It is used in \n   contexts when a precision format is necessary, e.g. in the commands \n   round and roundcoefficients. It is not supported for implementpoly.\n   See the corresponding help pages for examples.\n\nExample 1: \n   > display=binary!;\n   > HP(0.1);\n   1.100110011_2 * 2^(-4)\n   > HP(4.17);\n   1.00001011_2 * 2^(2)\n   > HP(1.011_2 * 2^(-23));\n   1.1_2 * 2^(-23)\n\nSee also: single, double, doubleextended, doubledouble, quad, tripledouble, roundcoefficients, fpminimax, implementpoly, round, printsingle\n"
#define HELP_HEAD_TEXT "Name: head\n==> gives the first element of a list.\n\nLibrary name:\n   sollya_obj_t sollya_lib_head(sollya_obj_t)\n\nUsage: \n   head({L}) : list -> any type\n\nParameters: \n   {L} is a list.\n\nDescription: \n   * head({L}) returns the first element of the list {L}. It is equivalent\n   to L[0].\n\n   * If {L} is empty, the command will fail with an error.\n\nExample 1: \n   > head([|1,2,3|]);\n   1\n   > head([|1,2...|]);\n   1\n\nSee also: tail, revert\n"
#define HELP_HEXADECIMAL_TEXT "Name: hexadecimal\n==> special value for global state display\n\nLibrary names:\n   sollya_obj_t sollya_lib_hexadecimal()\n   int sollya_lib_is_hexadecimal(sollya_obj_t)\n\nDescription: \n   * hexadecimal is a special value used for the global state display.  If\n   the global state display is equal to hexadecimal, all data will be\n   output in hexadecimal C99/ IEEE 754-2008 notation.\n    \n   As any value it can be affected to a variable and stored in lists.\n\nSee also: decimal, dyadic, powers, binary, display\n"
#define HELP_HONORCOEFFPREC_TEXT "Name: honorcoeffprec\n==> indicates the (forced) honoring the precision of the coefficients in implementpoly\n\nLibrary names:\n   sollya_obj_t sollya_lib_honorcoeffprec()\n   int sollya_lib_is_honorcoeffprec(sollya_obj_t)\n\nUsage: \n   honorcoeffprec : honorcoeffprec\n\nDescription: \n   * Used with command implementpoly, honorcoeffprec makes implementpoly honor\n   the precision of the given polynomial. This means if a coefficient\n   needs a double-double or a triple-double to be exactly stored,\n   implementpoly will allocate appropriate space and use a double-double\n   or triple-double operation even if the automatic (heuristic)\n   determination implemented in command implementpoly indicates that the\n   coefficient could be stored on less precision or, respectively, the\n   operation could be performed with less precision. See implementpoly\n   for details.\n\nExample 1: \n   > verbosity = 1!;\n   > q = implementpoly(1 - dirtysimplify(TD(1/6)) * x^2,[-1b-10;1b-10],1b-60,DD,\"p\",\"implementation.c\");\n   Warning: at least one of the coefficients of the given polynomial has been rounded in a way\n   that the target precision can be achieved at lower cost. Nevertheless, the implemented polynomial\n   is different from the given one.\n   > printexpansion(q);\n   0x3ff0000000000000 + x^2 * 0xbfc5555555555555\n   > r = implementpoly(1 - dirtysimplify(TD(1/6)) * x^2,[-1b-10;1b-10],1b-60,DD,\"p\",\"implementation.c\",honorcoeffprec);\n   Warning: the inferred precision of the 2th coefficient of the polynomial is greater than\n   the necessary precision computed for this step. This may make the automatic determination\n   of precisions useless.\n   > printexpansion(r);\n   0x3ff0000000000000 + x^2 * (0xbfc5555555555555 + 0xbc65555555555555 + 0xb905555555555555)\n\nSee also: implementpoly, printexpansion, fpminimax\n"
#define HELP_HOPITALRECURSIONS_TEXT "Name: hopitalrecursions\n==> controls the number of recursion steps when applying L'Hopital's rule.\n\nLibrary names:\n   void sollya_lib_set_hopitalrecursions_and_print(sollya_obj_t)\n   void sollya_lib_set_hopitalrecursions(sollya_obj_t)\n   sollya_obj_t sollya_lib_get_hopitalrecursions()\n\nUsage: \n   hopitalrecursions = {n} : integer -> void\n   hopitalrecursions = {n} ! : integer -> void\n   hopitalrecursions : integer\n\nParameters: \n   {n} represents the number of recursions\n\nDescription: \n   * hopitalrecursions is a global variable. Its value represents the number of steps of\n   recursion that are tried when applying L'Hopital's rule. This rule is applied\n   by the interval evaluator present in the core of Sollya (and particularly\n   visible in commands like infnorm).\n\n   * If an expression of the form f/g has to be evaluated by interval \n   arithmetic on an interval I and if f and g have a common zero\n   in I, a direct evaluation leads to NaN.\n   Sollya implements a safe heuristic to avoid this, based on L'Hopital's rule: in \n   such a case, it can be shown that (f/g)(I) C (f'/g')(I). Since\n   the same problem may exist for f'/g', the rule is applied recursively.\n   The number of step in this recursion process is controlled by hopitalrecursions.\n\n   * Setting hopitalrecursions to 0 makes Sollya use this rule only once;\n   setting it to 1 makes Sollya use the rule twice, and so on.\n   In particular: the rule is always applied at least once, if necessary.\n\nExample 1: \n   > hopitalrecursions=0;\n   The number of recursions for Hopital's rule has been set to 0.\n   > evaluate(log(1+x)^2/x^2,[-1/2; 1]);\n   [NaN;NaN]\n   > hopitalrecursions=1;\n   The number of recursions for Hopital's rule has been set to 1.\n   > evaluate(log(1+x)^2/x^2,[-1/2; 1]);\n   [-2.5225887222397812376689284858327062723020005374411;6.7725887222397812376689284858327062723020005374412]\n\nSee also: taylorrecursions, infnorm, findzeros, evaluate\n"
#define HELP_HORNER_TEXT "Name: horner\n==> brings all polynomial subexpressions of an expression to Horner form\n\nLibrary name:\n   sollya_obj_t sollya_lib_horner(sollya_obj_t)\n\nUsage: \n   horner({function}) : function -> function\n\nParameters: \n   {function} represents the expression to be rewritten in Horner form\n\nDescription: \n   * The command horner rewrites the expression representing the function\n   {function} in a way such that all polynomial subexpressions (or the\n   whole expression itself, if it is a polynomial) are written in Horner\n   form.  The command horner does not endanger the safety of\n   computations even in Sollya's floating-point environment: the\n   function returned is mathematically equal to the function {function}.\n\nExample 1: \n   > print(horner(1 + 2 * x + 3 * x^2));\n   1 + x * (2 + x * 3)\n   > print(horner((x + 1)^7));\n   1 + x * (7 + x * (21 + x * (35 + x * (35 + x * (21 + x * (7 + x))))))\n\nExample 2: \n   > print(horner(exp((x + 1)^5) - log(asin(x + x^3) + x)));\n   exp(1 + x * (5 + x * (10 + x * (10 + x * (5 + x))))) - log(asin(x * (1 + x^2)) + x)\n\nSee also: canonical, print, coeff, degree, autosimplify, simplify\n"
#define HELP_HP_TEXT "Name: HP\n==> short form for halfprecision\n\nSee also: halfprecision\n"
#define HELP_IMPLEMENTCONSTANT_TEXT "Name: implementconstant\n==> implements a constant in arbitrary precision\n\nLibrary names:\n   void sollya_lib_implementconstant(sollya_obj_t, ...);\n   void sollya_lib_v_implementconstant(sollya_obj_t, va_list);\n\nUsage: \n   implementconstant({expr}) : constant -> void\n   implementconstant({expr},{filename}) : (constant, string) -> void\n   implementconstant({expr},{filename},{functionname}) : (constant, string, string) -> void\n\nDescription: \n   * The command implementconstant implements the constant expression {expr} in \n   arbitrary precision. More precisely, it generates the source code (written\n   in C, and using MPFR) of a C function const_something with the following\n   signature:\n    \n             void const_something (mpfr_ptr y, mp_prec_t prec)\n    \n   Let us denote by c the exact mathematical value of the constant defined by\n   the expression {expr}. When called with arguments y and prec (where the\n   variable y is supposed to be already initialized), the function\n   mpfr_const_something sets the precision of y to a suitable precision and\n   stores in it an approximate value of c such that\n                               |y-c| <= |c|*2^(1-prec).\n\n   * When no filename {filename} is given or if default is given as\n   {filename}, the source code produced by implementconstant is printed on\n   standard output. Otherwise, when {filename} is given as a \n   string of characters, the source code is output to a file \n   named {filename}. If that file cannot be opened and/or \n   written to, implementconstant fails and has no other effect.\n\n   * When {functionname} is given as an argument to implementconstant and\n   {functionname} evaluates to a string of characters, the default name\n   for the C function const_something is\n   replaced by {functionname}. When default is given as {functionname},\n   the default name is used nevertheless, as if no {functionname}\n   argument were given.  When choosing a character sequence for\n   {functionname}, the user should keep attention to the fact that\n   {functionname} must be a valid C identifier in order to enable\n   error-free compilation of the produced code.\n\n   * If {expr} refers to a constant defined with libraryconstant, the produced\n   code uses the external code implementing this constant. The user should\n   keep in mind that it is up to them to make sure the symbol for that \n   external code can get resolved when the newly generated code is to \n   be loaded.\n\n   * If a subexpression of {expr} evaluates to 0, implementconstant will most\n   likely fail with an error message.\n\n   * implementconstant is unable to implement constant expressions {expr} that\n   contain procedure-based functions, i.e. functions created from Sollya\n   procedures using the function construct. If {expr} contains such a\n   procedure-based function, implementconstant prints a warning and fails\n   silently. The reason for this lack of functionality is that the\n   produced C source code, which is supposed to be compiled, would have\n   to call back to the Sollya interpreter in order to evaluate the\n   procedure-based function.\n\n   * Similarly, implementconstant is currently unable to implement constant\n   expressions {expr} that contain library-based functions, i.e.\n   functions dynamically bound to Sollya using the library construct.\n   If {expr} contains such a library-based function, implementconstant prints\n   a warning and fails silently. Support for this feature is in principle\n   feasible from a technical standpoint and might be added in a future\n   release of Sollya.\n\n   * Currently, non-differentiable functions such as double, doubledouble,\n   tripledouble, single, halfprecision, quad, doubleextended, \n   floor, ceil, nearestint are not supported by implementconstant. \n   If implementconstant encounters one of them, a warning message is displayed \n   and no code is produced. However, if autosimplify equals on, it is \n   possible that Sollya silently simplifies subexpressions of {expr} \n   containing such functions and that implementconstant successfully produces \n   code for evaluating {expr}.\n\n   * While it produces an MPFR-based C source code for {expr}, implementconstant\n   takes architectural and system-dependent parameters into account.  For\n   example, it checks whether literal constants figuring in {expr} can be\n   represented on a C long int type or if they must\n   be stored in a different manner not to affect their accuracy. These\n   tests, performed by Sollya during execution of implementconstant, depend\n   themselves on the architecture Sollya is running on. Users should\n   keep this matter in mind, especially when trying to compile source\n   code on one machine whilst it has been produced on another.\n\nExample 1: \n   > implementconstant(exp(1)+log(2)/sqrt(1/10)); \n\n           [ The first 100 lines of the output have been removed  ]\n\n       modify or redistribute this generated code itself, or its skeleton,\n       you may (at your option) remove this special exception, which will\n       cause this generated code and its skeleton and the resulting Sollya\n       output files to be licensed under the CeCILL-C licence without this\n       special exception.\n       \n       This special exception was added by the Sollya copyright holders in\n       version 4.1 of Sollya.\n       \n   */\n   \n   \n   #include <mpfr.h>\n   \n   void\n   const_something (mpfr_ptr y, mp_prec_t prec)\n   {\n     /* Declarations */\n     mpfr_t tmp1;\n     mpfr_t tmp2;\n     mpfr_t tmp3;\n     mpfr_t tmp4;\n     mpfr_t tmp5;\n     mpfr_t tmp6;\n     mpfr_t tmp7;\n   \n     /* Initializations */\n     mpfr_init2 (tmp2, prec+5);\n     mpfr_init2 (tmp1, prec+3);\n     mpfr_init2 (tmp4, prec+8);\n     mpfr_init2 (tmp3, prec+7);\n     mpfr_init2 (tmp6, prec+11);\n     mpfr_init2 (tmp7, prec+11);\n     mpfr_init2 (tmp5, prec+11);\n   \n     /* Core */\n     mpfr_set_prec (tmp2, prec+4);\n     mpfr_set_ui (tmp2, 1, MPFR_RNDN);\n     mpfr_set_prec (tmp1, prec+3);\n     mpfr_exp (tmp1, tmp2, MPFR_RNDN);\n     mpfr_set_prec (tmp4, prec+8);\n     mpfr_set_ui (tmp4, 2, MPFR_RNDN);\n     mpfr_set_prec (tmp3, prec+7);\n     mpfr_log (tmp3, tmp4, MPFR_RNDN);\n     mpfr_set_prec (tmp6, prec+11);\n     mpfr_set_ui (tmp6, 1, MPFR_RNDN);\n     mpfr_set_prec (tmp7, prec+11);\n     mpfr_set_ui (tmp7, 10, MPFR_RNDN);\n     mpfr_set_prec (tmp5, prec+11);\n     mpfr_div (tmp5, tmp6, tmp7, MPFR_RNDN);\n     mpfr_set_prec (tmp4, prec+7);\n     mpfr_sqrt (tmp4, tmp5, MPFR_RNDN);\n     mpfr_set_prec (tmp2, prec+5);\n     mpfr_div (tmp2, tmp3, tmp4, MPFR_RNDN);\n     mpfr_set_prec (y, prec+3);\n     mpfr_add (y, tmp1, tmp2, MPFR_RNDN);\n   \n     /* Cleaning stuff */\n     mpfr_clear(tmp1);\n     mpfr_clear(tmp2);\n     mpfr_clear(tmp3);\n     mpfr_clear(tmp4);\n     mpfr_clear(tmp5);\n     mpfr_clear(tmp6);\n     mpfr_clear(tmp7);\n   }\n\nExample 2: \n   > implementconstant(sin(13/17),\"sine_of_thirteen_seventeenth.c\");\n   > bashevaluate(\"tail -n 30 sine_of_thirteen_seventeenth.c\");\n   #include <mpfr.h>\n   \n   void\n   const_something (mpfr_ptr y, mp_prec_t prec)\n   {\n     /* Declarations */\n     mpfr_t tmp1;\n     mpfr_t tmp2;\n     mpfr_t tmp3;\n   \n     /* Initializations */\n     mpfr_init2 (tmp2, prec+6);\n     mpfr_init2 (tmp3, prec+6);\n     mpfr_init2 (tmp1, prec+6);\n   \n     /* Core */\n     mpfr_set_prec (tmp2, prec+6);\n     mpfr_set_ui (tmp2, 13, MPFR_RNDN);\n     mpfr_set_prec (tmp3, prec+6);\n     mpfr_set_ui (tmp3, 17, MPFR_RNDN);\n     mpfr_set_prec (tmp1, prec+6);\n     mpfr_div (tmp1, tmp2, tmp3, MPFR_RNDN);\n     mpfr_set_prec (y, prec+2);\n     mpfr_sin (y, tmp1, MPFR_RNDN);\n   \n     /* Cleaning stuff */\n     mpfr_clear(tmp1);\n     mpfr_clear(tmp2);\n     mpfr_clear(tmp3);\n   }\n\nExample 3: \n   > implementconstant(asin(1/3 * pi),default,\"arcsin_of_one_third_pi\"); \n\n           [ The first 100 lines of the output have been removed  ]\n\n       modify or redistribute this generated code itself, or its skeleton,\n       you may (at your option) remove this special exception, which will\n       cause this generated code and its skeleton and the resulting Sollya\n       output files to be licensed under the CeCILL-C licence without this\n       special exception.\n       \n       This special exception was added by the Sollya copyright holders in\n       version 4.1 of Sollya.\n       \n   */\n   \n   \n   #include <mpfr.h>\n   \n   void\n   arcsin_of_one_third_pi (mpfr_ptr y, mp_prec_t prec)\n   {\n     /* Declarations */\n     mpfr_t tmp1;\n     mpfr_t tmp2;\n     mpfr_t tmp3;\n   \n     /* Initializations */\n     mpfr_init2 (tmp2, prec+8);\n     mpfr_init2 (tmp3, prec+8);\n     mpfr_init2 (tmp1, prec+8);\n   \n     /* Core */\n     mpfr_set_prec (tmp2, prec+8);\n     mpfr_const_pi (tmp2, MPFR_RNDN);\n     mpfr_set_prec (tmp3, prec+8);\n     mpfr_set_ui (tmp3, 3, MPFR_RNDN);\n     mpfr_set_prec (tmp1, prec+8);\n     mpfr_div (tmp1, tmp2, tmp3, MPFR_RNDN);\n     mpfr_set_prec (y, prec+2);\n     mpfr_asin (y, tmp1, MPFR_RNDN);\n   \n     /* Cleaning stuff */\n     mpfr_clear(tmp1);\n     mpfr_clear(tmp2);\n     mpfr_clear(tmp3);\n   }\n\nExample 4: \n   > implementconstant(ceil(log(19 + 1/3)),\"constant_code.c\",\"magic_constant\");\n   > bashevaluate(\"tail -n -9 constant_code.c\");\n   void\n   magic_constant (mpfr_ptr y, mp_prec_t prec)\n   {\n     /* Initializations */\n   \n     /* Core */\n     mpfr_set_prec (y, prec);\n     mpfr_set_ui (y, 3, MPFR_RNDN);\n   }\n\nExample 5: \n   > bashexecute(\"gcc -fPIC -Wall -c libraryconstantexample.c -I$HOME/.local/include\");\n   > bashexecute(\"gcc -shared -o libraryconstantexample libraryconstantexample.o -lgmp -lmpfr\");\n   > euler_gamma = libraryconstant(\"./libraryconstantexample\");\n   > implementconstant(euler_gamma^(1/3), \"euler.c\");\n   > bashevaluate(\"tail -n -17 euler.c\");\n   void\n   const_something (mpfr_ptr y, mp_prec_t prec)\n   {\n     /* Declarations */\n     mpfr_t tmp1;\n   \n     /* Initializations */\n     mpfr_init2 (tmp1, prec+1);\n   \n     /* Core */\n     euler_gamma (tmp1, prec+1);\n     mpfr_set_prec (y, prec+2);\n     mpfr_root (y, tmp1, 3, MPFR_RNDN);\n   \n     /* Cleaning stuff */\n     mpfr_clear(tmp1);\n   }\n\nSee also: implementpoly, libraryconstant, library, function, bashevaluate\n"
#define HELP_IMPLEMENTPOLY_TEXT "Name: implementpoly\n==> implements a polynomial using double, double-double and triple-double arithmetic and generates a Gappa proof\n\nLibrary names:\n   sollya_obj_t sollya_lib_implementpoly(sollya_obj_t, sollya_obj_t,\n                                         sollya_obj_t, sollya_obj_t,\n                                         sollya_obj_t, sollya_obj_t, ...)\n   sollya_obj_t sollya_lib_v_implementpoly(sollya_obj_t, sollya_obj_t,\n                                           sollya_obj_t, sollya_obj_t,\n                                           sollya_obj_t, sollya_obj_t, va_list)\n\nUsage: \n   implementpoly({polynomial}, {range}, {error bound}, {format}, {functionname}, {filename}) : (function, range, constant, D|double|DD|doubledouble|TD|tripledouble, string, string) -> function\n   implementpoly({polynomial}, {range}, {error bound}, {format}, {functionname}, {filename}, {honor coefficient precisions}) : (function, range, constant, D|double|DD|doubledouble|TD|tripledouble, string, string, honorcoeffprec) -> function\n   implementpoly({polynomial}, {range}, {error bound}, {format}, {functionname}, {filename}, {proof filename}) : (function, range, constant, D|double|DD|doubledouble|TD|tripledouble, string, string, string) -> function\n   implementpoly({polynomial}, {range}, {error bound}, {format}, {functionname}, {filename}, {honor coefficient precisions}, {proof filename}) : (function, range, constant, D|double|DD|doubledouble|TD|tripledouble, string, string, honorcoeffprec, string) -> function\n\nDescription: \n   * The command implementpoly implements the polynomial {polynomial} in range\n   {range} as a function called {functionname} in C code\n   using double, double-double and triple-double arithmetic in a way that\n   the rounding error (estimated at its first order) is bounded by {error bound}. \n   The produced code is output in a file named {filename}. The\n   argument {format} indicates the double, double-double or triple-double\n   format of the variable in which the polynomial varies, influencing\n   also in the signature of the C function.\n    \n   If a seventh or eighth argument {proof filename} is given and if this\n   argument evaluates to a variable of type string, the command\n   implementpoly will produce a Gappa proof that the\n   rounding error is less than the given bound. This proof will be output\n   in Gappa syntax in a file name {proof filename}.\n    \n   The command implementpoly returns the polynomial that has been\n   implemented. As the command implementpoly tries to adapt the precision\n   needed in each evaluation step to its strict minimum and as it applies\n   renormalization to double-double and triple-double precision\n   coefficients to bring them to a round-to-nearest expansion form, the\n   returned polynomial may differ from the polynomial\n   {polynomial}. Nevertheless the difference will be small enough that\n   the rounding error bound with regard to the polynomial {polynomial}\n   (estimated at its first order) will be less than the given error\n   bound.\n    \n   If a seventh argument {honor coefficient precisions} is given and\n   evaluates to a variable honorcoeffprec of type honorcoeffprec,\n   implementpoly will honor the precision of the given polynomial\n   {polynomials}. This means if a coefficient needs a double-double or a\n   triple-double to be exactly stored, implementpoly will allocate appropriate\n   space and use a double-double or triple-double operation even if the\n   automatic (heuristic) determination implemented in command implementpoly\n   indicates that the coefficient could be stored on less precision or,\n   respectively, the operation could be performed with less\n   precision. The use of honorcoeffprec has advantages and\n   disadvantages. If the polynomial {polynomial} given has not been\n   determined by a process considering directly polynomials with\n   floating-point coefficients, honorcoeffprec should not be\n   indicated. The implementpoly command can then determine the needed\n   precision using the same error estimation as used for the\n   determination of the precisions of the operations. Generally, the\n   coefficients will get rounded to double, double-double and\n   triple-double precision in a way that minimizes their number and\n   respects the rounding error bound {error bound}.  Indicating\n   honorcoeffprec may in this case short-circuit most precision\n   estimations leading to sub-optimal code. On the other hand, if the\n   polynomial {polynomial} has been determined with floating-point\n   precisions in mind, honorcoeffprec should be indicated because such\n   polynomials often are very sensitive in terms of error propagation with\n   regard to their coefficients' values. Indicating honorcoeffprec\n   prevents the implementpoly command from rounding the coefficients and\n   altering by many orders of magnitude the approximation error of the\n   polynomial with regard to the function it approximates.\n    \n   The implementer behind the implementpoly command makes some assumptions on\n   its input and verifies them. If some assumption cannot be verified,\n   the implementation will not succeed and implementpoly will evaluate to a\n   variable error of type error. The same behaviour is observed if\n   some file is not writable or some other side-effect fails, e.g. if\n   the implementer runs out of memory.\n    \n   As error estimation is performed only on the first order, the code\n   produced by the implementpoly command should be considered valid iff a\n   Gappa proof has been produced and successfully run\n   in Gappa.\n\nExample 1: \n   > implementpoly(1 - 1/6 * x^2 + 1/120 * x^4, [-1b-10;1b-10], 1b-30, D, \"p\",\"implementation.c\");\n   1 + x^2 * (-0.166666666666666657414808128123695496469736099243164 + x^2 * 8.3333333333333332176851016015461937058717012405396e-3)\n   > bashevaluate(\"tail -n -29 implementation.c\");\n   #define p_coeff_0h 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000e+00\n   #define p_coeff_2h -1.66666666666666657414808128123695496469736099243164062500000000000000000000000000e-01\n   #define p_coeff_4h 8.33333333333333321768510160154619370587170124053955078125000000000000000000000000e-03\n   \n   \n   void p(double *p_resh, double x) {\n   double p_x_0_pow2h;\n   \n   \n   p_x_0_pow2h = x * x;\n   \n   \n   double p_t_1_0h;\n   double p_t_2_0h;\n   double p_t_3_0h;\n   double p_t_4_0h;\n   double p_t_5_0h;\n    \n   \n   \n   p_t_1_0h = p_coeff_4h;\n   p_t_2_0h = p_t_1_0h * p_x_0_pow2h;\n   p_t_3_0h = p_coeff_2h + p_t_2_0h;\n   p_t_4_0h = p_t_3_0h * p_x_0_pow2h;\n   p_t_5_0h = p_coeff_0h + p_t_4_0h;\n   *p_resh = p_t_5_0h;\n   \n   \n   }\n\nExample 2: \n   > implementpoly(1 - 1/6 * x^2 + 1/120 * x^4, [-1b-10;1b-10], 1b-30, D, \"p\",\"implementation.c\",\"implementation.gappa\");\n   1 + x^2 * (-0.166666666666666657414808128123695496469736099243164 + x^2 * 8.3333333333333332176851016015461937058717012405396e-3)\n\nExample 3: \n   > verbosity = 1!;\n   > q = implementpoly(1 - dirtysimplify(TD(1/6)) * x^2,[-1b-10;1b-10],1b-60,DD,\"p\",\"implementation.c\");\n   Warning: at least one of the coefficients of the given polynomial has been rounded in a way\n   that the target precision can be achieved at lower cost. Nevertheless, the implemented polynomial\n   is different from the given one.\n   > printexpansion(q);\n   0x3ff0000000000000 + x^2 * 0xbfc5555555555555\n   > r = implementpoly(1 - dirtysimplify(TD(1/6)) * x^2,[-1b-10;1b-10],1b-60,DD,\"p\",\"implementation.c\",honorcoeffprec);\n   Warning: the inferred precision of the 2th coefficient of the polynomial is greater than\n   the necessary precision computed for this step. This may make the automatic determination\n   of precisions useless.\n   > printexpansion(r);\n   0x3ff0000000000000 + x^2 * (0xbfc5555555555555 + 0xbc65555555555555 + 0xb905555555555555)\n\nExample 4: \n   > p = 0x3ff0000000000000 + x * (0x3ff0000000000000 + x * (0x3fe0000000000000 + x * (0x3fc5555555555559 + x * (0x3fa55555555555bd + x * (0x3f811111111106e2 + x * (0x3f56c16c16bf5eb7 + x * (0x3f2a01a01a292dcd + x * (0x3efa01a0218a016a + x * (0x3ec71de360331aad + x * (0x3e927e42e3823bf3 + x * (0x3e5ae6b2710c2c9a + x * (0x3e2203730c0a7c1d + x * 0x3de5da557e0781df))))))))))));\n   > q = implementpoly(p,[-1/2;1/2],1b-60,D,\"p\",\"implementation.c\",honorcoeffprec,\"implementation.gappa\");\n   > if (q != p) then print(\"During implementation, rounding has happened.\") else print(\"Polynomial implemented as given.\");\t\n   Polynomial implemented as given.\n\nSee also: honorcoeffprec, roundcoefficients, double, doubledouble, tripledouble, bashevaluate, printexpansion, error, remez, fpminimax, taylor, implementconstant\n"
#define HELP_INF_TEXT "Name: inf\n==> gives the lower bound of an interval.\n\nLibrary name:\n   sollya_obj_t sollya_lib_inf(sollya_obj_t)\n\nUsage: \n   inf({I}) : range -> constant\n   inf({x}) : constant -> constant\n\nParameters: \n   {I} is an interval.\n   {x} is a real number.\n\nDescription: \n   * Returns the lower bound of the interval {I}. Each bound of an interval has its \n   own precision, so this command is exact, even if the current precision is too \n   small to represent the bound.\n\n   * When called on a real number {x}, inf behaves like the identity.\n\nExample 1: \n   > inf([1;3]);\n   1\n   > inf(0);\n   0\n\nExample 2: \n   > display=binary!;\n   > I=[0.111110000011111_2; 1];\n   > inf(I);\n   1.11110000011111_2 * 2^(-1)\n   > prec=12!;\n   > inf(I);\n   1.11110000011111_2 * 2^(-1)\n\nSee also: mid, sup, max, min\n"
#define HELP_IN_TEXT "Name: in\n==> containment test operator\n\nLibrary name:\n   sollya_obj_t sollya_lib_cmp_in(sollya_obj_t, sollya_obj_t)\n\nUsage: \n   {expr} in {range1} : (constant, range) -> boolean\n   {range1} in {range2} : (range, range) -> boolean\n\nParameters: \n   {expr} represents a constant expression\n   {range1} and {range2} represent ranges (intervals)\n\nDescription: \n   * When its first operand is a constant expression {expr},\n   the operator in evaluates to true iff the constant value\n   of the expression {expr} is contained in the interval {range1}.\n\n   * When both its operands are ranges (intervals), \n   the operator in evaluates to true iff all values\n   in {range1} are contained in the interval {range2}.\n\n   * in is also used as a keyword for loops over the different\n   elements of a list.\n\nExample 1: \n   > 5 in [-4;7];\n   true\n   > 4 in [-1;1];\n   false\n   > 0 in sin([-17;17]);\n   true\n\nExample 2: \n   > [5;7] in [2;8];\n   true\n   > [2;3] in [4;5];\n   false\n   > [2;3] in [2.5;5];\n   false\n\nExample 3: \n   > for i in [|1,...,5|] do print(i);\n   1\n   2\n   3\n   4\n   5\n\nSee also: ==, !=, >=, >, <=, <, !, &&, ||, prec, print\n"
#define HELP_INTEGER_TEXT "Name: integer\n==> keyword representing a machine integer type \n\nLibrary name:\n   SOLLYA_EXTERNALPROC_TYPE_INTEGER\n\nUsage: \n   integer : type type\n\nDescription: \n   * integer represents the machine integer type for declarations\n   of external procedures externalproc.\n    \n   Remark that in contrast to other indicators, type indicators like\n   integer cannot be handled outside the externalproc context.  In\n   particular, they cannot be assigned to variables.\n\nSee also: externalproc, boolean, constant, function, list of, range, string, object\n"
#define HELP_INTEGRAL_TEXT "Name: integral\n==> computes an interval bounding the integral of a function on an interval.\n\nLibrary name:\n   sollya_obj_t sollya_lib_integral(sollya_obj_t, sollya_obj_t)\n\nUsage: \n   integral({f},{I}) : (function, range) -> range\n\nParameters: \n   {f} is a function.\n   {I} is an interval.\n\nDescription: \n   * integral({f},{I}) returns an interval J such that the exact value of \n   the integral of {f} on {I} lies in J.\n\n   * This command is safe but very inefficient. Use dirtyintegral if you just want\n   an approximate value.\n\n   * The result of this command depends on the global variable diam.\n   The method used is the following: {I} is cut into intervals of length not \n   greater then d*|I| where d is the value\n   of global variable diam.\n   On each small interval {J}, an evaluation of {f} by interval is\n   performed. The result is multiplied by the length of {J}. Finally all values \n   are summed.\n\nExample 1: \n   > sin(10);\n   -0.54402111088936981340474766185137728168364301291622\n   > integral(cos(x),[0;10]);\n   [-0.54710197983579690224097637163525943075698599257333;-0.54094015130013183848150540881373370744053741191729]\n   > diam=1e-5!;\n   > integral(cos(x),[0;10]);\n   [-0.54432915685955427101857780295936956775293876382777;-0.54371306401249969508039644221927489010425803173555]\n\nSee also: diam, dirtyintegral, prec\n"
#define HELP_INTERPOLATE_TEXT "Name: interpolate\n==> computes an interpolation polynomial.\n\nLibrary names:\n   sollya_obj_t sollya_lib_interpolate(sollya_obj_t, sollya_obj_t, ...)\n   sollya_obj_t sollya_lib_v_interpolate(sollya_obj_t, sollya_obj_t, va_list)\n\nUsage: \n   interpolate({X}, {Y}) : (list, list) -> function\n   interpolate({X}, {Y}, {D}) : (list, list, constant) -> function\n   interpolate({X}, {Y}, {D}, {I}) : (list, list, constant, range) -> function\n   interpolate({X}, {f}) : (list, function) -> function\n   interpolate({X}, {f}, {D}) : (list, function, constant) -> function\n   interpolate({X}, {f}, {D}, {I}) : (list, function, constant, range) -> function\n\nParameters: \n   {X} is a list of constants for the interpolation abscissas\n   {Y} is a list of constants for the interpolation ordinates\n   {f} is a function to be interpolated\n   {D} is a constant defining the maximum permissible error\n   {I} is an interval defining the domain to be considered for the error\n\nDescription: \n   * interpolate computes an interpolation polynomial p of minimal degree such\n   that for all given abscissa points xi in the list {X} the interpolation\n   condition is fullfilled with p(xi) = yi, where yi is the corresponding entry\n   in the list of ordinates {Y}. All entries of the lists {X} and {Y} need to be\n   constant expressions; the entries in the list of abscissas {X} need to be\n   pairwise distinct. If no parameter {D} is given, the interpolation is exact,\n   i.e., an interpolation polynomial (expression) is formed such that the\n   interpolation condition is satisfied without error.\n\n   * interpolate accepts a function {f} instead of a list of ordinates. When\n   called in this manner, interpolate computes a polynomial p such that for all\n   given abscissa points xi in the list {X} the interpolation condition is\n   fullfilled with p(xi) = f(xi). All entries in the list {X} still need to be\n   constant expressions and they must be pairwise distinct. If no parameter {D}\n   is given, the interpolation stays exact, even if this means forming constant\n   expressions for the ordinates f(xi).\n\n   * As exact interpolation is often not needed and in order to speed up\n   computations, interpolate accepts an optional parameter {D}, a positive\n   constant, that defines the maximum permissible error. In this case, instead\n   of computing the exact interpolation polynomial p as it is defined above,\n   interpolate computes and returns an approximate interpolation polynomial p~\n   that does not differ from p more than the amount {D} with supremum norm over\n   the interval I that is given by the interval of all abscissa points in {X}.\n    \n   Formally, let I be the convex hull of all abscissa points in {X}; typically,\n   the lower bound of I is the minimum value amongst all {X}, the upper bound is\n   the maximum value amongst all {X}. Let p be the unique polynomial such that\n   p(xi) = yi for all xi in the list {X} and yi either the corresponding entry\n   in the list {Y} or yi = f(xi). Then interpolate returns p~ such that\n                              ||p~ - p ||^I <= D.\n    \n   The support for {D} works for any list of distinct abscissa points {X} and\n   for any list of ordinate points {Y} or function {f}. The algorithm is however\n   optimized for the case when {X} is a list of floating-point (or rational)\n   constants and a function {f}. When {f} is a polynomial of degree n and {X}\n   contains at most n+1 abscissa points, interpolate may return {f} as-is, even\n   though {D} has been provided; typically without performing any rounding on\n   the coefficients of the polynomial {f}.\n\n   * When a permissible-error argument {D} is given to interpolate, the command\n   additionnally supports an optional interval parameter {I}. If this parameter\n   is specified, the interval I to consider the error between p~ and p on is not\n   taken as the convex hull of the abscissa points {X} but assumed to be the\n   interval I. This parameter is supported to both allow for interpolation over\n   intervals where the first (or last) interpolation point does not lie on the\n   lower (resp. upper) bound of the interval and to speed up computation:\n   determining the minimum and maximum values in {X} may be expensive.\n\n   * interpolate is completely insensible to the tool's working precision prec.\n   It adapts its own working precision entirely automatically. However the user\n   should be aware that precision adaption comes at a price: if the\n   interpolation problem requires high precision to be solved, the execution\n   time of interpolate will be high. This can typically be observed when the\n   list of abscissas {X} contains two values that are mathematically different\n   but for which high precision is needed to distinguish them.\n\n   * In case of error, e.g., when the abscissa points in {X} are not all\n   distinct, when the function does not evaluate at one of the abscissa points\n   or when the permissible error {D} or domain interval {I} are not acceptable,\n   interpolate evaluates to error.\n\nExample 1: \n   > p = interpolate([| 1, 2, 3 |], [| 3, 5, 9 |]);\n   > write(\"p = \", p, \"\\n\");\n   p = 3 + _x_ * (-1 + _x_)\n\nExample 2: \n   > p = interpolate([| 1, 2, 3, 4 |], [| 1, -1, 2, -3 |]);\n   > write(\"p = \", p, \"\\n\");\n   p = 21 + _x_ * (-100 / 3 + _x_ * (15.5 + _x_ * -13 / 6))\n   > p = interpolate([| 1, 2, 3, 4 |], [| 1, -1, 2, -3 |], 2^-17);\n   > write(\"p = \", p, \"\\n\");\n   p = 21 + _x_ * (-33.333333492279052734375 + _x_ * (15.5 + _x_ * (-2.1666666567325592041015625)))\n   > p = interpolate([| 1, 2, 3, 4 |], [| 1, -1, 2, -3 |], 2^-17, [0; 2^42]);\n   > write(\"p = \", p, \"\\n\");\n   p = 21 + _x_ * (-33.333333333333333333333333333333333333333333363228 + _x_ * (15.5 + _x_ * (-2.1666666666666666666666666666666666666666666647983)))\n\nExample 3: \n   > p = interpolate([| 1, 2, 3, 4 |], [| 1, -1, 2, -3 |]);\n   > q = interpolate([| 1, 2, 3, 4 |], [| 1, -1, 2, -3 |], 2^-17);\n   > delta = horner(p - q);\n   > write(\"delta = \", delta, \"\\n\");\n   delta = _x_ * (1 / 6291456 + _x_^2 * -1 / 100663296)\n   > Delta = dirtyinfnorm(delta,[1;4]);\n   > \"Delta = \", Delta, \" = 2^(\", log2(Delta), \")\";\n   Delta = 2.4471294368728034316556666925301338011322095712879e-7 = 2^(-21.962406251802890453634347359869541271899536019231)\n   > p = interpolate([| 1, 2, 3, 4 |], [| 1, -1, 2, -3 |]);\n   > q = interpolate([| 1, 2, 3, 4 |], [| 1, -1, 2, -3 |], 2^-2000);\n   > delta = horner(p - q);\n   > write(\"delta = \", delta, \"\\n\");\n   delta = _x_ * (1 / 4.4088218698531373730540794925222988186456999760206e604 + _x_^2 * -1 / 7.054114991765019796886527188035678109833119961633e605)\n   > Delta = dirtyinfnorm(delta,[1;4]);\n   > \"Delta = \", Delta, \" = 2^(\", log2(Delta), \")\";\n   Delta = 3.4920910013773992744476948245123751988401933577684e-605 = 2^(-2007.9624062518028904536343473598695412718995360192)\n\nExample 4: \n   > p = interpolate([| 1, 2, 3, 4 |], [| 1, -1, 2, -3 |]);\n   > q = interpolate([| 1, 2, 3, 4 |], [| 1, -1, 2, -3 |], 2^-17, [0;2^10]);\n   > delta = horner(p - q);\n   > write(\"delta = \", delta, \"\\n\");\n   delta = _x_ * (1 / 422212465065984 + _x_^2 * -1 / 6755399441055744)\n   > Delta = dirtyinfnorm(delta,[0;2^10]);\n   > \"Delta = \", Delta, \" = 2^(\", log2(Delta), \")\";\n   Delta = 1.589432940818369388580322265625e-7 = 2^(-22.584984514668420136955755457026138868402791643092)\n   > p = interpolate([| 1, 2, 3, 4 |], [| 1, -1, 2, -3 |]);\n   > q = interpolate([| 1, 2, 3, 4 |], [| 1, -1, 2, -3 |], 2^-2000, [0;2^10]);\n   > delta = horner(p - q);\n   > write(\"delta = \", delta, \"\\n\");\n   delta = _x_ * (-1 / 3.6983878408024986992700435663608496048481867984446e611 + _x_^2 * 1 / 5.9174205452839979188320697061773593677570988775114e612)\n   > Delta = dirtyinfnorm(delta,[0;2^10]);\n   > \"Delta = \", Delta, \" = 2^(\", log2(Delta), \")\";\n   Delta = 1.8145160239721784427448462541908690004638874174061e-604 = 2^(-2005.58498451466842013695575545702613886840279164307)\n\nExample 5: \n   > p = interpolate([| 1, 2, 3, 4 |], 17 + _x_ * (42 + _x_ * (23 + _x_ * 1664)));\n   > write(\"p = \", p, \"\\n\");\n   p = 17 + _x_ * (42 + _x_ * (23 + _x_ * 1664))\n\nExample 6: \n   > p = interpolate([| 1, 2, 3, 4 |], exp(_x_));\n   > write(\"p = \", p, \"\\n\");\n   p = -1 * (-2 * (-3 * ((exp(4) - exp(3) - (exp(3) - exp(2))) / 2 - (exp(3) - exp(2) - (exp(2) - exp(1))) / 2) / 3 + (exp(3) - exp(2) - (exp(2) - exp(1))) / 2) + exp(2) - exp(1)) + exp(1) + _x_ * (-1 * (-2 * ((exp(4) - exp(3) - (exp(3) - exp(2))) / 2 - (exp(3) - exp(2) - (exp(2) - exp(1))) / 2) / 3 + -3 * ((exp(4) - exp(3) - (exp(3) - exp(2))) / 2 - (exp(3) - exp(2) - (exp(2) - exp(1))) / 2) / 3 + (exp(3) - exp(2) - (exp(2) - exp(1))) / 2) + -2 * (-3 * ((exp(4) - exp(3) - (exp(3) - exp(2))) / 2 - (exp(3) - exp(2) - (exp(2) - exp(1))) / 2) / 3 + (exp(3) - exp(2) - (exp(2) - exp(1))) / 2) + exp(2) - exp(1) + _x_ * (-1 * ((exp(4) - exp(3) - (exp(3) - exp(2))) / 2 - (exp(3) - exp(2) - (exp(2) - exp(1))) / 2) / 3 + -2 * ((exp(4) - exp(3) - (exp(3) - exp(2))) / 2 - (exp(3) - exp(2) - (exp(2) - exp(1))) / 2) / 3 + -3 * ((exp(4) - exp(3) - (exp(3) - exp(2))) / 2 - (exp(3) - exp(2) - (exp(2) - exp(1))) / 2) / 3 + (exp(3) - exp(2) - (exp(2) - exp(1))) / 2 + _x_ * ((exp(4) - exp(3) - (exp(3) - exp(2))) / 2 - (exp(3) - exp(2) - (exp(2) - exp(1))) / 2) / 3))\n   > p = interpolate([| 1, 2, 3, 4 |], exp(_x_), 2^-17);\n   > write(\"p = \", p, \"\\n\");\n   p = -7.7172116227447986602783203125 + _x_ * (17.9146616198122501373291015625 + _x_ * (-9.7775724567472934722900390625 + _x_ * 2.2984042889438569545745849609375))\n   > p = interpolate([| 1, 2, 3, 4 |], exp(_x_), 2^-17, [0; 2^42]);\n   > write(\"p = \", p, \"\\n\");\n   p = -7.717211620141288536337557462573403702892010733189 + _x_ * (17.914661614969411928830253122773955194465923548481 + _x_ * (-9.7775724550214350407416860470959032694184512464826 + _x_ * 2.2984042886523568836092778582480142756017855238293))\n\nExample 7: \n   > p = interpolate([| 1, 2, 3, 4 |], exp(_x_));\n   > q = interpolate([| 1, 2, 3, 4 |], exp(_x_), 2^-17);\n   > delta = horner(p - q);\n   > Delta = dirtyinfnorm(delta,[1;4]);\n   > \"Delta = \", Delta, \" = 2^(\", log2(Delta), \")\";\n   Delta = 7.8101123470606372346391215972092629613859312741733e-9 = 2^(-26.932009552561199842757802778211432954321538161928)\n   > p = interpolate([| 1, 2, 3, 4 |], exp(_x_));\n   > q = interpolate([| 1, 2, 3, 4 |], exp(_x_), 2^-2000);\n   > delta = horner(p - q);\n   > Delta = dirtyinfnorm(delta,[1;4]);\n   > \"Delta = \", Delta, \" = 2^(\", log2(Delta), \")\";\n   Delta = 3.574737886097255322676984068596786349480238060537e-606 = 2^(-2011.2505880400718258175558034736121948862189809702)\n\nExample 8: \n   > p = interpolate([| 1, 2, 3, 4 |], exp(_x_));\n   > q = interpolate([| 1, 2, 3, 4 |], exp(_x_), 2^-17, [0;2^10]);\n   > delta = horner(p - q);\n   > Delta = dirtyinfnorm(delta,[0;2^10]);\n   > \"Delta = \", Delta, \" = 2^(\", log2(Delta), \")\";\n   Delta = 3.3174992022654716926120201737930257514243356389991e-9 = 2^(-28.167256735304970710773265696018465191273351786528)\n   > p = interpolate([| 1, 2, 3, 4 |], exp(_x_));\n   > q = interpolate([| 1, 2, 3, 4 |], exp(_x_), 2^-2000, [0;2^10]);\n   > delta = horner(p - q);\n   > Delta = dirtyinfnorm(delta,[0;2^10]);\n   > \"Delta = \", Delta, \" = 2^(\", log2(Delta), \")\";\n   Delta = 1.67480290063655159679957323422134460429582811153817e-605 = 2^(-2009.0225060850185477225876655278327362519640642038)\n\nExample 9: \n   > f = exp(_x_);\n   > I = [-1/2;1/2];\n   > n = 17;\n   > X = [||]; for i from 0 to n do X = (~(1/2 * (inf(I) + sup(I)) + 1/2 * (sup(I) - inf(I)) * cos(pi * ((2 * i + 1)/(2 * (n + 1)))))) .: X; X = revert(X);\n   > p = interpolate(X, f, 2^-110);\n   > q = remez(f, n, I);\n   > Delta = dirtyinfnorm(p-f,I);\n   > \"||p-f|| = \", Delta, \" = 2^(\", log2(Delta), \")\";\n   ||p-f|| = 4.6822823648740795415790209572324990540532715520787e-27 = 2^(-87.464846623211506004130540250100341126958424233896)\n   > Delta = dirtyinfnorm(q-f,I);\n   > \"||q-f|| = \", Delta, \" = 2^(\", log2(Delta), \")\";\n   ||q-f|| = 4.5615560104462964431174181483603567519672456911095e-27 = 2^(-87.502532530192383004694428978646385337892102159012)\n   > Delta = dirtyinfnorm(horner(p-q),I);\n   > \"||p-q|| = \", Delta, \" = 2^(\", log2(Delta), \")\";\n   ||p-q|| = 1.20729201910945452306513389470528343007256343110758e-28 = 2^(-92.742211980284523389260465711218526032152621095553)\n\nExample 10: \n   > interpolate([| 1, 1 + 2^-1000 |], 17 + 42 * x);\n   17 + x * 42\n   > interpolate([| 1, 1 + 2^-10000 |], 17 + 42 * x);\n   17 + x * 42\n   > interpolate([| 1, 1 |], 17 + 42 * x);\n   error\n\nSee also: remez, dirtyinfnorm, supnorm, prec, error\n"
#define HELP_ISBOUND_TEXT "Name: isbound\n==> indicates whether a variable is bound or not.\n\nUsage: \n   isbound({ident}) : boolean\n\nParameters: \n   {ident} is a name.\n\nDescription: \n   * isbound({ident}) returns a boolean value indicating whether the name {ident}\n   is used or not to represent a variable. It returns true when {ident} is the \n   name used to represent the global variable or if the name is currently used\n   to refer to a (possibly local) variable.\n\n   * When a variable is defined in a block and has not been defined outside, \n   isbound returns true when called inside the block, and false outside.\n   Note that isbound returns true as soon as a variable has been declared with \n   var, even if no value is actually stored in it.\n\n   * If {ident1} is bound to a variable and if {ident2} refers to the global \n   variable, the command rename({ident2}, {ident1}) hides the value of {ident1}\n   which becomes the global variable. However, if the global variable is again\n   renamed, {ident1} gets its value back. In this case, isbound({ident1}) returns\n   true. If {ident1} was not bound before, isbound({ident1}) returns false after\n   that {ident1} has been renamed.\n\nExample 1: \n   > isbound(x);\n   false\n   > isbound(f);\n   false\n   > isbound(g);\n   false\n   > f=sin(x);\n   > isbound(x);\n   true\n   > isbound(f);\n   true\n   > isbound(g);\n   false\n\nExample 2: \n   > isbound(a);\n   false\n   > { var a; isbound(a); };\n   true\n   > isbound(a);\n   false\n\nExample 3: \n   > f=sin(x);\n   > isbound(x);\n   true\n   > rename(x,y);\n   > isbound(x);\n   false\n\nExample 4: \n   > x=1;\n   > f=sin(y);\n   > rename(y,x);\n   > f;\n   sin(x)\n   > x;\n   x\n   > isbound(x);\n   true\n   > rename(x,y);\n   > isbound(x);\n   true\n   > x;\n   1\n\nSee also: rename\n"
#define HELP_ISEVALUABLE_TEXT "Name: isevaluable\n==> tests whether a function can be evaluated at a point \n\nUsage: \n   isevaluable({function}, {constant}) : (function, constant) -> boolean\n\nParameters: \n   {function} represents a function\n   {constant} represents a constant point\n\nDescription: \n   * isevaluable applied to function {function} and a constant {constant}\n   returns a boolean indicating whether or not a subsequent call to evaluate on\n   the same function {function} and constant {constant} will produce a numerical\n   result or NaN. This means isevaluable returns false iff evaluate will\n   return NaN.\n\n   * The command isevaluable is now considered DEPRECATED in Sollya.\n   As checks for NaNs are now possible in Sollya, the command isevaluable\n   can be fully emulated with a call to evaluate and a couple of tests, \n   as shown below in the last example.\n\nExample 1: \n   > isevaluable(sin(pi * log(x)), 0.5);\n   true\n   > print(evaluate(sin(pi * log(x)), 0.5));\n   -0.82148283122563882875872566228649962370813607461095\n\nExample 2: \n   > isevaluable(sin(pi * log(x)), 0);\n   true\n   > print(evaluate(sin(pi * log(x)), 0));\n   [-1;1]\n\nExample 3: \n   > isevaluable(sin(pi * 1/x), 0.5);\n   true\n   > print(evaluate(sin(pi * 1/x), 0.5));\n   [-3.100365765139897619749121887390789523854170596558e-13490;5.3002401585857127605350842426029223241500776302528e-13489]\n\nExample 4: \n   > procedure isEvaluableEmulation(f, c) {\n     \t  return match evaluate(f, c) with \n     \t  \t       NaN : (false)\n     \t\t       [NaN;NaN] : (false)\n     \t\t       default : (true);\n     };\n   > isEvaluableEmulation(sin(pi * log(x)), 0.5);\n   true\n   > isEvaluableEmulation(sin(pi * log(x)), 0);\n   true\n   > isEvaluableEmulation(sin(pi * log(x)), -1);\n   false\n\nSee also: evaluate\n"
#define HELP_LENGTH_TEXT "Name: length\n==> computes the length of a list or string.\n\nLibrary name:\n   sollya_obj_t sollya_lib_length(sollya_obj_t)\n\nUsage: \n   length({L}) : list -> integer\n   length({s}) : string -> integer\n\nParameters: \n   {L} is a list.\n   {s} is a string.\n\nDescription: \n   * length returns the length of a list or a string, e.g. the number of elements\n   or letters.\n\n   * The empty list or string have length 0.\n   If {L} is an end-elliptic list, length returns +Inf.\n\nExample 1: \n   > length(\"Hello World!\");\n   12\n\nExample 2: \n   > length([|1,...,5|]);\n   5\n\nExample 3: \n   > length([| |]);\n   0\n\nExample 4: \n   > length([|1,2...|]);\n   infty\n\n"
#define HELP_LE_TEXT "Name: <=\n==> less-than-or-equal-to operator\n\nLibrary name:\n   sollya_obj_t sollya_lib_cmp_less_equal(sollya_obj_t, sollya_obj_t)\n\nUsage: \n   {expr1} <= {expr2} : (constant, constant) -> boolean\n\nParameters: \n   {expr1} and {expr2} represent constant expressions\n\nDescription: \n   * The operator <= evaluates to true iff its operands {expr1} and\n   {expr2} evaluate to two floating-point numbers a1\n   respectively a2 with the global precision prec and\n   a1 is less than or equal to a2. The user should\n   be aware of the fact that because of floating-point evaluation, the\n   operator <= is not exactly the same as the mathematical\n   operation \"less-than-or-equal-to\".\n\nExample 1: \n   > 5 <= 4;\n   false\n   > 5 <= 5;\n   true\n   > 5 <= 6;\n   true\n   > exp(2) <= exp(1);\n   false\n   > log(1) <= exp(2);\n   true\n\nExample 2: \n   > prec = 12;\n   The precision has been set to 12 bits.\n   > 16385.1 <= 16384.1;\n   true\n\nSee also: ==, !=, >=, >, <, in, !, &&, ||, prec, max, min\n"
#define HELP_LIBRARYCONSTANT_TEXT "Name: libraryconstant\n==> binds an external mathematical constant to a variable in Sollya\n\nLibrary names:\n   sollya_obj_t sollya_lib_libraryconstant(char *, void (*)(mpfr_t, mp_prec_t))\n   sollya_obj_t sollya_lib_build_function_libraryconstant(char *,\n                                                          void (*)(mpfr_t,\n                                                                   mp_prec_t))\n   sollya_obj_t sollya_lib_libraryconstant_with_data(char *,\n                                                     void (*)(mpfr_t,\n                                                              mp_prec_t,\n                                                              void *),\n                                                     void *,\n                                                     void (*)(void *))\n   sollya_obj_t sollya_lib_build_function_libraryconstant_with_data(\n                                                     char *,\n                                                     void (*)(mpfr_t,\n                                                              mp_prec_t,\n                                                              void *),\n                                                     void *,\n                                                     void (*)(void *))\n\nUsage: \n   libraryconstant({path}) : string -> function\n\nDescription: \n   * The command libraryconstant lets you extend the set of mathematical\n   constants known to Sollya.\n   By default, the only mathematical constant known by Sollya is pi.\n   For particular applications, one may want to\n   manipulate other constants, such as Euler's gamma constant, for instance.\n\n   * libraryconstant makes it possible to let Sollya know about new constants.\n   In order to let it know, you have to provide an implementation of the\n   constant you are interested in. This implementation is a C file containing\n   a function of the form:\n                 void my_ident(mpfr_t result, mp_prec_t prec) \n   The semantic of this function is the following: it is an implementation of\n   the constant in arbitrary precision.\n   my_ident(result, prec) shall set the\n   precision of the variable result to a suitable precision (the variable is\n   assumed to be already initialized) and store in result an approximate value\n   of the constant with a relative error not greater than 2^(1-prec).\n   More precisely, if c is the exact value of the constant, the value stored\n   in result should satisfy |result-c| <= 2^(1-prec)*|c|.\n\n   * You can include sollya.h in your implementation and use library \n   functionnalities of Sollya for your implementation. However, this requires to\n   have compiled Sollya with -fPIC in order to make the Sollya executable\n   code position independent and to use a system on with programs, using dlopen\n   to open dynamic routines can dynamically open themselves.\n\n   * To bind your constant into Sollya, you must use the same identifier as the\n   function name used in your implementation file (my_ident in the previous\n   example). Once the function code has been bound to an identifier, you can use\n   a simple assignment to assign the bound identifier to yet another identifier.\n   This way, you may use convenient names inside Sollya even if your\n   implementation environment requires you to use a less convenient name.\n\n   * Once your constant is bound, it is considered by Sollya as an infinitely\n   accurate constant (i.e. a 0-ary function, exactly like pi).\n\n   * The dynamic object file whose name is given to libraryconstant for binding of an\n   external library constant may also define a destructor function int sollya_external_lib_close(void).\n   If Sollya finds such a destructor function in the dynamic object file, it will call \n   that function when closing the dynamic object file again. This happens when Sollya\n   is terminated or when the current Sollya session is restarted using restart.\n   The purpose of the destructor function is to allow the dynamically bound code\n   to free any memory that it might have allocated before Sollya is terminated \n   or restarted. \n   The dynamic object file is not necessarily needed to define a destructor\n   function. This ensure backward compatibility with older Sollya external \n   library function object files.\n   When defined, the destructor function is supposed to return an integer\n   value indicating if an error has happened. Upon success, the destructor\n   functions is to return a zero value, upon error a non-zero value.\n\nExample 1: \n   > bashexecute(\"gcc -fPIC -Wall -c libraryconstantexample.c -I$HOME/.local/include\");\n   > bashexecute(\"gcc -shared -o libraryconstantexample libraryconstantexample.o -lgmp -lmpfr\");\n   > euler_gamma = libraryconstant(\"./libraryconstantexample\");\n   > prec = 20!;\n   > euler_gamma;\n   0.577215\n   > prec = 100!;\n   > euler_gamma;\n   0.577215664901532860606512090082\n   > midpointmode = on;\n   Midpoint mode has been activated.\n   > [euler_gamma];\n   0.57721566490153286060651209008~2/4~\n\nSee also: bashexecute, externalproc, externaldata, externalplot, pi, library, evaluate, implementconstant\n"
#define HELP_LIBRARY_TEXT "Name: library\n==> binds an external mathematical function to a variable in Sollya\n\nLibrary names:\n   sollya_obj_t sollya_lib_libraryfunction(sollya_obj_t, char *,\n                                           int (*)(mpfi_t, mpfi_t, int))\n   sollya_obj_t sollya_lib_build_function_libraryfunction(sollya_obj_t, char *,\n                                                          int (*)(mpfi_t,\n                                                                  mpfi_t, int))\n   sollya_obj_t sollya_lib_libraryfunction_with_data(\n                                           sollya_obj_t, char *,\n                                           int (*)(mpfi_t, mpfi_t, int, void *),\n                                           void *, void (*)(void *))\n   sollya_obj_t sollya_lib_build_function_libraryfunction_with_data(\n                                           sollya_obj_t, char *,\n                                           int (*)(mpfi_t,\n                                                   mpfi_t, int, void *),\n                                           void *, void (*)(void *))\n\nUsage: \n   library({path}) : string -> function\n\nDescription: \n   * The command library lets you extend the set of mathematical\n   functions known to Sollya.\n   By default, Sollya knows the most common mathematical functions such\n   as exp, sin, erf, etc. Within Sollya, these functions may be\n   composed. This way, Sollya should satisfy the needs of a lot of\n   users. However, for particular applications, one may want to\n   manipulate other functions such as Bessel functions, or functions\n   defined by an integral or even a particular solution of an ODE.\n\n   * library makes it possible to let Sollya know about new functions. In\n   order to let it know, you have to provide an implementation of the\n   function you are interested in. This implementation is a C file containing\n   a function of the form:\n                 int my_ident(sollya_mpfi_t result, sollya_mpfi_t op, int n) \n   The semantic of this function is the following: it is an implementation of\n   the function and its derivatives in interval arithmetic.\n   my_ident(result, I, n) shall store in result an enclosure \n   of the image set of the n-th derivative\n   of the function f over I: f^(n)(I) C result.\n\n   * The integer value returned by the function implementation currently has no\n   meaning.\n\n   * You do not need to provide a working implementation for any n. Most\n   functions of Sollya requires a relevant implementation only for f,\n   f' and f''. For higher derivatives, its is not so critical and the\n   implementation may just store [-Inf, +Inf] in result whenever n>2.\n\n   * Note that you should respect somehow interval-arithmetic standards in your\n   implementation: result has its own precision and you should perform the \n   intermediate computations so that result is as tight as possible.\n\n   * You can include sollya.h in your implementation and use library \n   functionnalities of Sollya for your implementation. However, this requires to\n   have compiled Sollya with -fPIC in order to make the Sollya executable code\n   position independent and to use a system on with programs, using dlopen to\n   open dynamic routines can dynamically open themselves. IMPORTANT NOTICE: as\n   the code will be run in a context where a sollya session is already opened,\n   the library functions must be used directly, without calling sollya_lib_init\n   and sollya_lib_close (calling these functions would conflict with the\n   current session, leading to weird and hard to debug behaviors).\n\n   * To bind your function into Sollya, you must use the same identifier as the\n   function name used in your implementation file (my_ident in the previous\n   example). Once the function code has been bound to an identifier, you can use\n   a simple assignment to assign the bound identifier to yet another identifier.\n   This way, you may use convenient names inside Sollya even if your\n   implementation environment requires you to use a less convenient name.\n\n   * The dynamic object file whose name is given to library for binding of an\n   external library function may also define a destructor function\n     int sollya_external_lib_close(void).\n   If Sollya finds such a destructor function in the dynamic object file, it\n   will call that function when closing the dynamic object file again.\n   This happens when Sollya is terminated or when the current Sollya session\n   is restarted using restart.\n   The purpose of the destructor function is to allow the dynamically bound code\n   to free any memory that it might have allocated before Sollya is terminated \n   or restarted. \n   The dynamic object file is not necessarily needed to define a destructor\n   function. This ensure backward compatibility with older Sollya external \n   library function object files.\n   When defined, the destructor function is supposed to return an integer\n   value indicating if an error has happened. Upon success, the destructor\n   functions is to return a zero value, upon error a non-zero value.\n\nExample 1: \n   > bashexecute(\"gcc -fPIC -Wall -c libraryexample.c -I$HOME/.local/include\");\n   > bashexecute(\"gcc -shared -o libraryexample libraryexample.o -lgmp -lmpfr\");\n   > myownlog = library(\"./libraryexample\");\n   > evaluate(log(x), 2);\n   0.69314718055994530941723212145817656807550013436025\n   > evaluate(myownlog(x), 2);\n   0.69314718055994530941723212145817656807550013436025\n\nSee also: function, bashexecute, externalproc, externaldata, externalplot, diff, evaluate, libraryconstant\n"
#define HELP_LISTOF_TEXT "Name: list of\n==> keyword used in combination with a type keyword\n\nLibrary names:\n   SOLLYA_EXTERNALPROC_TYPE_CONSTANT_LIST\n   SOLLYA_EXTERNALPROC_TYPE_FUNCTION_LIST\n   SOLLYA_EXTERNALPROC_TYPE_RANGE_LIST\n   SOLLYA_EXTERNALPROC_TYPE_INTEGER_LIST\n   SOLLYA_EXTERNALPROC_TYPE_STRING_LIST\n   SOLLYA_EXTERNALPROC_TYPE_BOOLEAN_LIST\n   SOLLYA_EXTERNALPROC_TYPE_OBJECT_LIST\n\nDescription: \n   * list of is used in combination with one of the following keywords for\n   indicating lists of the respective type in declarations of external\n   procedures using externalproc: boolean, constant, function,\n   integer, range, object and string.\n\nSee also: externalproc, boolean, constant, function, integer, range, string, object\n"
#define HELP_LOG10_TEXT "Name: log10\n==> decimal logarithm.\n\nLibrary names:\n   sollya_obj_t sollya_lib_log10(sollya_obj_t)\n   sollya_obj_t sollya_lib_build_function_log10(sollya_obj_t)\n   #define SOLLYA_LOG10(x) sollya_lib_build_function_log10(x)\n\nDescription: \n   * log10 is the decimal logarithm defined by: log10(x) = log(x)/log(10).\n\n   * It is defined only for x in [0; +Inf].\n\nSee also: log, log2\n"
#define HELP_LOG1P_TEXT "Name: log1p\n==> translated logarithm.\n\nLibrary names:\n   sollya_obj_t sollya_lib_log1p(sollya_obj_t)\n   sollya_obj_t sollya_lib_build_function_log1p(sollya_obj_t)\n   #define SOLLYA_LOG1P(x) sollya_lib_build_function_log1p(x)\n\nDescription: \n   * log1p is the function defined by log1p(x) = log(1+x).\n\n   * It is defined only for x in [-1; +Inf].\n\nSee also: log\n"
#define HELP_LOG2_TEXT "Name: log2\n==> binary logarithm.\n\nLibrary names:\n   sollya_obj_t sollya_lib_log2(sollya_obj_t)\n   sollya_obj_t sollya_lib_build_function_log2(sollya_obj_t)\n   #define SOLLYA_LOG2(x) sollya_lib_build_function_log2(x)\n\nDescription: \n   * log2 is the binary logarithm defined by: log2(x) = log(x)/log(2).\n\n   * It is defined only for x in [0; +Inf].\n\nSee also: log, log10\n"
#define HELP_LOG_TEXT "Name: log\n==> natural logarithm.\n\nLibrary names:\n   sollya_obj_t sollya_lib_log(sollya_obj_t)\n   sollya_obj_t sollya_lib_build_function_log(sollya_obj_t)\n   #define SOLLYA_LOG(x) sollya_lib_build_function_log(x)\n\nDescription: \n   * log is the natural logarithm defined as the inverse of the exponential\n   function: log(y) is the unique real number x such that exp(x)=y.\n\n   * It is defined only for y in [0; +Inf].\n\nSee also: exp, log2, log10\n"
#define HELP_LT_TEXT "Name: <\n==> less-than operator\n\nLibrary name:\n   sollya_obj_t sollya_lib_cmp_less(sollya_obj_t, sollya_obj_t)\n\nUsage: \n   {expr1} < {expr2} : (constant, constant) -> boolean\n\nParameters: \n   {expr1} and {expr2} represent constant expressions\n\nDescription: \n   * The operator < evaluates to true iff its operands {expr1} and\n   {expr2} evaluate to two floating-point numbers a1\n   respectively a2 with the global precision prec and\n   a1 is less than a2. The user should\n   be aware of the fact that because of floating-point evaluation, the\n   operator < is not exactly the same as the mathematical\n   operation \"less-than\".\n\nExample 1: \n   > 5 < 4;\n   false\n   > 5 < 5;\n   false\n   > 5 < 6;\n   true\n   > exp(2) < exp(1);\n   false\n   > log(1) < exp(2);\n   true\n\nExample 2: \n   > prec = 12;\n   The precision has been set to 12 bits.\n   > 16384.1 < 16385.1;\n   false\n\nSee also: ==, !=, >=, >, <=, in, !, &&, ||, prec, max, min\n"
#define HELP_MANTISSA_TEXT "Name: mantissa\n==> returns the integer mantissa of a number.\n\nLibrary name:\n   sollya_obj_t sollya_lib_mantissa(sollya_obj_t)\n\nUsage: \n   mantissa({x}) : constant -> integer\n\nParameters: \n   {x} is a dyadic number.\n\nDescription: \n   * mantissa(x) is by definition x if x equals 0, NaN, or Inf.\n\n   * If {x} is not zero, it can be uniquely written as x = m*2^e where\n   m is an odd integer and e is an integer. mantissa(x) returns m. \n\nExample 1: \n   > a=round(Pi,20,RN);\n   > e=exponent(a);\n   > m=mantissa(a);\n   > m;\n   411775\n   > a-m*2^e;\n   0\n\nSee also: exponent, precision\n"
#define HELP_MAX_TEXT "Name: max\n==> determines which of given constant expressions has maximum value\n\nLibrary names:\n   sollya_obj_t sollya_lib_max(sollya_obj_t, ...)\n   sollya_obj_t sollya_lib_v_max(sollya_obj_t, va_list)\n\nUsage: \n   max({expr1},{expr2},...,{exprn}) : (constant, constant, ..., constant) -> constant\n   max({l}) : list -> constant\n\nParameters: \n   {expr} are constant expressions.\n   {l} is a list of constant expressions.\n\nDescription: \n   * max determines which of a given set of constant expressions\n   {expr} has maximum value. To do so, max tries to increase the\n   precision used for evaluation until it can decide the ordering or some\n   maximum precision is reached. In the latter case, a warning is printed\n   indicating that there might actually be another expression that has a\n   greater value.\n\n   * Even though max determines the maximum expression by evaluation, it \n   returns the expression that is maximum as is, i.e. as an expression\n   tree that might be evaluated to any accuracy afterwards.\n\n   * max can be given either an arbitrary number of constant\n   expressions in argument or a list of constant expressions. The list\n   however must not be end-elliptic.\n\n   * Users should be aware that the behavior of max follows the IEEE\n   754-2008 standard with respect to NaNs. In particular, max\n   evaluates to NaN if and only if all arguments of max are\n   NaNs. This means that NaNs may disappear during computations.\n\nExample 1: \n   > max(1,2,3,exp(5),log(0.25));\n   148.41315910257660342111558004055227962348766759388\n   > max(17);\n   17\n\nExample 2: \n   > l = [|1,2,3,exp(5),log(0.25)|];\n   > max(l);\n   148.41315910257660342111558004055227962348766759388\n\nExample 3: \n   > print(max(exp(17),sin(62)));\n   exp(17)\n\nExample 4: \n   > verbosity = 1!;\n   > print(max(17 + log2(13)/log2(9),17 + log(13)/log(9)));\n   Warning: the tool is unable to decide a maximum computation by evaluation even though faithful evaluation of the terms has been possible. The terms will be considered to be equal.\n   17 + log2(13) / log2(9)\n\nSee also: min, ==, !=, >=, >, <, <=, in, inf, sup\n"
#define HELP_MIDPOINTMODE_TEXT "Name: midpointmode\n==> global variable controlling the way intervals are displayed.\n\nLibrary names:\n   void sollya_lib_set_midpointmode_and_print(sollya_obj_t)\n   void sollya_lib_set_midpointmode(sollya_obj_t)\n   sollya_obj_t sollya_lib_get_midpointmode()\n\nUsage: \n   midpointmode = {activation value} : on|off -> void\n   midpointmode = {activation value} ! : on|off -> void\n   midpointmode : on|off\n\nParameters: \n   {activation value} enables or disables the mode.\n\nDescription: \n   * midpointmode is a global variable. When its value is off, intervals are displayed\n   as usual (in the form [a;b]).\n   When its value is on, and if a and b have the same first significant digits,\n   the interval in displayed in a way that lets one immediately see the common\n   digits of the two bounds.\n\n   * This mode is supported only with display set to decimal. In other modes of \n   display, midpointmode value is simply ignored.\n\nExample 1: \n   > a = round(Pi,30,RD);\n   > b = round(Pi,30,RU);\n   > d = [a,b];\n   > d;\n   [3.1415926516056060791015625;3.1415926553308963775634765625]\n   > midpointmode=on!;\n   > d;\n   0.314159265~1/6~e1\n\nSee also: on, off, roundingwarnings, display, decimal\n"
#define HELP_MID_TEXT "Name: mid\n==> gives the middle of an interval.\n\nLibrary name:\n   sollya_obj_t sollya_lib_mid(sollya_obj_t)\n\nUsage: \n   mid({I}) : range -> constant\n   mid({x}) : constant -> constant\n\nParameters: \n   {I} is an interval.\n   {x} is a real number.\n\nDescription: \n   * Returns the middle of the interval {I}. If the middle is not exactly\n   representable at the current precision, the value is returned as an\n   unevaluated expression.\n\n   * When called on a real number {x}, mid behaves like the identity.\n\nExample 1: \n   > mid([1;3]);\n   2\n   > mid(17);\n   17\n\nSee also: inf, sup\n"
#define HELP_MIN_TEXT "Name: min\n==> determines which of given constant expressions has minimum value\n\nLibrary names:\n   sollya_obj_t sollya_lib_min(sollya_obj_t, ...)\n   sollya_obj_t sollya_lib_v_min(sollya_obj_t, va_list)\n\nUsage: \n   min({expr1},{expr2},...,{exprn}) : (constant, constant, ..., constant) -> constant\n   min({l}) : list -> constant\n\nParameters: \n   {expr} are constant expressions.\n   {l} is a list of constant expressions.\n\nDescription: \n   * min determines which of a given set of constant expressions\n   {expr} has minimum value. To do so, min tries to increase the\n   precision used for evaluation until it can decide the ordering or some\n   maximum precision is reached. In the latter case, a warning is printed\n   indicating that there might actually be another expression that has a\n   lesser value.\n\n   * Even though min determines the minimum expression by evaluation, it \n   returns the expression that is minimum as is, i.e. as an expression\n   tree that might be evaluated to any accuracy afterwards.\n\n   * min can be given either an arbitrary number of constant\n   expressions in argument or a list of constant expressions. The list\n   however must not be end-elliptic.\n\n   * Users should be aware that the behavior of min follows the IEEE\n   754-2008 standard with respect to NaNs. In particular, min\n   evaluates to NaN if and only if all arguments of min are\n   NaNs. This means that NaNs may disappear during computations.\n\nExample 1: \n   > min(1,2,3,exp(5),log(0.25));\n   -1.3862943611198906188344642429163531361510002687205\n   > min(17);\n   17\n\nExample 2: \n   > l = [|1,2,3,exp(5),log(0.25)|];\n   > min(l);\n   -1.3862943611198906188344642429163531361510002687205\n\nExample 3: \n   > print(min(exp(17),sin(62)));\n   sin(62)\n\nExample 4: \n   > verbosity = 1!;\n   > print(min(17 + log2(13)/log2(9),17 + log(13)/log(9)));\n   Warning: the tool is unable to decide a minimum computation by evaluation even though faithful evaluation of the terms has been possible. The terms will be considered to be equal.\n   17 + log(13) / log(9)\n\nSee also: max, ==, !=, >=, >, <, <=, in, inf, sup\n"
#define HELP_MINUS_TEXT "Name: -\n==> subtraction function\n\nLibrary names:\n   sollya_obj_t sollya_lib_sub(sollya_obj_t, sollya_obj_t)\n   sollya_obj_t sollya_lib_build_function_sub(sollya_obj_t, sollya_obj_t)\n   #define SOLLYA_SUB(x,y) sollya_lib_build_function_sub((x), (y))\n   sollya_obj_t sollya_lib_neg(sollya_obj_t)\n   sollya_obj_t sollya_lib_build_function_neg(sollya_obj_t)\n   #define SOLLYA_NEG(x) sollya_lib_build_function_neg(x)\n\nUsage: \n   {function1} - {function2} : (function, function) -> function\n   {interval1} - {interval2} : (range, range) -> range\n   {interval1} - {constant} : (range, constant) -> range\n   {interval1} - {constant} : (constant, range) -> range\n   - {function1} : function -> function\n   - {interval1} : range -> range\n\nParameters: \n   {function1} and {function2} represent functions\n   {interval1} and {interval2} represent intervals (ranges)\n   {constant} represents a constant or constant expression\n\nDescription: \n   * - represents the subtraction (function) on reals. \n   The expression {function1} - {function2} stands for\n   the function composed of the subtraction function and the two\n   functions {function1} and {function2}, where {function1} is \n   the subtrahend and {function2} the subtractor.\n\n   * - can be used for interval arithmetic on intervals\n   (ranges). - will evaluate to an interval that safely\n   encompasses all images of the subtraction function with arguments varying\n   in the given intervals.  Any combination of intervals with intervals\n   or constants (resp. constant expressions) is supported. However, it is\n   not possible to represent families of functions using an interval as\n   one argument and a function (varying in the free variable) as the\n   other one.\n\n   * - stands also for the negation function.\n\nExample 1: \n   > 5 - 2;\n   3\n\nExample 2: \n   > x - 2;\n   -2 + x\n\nExample 3: \n   > x - x;\n   0\n\nExample 4: \n   > diff(sin(x) - exp(x));\n   cos(x) - exp(x)\n\nExample 5: \n   > [1;2] - [3;4];\n   [-3;-1]\n   > [1;2] - 17;\n   [-16;-15]\n   > 13 - [-4;17];\n   [-4;17]\n\nExample 6: \n   > -exp(x);\n   -exp(x)\n   > -13;\n   -13\n   > -[13;17];\n   [-17;-13]\n\nSee also: +, *, /, ^\n"
#define HELP_MODEUCL_TEXT "Name: mod\n==> Computes the euclidian division of polynomials or numbers and returns the rest\n\nLibrary name:\n   sollya_obj_t sollya_lib_euclidian_mod(sollya_obj_t, sollya_obj_t)\n\nUsage: \n   mod({a}, {b}) : (function, function) -> function\n\nParameters: \n   {a} is a constant or a polynomial.\n   {b} is a constant or a polynomial.\n\nDescription: \n   * mod({a},{b}) computes {a} - ({b} * div({a},{b})).\n   In other words, it returns the remainder of the Euclidian division\n   of {a} by {b}.\n\n   * See div for subtle cases involving polynomials whose degree can\n   not easily be computed by the tool as their leading coefficient is\n   given as a constant expression that is mathematically zero but for\n   which the tool is unable to detect this fact.\n\nExample 1: \n   > mod(1001, 231);\n   77\n   > mod(13, 17);\n   13\n   > mod(-14, 15);\n   1\n   > mod(-213, -5);\n   -3\n   > print(mod(23/13, 11/17));\n   105 / 221\n   > print(mod(exp(13),-sin(17)));\n   exp(13) + 460177 * sin(17)\n\nExample 2: \n   > mod(24 + 68 * x + 74 * x^2 + 39 * x^3 + 10 * x^4 + x^5, 4 + 4 * x + x^2);\n   0\n   > mod(24 + 68 * x + 74 * x^2 + 39 * x^3 + 10 * x^4 + x^5, 2 * x^3);\n   24 + x * (68 + x * 74)\n   > mod(x^2, x^3);\n   x^2\n\nExample 3: \n   > mod(exp(x), x^2);\n   exp(x)\n   > mod(x^3, sin(x));\n   x^3\n\nSee also: gcd, div, bezout, numberroots\n"
#define HELP_MULT_TEXT "Name: *\n==> multiplication function\n\nLibrary names:\n   sollya_obj_t sollya_lib_mul(sollya_obj_t, sollya_obj_t)\n   sollya_obj_t sollya_lib_build_function_mul(sollya_obj_t, sollya_obj_t)\n   #define SOLLYA_MUL(x,y) sollya_lib_build_function_mul((x), (y))\n\nUsage: \n   {function1} * {function2} : (function, function) -> function\n   {interval1} * {interval2} : (range, range) -> range\n   {interval1} * {constant} : (range, constant) -> range\n   {interval1} * {constant} : (constant, range) -> range\n\nParameters: \n   {function1} and {function2} represent functions\n   {interval1} and {interval2} represent intervals (ranges)\n   {constant} represents a constant or constant expression\n\nDescription: \n   * * represents the multiplication (function) on reals. \n   The expression {function1} * {function2} stands for\n   the function composed of the multiplication function and the two\n   functions {function1} and {function2}.\n\n   * * can be used for interval arithmetic on intervals\n   (ranges). * will evaluate to an interval that safely\n   encompasses all images of the multiplication function with arguments varying\n   in the given intervals.  Any combination of intervals with intervals\n   or constants (resp. constant expressions) is supported. However, it is\n   not possible to represent families of functions using an interval as\n   one argument and a function (varying in the free variable) as the\n   other one.\n\nExample 1: \n   > 5 * 2;\n   10\n\nExample 2: \n   > x * 2;\n   x * 2\n\nExample 3: \n   > x * x;\n   x^2\n\nExample 4: \n   > diff(sin(x) * exp(x));\n   sin(x) * exp(x) + exp(x) * cos(x)\n\nExample 5: \n   > [1;2] * [3;4];\n   [3;8]\n   > [1;2] * 17;\n   [17;34]\n   > 13 * [-4;17];\n   [-52;221]\n\nSee also: +, -, /, ^\n"
#define HELP_NEARESTINT_TEXT "Name: nearestint\n==> the function mapping the reals to the integers nearest to them.\n\nLibrary names:\n   sollya_obj_t sollya_lib_nearestint(sollya_obj_t)\n   sollya_obj_t sollya_lib_build_function_nearestint(sollya_obj_t)\n   #define SOLLYA_NEARESTINT(x) sollya_lib_build_function_nearestint(x)\n\nDescription: \n   * nearestint is defined as usual: nearestint(x) is the integer nearest to x, with the\n   special rule that the even integer is chosen if there exist two integers equally near to x.\n\n   * It is defined for every real number x.\n\nSee also: ceil, floor, round, RN\n"
#define HELP_NEQ_TEXT "Name: !=\n==> negated equality test operator\n\nLibrary name:\n   sollya_obj_t sollya_lib_cmp_not_equal(sollya_obj_t, sollya_obj_t)\n\nUsage: \n   {expr1} != {expr2} : (any type, any type) -> boolean\n\nParameters: \n   {expr1} and {expr2} represent expressions\n\nDescription: \n   * The operator != evaluates to true iff its operands {expr1} and\n   {expr2} are syntactically unequal and both different from error,\n   constant expressions that are not constants and that evaluate to two\n   different floating-point number with the global precision prec or \n   polynomials that are unequal while automatic expression simplification \n   is activated. The user should be aware of the fact that because of \n   floating-point evaluation, the operator != is not exactly the \n   same as the negation of the mathematical equality. Further, expressions \n   that are polynomials may not be structurally equal when != evaluates \n   to false; in order to obtain purely structural tests, the user should \n   deactivate automatic simplification using autosimplify.\n    \n   Following the IEEE 754 standard, NaN compares unequal to itself, even though\n   this corresponds to a case when {expr1} and {expr2} are syntactically equal\n   and different from error. Accordingly, the interval [NaN, NaN] compares\n   unequal to itself.\n    \n   Note that the expressions !({expr1} != {expr2}) and {expr1} == {expr2}\n   do not always evaluate to the same boolean value. See error for details.\n\n   * Notice that @NaN@, [@NaN, @NaN@] and error have special properties \n   with respect to comparison for equality with == and !=. See\n   documentation for == for a detailed description.\n\nExample 1: \n   > \"Hello\" != \"Hello\";\n   false\n   > \"Hello\" != \"Salut\";\n   true\n   > \"Hello\" != 5;\n   true\n   > 5 + x != 5 + x;\n   false\n\nExample 2: \n   > 1 != exp(0);\n   false\n   > asin(1) * 2 != pi;\n   false\n   > exp(5) != log(4);\n   true\n\nExample 3: \n   > sin(pi/6) != 1/2 * sqrt(3);\n   true\n\nExample 4: \n   > prec = 12;\n   The precision has been set to 12 bits.\n   > 16384.1 != 16385.1;\n   false\n\nExample 5: \n   > NaN != NaN;\n   true\n   > [NaN,NaN] != [NaN,NaN];\n   true\n   > error != error;\n   false\n\nExample 6: \n   > p = x + x^2;\n   > q = x * (1 + x);\n   > autosimplify = on;\n   Automatic pure tree simplification has been activated.\n   > p != q;\n   false\n   > autosimplify = off;\n   Automatic pure tree simplification has been deactivated.\n   > p != q;\n   true\n\nSee also: ==, >, >=, <=, <, in, !, &&, ||, error, prec, autosimplify\n"
#define HELP_NOP_TEXT "Name: nop\n==> no operation\n\nUsage: \n   nop : void -> void\n   nop() : void -> void\n   nop({n}) : integer -> void\n\nDescription: \n   * The command nop does nothing. This means it is an explicit parse\n   element in the Sollya language that finally does not produce any\n   result or side-effect.\n\n   * The command nop may take an optional positive integer argument\n   {n}. The argument controls how much (useless) multiprecision\n   floating-point multiplications Sollya performs while doing nothing.\n   With this behaviour, nop can be used for calibration of timing\n   tests.\n\n   * The keyword nop is implicit in some procedure\n   definitions. Procedures without imperative body get parsed as if they\n   had an imperative body containing one nop statement.\n\nExample 1: \n   > nop;\n\nExample 2: \n   > nop(100);\n\nExample 3: \n   > succ = proc(n) { return n + 1; };\n   > succ;\n   proc(n)\n   {\n   nop;\n   return (n) + (1);\n   }\n   > succ(5);\n   6\n\nSee also: proc, time\n"
#define HELP_NOT_TEXT "Name: !\n==> boolean NOT operator\n\nLibrary name:\n   sollya_obj_t sollya_lib_negate(sollya_obj_t)\n\nUsage: \n   ! {expr} : boolean -> boolean\n\nParameters: \n   {expr} represents a boolean expression\n\nDescription: \n   * ! evaluates to the boolean NOT of the boolean expression\n   {expr}. ! {expr} evaluates to true iff {expr} does not evaluate\n   to true.\n\nExample 1: \n   > ! false;\n   true\n\nExample 2: \n   > ! (1 == exp(0));\n   false\n\nSee also: &&, ||\n"
#define HELP_NUMBERROOTS_TEXT "Name: numberroots\n==> Computes the number of roots of a polynomial in a given range.\n\nLibrary name:\n   sollya_obj_t sollya_lib_numberroots(sollya_obj_t, sollya_obj_t)\n\nUsage: \n   numberroots({p}, {I}) : (function, range) -> integer\n\nParameters: \n   {p} is a polynomial.\n   {I} is an interval.\n\nDescription: \n   * numberroots rigorously computes the number of roots of polynomial the p in\n   the interval I. The technique used is Sturm's algorithm. The value returned\n   is not just a numerical estimation of the number of roots of p in I: it is\n   the exact number of roots.\n\n   * The command findzeros computes safe enclosures of all the zeros of a\n   function, without forgetting any, but it is not guaranteed to separate them\n   all in distinct intervals. numberroots is more accurate since it guarantees \n   the exact number of roots. However, it does not compute them. It may be used,\n   for instance, to certify that findzeros did not put two distinct roots in \n   the same interval.\n\n   * Multiple roots are counted only once.\n\n   * The interval I must be bounded. The algorithm cannot handle unbounded\n   intervals. Moreover, the interval is considered as a closed interval: if one\n   (or both) of the endpoints of I are roots of p, they are counted.\n\n   * The argument p can be any expression, but if Sollya fails to prove that\n   it is a polynomial an error is produced. Also, please note that if the\n   coefficients of p or the endpoints of I are not exactly representable,\n   they are first numerically evaluated, before the algorithm is used. In that\n   case, the counted number of roots corresponds to the rounded polynomial on\n   the rounded interval *and not* to the exact parameters given by the user.\n   A warning is displayed to inform the user.\n\nExample 1: \n   > numberroots(1+x-x^2, [1,2]);\n   1\n   > findzeros(1+x-x^2, [1,2]);\n   [|[1.617919921875;1.6180419921875]|]\n\nExample 2: \n   > numberroots((1+x)*(1-x), [-1,1]);\n   2\n   > numberroots(x^2, [-1,1]);\n   1\n\nExample 3: \n   > verbosity = 1!;\n   > numberroots(x-pi, [0,4]);\n   Warning: the 0th coefficient of the polynomial is neither a floating point\n   constant nor can be evaluated without rounding to a floating point constant.\n   Will faithfully evaluate it with the current precision (165 bits) \n   1\n\nExample 4: \n   > verbosity = 1!;\n   > numberroots(1+x-x^2, [0, @Inf@]);\n   Warning: the given interval must have finite bounds.\n   Warning: at least one of the given expressions or a subexpression is not correctly typed\n   or its evaluation has failed because of some error on a side-effect.\n   error\n   > numberroots(exp(x), [0, 1]);\n   Warning: the given function must be a polynomial in this context.\n   Warning: at least one of the given expressions or a subexpression is not correctly typed\n   or its evaluation has failed because of some error on a side-effect.\n   error\n\nSee also: dirtyfindzeros, findzeros, gcd\n"
#define HELP_NUMERATOR_TEXT "Name: numerator\n==> gives the numerator of an expression\n\nLibrary name:\n   sollya_obj_t sollya_lib_numerator(sollya_obj_t)\n\nUsage: \n   numerator({expr}) : function -> function\n\nParameters: \n   {expr} represents an expression\n\nDescription: \n   * If {expr} represents a fraction {expr1}/{expr2}, numerator({expr})\n   returns the numerator of this fraction, i.e. {expr1}.\n    \n   If {expr} represents something else, numerator({expr}) \n   returns the expression itself, i.e. {expr}.\n    \n   Note that for all expressions {expr}, numerator({expr}) / denominator({expr})\n   is equal to {expr}.\n\nExample 1: \n   > numerator(5/3);\n   5\n\nExample 2: \n   > numerator(exp(x));\n   exp(x)\n\nExample 3: \n   > a = 5/3;\n   > b = numerator(a)/denominator(a);\n   > print(a);\n   5 / 3\n   > print(b);\n   5 / 3\n\nExample 4: \n   > a = exp(x/3);\n   > b = numerator(a)/denominator(a);\n   > print(a);\n   exp(x / 3)\n   > print(b);\n   exp(x / 3)\n\nSee also: denominator, rationalmode\n"
#define HELP_OBJECTNAME_TEXT "Name: objectname\n==> returns, given a Sollya object, a string that can be reparsed to the object\n\nLibrary name:\n   sollya_obj_t sollya_lib_objectname(sollya_obj_t);\n\nUsage: \n   objectname({obj}) : any type -> string\n\nDescription: \n   * objectname({obj}) queries the Sollya symbol table in order to recover the\n   name of an identifier the object {obj} is assigned to. If it succeeds, it\n   returns a string containing the recovered identifier. In contrast, if it\n   does not succeed, it returns a string simply containing a textual\n   representation of {obj}.\n\n   * The only condition for an identifier to be eligible to be returned by\n   objectname({obj}) is to be accessible in the scope objectname is executed in,\n   i.e., not to be shadowed by an identifier of the same name which does not\n   hold the object {obj}.\n\n   * In any case, if the string returned by objectname is given to the parse\n   command in the same scope, the original object {obj} is recovered.\n\n   * objectname is particularly useful in combination with getbacktrace, when\n   the Sollya procedure stack is to be displayed in a fashion, where\n   procedures are identified by their name and not their procedural content.\n\n   * objectname may also be used to get a string representation of the free\n   mathematical variable.\n\n   * If an object is simply to be cast into a string, without trying to\n   retrieve an identifier for it, objectname is not appropriate. In this case,\n   it suffices to concatenate it to an empty string with the @ operator.\n\nExample 1: \n   > s = \"Hello\";\n   > objectname(\"Hello\");\n   s\n\nExample 2: \n   > f = exp(x);\n   > g = sin(x);\n   > [| objectname(exp(x)), objectname(sin(x)), objectname(cos(x)) |];\n   [|\"f\", \"g\", \"cos(x)\"|]\n\nExample 3: \n   > o = { .f = exp(x), .I = [-1;1] };\n   > s1 = o@\"\"; s1;\n   { .f = exp(x), .I = [-1;1] }\n   > s2 = objectname({ .I = [-1;1], .f = exp(x)}); s2;\n   o\n   > parse(s1) == parse(s2);\n   true\n   > write(\"s2 = \\\"\", s2, \"\\\" parses to \", parse(s2), \"\\n\");\n   s2 = \"o\" parses to { .f = exp(x), .I = [-1;1] }\n\nExample 4: \n   > n = 1664;\n   > objectname(n);\n   n\n\nExample 5: \n   > f = exp(x);\n   > g = sin(x);\n   > procedure test() {\n         var f;\n         var h;\n         f = tan(x);\n         h = cos(x);\n         [| objectname(exp(x)), objectname(sin(x)), objectname(cos(x)), objectname(tan(x)) |];\n     };\n   > test();\n   [|\"exp(x)\", \"g\", \"h\", \"f\"|]\n\nExample 6: \n   > procedure apply_proc(p, a, b) {\n         return p(a, b);\n     };\n   > procedure show_trace_and_add(n, m) {\n         var i, bt;\n         bt = getbacktrace();\n         write(\"Procedure stack:\\n\");\n         for i from 0 to length(bt) - 1 do {\n         \twrite(\"   Procedure \", objectname((bt[i]).called_proc), \" called with \", length((bt[i]).passed_args), \" arguments\\n\");\n         };\n         write(\"\\n\");\n         return n + m;\n     };\n   > procedure show_and_succ(u) {\n     \t  return apply_proc(show_trace_and_add, u, 1);\n     };\n   > show_and_succ(16);\n   Procedure stack:\n      Procedure show_trace_and_add called with 2 arguments\n      Procedure apply_proc called with 3 arguments\n      Procedure show_and_succ called with 1 arguments\n   \n   17\n\nExample 7: \n   > f = exp(three_decker_sauerkraut_and_toadstool_sandwich_with_arsenic_sauce);\n   > g = sin(_x_);\n   > h = f(g);\n   > h;\n   exp(sin(three_decker_sauerkraut_and_toadstool_sandwich_with_arsenic_sauce))\n   > objectname(_x_);\n   three_decker_sauerkraut_and_toadstool_sandwich_with_arsenic_sauce\n\nSee also: parse, var, getbacktrace, proc, procedure, @\n"
#define HELP_OBJECT_TEXT "Name: object\n==> keyword representing a Sollya object type \n\nLibrary name:\n   SOLLYA_EXTERNALPROC_TYPE_OBJECT\n\nUsage: \n   object : type type\n\nDescription: \n   * object represents the Sollya object type for declarations\n   of external procedures externalproc.\n    \n   Remark that in contrast to other indicators, type indicators like\n   object cannot be handled outside the externalproc context.  In\n   particular, they cannot be assigned to variables.\n\nSee also: externalproc, boolean, constant, function, list of, range, string, integer\n"
#define HELP_OFF_TEXT "Name: off\n==> special value for certain global variables.\n\nLibrary names:\n   sollya_obj_t sollya_lib_off()\n   int sollya_lib_is_off(sollya_obj_t)\n\nDescription: \n   * off is a special value used to deactivate certain functionnalities\n   of Sollya.\n\n   * As any value it can be affected to a variable and stored in lists.\n\nExample 1: \n   > canonical=on;\n   Canonical automatic printing output has been activated.\n   > p=1+x+x^2;\n   > mode=off;\n   > p;\n   1 + x + x^2\n   > canonical=mode;\n   Canonical automatic printing output has been deactivated.\n   > p;\n   1 + x * (1 + x)\n\nSee also: on, autosimplify, canonical, timing, fullparentheses, midpointmode, rationalmode, roundingwarnings, timing, dieonerrormode\n"
#define HELP_ON_TEXT "Name: on\n==> special value for certain global variables.\n\nLibrary names:\n   sollya_obj_t sollya_lib_on()\n   int sollya_lib_is_on(sollya_obj_t)\n\nDescription: \n   * on is a special value used to activate certain functionnalities \n   of Sollya.\n\n   * As any value it can be affected to a variable and stored in lists.\n\nExample 1: \n   > p=1+x+x^2;\n   > mode=on;\n   > p;\n   1 + x * (1 + x)\n   > canonical=mode;\n   Canonical automatic printing output has been activated.\n   > p;\n   1 + x + x^2\n\nSee also: off, autosimplify, canonical, timing, fullparentheses, midpointmode, rationalmode, roundingwarnings, timing, dieonerrormode\n"
#define HELP_OR_TEXT "Name: ||\n==> boolean OR operator\n\nLibrary name:\n   sollya_obj_t sollya_lib_or(sollya_obj_t, sollya_obj_t)\n\nUsage: \n   {expr1} || {expr2} : (boolean, boolean) -> boolean\n\nParameters: \n   {expr1} and {expr2} represent boolean expressions\n\nDescription: \n   * || evaluates to the boolean OR of the two\n   boolean expressions {expr1} and {expr2}. || evaluates to \n   true iff at least one of {expr1} or {expr2} evaluates to true.\n\nExample 1: \n   > false || false;\n   false\n\nExample 2: \n   > (1 == exp(0)) || (0 == log(1));\n   true\n\nSee also: &&, !\n"
#define HELP_PARSE_TEXT "Name: parse\n==> parses an expression contained in a string\n\nLibrary name:\n   sollya_obj_t sollya_lib_parse(sollya_obj_t)\n\nUsage: \n   parse({string}) : string -> function | error\n\nParameters: \n   {string} represents a character sequence\n\nDescription: \n   * parse({string}) parses the character sequence {string} containing an\n   expression built on constants and base functions.\n    \n   If the character sequence does not contain a well-defined expression, a\n   warning is displayed indicating a syntax error and parse returns a error of\n   type error.\n\n   * The character sequence to be parsed by parse may contain commands that\n   return expressions, including parse itself. Those commands get executed\n   after the string has been parsed. parse({string}) will return the\n   expression computed by the commands contained in the character sequence\n   {string}.\n\n   * parse expects an expression (or a command returning an expression) but\n   cannot be used to evaluate a command producing a side effect without\n   returning a result, nor to evaluate a sequence of instructions. However, such\n   a behavior may be obtained by encapsulating the side effects into an\n   anonymous procedure that parse can handle and by immediately applying it (see\n   examples below).\n\nExample 1: \n   > parse(\"exp(x)\");\n   exp(x)\n\nExample 2: \n   > text = \"remez(exp(x),5,[-1;1])\";\n   > print(\"The string\", text, \"gives\", parse(text));\n   The string remez(exp(x),5,[-1;1]) gives 8.7381909882756203676868315731687604903964388498642e-3 * x^5 + 4.3793696379596015478233171265365272893795005588381e-2 * x^4 + 0.16642465614952768185129433844012193925654065755905 * x^3 + 0.49919698262963614991826575452094101562044819693772 * x^2 + 1.00003834650599815466340068058231011540878088492516 * x + 1.00004475029559502606203712816558243384077522932213\n\nExample 3: \n   > verbosity = 1!;\n   > parse(\"5 + * 3\");\n   Warning: syntax error. Will try to continue parsing (expecting \";\"). May leak memory.\n   Warning: the string \"5 + * 3\" could not be parsed by the miniparser.\n   Warning: at least one of the given expressions or a subexpression is not correctly typed\n   or its evaluation has failed because of some error on a side-effect.\n   error\n\nExample 4: \n   > i = 17;\n   > parse(\"i = 42\");\n   error\n   > i;\n   17\n   > (parse(\"proc () { i = 42; }\"))();\n   > i;\n   42\n\nSee also: execute, readfile, print, error, dieonerrormode, proc\n"
#define HELP_PERTURB_TEXT "Name: perturb\n==> indicates random perturbation of sampling points for externalplot\n\nLibrary names:\n   sollya_obj_t sollya_lib_perturb()\n   int sollya_lib_is_perturb(sollya_obj_t)\n\nUsage: \n   perturb : perturb\n\nDescription: \n   * The use of perturb in the command externalplot enables the addition\n   of some random noise around each sampling point in externalplot.\n    \n   See externalplot for details.\n\nExample 1: \n   > bashexecute(\"gcc -fPIC -c externalplotexample.c\");\n   > bashexecute(\"gcc -shared -o externalplotexample externalplotexample.o -lgmp -lmpfr\");\n   > externalplot(\"./externalplotexample\",relative,exp(x),[-1/2;1/2],12,perturb);\n\nSee also: externalplot, absolute, relative, bashexecute\n"
#define HELP_PI_TEXT "Name: pi\n==> the constant Pi.\n\nLibrary names:\n   sollya_obj_t sollya_lib_pi()\n   int sollya_lib_is_pi(sollya_obj_t)\n   sollya_obj_t sollya_lib_build_function_pi()\n   #define SOLLYA_PI (sollya_lib_build_function_pi())\n\nDescription: \n   * pi is the constant Pi, defined as half the period of sine and cosine.\n\n   * In Sollya, pi is considered a 0-ary function. This way, the constant \n   is not evaluated at the time of its definition but at the time of its use. For \n   instance, when you define a constant or a function relating to Pi, the current\n   precision at the time of the definition does not matter. What is important is \n   the current precision when you evaluate the function or the constant value.\n\n   * Remark that when you define an interval, the bounds are first evaluated and \n   then the interval is defined. In this case, pi will be evaluated as any \n   other constant value at the definition time of the interval, thus using the \n   current precision at this time.\n\nExample 1: \n   > verbosity=1!; prec=12!;\n   > a = 2*pi;\n   > a;\n   Warning: rounding has happened. The value displayed is a faithful rounding to 12 bits of the true result.\n   Warning: For at least 1 of the constants displayed in decimal, rounding has happened.\n   6.283\n   > prec=20!;\n   > a;\n   Warning: rounding has happened. The value displayed is a faithful rounding to 20 bits of the true result.\n   Warning: For at least 1 of the constants displayed in decimal, rounding has happened.\n   6.28319\n\nExample 2: \n   > display=binary;\n   Display mode is binary numbers.\n   > prec=12!;\n   > d = [pi; 5];\n   > d;\n   [1.1001001_2 * 2^(1);1.01_2 * 2^(2)]\n   > prec=20!;\n   > d;\n   [1.1001001_2 * 2^(1);1.01_2 * 2^(2)]\n\nSee also: cos, sin, tan, asin, acos, atan, evaluate, prec, libraryconstant\n"
#define HELP_PLOT_TEXT "Name: plot\n==> plots one or several functions\n\nLibrary names:\n   void sollya_lib_plot(sollya_obj_t, sollya_obj_t, ...)\n   void sollya_lib_v_plot(sollya_obj_t, sollya_obj_t, va_list)\n\nUsage: \n   plot({f1}, ... ,{fn}, {I}) : (function, ... ,function, range) -> void\n   plot({f1}, ... ,{fn}, {I}, file, {name}) : (function, ... ,function, range, file, string) -> void\n   plot({f1}, ... ,{fn}, {I}, postscript, {name}) : (function, ... ,function, range, postscript, string) -> void\n   plot({f1}, ... ,{fn}, {I}, postscriptfile, {name}) : (function, ... ,function, range, postscriptfile, string) -> void\n   plot({L}, {I}) : (list, range) -> void\n   plot({L}, {I}, file, {name}) : (list, range, file, string) -> void\n   plot({L}, {I}, postscript, {name}) : (list, range, postscript, string) -> void\n   plot({L}, {I}, postscriptfile, {name}) : (list, range, postscriptfile, string) -> void\n\nParameters: \n   {f1}, ..., {fn} are functions to be plotted.\n   {L} is a list of functions to be plotted.\n   {I} is the interval where the functions have to be plotted.\n   {name} is a string representing the name of a file.\n\nDescription: \n   * This command plots one or several functions {f1}, ... ,{fn} on an\n   interval {I}. Functions can be either given as parameters of plot or as a\n   list {L} which elements are functions.\n   The functions are drawn on the same plot with different colors.\n\n   * If {L} contains an element that is not a function (or a constant), an error\n   occurs.\n\n   * plot relies on the value of global variable points. Let n be the \n   value of this variable. The algorithm is the following: each function is \n   evaluated at n evenly distributed points in {I}. At each point, the \n   computed value is a faithful rounding of the exact value with a sufficiently\n   high precision. Each point is finally plotted.\n   This should avoid numerical artefacts such as critical cancellations.\n\n   * The plot can be saved either as a data file or as a postscript file.\n\n   * If you use argument file with a string {name}, Sollya will save a data file\n   called name.dat and a gnuplot directives file called name.p. Invoking gnuplot\n   on name.p will plot the data stored in name.dat.\n\n   * If you use argument postscript with a string {name}, Sollya will save a \n   postscript file called name.eps representing your plot.\n\n   * If you use argument postscriptfile with a string {name}, Sollya will \n   produce the corresponding name.dat, name.p and name.eps.\n\n   * By default, this command uses gnuplot to produce the final plot. If Sollya\n   is run while the environment variable SOLLYA_GNUPLOT is set, the content of\n   that variable is used as the gnuplot binary.\n   If your terminal is not graphic (typically if you use Sollya through \n   ssh without -X)\n   gnuplot should be able to detect that and produce an ASCII-art version on the\n   standard output. If it is not the case, you can either store the plot in a\n   postscript file to view it locally, or use asciiplot command.\n\n   * If every function is constant, plot will not plot them but just display\n   their value.\n\n   * If the interval is reduced to a single point, plot will just display the\n   value of the functions at this point.\n\nExample 1: \n   > plot(sin(x),0,cos(x),[-Pi,Pi]);\n\nExample 2: \n   > plot(sin(x),0,cos(x),[-Pi,Pi],postscriptfile,\"plotSinCos\");\n\nExample 3: \n   > plot(exp(0), sin(1), [0;1]);\n   1\n   0.84147098480789650665250232163029899962256306079837\n\nExample 4: \n   > plot(sin(x), cos(x), [1;1]);\n   0.84147098480789650665250232163029899962256306079837\n   0.54030230586813971740093660744297660373231042061792\n\nSee also: externalplot, asciiplot, file, postscript, postscriptfile, points\n"
#define HELP_PLUS_TEXT "Name: +\n==> addition function\n\nLibrary names:\n   sollya_obj_t sollya_lib_add(sollya_obj_t, sollya_obj_t)\n   sollya_obj_t sollya_lib_build_function_add(sollya_obj_t, sollya_obj_t)\n   #define SOLLYA_ADD(x,y) sollya_lib_build_function_add((x), (y))\n\nUsage: \n   {function1} + {function2} : (function, function) -> function\n   {interval1} + {interval2} : (range, range) -> range\n   {interval1} + {constant} : (range, constant) -> range\n   {interval1} + {constant} : (constant, range) -> range\n\nParameters: \n   {function1} and {function2} represent functions\n   {interval1} and {interval2} represent intervals (ranges)\n   {constant} represents a constant or constant expression\n\nDescription: \n   * + represents the addition (function) on reals. \n   The expression {function1} + {function2} stands for\n   the function composed of the addition function and the two\n   functions {function1} and {function2}.\n\n   * + can be used for interval arithmetic on intervals\n   (ranges). + will evaluate to an interval that safely\n   encompasses all images of the addition function with arguments varying\n   in the given intervals.  Any combination of intervals with intervals\n   or constants (resp. constant expressions) is supported. However, it is\n   not possible to represent families of functions using an interval as\n   one argument and a function (varying in the free variable) as the\n   other one.\n\nExample 1: \n   > 1 + 2;\n   3\n\nExample 2: \n   > x + 2;\n   2 + x\n\nExample 3: \n   > x + x;\n   x * 2\n\nExample 4: \n   > diff(sin(x) + exp(x));\n   cos(x) + exp(x)\n\nExample 5: \n   > [1;2] + [3;4];\n   [4;6]\n   > [1;2] + 17;\n   [18;19]\n   > 13 + [-4;17];\n   [9;30]\n\nSee also: -, *, /, ^\n"
#define HELP_POINTS_TEXT "Name: points\n==> controls the number of points chosen by Sollya in certain commands.\n\nLibrary names:\n   void sollya_lib_set_points_and_print(sollya_obj_t)\n   void sollya_lib_set_points(sollya_obj_t)\n   sollya_obj_t sollya_lib_get_points()\n\nUsage: \n   points = {n} : integer -> void\n   points = {n} ! : integer -> void\n   points : constant\n\nParameters: \n   {n} represents the number of points\n\nDescription: \n   * points is a global variable. Its value represents the number of points\n   used in numerical algorithms of Sollya (namely dirtyinfnorm,\n   dirtyintegral, dirtyfindzeros, plot).\n\nExample 1: \n   > f=x^2*sin(1/x);\n   > points=10;\n   The number of points has been set to 10.\n   > dirtyfindzeros(f, [0;1]);\n   [|0, 0.31830988618379067153776752674502872406891929148092|]\n   > points=100;\n   The number of points has been set to 100.\n   > dirtyfindzeros(f, [0;1]);\n   [|0, 2.4485375860291590118289809749617594159147637806224e-2, 3.9788735772973833942220940843128590508614911435115e-2, 4.5472840883398667362538218106432674866988470211559e-2, 5.3051647697298445256294587790838120678153215246819e-2, 6.3661977236758134307553505349005744813783858296184e-2, 7.957747154594766788444188168625718101722982287023e-2, 0.106103295394596890512589175581676241356306430493638, 0.15915494309189533576888376337251436203445964574046, 0.31830988618379067153776752674502872406891929148092|]\n\nSee also: dirtyinfnorm, dirtyintegral, dirtyfindzeros, plot, diam, prec\n"
#define HELP_POSTSCRIPTFILE_TEXT "Name: postscriptfile\n==> special value for commands plot and externalplot\n\nLibrary names:\n   sollya_obj_t sollya_lib_postscriptfile()\n   int sollya_lib_is_postscriptfile(sollya_obj_t)\n\nDescription: \n   * postscriptfile is a special value used in commands plot and externalplot to save\n   the result of the command in a data file and a postscript file.\n\n   * As any value it can be affected to a variable and stored in lists.\n\nExample 1: \n   > savemode=postscriptfile;\n   > name=\"plotSinCos\";\n   > plot(sin(x),0,cos(x),[-Pi,Pi],savemode, name);\n\nSee also: externalplot, plot, file, postscript\n"
#define HELP_POSTSCRIPT_TEXT "Name: postscript\n==> special value for commands plot and externalplot\n\nLibrary names:\n   sollya_obj_t sollya_lib_postscript()\n   int sollya_lib_is_postscript(sollya_obj_t)\n\nDescription: \n   * postscript is a special value used in commands plot and externalplot to save\n   the result of the command in a postscript file.\n\n   * As any value it can be affected to a variable and stored in lists.\n\nExample 1: \n   > savemode=postscript;\n   > name=\"plotSinCos\";\n   > plot(sin(x),0,cos(x),[-Pi,Pi],savemode, name);\n\nSee also: externalplot, plot, file, postscriptfile\n"
#define HELP_POWER_TEXT "Name: ^\n==> power function\n\nLibrary names:\n   sollya_obj_t sollya_lib_pow(sollya_obj_t, sollya_obj_t)\n   sollya_obj_t sollya_lib_build_function_pow(sollya_obj_t, sollya_obj_t)\n   #define SOLLYA_POW(x,y) sollya_lib_build_function_pow((x), (y))\n\nUsage: \n   {function1} ^ {function2} : (function, function) -> function\n   {interval1} ^ {interval2} : (range, range) -> range\n   {interval1} ^ {constant} : (range, constant) -> range\n   {interval1} ^ {constant} : (constant, range) -> range\n\nParameters: \n   {function1} and {function2} represent functions\n   {interval1} and {interval2} represent intervals (ranges)\n   {constant} represents a constant or constant expression\n\nDescription: \n   * ^ represents the power (function) on reals. \n   The expression {function1} ^ {function2} stands for\n   the function composed of the power function and the two\n   functions {function1} and {function2}, where {function1} is\n   the base and {function2} the exponent.\n   If {function2} is a constant integer, ^ is defined\n   on negative values of {function1}. Otherwise ^\n   is defined as exp(y * log(x)).\n\n   * Note that whenever several ^ are composed, the priority goes\n   to the last ^. This corresponds to the natural way of\n   thinking when a tower of powers is written on a paper.\n   Thus, 2^3^5 is interpreted as 2^(3^5).\n\n   * ^ can be used for interval arithmetic on intervals\n   (ranges). ^ will evaluate to an interval that safely\n   encompasses all images of the power function with arguments\n   varying in the given intervals. If the intervals given contain points\n   where the power function is not defined, infinities and NaNs will be\n   produced in the output interval.  Any combination of intervals with\n   intervals or constants (resp. constant expressions) is\n   supported. However, it is not possible to represent families of\n   functions using an interval as one argument and a function (varying in\n   the free variable) as the other one.\n\nExample 1: \n   > 5 ^ 2;\n   25\n\nExample 2: \n   > x ^ 2;\n   x^2\n\nExample 3: \n   > 3 ^ (-5);\n   4.1152263374485596707818930041152263374485596707819e-3\n\nExample 4: \n   > (-3) ^ (-2.5);\n   NaN\n\nExample 5: \n   > diff(sin(x) ^ exp(x));\n   sin(x)^exp(x) * ((cos(x) * exp(x)) / sin(x) + exp(x) * log(sin(x)))\n\nExample 6: \n   > 2^3^5;\n   14134776518227074636666380005943348126619871175004951664972849610340958208\n   > (2^3)^5;\n   32768\n   > 2^(3^5);\n   14134776518227074636666380005943348126619871175004951664972849610340958208\n\nExample 7: \n   > [1;2] ^ [3;4];\n   [1;16.000000000000000000000000000000000000000000000001]\n   > [1;2] ^ 17;\n   [1;131072]\n   > 13 ^ [-4;17];\n   [3.501277966457757081334687160813696999404782745702e-5;8650415919381337933]\n\nSee also: +, -, *, /\n"
#define HELP_POWERS_TEXT "Name: powers\n==> special value for global state display\n\nLibrary names:\n   sollya_obj_t sollya_lib_powers()\n   int sollya_lib_is_powers(sollya_obj_t)\n\nDescription: \n   * powers is a special value used for the global state display.  If\n   the global state display is equal to powers, all data will be\n   output in dyadic notation with numbers displayed in a Maple and\n   PARI/GP compatible format.\n    \n   As any value it can be affected to a variable and stored in lists.\n\nSee also: decimal, dyadic, hexadecimal, binary, display\n"
#define HELP_PRECISION_TEXT "Name: precision\n==> returns the precision necessary to represent a number.\n\nLibrary name:\n   sollya_obj_t sollya_lib_precision(sollya_obj_t)\n\nUsage: \n   precision({x}) : constant -> integer\n\nParameters: \n   {x} is a dyadic number.\n\nDescription: \n   * precision(x) is by definition |x| if x equals 0, NaN, or Inf.\n\n   * If {x} is not zero, it can be uniquely written as x = m*2^e where\n   m is an odd integer and e is an integer. precision(x) returns the number\n   of bits necessary to write m in binary (i.e. 1+floor(log2(m))).\n\nExample 1: \n   > a=round(Pi,20,RN);\n   > precision(a);\n   19\n   > m=mantissa(a);\n   > 1+floor(log2(m));\n   19\n\nExample 2: \n   > a=255;\n   > precision(a);\n   8\n   > m=mantissa(a);\n   > 1+floor(log2(m));\n   8\n\nExample 3: \n   > a=256;\n   > precision(a);\n   1\n   > m=mantissa(a);\n   > 1+floor(log2(m));\n   1\n\nSee also: mantissa, exponent, round\n"
#define HELP_PREC_TEXT "Name: prec\n==> controls the precision used in numerical computations.\n\nLibrary names:\n   void sollya_lib_set_prec_and_print(sollya_obj_t)\n   void sollya_lib_set_prec(sollya_obj_t)\n   sollya_obj_t sollya_lib_get_prec()\n\nDescription: \n   * prec is a global variable. Its value represents the precision of the \n   floating-point format used in numerical computations.\n\n   * Many commands try to adapt their working precision in order to have \n   approximately n correct bits in output, where n is the value of prec.\n\nExample 1: \n   > display=binary!;\n   > prec=50;\n   The precision has been set to 50 bits.\n   > dirtyinfnorm(exp(x),[1;2]);\n   1.110110001110011001001011100011010100110111011011_2 * 2^(2)\n   > prec=100;\n   The precision has been set to 100 bits.\n   > dirtyinfnorm(exp(x),[1;2]);\n   1.11011000111001100100101110001101010011011101101011011100110000110011101000111011101000100000011011_2 * 2^(2)\n\nSee also: evaluate, diam\n"
#define HELP_PREPEND_TEXT "Name: .:\n==> add an element at the beginning of a list.\n\nLibrary name:\n   sollya_obj_t sollya_lib_prepend(sollya_obj_t, sollya_obj_t)\n\nUsage: \n   {x}.:{L} : (any type, list) -> list\n\nParameters: \n   {x} is an object of any type.\n   {L} is a list (possibly empty).\n\nDescription: \n   * .: adds the element {x} at the beginning of the list {L}.\n\n   * Note that since {x} may be of any type, it can be in particular a list.\n\nExample 1: \n   > 1.:[|2,3,4|];\n   [|1, 2, 3, 4|]\n\nExample 2: \n   > [|1,2,3|].:[|4,5,6|];\n   [|[|1, 2, 3|], 4, 5, 6|]\n\nExample 3: \n   > 1.:[||];\n   [|1|]\n\nSee also: :., @\n"
#define HELP_PRINTDOUBLE_TEXT "Name: printdouble\n==> prints a constant value as a hexadecimal double precision number\n\nLibrary name:\n   void sollya_lib_printdouble(sollya_obj_t)\n\nUsage: \n   printdouble({constant}) : constant -> void\n\nParameters: \n   {constant} represents a constant\n\nDescription: \n   * Prints a constant value as a hexadecimal number on 16 hexadecimal\n   digits. The hexadecimal number represents the integer equivalent to\n   the 64 bit memory representation of the constant considered as a\n   double precision number.\n    \n   If the constant value does not hold on a double precision number, it\n   is first rounded to the nearest double precision number before\n   displayed. A warning is displayed in this case.\n\nExample 1: \n   > printdouble(3);\n   0x4008000000000000\n\nExample 2: \n   > prec=100!;\n   > verbosity = 1!;\n   > printdouble(exp(5));\n   Warning: the given expression is not a constant but an expression to evaluate. A faithful evaluation to 100 bits will be used.\n   Warning: rounding down occurred before printing a value as a double.\n   0x40628d389970338f\n\nSee also: printsingle, printexpansion, double\n"
#define HELP_PRINTEXPANSION_TEXT "Name: printexpansion\n==> prints a polynomial in Horner form with its coefficients written as a expansions of double precision numbers\n\nLibrary name:\n   void sollya_lib_printexpansion(sollya_obj_t)\n\nUsage: \n   printexpansion({polynomial}) : function -> void\n\nParameters: \n   {polynomial} represents the polynomial to be printed\n\nDescription: \n   * The command printexpansion prints the polynomial {polynomial} in Horner form\n   writing its coefficients as expansions of double precision\n   numbers. The double precision numbers themselves are displayed in\n   hexadecimal memory notation (see printdouble). \n    \n   If some of the coefficients of the polynomial {polynomial} are not\n   floating-point constants but constant expressions, they are evaluated\n   to floating-point constants using the global precision prec.  If a\n   rounding occurs in this evaluation, a warning is displayed.\n    \n   If the exponent range of double precision is not sufficient to display\n   all the mantissa bits of a coefficient, the coefficient is displayed\n   rounded and a warning is displayed.\n    \n   If the argument {polynomial} does not a polynomial, nothing but a\n   warning or a newline is displayed. Constants can be displayed using\n   printexpansion since they are polynomials of degree 0.\n\nExample 1: \n   > printexpansion(roundcoefficients(taylor(exp(x),5,0),[|DD...|]));\n   0x3ff0000000000000 + x * (0x3ff0000000000000 + x * (0x3fe0000000000000 + x * ((0x3fc5555555555555 + 0x3c65555555555555) + x * ((0x3fa5555555555555 + 0x3c45555555555555) + x * (0x3f81111111111111 + 0x3c01111111111111)))))\n\nExample 2: \n   > printexpansion(remez(exp(x),5,[-1;1]));\n   (0x3ff0002eec90e5a6 + 0x3c9ea6a6a0087757 + 0xb8eb3e644ef44998) + x * ((0x3ff00028358fd3ac + 0x3c8ffa7d96c95f7a + 0xb91da9809b13dd54 + 0x35c0000000000000) + x * ((0x3fdff2d7e6a9fea5 + 0x3c74460e4c0e4fe2 + 0x38fcd1b6b4e85bb0 + 0x3590000000000000) + x * ((0x3fc54d6733b4839e + 0x3c6654e4d8614a44 + 0xb905c7a26b66ea92 + 0xb598000000000000) + x * ((0x3fa66c209b7150a8 + 0x3c34b1bba8f78092 + 0xb8c75f6eb90dae02 + 0x3560000000000000) + x * (0x3f81e554242ab128 + 0xbc23e920a76e760c + 0x38c0589c2cae6caf + 0x3564000000000000)))))\n\nExample 3: \n   > verbosity = 1!;\n   > prec = 3500!;\n   > printexpansion(pi);\n   (0x400921fb54442d18 + 0x3ca1a62633145c07 + 0xb92f1976b7ed8fbc + 0x35c4cf98e804177d + 0x32631d89cd9128a5 + 0x2ec0f31c6809bbdf + 0x2b5519b3cd3a431b + 0x27e8158536f92f8a + 0x246ba7f09ab6b6a9 + 0xa0eedd0dbd2544cf + 0x1d779fb1bd1310ba + 0x1a1a637ed6b0bff6 + 0x96aa485fca40908e + 0x933e501295d98169 + 0x8fd160dbee83b4e0 + 0x8c59b6d799ae131c + 0x08f6cf70801f2e28 + 0x05963bf0598da483 + 0x023871574e69a459 + 0x8000000005702db3 + 0x8000000000000000)\n   Warning: the expansion is not complete because of the limited exponent range of double precision.\n   Warning: rounding occurred while printing.\n\nSee also: printdouble, horner, print, prec, remez, taylor, roundcoefficients, fpminimax, implementpoly\n"
#define HELP_PRINT_TEXT "Name: print\n==> prints an expression\n\nUsage: \n   print({expr1},...,{exprn}) : (any type,..., any type) -> void\n   print({expr1},...,{exprn}) > {filename} : (any type,..., any type, string) -> void\n   print({expr1},...,{exprn}) >> {filename} : (any type,...,any type, string) -> void\n\nParameters: \n   {expr} represents an expression\n   {filename} represents a character sequence indicating a file name\n\nDescription: \n   * print({expr1},...,{exprn}) prints the expressions {expr1} through\n   {exprn} separated by spaces and followed by a newline.\n    \n   If a second argument {filename} is given after a single  \">\", the\n   displaying is not output on the standard output of Sollya but if in\n   the file {filename} that get newly created or overwritten. If a double\n    \">>\" is given, the output will be appended to the file {filename}.\n    \n   The global variables display, midpointmode and fullparentheses have\n   some influence on the formatting of the output (see display,\n   midpointmode and fullparentheses).\n    \n   Remark that if one of the expressions {expri} given in argument is of\n   type string, the character sequence {expri} evaluates to is\n   displayed. However, if {expri} is of type list and this list\n   contains a variable of type string, the expression for the list\n   is displayed, i.e.  all character sequences get displayed surrounded\n   by double quotes (\"). Nevertheless, escape sequences used upon defining\n   character sequences are interpreted immediately.\n\nExample 1: \n   > print(x + 2 + exp(sin(x))); \n   x + 2 + exp(sin(x))\n   > print(\"Hello\",\"world\");\n   Hello world\n   > print(\"Hello\",\"you\", 4 + 3, \"other persons.\");\n   Hello you 7 other persons.\n\nExample 2: \n   > print(\"Hello\");\n   Hello\n   > print([|\"Hello\"|]);\n   [|\"Hello\"|]\n   > s = \"Hello\";\n   > print(s,[|s|]);\n   Hello [|\"Hello\"|]\n   > t = \"Hello\\tyou\";\n   > print(t,[|t|]);\n   Hello\tyou [|\"Hello\\tyou\"|]\n\nExample 3: \n   > print(x + 2 + exp(sin(x))) > \"foo.sol\";\n   > readfile(\"foo.sol\");\n   x + 2 + exp(sin(x))\n   \n\nExample 4: \n   > print(x + 2 + exp(sin(x))) >> \"foo.sol\";\n\nExample 5: \n   > display = decimal;\n   Display mode is decimal numbers.\n   > a = evaluate(sin(pi * x), 0.25);\n   > b = evaluate(sin(pi * x), [0.25; 0.25 + 1b-50]);\n   > print(a);\n   0.70710678118654752440084436210484903928483593768847\n   > display = binary;\n   Display mode is binary numbers.\n   > print(a);\n   1.01101010000010011110011001100111111100111011110011001001000010001011001011111011000100110110011011101010100101010111110100111110001110101101111011000001011101010001_2 * 2^(-1)\n   > display = hexadecimal;\n   Display mode is hexadecimal numbers.\n   > print(a);\n   0x1.6a09e667f3bcc908b2fb1366ea957d3e3adec1751p-1\n   > display = dyadic;\n   Display mode is dyadic numbers.\n   > print(a);\n   33070006991101558613323983488220944360067107133265b-165\n   > display = powers;\n   Display mode is dyadic numbers in integer-power-of-2 notation.\n   > print(a);\n   33070006991101558613323983488220944360067107133265 * 2^(-165)\n   > display = decimal;\n   Display mode is decimal numbers.\n   > midpointmode = off;\n   Midpoint mode has been deactivated.\n   > print(b);\n   [0.70710678118654752440084436210484903928483593768845;0.70710678118654949743721782517557347782646274417049]\n   > midpointmode = on;\n   Midpoint mode has been activated.\n   > print(b);\n   0.7071067811865~4/5~\n   > display = dyadic;\n   Display mode is dyadic numbers.\n   > print(b);\n   [2066875436943847413332748968013809022504194195829b-161;16535003495550825444196237019385936414432675156571b-164]\n   > display = decimal;\n   Display mode is decimal numbers.\n   > autosimplify = off;\n   Automatic pure tree simplification has been deactivated.\n   > fullparentheses = off;\n   Full parentheses mode has been deactivated.\n   > print(x + x * ((x + 1) + 1));\n   x + x * (x + 1 + 1)\n   > fullparentheses = on;\n   Full parentheses mode has been activated.\n   > print(x + x * ((x + 1) + 1));\n   x + (x * ((x + 1) + 1))\n\nSee also: write, printexpansion, printdouble, printsingle, printxml, readfile, autosimplify, display, midpointmode, fullparentheses, evaluate, rationalmode\n"
#define HELP_PRINTSINGLE_TEXT "Name: printsingle\n==> prints a constant value as a hexadecimal single precision number\n\nLibrary name:\n   void sollya_lib_printsingle(sollya_obj_t)\n\nUsage: \n   printsingle({constant}) : constant -> void\n\nParameters: \n   {constant} represents a constant\n\nDescription: \n   * Prints a constant value as a hexadecimal number on 8 hexadecimal\n   digits. The hexadecimal number represents the integer equivalent to\n   the 32 bit memory representation of the constant considered as a\n   single precision number.\n    \n   If the constant value does not hold on a single precision number, it\n   is first rounded to the nearest single precision number before it is\n   displayed. A warning is displayed in this case.\n\nExample 1: \n   > printsingle(3);\n   0x40400000\n\nExample 2: \n   > prec=100!;\n   > verbosity = 1!;\n   > printsingle(exp(5));\n   Warning: the given expression is not a constant but an expression to evaluate. A faithful evaluation to 100 bits will be used.\n   Warning: rounding up occurred before printing a value as a single.\n   0x431469c5\n\nSee also: printdouble, single\n"
#define HELP_PROCEDURE_TEXT "Name: procedure\n==> defines and assigns a Sollya procedure\n\nUsage: \n   procedure {identifier}({formal parameter1}, {formal parameter2},..., {formal parameter n}) { {procedure body} } : void -> void\n   procedure {identifier}({formal parameter1}, {formal parameter2},..., {formal parameter n}) { {procedure body} return {expression}; } : void -> void\n   procedure {identifier}({formal list parameter} = ...) { {procedure body} } : void -> void\n   procedure {identifier}({formal list parameter} = ...) { {procedure body} return {expression}; } : void -> void\n\nParameters: \n   {identifier} represents the name of the procedure to be defined and assigned\n   {formal parameter1}, {formal parameter2} through {formal parameter n} represent identifiers used as formal parameters\n   {formal list parameter} represents an identifier used as a formal parameter for the list of an arbitrary number of parameters\n   {procedure body} represents the imperative statements in the body of the procedure\n   {expression} represents the expression procedure shall evaluate to\n\nDescription: \n   * The procedure keyword allows for defining and assigning procedures in\n   the Sollya language. It is an abbreviation to a procedure definition\n   using proc with the same formal parameters, procedure body and\n   return-expression followed by an assignment of the procedure (object)\n   to the identifier {identifier}. In particular, all rules concerning\n   local variables declared using the var keyword apply for procedure.\n\nExample 1: \n   > procedure succ(n) { return n + 1; };\n   > succ(5);\n   6\n   > 3 + succ(0);\n   4\n   > succ;\n   proc(n)\n   {\n   nop;\n   return (n) + (1);\n   }\n\nExample 2: \n   > procedure myprint(L = ...) { var i; for i in L do i; };\n   > myprint(\"Lyon\",\"Nancy\",\"Beaverton\",\"Coye-la-Foret\",\"Amberg\",\"Nizhny Novgorod\",\"Cluj-Napoca\");\n   Lyon\n   Nancy\n   Beaverton\n   Coye-la-Foret\n   Amberg\n   Nizhny Novgorod\n   Cluj-Napoca\n\nSee also: proc, var, bind, getbacktrace\n"
#define HELP_PROC_TEXT "Name: proc\n==> defines a Sollya procedure\n\nUsage: \n   proc({formal parameter1}, {formal parameter2},..., {formal parameter n}) { {procedure body} } : void -> procedure\n   proc({formal parameter1}, {formal parameter2},..., {formal parameter n}) { {procedure body} return {expression}; } : void -> procedure\n   proc({formal list parameter} = ...) { {procedure body} } : void -> procedure\n   proc({formal list parameter} = ...) { {procedure body} return {expression}; } : void -> procedure\n\nParameters: \n   {formal parameter1}, {formal parameter2} through {formal parameter n} represent identifiers used as formal parameters\n   {formal list parameter} represents an identifier used as a formal parameter for the list of an arbitrary number of parameters\n   {procedure body} represents the imperative statements in the body of the procedure\n   {expression} represents the expression proc shall evaluate to\n\nDescription: \n   * The proc keyword allows for defining procedures in the Sollya\n   language. These procedures are common Sollya objects that can be\n   applied to actual parameters after definition. Upon such an\n   application, the Sollya interpreter applies the actual parameters to\n   the formal parameters {formal parameter1} through {formal parameter n}\n   (resp. builds up the list of arguments and applies it to the list\n   {formal list parameter}) and executes the {procedure body}. The\n   procedure applied to actual parameters evaluates then to the\n   expression {expression} in the return statement after the {procedure body} \n   or to void, if no return statement is given (i.e. a return\n   void statement is implicitly given).\n\n   * Sollya procedures defined by proc have no name. They can be bound\n   to an identifier by assigning the procedure object a proc\n   expression produces to an identifier. However, it is possible to use\n   procedures without giving them any name. For instance, Sollya\n   procedures, i.e. procedure objects, can be elements of lists. They can\n   even be given as an argument to other internal Sollya procedures. See\n   also procedure on this subject.\n\n   * Upon definition of a Sollya procedure using proc, no type check\n   is performed. More precisely, the statements in {procedure body} are\n   merely parsed but not interpreted upon procedure definition with\n   proc. Type checks are performed once the procedure is applied to\n   actual parameters or to void. At this time, if the procedure was\n   defined using several different formal parameters {formal parameter 1}\n   through {formal parameter n}, it is checked whether the number of\n   actual parameters corresponds to the number of formal parameters. If\n   the procedure was defined using the syntax for a procedure with an\n   arbitrary number of parameters by giving a {formal list parameter},\n   the number of actual arguments is not checked but only a list\n   {formal list parameter} of appropriate length is built up. Type checks are\n   further performed upon execution of each statement in {procedure body}\n   and upon evaluation of the expression {expression} to be returned.\n    \n   Procedures defined by proc containing a quit or restart command\n   cannot be executed (i.e. applied). Upon application of a procedure,\n   the Sollya interpreter checks beforehand for such a statement. If one\n   is found, the application of the procedure to its arguments evaluates\n   to error. A warning is displayed. Remark that in contrast to other\n   type or semantic correctness checks, this check is really performed\n   before interpreting any other statement in the body of the procedure.\n\n   * Through the var keyword it is possible to declare local\n   variables and thus to have full support of recursive procedures. This\n   means a procedure defined using proc may contain in its {procedure body} \n   an application of itself to some actual parameters: it suffices\n   to assign the procedure (object) to an identifier with an appropriate\n   name.\n\n   * Sollya procedures defined using proc may return other\n   procedures. Further {procedure body} may contain assignments of\n   locally defined procedure objects to identifiers. See var for the\n   particular behaviour of local and global variables.\n\n   * The expression {expression} returned by a procedure is evaluated with\n   regard to Sollya commands, procedures and external\n   procedures. Simplification may be performed.  However, an application\n   of a procedure defined by proc to actual parameters evaluates to the\n   expression {expression} that may contain the free global variable or\n   that may be composed.\n\nExample 1: \n   > succ = proc(n) { return n + 1; };\n   > succ(5);\n   6\n   > 3 + succ(0);\n   4\n   > succ;\n   proc(n)\n   {\n   nop;\n   return (n) + (1);\n   }\n\nExample 2: \n   > add = proc(m,n) { var res; res := m + n; return res; };\n   > add(5,6);\n   11\n   > add;\n   proc(m, n)\n   {\n   var res;\n   res := (m) + (n);\n   return res;\n   }\n   > verbosity = 1!;\n   > add(3);\n   Warning: at least one of the given expressions or a subexpression is not correctly typed\n   or its evaluation has failed because of some error on a side-effect.\n   error\n   > add(true,false);\n   Warning: at least one of the given expressions or a subexpression is not correctly typed\n   or its evaluation has failed because of some error on a side-effect.\n   Warning: the given expression or command could not be handled.\n   error\n\nExample 3: \n   > succ = proc(n) { return n + 1; };\n   > succ(5);\n   6\n   > succ(x);\n   1 + x\n\nExample 4: \n   > hey = proc() { print(\"Hello world.\"); };\n   > hey();\n   Hello world.\n   > print(hey());\n   Hello world.\n   void\n   > hey;\n   proc()\n   {\n   print(\"Hello world.\");\n   return void;\n   }\n\nExample 5: \n   > fac = proc(n) { var res; if (n == 0) then res := 1 else res := n * fac(n - 1); return res; };\n   > fac(5);\n   120\n   > fac(11);\n   39916800\n   > fac;\n   proc(n)\n   {\n   var res;\n   if (n) == (0) then\n   res := 1\n   else\n   res := (n) * (fac((n) - (1)));\n   return res;\n   }\n\nExample 6: \n   > myprocs = [| proc(m,n) { return m + n; }, proc(m,n) { return m - n; } |];\n   > (myprocs[0])(5,6);\n   11\n   > (myprocs[1])(5,6);\n   -1\n   > succ = proc(n) { return n + 1; };\n   > pred = proc(n) { return n - 1; };\n   > applier = proc(p,n) { return p(n); };\n   > applier(succ,5);\n   6\n   > applier(pred,5);\n   4\n\nExample 7: \n   > verbosity = 1!;\n   > myquit = proc(n) { print(n); quit; };\n   > myquit;\n   proc(n)\n   {\n   print(n);\n   quit;\n   return void;\n   }\n   > myquit(5);\n   Warning: a quit or restart command may not be part of a procedure body.\n   The procedure will not be executed.\n   Warning: an error occurred while executing a procedure.\n   Warning: the given expression or command could not be handled.\n   error\n\nExample 8: \n   > printsucc = proc(n) { var succ; succ = proc(n) { return n + 1; }; print(\"Successor of\",n,\"is\",succ(n)); };\n   > printsucc(5);\n   Successor of 5 is 6\n\nExample 9: \n   > makeadd = proc(n) { var add; print(\"n =\",n); add = proc(m,n) { return n + m; }; return add; };\n   > makeadd(4);\n   n = 4\n   proc(m, n)\n   {\n   nop;\n   return (n) + (m);\n   }\n   > (makeadd(4))(5,6);\n   n = 4\n   11\n\nExample 10: \n   > sumall = proc(L = ...) { var acc, i; acc = 0; for i in L do acc = acc + i; return acc; };\n   > sumall;\n   proc(L = ...)\n   {\n   var acc, i;\n   acc = 0;\n   for i in L do\n   acc = (acc) + (i);\n   return acc;\n   }\n   > sumall();\n   0\n   > sumall(2);\n   2\n   > sumall(2,5);\n   7\n   > sumall(2,5,7,9,16);\n   39\n   > sumall @ [|1,...,10|];\n   55\n\nSee also: return, externalproc, void, quit, restart, var, @, bind, getbacktrace, error\n"
#define HELP_QD_TEXT "Name: QD\n==> short form for quad\n\nSee also: quad\n"
#define HELP_QUAD_TEXT "Names: quad, QD\n==> rounding to the nearest IEEE 754 quad (binary128).\n\nLibrary names:\n   sollya_obj_t sollya_lib_quad(sollya_obj_t)\n   sollya_obj_t sollya_lib_quad_obj()\n   int sollya_lib_is_quad_obj(sollya_obj_t)\n   sollya_obj_t sollya_lib_build_function_quad(sollya_obj_t)\n   #define SOLLYA_QD(x) sollya_lib_build_function_quad(x)\n\nDescription: \n   * quad is both a function and a constant.\n\n   * As a function, it rounds its argument to the nearest IEEE 754 quad precision (i.e. IEEE754-2008 binary128) number.\n   Subnormal numbers are supported as well as standard numbers: it is the real\n   rounding described in the standard.\n\n   * As a constant, it symbolizes the quad precision format. It is used in \n   contexts when a precision format is necessary, e.g. in the commands \n   round and roundcoefficients. It is not supported for implementpoly.\n   See the corresponding help pages for examples.\n\nExample 1: \n   > display=binary!;\n   > QD(0.1);\n   1.100110011001100110011001100110011001100110011001100110011001100110011001100110011001100110011001100110011001101_2 * 2^(-4)\n   > QD(4.17);\n   1.000010101110000101000111101011100001010001111010111000010100011110101110000101000111101011100001010001111010111_2 * 2^(2)\n   > QD(1.011_2 * 2^(-16493));\n   1.1_2 * 2^(-16493)\n\nSee also: halfprecision, single, double, doubleextended, doubledouble, tripledouble, roundcoefficients, implementpoly, fpminimax, round, printsingle\n"
#define HELP_QUIT_TEXT "Name: quit\n==> quits Sollya\n\nUsage: \n   quit : void -> void\n\nDescription: \n   * The command quit, when executed, stops the execution of a Sollya\n   script and leaves the Sollya interpreter unless the quit command \n   is executed in a Sollya script read into a main Sollya script by\n   execute or #include.\n    \n   Upon exiting the Sollya interpreter, all state is thrown away, all\n   memory is deallocated, all bound libraries are unbound and the\n   temporary files produced by plot and externalplot are deleted.\n    \n   If the quit command does not lead to a halt of the Sollya\n   interpreter, a warning is displayed.\n\nExample 1: \n   > quit;\n\nSee also: restart, execute, plot, externalplot, return\n"
#define HELP_RANGE_TEXT "Name: range\n==> keyword representing a range type \n\nLibrary name:\n   SOLLYA_EXTERNALPROC_TYPE_RANGE\n\nUsage: \n   range : type type\n\nDescription: \n   * range represents the range type for declarations\n   of external procedures by means of externalproc.\n    \n   Remark that in contrast to other indicators, type indicators like\n   range cannot be handled outside the externalproc context.  In\n   particular, they cannot be assigned to variables.\n\nSee also: externalproc, boolean, constant, function, integer, list of, string, object\n"
#define HELP_RATIONALAPPROX_TEXT "Name: rationalapprox\n==> returns a fraction close to a given number.\n\nLibrary name:\n   sollya_obj_t sollya_lib_rationalapprox(sollya_obj_t, sollya_obj_t)\n\nUsage: \n   rationalapprox({x},{n}) : (constant, integer) -> function\n\nParameters: \n   {x} is a number to approximate.\n   {n} is a integer (representing a format).\n\nDescription: \n   * rationalapprox({x},{n}) returns a constant function of the form a/b where a and b are\n   integers. The value a/b is an approximation of {x}. The quality of this \n   approximation is determined by the parameter {n} that indicates the number of\n   correct bits that a/b should have.\n\n   * The command is not safe in the sense that it is not ensured that the error \n   between a/b and {x} is less than 2^(-n).\n\n   * The following algorithm is used: {x} is first rounded downwards and upwards to\n   a format of {n} bits, thus obtaining an interval [xl,xu]. This interval is then\n   developed into a continued fraction as far as the representation is the same\n   for every elements of [xl,xu]. The corresponding fraction is returned.\n\n   * Since rational numbers are not a primitive object of Sollya, the fraction is\n   returned as a constant function. This can be quite amazing, because Sollya\n   immediately simplifies a constant function by evaluating it when the constant\n   has to be displayed.\n   To avoid this, you can use print (that displays the expression representing\n   the constant and not the constant itself) or the commands numerator \n   and denominator.\n\nExample 1: \n   > pi10 = rationalapprox(Pi,10);\n   > pi50 = rationalapprox(Pi,50);\n   > pi100 = rationalapprox(Pi,100);\n   > print( pi10, \": \", dirtysimplify(floor(-log2(abs(pi10-Pi)/Pi))), \"bits.\" );\n   3.140625 :  11 bits.\n   > print( pi50, \": \", dirtysimplify(floor(-log2(abs(pi50-Pi)/Pi))), \"bits.\" );\n   85563208 / 27235615 :  51 bits.\n   > print( pi100, \": \", dirtysimplify(floor(-log2(abs(pi100-Pi)/Pi))), \"bits.\" );\n   4422001152019829 / 1407566683404023 :  100 bits.\n\nExample 2: \n   > a=0.1;\n   > b=rationalapprox(a,4);\n   > numerator(b); denominator(b);\n   1\n   10\n   > print(dirtysimplify(floor(-log2(abs((b-a)/a)))), \"bits.\");\n   166 bits.\n\nSee also: print, numerator, denominator, rationalmode\n"
#define HELP_RATIONALMODE_TEXT "Name: rationalmode\n==> global variable controlling if rational arithmetic is used or not.\n\nLibrary names:\n   void sollya_lib_set_rationalmode_and_print(sollya_obj_t)\n   void sollya_lib_set_rationalmode(sollya_obj_t)\n   sollya_obj_t sollya_lib_get_rationalmode()\n\nUsage: \n   rationalmode = {activation value} : on|off -> void\n   rationalmode = {activation value} ! : on|off -> void\n   rationalmode : on|off\n\nParameters: \n   {activation value} controls if rational arithmetic should be used or not\n\nDescription: \n   * rationalmode is a global variable. When its value is off, which is the\n   default, Sollya will not use rational arithmetic to simplify expressions. All\n   computations, including the evaluation of constant expressions given on the\n   Sollya prompt, will be performed using floating-point and interval\n   arithmetic.\n   Constant expressions will be approximated by floating-point numbers, which\n   are in most cases faithful roundings of the expressions, when shown at the\n   prompt.\n\n   * When the value of the global variable rationalmode is on, Sollya will use\n   rational arithmetic when simplifying expressions. Constant expressions, given\n   at the Sollya prompt, will be simplified to rational numbers and displayed\n   as such when they are in the set of the rational numbers. Otherwise,\n   floating-point and interval arithmetic will be used to compute a\n   floating-point approximation, which is in most cases a faithful rounding of\n   the constant expression.\n\n   * When a decimal value is parsed, the behavior of Sollya is different\n   depending on the value of the global variable rationalmode. If it is off, the\n   value gets rounded as a floating-point at precision prec. But if rationalmode\n   is set to on, the decimal value is interpreted exactly and converted as a\n   rational number of the form M/10^N where M and N are integers. Accordingly,\n   when rationalmode is set to on and display is set to decimal, all\n   floating-point values are displayed exactly: indeed, any floating-point\n   number with radix 2 has a finite decimal expansion. Therefore, any rational\n   number of the form M/(2^P*5^Q) gets displayed as an exact decimal value\n   (while other fractions get displayed as fractions).\n\nExample 1: \n   > rationalmode=off!;\n   > 19/17 + 3/94;\n   1.1495619524405506883604505632040050062578222778473\n   > rationalmode=on!;\n   > 19/17 + 3/94;\n   1837 / 1598\n\nExample 2: \n   > rationalmode=off!;\n   > exp(19/17 + 3/94);\n   3.1568097739551413675470920894482427634032816281442\n   > rationalmode=on!;\n   > exp(19/17 + 3/94);\n   3.1568097739551413675470920894482427634032816281441796574919218482279430946893345552216426846046106958476007343642301414070837350944742638603202067315578460693359375\n\nExample 3: \n   > prec = 12!;\n   > rationalmode=off!;\n   > r = 0.1;\n   > r == 1/10;\n   false\n   > rationalmode=on!;\n   > s = 0.1;\n   > s == 1/10;\n   true\n   > r == s;\n   false\n   > r;\n   0.100006103515625\n   > s;\n   0.1\n\nSee also: on, off, numerator, denominator, simplify, rationalapprox, autosimplify\n"
#define HELP_RD_TEXT "Name: RD\n==> constant representing rounding-downwards mode.\n\nLibrary names:\n   sollya_obj_t sollya_lib_round_down()\n   int sollya_lib_is_round_down(sollya_obj_t)\n\nDescription: \n   * RD is used in command round to specify that the value x must be rounded\n   to the greatest floating-point number y such that y <= x.\n\nExample 1: \n   > display=binary!;\n   > round(Pi,20,RD);\n   1.1001001000011111101_2 * 2^(1)\n\nSee also: RZ, RU, RN, round, floor\n"
#define HELP_READFILE_TEXT "Name: readfile\n==> reads the content of a file into a string variable\n\nUsage: \n   readfile({filename}) : string -> string\n\nParameters: \n   {filename} represents a character sequence indicating a file name\n\nDescription: \n   * readfile opens the file indicated by {filename}, reads it and puts its\n   contents in a character sequence of type string that is returned.\n    \n   If the file indicated by {filename} cannot be opened for reading, a\n   warning is displayed and readfile evaluates to an error variable of\n   type error.\n\nExample 1: \n   > print(\"Hello world\") > \"myfile.txt\";\n   > t = readfile(\"myfile.txt\"); \n   > t;\n   Hello world\n   \n\nExample 2: \n   > verbosity=1!;\n   > readfile(\"afile.txt\");\n   Warning: the file \"afile.txt\" could not be opened for reading.\n   Warning: at least one of the given expressions or a subexpression is not correctly typed\n   or its evaluation has failed because of some error on a side-effect.\n   error\n\nSee also: parse, execute, write, print, bashexecute, error\n"
#define HELP_RELATIVE_TEXT "Name: relative\n==> indicates a relative error for externalplot, fpminimax or supnorm\n\nLibrary names:\n   sollya_obj_t sollya_lib_relative()\n   int sollya_lib_is_relative(sollya_obj_t)\n\nUsage: \n   relative : absolute|relative\n\nDescription: \n   * The use of relative in the command externalplot indicates that during\n   plotting in externalplot a relative error is to be considered.\n    \n   See externalplot for details.\n\n   * Used with fpminimax, relative indicates that fpminimax must try to minimize\n   the relative error.\n    \n   See fpminimax for details.\n\n   * When given in argument to supnorm, relative indicates that a relative error\n   is to be considered for supremum norm computation.\n    \n   See supnorm for details.\n\nExample 1: \n   > bashexecute(\"gcc -fPIC -c externalplotexample.c\");\n   > bashexecute(\"gcc -shared -o externalplotexample externalplotexample.o -lgmp -lmpfr\");\n   > externalplot(\"./externalplotexample\",relative,exp(x),[-1/2;1/2],12,perturb);\n\nSee also: externalplot, fpminimax, absolute, bashexecute, supnorm\n"
#define HELP_REMEZ_TEXT "Name: remez\n==> computes the minimax of a function on an interval.\n\nLibrary names:\n   sollya_obj_t sollya_lib_remez(sollya_obj_t, sollya_obj_t, sollya_obj_t, ...)\n   sollya_obj_t sollya_lib_v_remez(sollya_obj_t, sollya_obj_t, sollya_obj_t,\n                                   va_list)\n\nUsage: \n   remez({f}, {n}, {range}, {w}, {quality}, {bounds}) : (function, integer, range, function, constant, range) -> function\n   remez({f}, {L}, {range}, {w}, {quality}, {bounds}) : (function, list, range, function, constant, range) -> function\n\nParameters: \n   {f} is the function to be approximated\n   {n} is the degree of the polynomial that must approximate {f}\n   {L} is a list of integers or a list of functions and indicates the basis for the approximation of {f}\n   {range} is the interval where the function must be approximated\n   {w} (optional) is a weight function. Default is 1.\n   {quality} (optional) is a parameter that controls the quality of the returned polynomial {p}, with respect to the exact minimax p*. Default is 1e-5.\n   {bounds} (optional) is a parameter that allows the user to make the algorithm stop earlier, whenever a given accuracy is reached or a given accuracy is proved unreachable. Default is [0, +Inf].\n\nDescription: \n   * remez computes an approximation of the function f with respect to\n   the weight function w on the interval {range}. More precisely, it\n   searches p such that ||p*w-f|| is\n   (almost) minimal among all p of a certain form. The norm is\n   the infinity norm, e.g. ||g|| = max {|g(x)|, x in {range}}.\n\n   * If w=1 (the default case), it consists in searching the best\n   polynomial approximation of f with respect to the absolute error.\n   If f=1 and w is of the form 1/g, it consists in\n   searching the best polynomial approximation of g with respect to the\n   relative error.\n\n   * If n is given, p is searched among the polynomials with degree not\n   greater than n.\n   If {L} is given and is a list of integers, p is searched as a linear\n   combination of monomials X^k where k belongs to {L}.\n   In the case when {L} is a list of integers, it may contain ellipses but\n   cannot be end-elliptic.\n   If {L} is given and is a list of functions g_k, p is searched as a\n   linear combination of the g_k. In that case {L} cannot contain ellipses.\n   It is the user responsibility to check that the g_k are linearly independent\n   over the interval {range}. Moreover, the functions w*g_k must be at least\n   twice differentiable over {range}. If these conditions are not fulfilled, the\n   algorithm might fail or even silently return a result as if it successfully\n   found the minimax, though the returned p is not optimal.\n\n   * The polynomial is obtained by a convergent iteration called Remez'\n   algorithm (and an extension of this algorithm, due to Stiefel).\n   The algorithm computes a sequence p1, ..., pk, ...\n   such that ek = ||pk*w-f|| converges towards\n   the optimal value e. The algorithm is stopped when the relative error\n   between ek and e is less than {quality}.\n    \n   For this reason, the returned polynomial usually has dyadic coefficients.\n   However, one should not rely on that property. Especially, a noticeable\n   exception to that statement is when we manage to detect that f/w exactly\n   simplifies to a polynomial of the required degree, in which case we return it\n   as it is without further rounding.\n\n   * The optional argument {bounds} is an interval [satisfying_err, target_err]\n   with the following behavior: \n     - if, during the algorithm, we manage to prove that target_err is\n       unreachable, we stop the algorithm returning the last computed\n       polynomial.\n     - if, during the algorithm, we obtain a polynomial with an error smaller\n       than satisfying_err, we stop the algorithm returning that polynomial.\n     - otherwise we loop until we find an optimal polynomial with the required\n       quality, as usual. \n   Examples of use: \n     [0, +Inf] (compute the optimal polynomial with the required quality) \n     [target_err] (stops as soon as a polynomial achieving target_err is\n                   obtained or as soon as such a polynomial is proved not to\n                   exist). \n     [0, target_err] (finds the optimal polynomial, but provided that its error\n                      is smaller than target_err). \n     [satisfying_err, +Inf] (stops as soon as a polynomial achieving\n                             satisfying_err is obtained. If such a polynomial\n                             does not exist, returns the optimal polynomial).\n\nExample 1: \n   > p = remez(exp(x),5,[0;1]);\n   > degree(p);\n   5\n   > dirtyinfnorm(p-exp(x),[0;1]);\n   1.1295698151096148707171193829266077607222634589363e-6\n\nExample 2: \n   > p = remez(1,[|0,2,4,6,8|],[0,Pi/4],1/cos(x));\n   > canonical=on!;\n   > p;\n   0.99999999994393732180959690352543887130348096061124 - 0.49999999571556857768772053063721544670949467222259 * x^2 + 4.1666613233473633009941059480570275870113220089059e-2 * x^4 - 1.3886529147145693651355523880319714051047635695061e-3 * x^6 + 2.4372679177224179934800328511009205218114284220126e-5 * x^8\n\nExample 3: \n   > p1 = remez(exp(x),5,[0;1],default,1e-5);\n   > p2 = remez(exp(x),5,[0;1],default,1e-10);\n   > p3 = remez(exp(x),5,[0;1],default,1e-15);\n   > dirtyinfnorm(p1-exp(x),[0;1]);\n   1.1295698151096148707171193829266077607222634589363e-6\n   > dirtyinfnorm(p2-exp(x),[0;1]);\n   1.12956980227478675612619255125474525171079325793124e-6\n   > dirtyinfnorm(p3-exp(x),[0;1]);\n   1.12956980227478675612619255125474525171079325793124e-6\n\nExample 4: \n   > L = [|exp(x), sin(x), cos(x)-1, sin(x^3)|];\n   > g = (2^x-1)/x;\n   > p1 = remez(g, L, [-1/16;1/16]);\n   > p2 = remez(g, 3, [-1/16;1/16]);\n   > dirtyinfnorm(p1 - g, [-1/16;1/16]);\n   9.8841323829271038137685646777951687620288462194746e-8\n   > dirtyinfnorm(p2 - g, [-1/16;1/16]);\n   2.54337800593461418356437401152248866818783932027105e-9\n\nExample 5: \n   > f = sin(x);\n   > I = [-3b-5;-1b-1074];\n   > time(popt = remez(1, [|1, 3, 4, 5, 7, 8, 9|], I, 1/f));\n   0.18622914699999999999999999999999999999657194099549\n   > time(p1 = remez(1, [|1, 3, 4, 5, 7, 8, 9|], I, 1/f, default, [0, 1b-73]));\n   0.131969854999999999999999999999999999989838853798724\n   > time(p2 = remez(1, [|1, 3, 4, 5, 7, 8, 9|], I, 1/f, default, [3b-72, +@Inf@]));\n   0.150655803000000000000000000000000000003592665829446\n   > dirtyinfnorm(popt/f-1, I);\n   2.06750931454112835098093903810531156576504665659064e-22\n   > dirtyinfnorm(p1/f-1, I);\n   2.49711266837493110470637913808914046704452778960875e-22\n   > dirtyinfnorm(p2/f-1, I);\n   5.4567247553615435246376977231253834265248756996947e-22\n   > 1b-73;\n   1.05879118406787542383540312584955245256423950195312e-22\n   > 3b-72;\n   6.3527471044072525430124187550973147153854370117187e-22\n\nSee also: dirtyinfnorm, infnorm, fpminimax, guessdegree, taylorform, taylor, interpolate\n"
#define HELP_RENAME_TEXT "Name: rename\n==> rename the free variable.\n\nLibrary name:\n   void sollya_lib_name_free_variable(const char *)\n\nUsage: \n   rename({ident1},{ident2}) : void\n\nParameters: \n   {ident1} is the current name of the free variable.\n   {ident2} is a fresh name.\n\nDescription: \n   * rename permits a change of the name of the free variable. Sollya can handle\n   only one free variable at a time. The first time in a session that an\n   unbound name is used in a context where it can be interpreted as a free\n   variable, the name is used to represent the free variable of Sollya. In the\n   following, this name can be changed using rename.\n\n   * Be careful: if {ident2} has been set before, its value will be lost. Use\n   the command isbound to know if {ident2} is already used or not.\n\n   * If {ident1} is not the current name of the free variable, an error occurs.\n\n   * If rename is used at a time when the name of the free variable has not been\n   defined, {ident1} is just ignored and the name of the free variable is set\n   to {ident2}.\n\n   * It is always possible to use the special keyword _x_ to denote the free\n   variable. Hence {ident1} can be _x_.\n\n   * Notice that {ident2} is an identifier, not a string. In particular, it is\n   not directly possible to use the content of a variable to provide the new\n   name of the free variable. This can however be obtained using a level of\n   indirection: first create a string that contains the call to rename, and\n   then evaluate it thanks to parse (see example below).\n\nExample 1: \n   > f=sin(x);\n   > f;\n   sin(x)\n   > rename(x,y);\n   > f;\n   sin(y)\n\nExample 2: \n   > a=1;\n   > f=sin(x);\n   > rename(x,a);\n   > a;\n   a\n   > f;\n   sin(a)\n\nExample 3: \n   > verbosity=1!;\n   > f=sin(x);\n   > rename(y, z);\n   Warning: the current free variable is named \"x\" and not \"y\". Can only rename the free variable.\n   The last command will have no effect.\n   > rename(_x_, z);\n   Information: the free variable has been renamed from \"x\" to \"z\".\n\nExample 4: \n   > verbosity=1!;\n   > rename(x,y);\n   Information: the free variable has been named \"y\".\n   > isbound(x);\n   false\n   > isbound(y);\n   true\n\nExample 5: \n   > verbosity=1!;\n   > f = sin(x);\n   > new_varname = \"foo\";\n   > rename(_x_, new_varname);\n   Information: the free variable has been renamed from \"x\" to \"new_varname\".\n   > f;\n   sin(new_varname)\n   > rename(_x_, x);\n   Information: the free variable has been renamed from \"new_varname\" to \"x\".\n   > new_varname = \"foo\";\n   > str = \"rename(_x_, \" @ new_varname @ \");\";\n   > (parse(\"proc () { \" @ str @ \"}\"))();\n   Information: the free variable has been renamed from \"x\" to \"foo\".\n   > f;\n   sin(foo)\n\nExample 6: \n   > verbosity=1!;\n   > f = sin(x);\n   > f;\n   sin(x)\n   > rename(x, _x_);\n   Information: the free variable has been renamed from \"x\" to \"_x_\".\n   > f;\n   sin(_x_)\n   > g = cos(y);\n   > f;\n   sin(y)\n   > g;\n   cos(y)\n   > rename(_x_, _x_);\n   Information: the free variable has been renamed from \"y\" to \"_x_\".\n   > f;\n   sin(_x_)\n   > g;\n   cos(_x_)\n\nSee also: isbound, parse\n"
#define HELP_RESTART_TEXT "Name: restart\n==> brings Sollya back to its initial state\n\nUsage: \n   restart : void -> void\n\nDescription: \n   * The command restart brings Sollya back to its initial state.  All\n   current state is abandoned, all libraries unbound and all memory freed.\n    \n   The restart command has no effect when executed inside a Sollya\n   script read into a main Sollya script using execute. It is executed\n   in a Sollya script included by a #include macro.\n    \n   Using the restart command in nested elements of imperative\n   programming like for or while loops is possible. Since in most cases\n   abandoning the current state of Sollya means altering a loop\n   invariant, warnings for the impossibility of continuing a loop may\n   follow unless the state is rebuilt.\n\nExample 1: \n   > print(exp(x));\n   exp(x)\n   > a = 3;\n   > restart;\n   The tool has been restarted.\n   > print(x);\n   x\n   > a;\n   Warning: the identifier \"a\" is neither assigned to, nor bound to a library function nor external procedure, nor equal to the current free variable.\n   Will interpret \"a\" as \"x\".\n   x\n\nExample 2: \n   > print(exp(x));\n   exp(x)\n   > for i from 1 to 10 do {\n     \tprint(i);\n     \tif (i == 5) then restart;\n     };\n   1\n   2\n   3\n   4\n   5\n   The tool has been restarted.\n   Warning: the tool has been restarted inside a for loop.\n   The for loop will no longer be executed.\n\nExample 3: \n   > print(exp(x));\n   exp(x)\n   > a = 3;\n   > for i from 1 to 10 do {\n     \tprint(i);\n     \tif (i == 5) then {\n     \t\trestart;\n     \t\ti = 7;\n     \t};\n     };\n   1\n   2\n   3\n   4\n   5\n   The tool has been restarted.\n   8\n   9\n   10\n   > print(x);\n   x\n   > a;\n   Warning: the identifier \"a\" is neither assigned to, nor bound to a library function nor external procedure, nor equal to the current free variable.\n   Will interpret \"a\" as \"x\".\n   x\n\nSee also: quit, execute\n"
#define HELP_RETURN_TEXT "Name: return\n==> indicates an expression to be returned in a procedure\n\nUsage: \n   return {expression} : void\n\nParameters: \n   {expression} represents the expression to be returned\n\nDescription: \n   * The keyword return allows for returning the (evaluated) expression\n   {expression} at the end of a begin-end-block ({}-block) used as a\n   Sollya procedure body. See proc for further details concerning\n   Sollya procedure definitions.\n     \n   Statements for returning expressions using return are only possible\n    at the end of a begin-end-block used as a Sollya procedure\n    body. Only one return statement can be given per begin-end-block.\n\n   * If at the end of a procedure definition using proc no return\n   statement is given, a return void statement is implicitly\n   added. Procedures, i.e. procedure objects, when printed out in Sollya\n   defined with an implicit return void statement are displayed with\n   this statement explicitly given.\n\nExample 1: \n   > succ = proc(n) { var res; res := n + 1; return res; };\n   > succ(5);\n   6\n   > succ;\n   proc(n)\n   {\n   var res;\n   res := (n) + (1);\n   return res;\n   }\n\nExample 2: \n   > hey = proc(s) { print(\"Hello\",s); };\n   > hey(\"world\");\n   Hello world\n   > hey;\n   proc(s)\n   {\n   print(\"Hello\", s);\n   return void;\n   }\n\nSee also: proc, void\n"
#define HELP_REVERT_TEXT "Name: revert\n==> reverts a list.\n\nLibrary name:\n   sollya_obj_t sollya_lib_revert(sollya_obj_t)\n\nUsage: \n   revert({L}) : list -> list\n\nParameters: \n   {L} is a list.\n\nDescription: \n   * revert({L}) returns the same list, but with its elements in reverse order.\n\n   * If {L} is an end-elliptic list, revert will fail with an error.\n\nExample 1: \n   > revert([| |]);\n   [| |]\n\nExample 2: \n   > revert([|2,3,5,2,1,4|]);\n   [|4, 1, 2, 5, 3, 2|]\n\nSee also: sort, head, tail\n"
#define HELP_RN_TEXT "Name: RN\n==> constant representing rounding-to-nearest mode.\n\nLibrary names:\n   sollya_obj_t sollya_lib_round_to_nearest()\n   int sollya_lib_is_round_to_nearest(sollya_obj_t)\n\nDescription: \n   * RN is used in command round to specify that the value must be rounded\n   to the nearest representable floating-point number.\n\nExample 1: \n   > display=binary!;\n   > round(Pi,20,RN);\n   1.100100100001111111_2 * 2^(1)\n\nSee also: RD, RU, RZ, round, nearestint\n"
#define HELP_ROUNDCOEFFICIENTS_TEXT "Name: roundcoefficients\n==> rounds the coefficients of a polynomial to classical formats.\n\nLibrary name:\n   sollya_obj_t sollya_lib_roundcoefficients(sollya_obj_t, sollya_obj_t)\n\nUsage: \n   roundcoefficients({p},{L}) : (function, list) -> function\n\nParameters: \n   {p} is a function. Usually a polynomial.\n   {L} is a list of formats.\n\nDescription: \n   * If {p} is a polynomial and {L} a list of floating-point formats, \n   roundcoefficients({p},{L}) rounds each coefficient of {p} to the corresponding format\n   in {L}.\n\n   * If {p} is not a polynomial, roundcoefficients does not do anything.\n\n   * If {L} contains other elements than HP, halfprecision, SG, single, D, double, \n   DE, doubleextended, DD, doubledouble, QD, quad, TD and tripledouble,\n   an error occurs.\n\n   * The coefficients in {p} corresponding to X^i is rounded to the \n   format L[i]. If {L} does not contain enough elements\n   (e.g. if length(L) < degree(p)+1), a warning is displayed. However, the\n   coefficients corresponding to an element of {L} are rounded. The trailing \n   coefficients (that do not have a corresponding element in {L}) are kept with\n   their own precision.\n   If {L} contains too much elements, the trailing useless elements are ignored.\n   In particular {L} may be end-elliptic in which case roundcoefficients has the \n   natural behavior.\n\nExample 1: \n   > p=exp(1) + x*(exp(2) + x*exp(3));\n   > display=binary!;\n   > roundcoefficients(p,[|DD,D,D|]);\n   1.010110111111000010101000101100010100010101110110100101010011010101011111101110001010110001000000010011101_2 * 2^(1) + x * (1.110110001110011001001011100011010100110111011010111_2 * 2^(2) + x * (1.010000010101111001011011111101101111101100010000011_2 * 2^(4)))\n   > roundcoefficients(p,[|DD,D...|]);\n   1.010110111111000010101000101100010100010101110110100101010011010101011111101110001010110001000000010011101_2 * 2^(1) + x * (1.110110001110011001001011100011010100110111011010111_2 * 2^(2) + x * (1.010000010101111001011011111101101111101100010000011_2 * 2^(4)))\n\nExample 2: \n   > f=sin(exp(1)*x);\n   > display=binary!;\n   > f;\n   sin(x * (1.0101101111110000101010001011000101000101011101101001010100110101010111111011100010101100010000000100111001111010011110011110001110110001011100111000101100000111101_2 * 2^(1)))\n   > roundcoefficients(f,[|D...|]);\n   sin(x * (1.0101101111110000101010001011000101000101011101101001010100110101010111111011100010101100010000000100111001111010011110011110001110110001011100111000101100000111101_2 * 2^(1)))\n\nExample 3: \n   > p=exp(1) + x*(exp(2) + x*exp(3));\n   > verbosity=1!;\n   > display=binary!;\n   > roundcoefficients(p,[|DD,D|]);\n   Warning: the number of the given formats does not correspond to the degree of the given polynomial.\n   Warning: the 0th coefficient of the given polynomial does not evaluate to a floating-point constant without any rounding.\n   Will evaluate the coefficient in the current precision in floating-point before rounding to the target format.\n   Warning: the 1th coefficient of the given polynomial does not evaluate to a floating-point constant without any rounding.\n   Will evaluate the coefficient in the current precision in floating-point before rounding to the target format.\n   Warning: rounding may have happened.\n   1.010110111111000010101000101100010100010101110110100101010011010101011111101110001010110001000000010011101_2 * 2^(1) + x * (1.110110001110011001001011100011010100110111011010111_2 * 2^(2) + x * (1.01000001010111100101101111110110111110110001000001011111001011010100101111011111110001010011011101000100110000111010001110010000010110000101100000111001011100101001_2 * 2^(4)))\n\nSee also: halfprecision, single, double, doubleextended, doubledouble, quad, tripledouble, fpminimax, remez, implementpoly, subpoly\n"
#define HELP_ROUNDCORRECTLY_TEXT "Name: roundcorrectly\n==> rounds an approximation range correctly to some precision\n\nLibrary name:\n   sollya_obj_t sollya_lib_roundcorrectly(sollya_obj_t)\n\nUsage: \n   roundcorrectly({range}) : range -> constant\n\nParameters: \n   {range} represents a range in which an exact value lies\n\nDescription: \n   * Let {range} be a range of values, determined by some approximation\n   process, safely bounding an unknown value v. The command\n   roundcorrectly({range}) determines a precision such that for this precision,\n   rounding to the nearest any value in {range} yields to the same\n   result, i.e. to the correct rounding of v.\n    \n   If no such precision exists, a warning is displayed and roundcorrectly\n   evaluates to NaN.\n\nExample 1: \n   > printbinary(roundcorrectly([1.010001_2; 1.0101_2]));\n   1.01_2\n   > printbinary(roundcorrectly([1.00001_2; 1.001_2]));\n   1_2\n\nExample 2: \n   > roundcorrectly([-1; 1]);\n   NaN\n\nSee also: round, mantissa, exponent, precision\n"
#define HELP_ROUNDINGWARNINGS_TEXT "Name: roundingwarnings\n==> global variable controlling whether or not a warning is displayed when roundings occur.\n\nLibrary names:\n   void sollya_lib_set_roundingwarnings_and_print(sollya_obj_t)\n   void sollya_lib_set_roundingwarnings(sollya_obj_t)\n   sollya_obj_t sollya_lib_get_roundingwarnings()\n\nUsage: \n   roundingwarnings = {activation value} : on|off -> void\n   roundingwarnings = {activation value} ! : on|off -> void\n   roundingwarnings : on|off\n\nParameters: \n   {activation value} controls if warnings should be shown or not\n\nDescription: \n   * roundingwarnings is a global variable. When its value is on, warnings are\n   emitted in appropriate verbosity modes (see verbosity) when roundings\n   occur.  When its value is off, these warnings are suppressed.\n\n   * This mode depends on a verbosity of at least 1. See\n   verbosity for more details.\n\n   * Default is on when the standard input is a terminal and\n   off when Sollya input is read from a file.\n\nExample 1: \n   > verbosity=1!;\n   > roundingwarnings = on;\n   Rounding warning mode has been activated.\n   > exp(0.1);\n   Warning: Rounding occurred when converting the constant \"0.1\" to floating-point with 165 bits.\n   If safe computation is needed, try to increase the precision.\n   Warning: rounding has happened. The value displayed is a faithful rounding to 165 bits of the true result.\n   Warning: For at least 1 of the constants displayed in decimal, rounding has happened.\n   1.1051709180756476248117078264902466682245471947375\n   > roundingwarnings = off;\n   Rounding warning mode has been deactivated.\n   > exp(0.1);\n   1.1051709180756476248117078264902466682245471947375\n\nSee also: on, off, verbosity, midpointmode, rationalmode, suppressmessage, unsuppressmessage, showmessagenumbers, getsuppressedmessages\n"
#define HELP_ROUND_TEXT "Name: round\n==> rounds a number to a floating-point format.\n\nLibrary name:\n   sollya_obj_t sollya_lib_round(sollya_obj_t, sollya_obj_t, sollya_obj_t)\n\nUsage: \n   round({x},{n},{mode}) : (constant, integer, RN|RZ|RU|RD) -> constant\n   round({x},{format},{mode}) : (constant, HP|halfprecision|SG|single|D|double|DE|doubleextended|DD|doubledouble|QD|quad|TD|tripledouble, RN|RZ|RU|RD) -> constant\n\nParameters: \n   {x} is a constant to be rounded.\n   {n} is the precision of the target format.\n   {format} is the name of a supported floating-point format.\n   {mode} is the desired rounding mode.\n\nDescription: \n   * If used with an integer parameter {n}, round({x},{n},{mode}) rounds {x} to a floating-point number with \n   precision {n}, according to rounding-mode {mode}. \n\n   * If used with a format parameter {format}, round({x},{format},{mode}) rounds {x} to a floating-point number in the \n   floating-point format {format}, according to rounding-mode {mode}. \n\n   * Subnormal numbers are handled for the case when {format} is one of\n   halfprecision, single, double, doubleextended, doubledouble,\n   quad or tripledouble. Otherwise, when {format} is an integer,\n   round does not take any exponent range into consideration,\n   i.e. typically uses the full exponent range of the underlying MPFR\n   library.\n\n   * It is worth mentioning that the result of round does not depend on\n   the current global precision of Sollya, unless a warning is\n   displayed. As a matter of fact, round rounds the given constant or\n   constant expression {x} applying all rules of IEEE 754 correct\n   rounding, unless a warning is displayed. The result of round is\n   hence the floating-point value of the given precision {n} or format\n   {format} that is nearest to {x} (resp. just below or just above,\n   depending on {mode}), computed as if infinite precision were used for\n   evaluating the constant {x}, unless a warning is displayed.\n\nExample 1: \n   > display=binary!;\n   > round(Pi,20,RN);\n   1.100100100001111111_2 * 2^(1)\n\nExample 2: \n   > printdouble(round(exp(17),53,RU));\n   0x417709348c0ea4f9\n   > printdouble(D(exp(17)));\n   0x417709348c0ea4f9\n\nExample 3: \n   > display=binary!;\n   > a=2^(-1100);\n   > round(a,53,RN);\n   1_2 * 2^(-1100)\n   > round(a,D,RN);\n   0\n   > double(a);\n   0\n\nSee also: RN, RD, RU, RZ, halfprecision, single, double, doubleextended, doubledouble, quad, tripledouble, roundcoefficients, roundcorrectly, printdouble, printsingle, ceil, floor, nearestint\n"
#define HELP_RU_TEXT "Name: RU\n==> constant representing rounding-upwards mode.\n\nLibrary names:\n   sollya_obj_t sollya_lib_round_up()\n   int sollya_lib_is_round_up(sollya_obj_t)\n\nDescription: \n   * RU is used in command round to specify that the value x must be rounded\n   to the smallest floating-point number y such that x <= y.\n\nExample 1: \n   > display=binary!;\n   > round(Pi,20,RU);\n   1.100100100001111111_2 * 2^(1)\n\nSee also: RZ, RD, RN, round, ceil\n"
#define HELP_RZ_TEXT "Name: RZ\n==> constant representing rounding-to-zero mode.\n\nLibrary names:\n   sollya_obj_t sollya_lib_round_towards_zero()\n   int sollya_lib_is_round_towards_zero(sollya_obj_t)\n\nDescription: \n   * RZ is used in command round to specify that the value must be rounded\n   to the closest floating-point number towards zero. It just consists in \n   truncating the value to the desired format.\n\nExample 1: \n   > display=binary!;\n   > round(Pi,20,RZ);\n   1.1001001000011111101_2 * 2^(1)\n\nSee also: RD, RU, RN, round, floor, ceil\n"
#define HELP_SEARCHGAL_TEXT "Name: searchgal\n==> searches for a preimage of a function such that the rounding the image yields an error smaller than a constant\n\nLibrary name:\n   sollya_obj_t sollya_lib_searchgal(sollya_obj_t, sollya_obj_t, sollya_obj_t,\n                                     sollya_obj_t, sollya_obj_t, sollya_obj_t)\n\nUsage: \n   searchgal({function}, {start}, {preimage precision}, {steps}, {format}, {error bound}) : (function, constant, integer, integer, HP|halfprecision|SG|single|D|double|DE|doubleextended|DD|doubledouble|QD|quad|TD|tripledouble, constant) -> list\n   searchgal({list of functions}, {start}, {preimage precision}, {steps}, {list of format}, {list of error bounds}) : (list, constant, integer, integer, list, list) -> list\n\nParameters: \n   {function} represents the function to be considered\n   {start} represents a value around which the search is to be performed\n   {preimage precision} represents the precision (discretization) for the eligible preimage values\n   {steps} represents the binary logarithm (log2) of the number of search steps to be performed\n   {format} represents the format the image of the function is to be rounded to\n   {error bound} represents a upper bound on the relative rounding error when rounding the image\n   {list of functions} represents the functions to be considered\n   {list of formats} represents the respective formats the images of the functions are to be rounded to\n   {list of error bounds} represents a upper bound on the relative rounding error when rounding the image\n\nDescription: \n   * The command searchgal searches for a preimage z of function\n   {function} or a list of functions {list of functions} such that\n   z is a floating-point number with {preimage precision}\n   significant mantissa bits and the image y of the function,\n   respectively each image yi of the functions, rounds to\n   format {format} respectively to the corresponding format in {list of format} \n   with a relative rounding error less than {error bound}\n   respectively the corresponding value in {list of error bounds}. During\n   this search, at most 2^{steps} attempts are made. The search\n   starts with a preimage value equal to {start}. This value is then\n   increased and decreased by 1 ulp in precision {preimage precision} \n   until a value is found or the step limit is reached.\n    \n   If the search finds an appropriate preimage z, searchgal\n   evaluates to a list containing this value. Otherwise, searchgal\n   evaluates to an empty list.\n\nExample 1: \n   > searchgal(log(x),2,53,15,DD,1b-112);\n   [| |]\n   > searchgal(log(x),2,53,18,DD,1b-112);\n   [|2.0000000000384972054234822280704975128173828125|]\n\nExample 2: \n   > f = exp(x);\n   > s = searchgal(f,2,53,18,DD,1b-112);\n   > if (s != [||]) then {\n        v = s[0];\n        print(\"The rounding error is 2^(\",evaluate(log2(abs(DD(f)/f - 1)),v),\")\");\n     } else print(\"No value found\");\n   The rounding error is 2^( -112.106878438809380148206984258358542322113874177832 )\n\nExample 3: \n   > searchgal([|sin(x),cos(x)|],1,53,15,[|D,D|],[|1b-62,1b-60|]);\n   [|1.00000000000159494639717649988597258925437927246094|]\n\nSee also: round, double, doubledouble, tripledouble, evaluate, worstcase\n"
#define HELP_SG_TEXT "Name: SG\n==> short form for single\n\nSee also: single\n"
#define HELP_SHOWMESSAGENUMBERS_TEXT "Name: showmessagenumbers\n==> activates, deactivates or inspects the state variable controlling the displaying of numbers for messages\n\nLibrary names:\n   void sollya_lib_set_showmessagenumbers_and_print(sollya_obj_t)\n   void sollya_lib_set_showmessagenumbers(sollya_obj_t)\n   sollya_obj_t sollya_lib_get_showmessagenumbers()\n\nUsage: \n   showmessagenumbers = {activation value} : on|off -> void\n   showmessagenumbers = {activation value} ! : on|off -> void\n   showmessagenumbers : on|off\n\nParameters: \n   {activation value} represents on or off, i.e. activation or deactivation\n\nDescription: \n   * An assignment showmessagenumbers = {activation value}, where {activation value}\n   is one of on or off, activates respectively deactivates the\n   displaying of numbers for warning and information messages. Every\n   Sollya warning or information message (that is not fatal to the\n   tool's execution) has a message number. By default, these numbers are\n   not displayed when a message is output. When message number displaying\n   is activated, the message numbers are displayed together with the\n   message. This allows the user to recover the number of a particular\n   message in order to suppress resp. unsuppress the displaying of this\n   particular message (see suppressmessage and unsuppressmessage).\n\n   * The user should be aware of the fact that message number display\n   activation resp. deactivation through showmessagenumbers does not affect message\n   displaying in general. For instance, even with message number\n   displaying activated, messages with only displayed when general\n   verbosity and rounding warning mode are set accordingly.\n\n   * If the assignment showmessagenumbers = {activation value} is followed by an\n   exclamation mark, no message indicating the new state is\n   displayed. Otherwise the user is informed of the new state of the\n   global mode by an indication.\n\nExample 1: \n   > verbosity = 1;\n   The verbosity level has been set to 1.\n   > 0.1;\n   Warning: Rounding occurred when converting the constant \"0.1\" to floating-point with 165 bits.\n   If safe computation is needed, try to increase the precision.\n   Warning: For at least 1 of the constants displayed in decimal, rounding has happened.\n   0.1\n   > showmessagenumbers = on;\n   Displaying of message numbers has been activated.\n   > 0.1;\n   Warning (174): Rounding occurred when converting the constant \"0.1\" to floating-point with 165 bits.\n   If safe computation is needed, try to increase the precision.\n   Warning (478): For at least 1 of the constants displayed in decimal, rounding has happened.\n   0.1\n   > showmessagenumbers;\n   on\n   > showmessagenumbers = off!;\n   > 0.1;\n   Warning: Rounding occurred when converting the constant \"0.1\" to floating-point with 165 bits.\n   If safe computation is needed, try to increase the precision.\n   Warning: For at least 1 of the constants displayed in decimal, rounding has happened.\n   0.1\n\nExample 2: \n   > showmessagenumbers = on;\n   Displaying of message numbers has been activated.\n   > verbosity = 1;\n   The verbosity level has been set to 1.\n   > diff(0.1 * x + 1.5 * x^2);\n   Warning (174): Rounding occurred when converting the constant \"0.1\" to floating-point with 165 bits.\n   If safe computation is needed, try to increase the precision.\n   Warning (478): For at least 1 of the constants displayed in decimal, rounding has happened.\n   0.1 + x * 3\n   > verbosity = 0;\n   The verbosity level has been set to 0.\n   > diff(0.1 * x + 1.5 * x^2);\n   0.1 + x * 3\n   > verbosity = 12;\n   The verbosity level has been set to 12.\n   > diff(0.1 * x + 1.5 * x^2);\n   Warning (174): Rounding occurred when converting the constant \"0.1\" to floating-point with 165 bits.\n   If safe computation is needed, try to increase the precision.\n   Information (196): formally differentiating a function.\n   Information (197): differentiating the expression '0.1 * x + 1.5 * x^2'\n   Information (195): expression '0.1 + 2 * 1.5 * x' has been simplified to expression '0.1 + 3 * x'.\n   Warning (478): For at least 3 of the constants previously displayed in decimal, rounding has happened.\n   Warning (478): For at least 1 of the constants displayed in decimal, rounding has happened.\n   0.1 + x * 3\n\nSee also: getsuppressedmessages, suppressmessage, unsuppressmessage, verbosity, roundingwarnings\n"
#define HELP_SIMPLIFY_TEXT "Name: simplify\n==> simplifies an expression representing a function\n\nLibrary name:\n   sollya_obj_t sollya_lib_simplify(sollya_obj_t)\n\nUsage: \n   simplify({function}) : function -> function\n\nParameters: \n   {function} represents the expression to be simplified\n\nDescription: \n   * The command simplify simplifies the expression given in argument\n   representing the function {function}.  The command simplify does not\n   endanger the safety of computations even in Sollya's floating-point\n   environment: the function returned is mathematically equal to the\n   function {function}. \n    \n   Remark that the simplification provided by simplify is not perfect:\n   they may exist simpler equivalent expressions for expressions returned\n   by simplify.\n\nExample 1: \n   > print(simplify((6 + 2) + (5 + exp(0)) * x));\n   8 + x * 6\n\nExample 2: \n   > print(simplify((log(x - x + 1) + asin(1))));\n   (pi) / 2\n\nExample 3: \n   > print(simplify((log(x - x + 1) + asin(1)) - (atan(1) * 2)));\n   (pi) / 2 - (pi) / 4 * 2\n\nSee also: dirtysimplify, autosimplify, rationalmode, horner\n"
#define HELP_SINGLE_TEXT "Names: single, SG\n==> rounding to the nearest IEEE 754 single (binary32).\n\nLibrary names:\n   sollya_obj_t sollya_lib_single(sollya_obj_t)\n   sollya_obj_t sollya_lib_single_obj()\n   int sollya_lib_is_single_obj(sollya_obj_t)\n   sollya_obj_t sollya_lib_build_function_single(sollya_obj_t)\n   #define SOLLYA_SG(x) sollya_lib_build_function_single(x)\n\nDescription: \n   * single is both a function and a constant.\n\n   * As a function, it rounds its argument to the nearest IEEE 754 single precision (i.e. IEEE754-2008 binary32) number.\n   Subnormal numbers are supported as well as standard numbers: it is the real\n   rounding described in the standard.\n\n   * As a constant, it symbolizes the single precision format. It is used in \n   contexts when a precision format is necessary, e.g. in the commands \n   round and roundcoefficients. In is not supported for implementpoly.\n   See the corresponding help pages for examples.\n\nExample 1: \n   > display=binary!;\n   > SG(0.1);\n   1.10011001100110011001101_2 * 2^(-4)\n   > SG(4.17);\n   1.000010101110000101001_2 * 2^(2)\n   > SG(1.011_2 * 2^(-1073));\n   0\n\nSee also: halfprecision, double, doubleextended, doubledouble, quad, tripledouble, roundcoefficients, implementpoly, round, printsingle\n"
#define HELP_SINH_TEXT "Name: sinh\n==> the hyperbolic sine function.\n\nLibrary names:\n   sollya_obj_t sollya_lib_sinh(sollya_obj_t)\n   sollya_obj_t sollya_lib_build_function_sinh(sollya_obj_t)\n   #define SOLLYA_SINH(x) sollya_lib_build_function_sinh(x)\n\nDescription: \n   * sinh is the usual hyperbolic sine function: sinh(x) = (exp(x)-exp(-x))/2.\n\n   * It is defined for every real number x.\n\nSee also: asinh, cosh, tanh\n"
#define HELP_SIN_TEXT "Name: sin\n==> the sine function.\n\nLibrary names:\n   sollya_obj_t sollya_lib_sin(sollya_obj_t)\n   sollya_obj_t sollya_lib_build_function_sin(sollya_obj_t)\n   #define SOLLYA_SIN(x) sollya_lib_build_function_sin(x)\n\nDescription: \n   * sin is the usual sine function.\n\n   * It is defined for every real number x.\n\nSee also: asin, cos, tan\n"
#define HELP_SORT_TEXT "Name: sort\n==> sorts a list of real numbers.\n\nLibrary name:\n   sollya_obj_t sollya_lib_sort(sollya_obj_t)\n\nUsage: \n   sort({L}) : list -> list\n\nParameters: \n   {L} is a list.\n\nDescription: \n   * If {L} contains only constant values, sort({L}) returns the same list, but\n   sorted in increasing order.\n\n   * If {L} contains at least one element that is not a constant, the command fails \n   with a type error.\n\n   * If {L} is an end-elliptic list, sort will fail with an error.\n\nExample 1: \n   > sort([| |]);\n   [| |]\n   > sort([|2,3,5,2,1,4|]);\n   [|1, 2, 2, 3, 4, 5|]\n\nSee also: revert\n"
#define HELP_SQRT_TEXT "Name: sqrt\n==> square root.\n\nLibrary names:\n   sollya_obj_t sollya_lib_sqrt(sollya_obj_t)\n   sollya_obj_t sollya_lib_build_function_sqrt(sollya_obj_t)\n   #define SOLLYA_SQRT(x) sollya_lib_build_function_sqrt(x)\n\nDescription: \n   * sqrt is the square root, e.g. the inverse of the function square: sqrt(y)\n   is the unique positive x such that x^2=y.\n\n   * It is defined only for x in [0; +Inf].\n\n"
#define HELP_STRING_TEXT "Name: string\n==> keyword representing a string type \n\nLibrary name:\n   SOLLYA_EXTERNALPROC_TYPE_STRING\n\nUsage: \n   string : type type\n\nDescription: \n   * string represents the string type for declarations\n   of external procedures by means of externalproc.\n    \n   Remark that in contrast to other indicators, type indicators like\n   string cannot be handled outside the externalproc context.  In\n   particular, they cannot be assigned to variables.\n\nSee also: externalproc, boolean, constant, function, integer, list of, range, object\n"
#define HELP_SUBPOLY_TEXT "Name: subpoly\n==> restricts the monomial basis of a polynomial to a list of monomials\n\nLibrary name:\n   sollya_obj_t sollya_lib_subpoly(sollya_obj_t, sollya_obj_t)\n\nUsage: \n   subpoly({polynomial}, {list}) : (function, list) -> function\n\nParameters: \n   {polynomial} represents the polynomial the coefficients are taken from\n   {list} represents the list of monomials to be taken\n\nDescription: \n   * subpoly extracts the coefficients of a polynomial {polynomial} and builds up a\n   new polynomial out of those coefficients associated to monomial degrees figuring in\n   the list {list}. \n    \n   If {polynomial} represents a function that is not a polynomial, subpoly returns 0.\n    \n   If {list} is a list that is end-elliptic, let be j the last value explicitly specified\n   in the list. All coefficients of the polynomial associated to monomials greater or\n   equal to j are taken.\n\nExample 1: \n   > p = taylor(exp(x),5,0);\n   > s = subpoly(p,[|1,3,5|]);\n   > print(p);\n   1 + x * (1 + x * (0.5 + x * (1 / 6 + x * (1 / 24 + x * 1 / 120))))\n   > print(s);\n   x * (1 + x^2 * (1 / 6 + x^2 / 120))\n\nExample 2: \n   > p = remez(atan(x),10,[-1,1]);\n   > subpoly(p,[|1,3,5...|]);\n   x * (0.99986632941452949026018468446163586361700915018232 + x^2 * (-0.33030478502455936362667794059988443130926433421739 + x^2 * (0.18015929317818756462894237037824735129130095574422 + x * (2.2845584115424788285112501565358576642429856963072e-9 + x * (-8.5156349064111377895500552996061844977507560037485e-2 + x * (-2.717563409627750199168187692393409435243830189218e-9 + x * (2.08451134307114729373239910549169872454686955895e-2 + x * 1.10889861181129057657199664386826630081793400489512e-9)))))))\n\nExample 3: \n   > subpoly(exp(x),[|1,2,3|]);\n   0\n\nSee also: roundcoefficients, taylor, remez, fpminimax, implementpoly\n"
#define HELP_SUBSTITUTE_TEXT "Name: substitute\n==> replace the occurrences of the free variable in an expression.\n\nLibrary name:\n   sollya_obj_t sollya_lib_substitute(sollya_obj_t, sollya_obj_t)\n\nUsage: \n   substitute({f},{g}) : (function, function) -> function\n   substitute({f},{t}) : (function, constant) -> constant\n\nParameters: \n   {f} is a function.\n   {g} is a function.\n   {t} is a real number.\n\nDescription: \n   * substitute({f}, {g}) produces the function (f o g) : x -> f(g(x)).\n\n   * substitute({f}, {t}) is the constant f(t). Note that the constant is\n   represented by its expression until it has been evaluated (exactly the same\n   way as if you type the expression {f} replacing instances of the free variable \n   by {t}).\n\n   * If {f} is stored in a variable {F}, the effect of the commands substitute({F},{g}) or substitute({F},{t}) is absolutely equivalent to \n   writing {F(g)} resp. {F(t)}.\n\nExample 1: \n   > f=sin(x);\n   > g=cos(x);\n   > substitute(f,g);\n   sin(cos(x))\n   > f(g);\n   sin(cos(x))\n\nExample 2: \n   > a=1;\n   > f=sin(x);\n   > substitute(f,a);\n   0.84147098480789650665250232163029899962256306079837\n   > f(a);\n   0.84147098480789650665250232163029899962256306079837\n\nSee also: evaluate, composepolynomials\n"
#define HELP_SUPPRESSMESSAGE_TEXT "Name: suppressmessage\n==> suppresses the displaying of messages with a certain number\n\nLibrary names:\n   void sollya_lib_suppressmessage(sollya_obj_t, ...);\n   void sollya_lib_v_suppressmessage(sollya_obj_t, va_list);\n\nUsage: \n   suppressmessage({msg num 1}, ..., {msg num n})   : (integer, ..., integer) -> void\n   suppressmessage({msg list})   : list -> void\n\nParameters: \n   {msg num 1} thru {msg num n} represent the numbers of n messages to be suppressed\n   {msg list} represents a list with numbers of messages to be suppressed\n\nDescription: \n   * The suppressmessage command allows particular warning and information\n   messages to be suppressed from message output, while maintaining\n   global verbosity levels (see verbosity) high. Every Sollya warning\n   or information message (that is not fatal to the tool's execution) has\n   a message number. When these message numbers {msg num 1} thru {msg num n} \n   are given to suppressmessage, the corresponding message are no longer\n   displayed.  The unsuppressmessage command reverts this suppression\n   from output for a particular message.\n\n   * Instead of giving suppressmessage several message numbers {msg num 1} thru\n   {msg num n} or calling suppressmessage several times, it is possible to give\n   a whole list {msg list} of message numbers to suppressmessage.\n\n   * The user should be aware that suppressmessage presents sticky behavior for\n   the warning and information messages suppressed from output. This\n   means that even if subsequent calls to suppressmessage occur, a message\n   suppressed by a call to suppressmessage stays suppressed until it is\n   unsuppressed using unsuppressmessage or the tool is restarted. This\n   behavior distinguishes message suppression from other global states of\n   the Sollya tool. The user may use getsuppressedmessages to obtain a\n   list of currently suppressed messages.\n\n   * When suppressmessage is used on message numbers that do not exist in the\n   current version of the tool, a warning is displayed. The call has no\n   other effect though.\n\nExample 1: \n   > verbosity = 1;\n   The verbosity level has been set to 1.\n   > 0.1;\n   Warning: Rounding occurred when converting the constant \"0.1\" to floating-point with 165 bits.\n   If safe computation is needed, try to increase the precision.\n   Warning: For at least 1 of the constants displayed in decimal, rounding has happened.\n   0.1\n   > suppressmessage(174);\n   > 0.1;\n   Warning: For at least 1 of the constants displayed in decimal, rounding has happened.\n   0.1\n   > suppressmessage(407);\n   > 0.1;\n   Warning: For at least 1 of the constants displayed in decimal, rounding has happened.\n   0.1\n   > verbosity = 12;\n   The verbosity level has been set to 12.\n   > showmessagenumbers = on;\n   Displaying of message numbers has been activated.\n   > diff(exp(x * 0.1));\n   Information (196): formally differentiating a function.\n   Information (197): differentiating the expression 'exp(x * 0.1)'\n   Information (207): no Horner simplification will be performed because the given tree is already in Horner form.\n   Warning (478): For at least 1 of the constants previously displayed in decimal, rounding has happened.\n   Warning (478): For at least 2 of the constants displayed in decimal, rounding has happened.\n   exp(x * 0.1) * 0.1\n   > suppressmessage(207, 196);\n   > diff(exp(x * 0.1));\n   Information (197): differentiating the expression 'exp(x * 0.1)'\n   Warning (478): For at least 1 of the constants previously displayed in decimal, rounding has happened.\n   Warning (478): For at least 2 of the constants displayed in decimal, rounding has happened.\n   exp(x * 0.1) * 0.1\n   > unsuppressmessage(174);\n   > 0.1;\n   Warning (174): Rounding occurred when converting the constant \"0.1\" to floating-point with 165 bits.\n   If safe computation is needed, try to increase the precision.\n   Warning (478): For at least 1 of the constants displayed in decimal, rounding has happened.\n   0.1\n\nExample 2: \n   > verbosity = 12;\n   The verbosity level has been set to 12.\n   > showmessagenumbers = on; \n   Displaying of message numbers has been activated.\n   > diff(exp(x * 0.1));\n   Warning (174): Rounding occurred when converting the constant \"0.1\" to floating-point with 165 bits.\n   If safe computation is needed, try to increase the precision.\n   Information (196): formally differentiating a function.\n   Information (197): differentiating the expression 'exp(x * 0.1)'\n   Information (207): no Horner simplification will be performed because the given tree is already in Horner form.\n   Warning (478): For at least 1 of the constants previously displayed in decimal, rounding has happened.\n   Warning (478): For at least 2 of the constants displayed in decimal, rounding has happened.\n   exp(x * 0.1) * 0.1\n   > suppressmessage([| 174, 207, 196 |]);\n   > diff(exp(x * 0.1));\n   Information (197): differentiating the expression 'exp(x * 0.1)'\n   Warning (478): For at least 1 of the constants previously displayed in decimal, rounding has happened.\n   Warning (478): For at least 2 of the constants displayed in decimal, rounding has happened.\n   exp(x * 0.1) * 0.1\n\nSee also: getsuppressedmessages, suppressmessage, unsuppressmessage, verbosity, roundingwarnings\n"
#define HELP_SUP_TEXT "Name: sup\n==> gives the upper bound of an interval.\n\nLibrary name:\n   sollya_obj_t sollya_lib_sup(sollya_obj_t)\n\nUsage: \n   sup({I}) : range -> constant\n   sup({x}) : constant -> constant\n\nParameters: \n   {I} is an interval.\n   {x} is a real number.\n\nDescription: \n   * Returns the upper bound of the interval {I}. Each bound of an interval has its \n   own precision, so this command is exact, even if the current precision is too \n   small to represent the bound.\n\n   * When called on a real number {x}, sup behaves like the identity.\n\nExample 1: \n   > sup([1;3]);\n   3\n   > sup(5);\n   5\n\nExample 2: \n   > display=binary!;\n   > I=[0; 0.111110000011111_2];\n   > sup(I);\n   1.11110000011111_2 * 2^(-1)\n   > prec=12!;\n   > sup(I);\n   1.11110000011111_2 * 2^(-1)\n\nSee also: inf, mid, max, min\n"
#define HELP_TAIL_TEXT "Name: tail\n==> gives the tail of a list.\n\nLibrary name:\n   sollya_obj_t sollya_lib_tail(sollya_obj_t)\n\nUsage: \n   tail({L}) : list -> list\n\nParameters: \n   {L} is a list.\n\nDescription: \n   * tail({L}) returns the list {L} without its first element.\n\n   * If {L} is empty, the command will fail with an error.\n\n   * tail can also be used with end-elliptic lists. In this case, the result of\n   tail is also an end-elliptic list.\n\nExample 1: \n   > tail([|1,2,3|]);\n   [|2, 3|]\n   > tail([|1,2...|]);\n   [|2...|]\n\nSee also: head, revert\n"
#define HELP_TANH_TEXT "Name: tanh\n==> the hyperbolic tangent function.\n\nLibrary names:\n   sollya_obj_t sollya_lib_tanh(sollya_obj_t)\n   sollya_obj_t sollya_lib_build_function_tanh(sollya_obj_t)\n   #define SOLLYA_TANH(x) sollya_lib_build_function_tanh(x)\n\nDescription: \n   * tanh is the hyperbolic tangent function, defined by tanh(x) = sinh(x)/cosh(x).\n\n   * It is defined for every real number x.\n\nSee also: atanh, cosh, sinh\n"
#define HELP_TAN_TEXT "Name: tan\n==> the tangent function.\n\nLibrary names:\n   sollya_obj_t sollya_lib_tan(sollya_obj_t)\n   sollya_obj_t sollya_lib_build_function_tan(sollya_obj_t)\n   #define SOLLYA_TAN(x) sollya_lib_build_function_tan(x)\n\nDescription: \n   * tan is the tangent function, defined by tan(x) = sin(x)/cos(x).\n\n   * It is defined for every real number x that is not of the form n*Pi+Pi/2 where n is an integer.\n\nSee also: atan, cos, sin\n"
#define HELP_TAYLORFORM_TEXT "Name: taylorform\n==> computes a rigorous polynomial approximation (polynomial, interval error bound) for a function, based on Taylor expansions.\n\nLibrary names:\n   sollya_obj_t sollya_lib_taylorform(sollya_obj_t, sollya_obj_t,\n                                      sollya_obj_t, ...)\n   sollya_obj_t sollya_lib_v_taylorform(sollya_obj_t, sollya_obj_t,\n                                        sollya_obj_t, va_list)\n\nUsage: \n   taylorform({f}, {n}, {x0}, {I}, {errorType}) : (function, integer, constant, range, absolute|relative) -> list\n   taylorform({f}, {n}, {x0}, {I}, {errorType}) : (function, integer, range, range, absolute|relative) -> list\n   taylorform({f}, {n}, {x0}, {errorType}) : (function, integer, constant, absolute|relative) -> list\n   taylorform({f}, {n}, {x0}, {errorType}) : (function, integer, range, absolute|relative) -> list\n\nParameters: \n   {f} is the function to be approximated.\n   {n} is the degree of the polynomial that must approximate {f}.\n   {x0} is the point (it can be a real number or an interval) where the Taylor exansion of the function is to be considered.\n   {I} is the interval over which the function is to be approximated. If this parameter is omitted, the behavior is changed (see detailed description below).\n   {errorType} (optional) is the type of error to be considered. See the detailed description below. Default is absolute.\n\nDescription: \n   * WARNING: taylorform is a certified command, not difficult to use but not\n   completely straightforward to use either. In order to be sure to use it\n   correctly, the reader is invited to carefully read this documentation\n   entirely.\n\n   * taylorform computes an approximation polynomial and an interval error\n   bound for function f. \n   More precisely, it returns a list\n   L=[p, coeffErrors, Delta] where:\n    \n     - p is an approximation polynomial of degree n such that p(x-x0) is\n   roughly speaking a numerical Taylor expansion of f at the point x0.\n     - coeffsErrors is a list of n+1 intervals. Each interval coeffsErrors[i]\n   contains an enclosure of all the errors accumulated when computing the i-th\n   coefficient of p.\n     - Delta is an interval that provides a bound for the approximation error\n   between p and f. Its significance depends on the {errorType} considered.\n    \n\n   * The polynomial p and the bound  Delta are obtained using Taylor Models\n   principles.\n\n   * Please note that x0 can be an interval. In general, it is meant to be a\n   small interval approximating a non representable value. If x0 is given as a\n   constant expression, it is first numerically evaluated (leading to a faithful\n   rounding xapprox0 at precision prec), and it is then replaced by the (exactly\n   representable) point-interval [xapprox0, xapprox0]. In particular, it is not\n   the same to call taylorform with x0 = pi and with x0 = [pi], for instance.\n   In general, if the point around which one desires to compute the polynomial\n   is not exactly representable, one should preferably use a small interval\n   for x0.\n\n   * More formally, the mathematical property ensured by the algorithm may be\n   stated as follows. For all xi0 in x0, there exist (small) values\n   eps[i] in coeffsErrors[i] such that:\n    \n   If {errorType} is absolute, for all x in I, there exists delta in Delta such\n   that f(x) - p(x-xi0) = sum{i=0...n} eps[i]*(x-xi0)^i + delta.\n    \n   If {errorType} is relative, for all x in I, there exists delta in Delta such\n   that f(x) - p(x-xi0) = sum{i=0...n} eps[i]*(x-xi0)^i + delta*(x-xi0)^(n+1).\n\n   * It is also possible to use a large interval for x0, though it is not\n   obvious to give an intuitive sense to the result of taylorform in that case.\n   A particular case that might be interesting is when x0=I in relative mode.\n   In that case, denoting by p_i the coefficient of p of order i, the interval\n   p_i + coeffsError[i] gives an enclosure of f^(i)(I)/i!.\n   However, the command autodiff is more convenient for computing such\n   enclosures.\n\n   * When the interval I is not given, the approximated Taylor polynomial is\n   computed but no remainder is produced. In that case the returned list\n   is L=[p, coeffErrors].\n\n   * The relative case is especially useful when functions with removable\n   singularities are considered. In such a case, this routine is able to compute\n   a finite remainder bound, provided that the expansion point given is the\n   problematic removable singularity point.\n\n   * The algorithm does not guarantee that by increasing the degree of the\n   approximation, the remainder bound will become smaller. Moreover, it may \n   even become larger due to the dependency phenomenon present with interval\n   arithmetic. In order to reduce this phenomenon, a possible solution is to\n   split the definition domain I into several smaller intervals. \n\n   * The command taylor also computes a Taylor polynomial of a function. However\n   it does not provide a bound on the remainder. Besides, taylor is a somehow\n   symbolic command: each coefficient of the Taylor polynomial is computed\n   exactly and returned as an expression tree exactly equal to theoretical\n   value. It is henceforth much more inefficient than taylorform and taylorform\n   should be preferred if only numercial (yet safe) computations are required.\n   The same difference exists between commands diff and autodiff.\n\nExample 1: \n   > TL=taylorform(sin(x)/x, 10, 0, [-1,1], relative);\n   > p=TL[0];\n   > Delta=TL[2];\n   > errors=TL[1];\n   > for epsi in errors do epsi;\n   [0;0]\n   [0;0]\n   [0;5.34552942018439129228107293430296375763039376021e-51]\n   [0;0]\n   [-3.3409558876152445576756705839393523485189961001313e-52;3.3409558876152445576756705839393523485189961001313e-52]\n   [0;0]\n   [-1.04404871487976392427364705748104760891218628129103e-53;1.04404871487976392427364705748104760891218628129103e-53]\n   [0;0]\n   [-1.63132611699963113167757352731413688892529106451724e-55;1.63132611699963113167757352731413688892529106451724e-55]\n   [0;0]\n   [-1.91171029335894273243465647732125416670932546623114e-57;1.91171029335894273243465647732125416670932546623114e-57]\n   > p; Delta;\n   1 + x^2 * (-0.16666666666666666666666666666666666666666666666667 + x^2 * (8.3333333333333333333333333333333333333333333333333e-3 + x^2 * (-1.984126984126984126984126984126984126984126984127e-4 + x^2 * (2.7557319223985890652557319223985890652557319223986e-6 + x^2 * (-2.5052108385441718775052108385441718775052108385442e-8)))))\n   [-1.6135797443886066084999806203254010793747502812764e-10;1.6135797443886066084999806203254010793747502812764e-10]\n\nExample 2: \n   > TL=taylorform(exp(x), 10, 0, [-1,1], absolute);\n   > p=TL[0];\n   > Delta=TL[2];\n   > p; Delta;\n   1 + x * (1 + x * (0.5 + x * (0.16666666666666666666666666666666666666666666666667 + x * (4.1666666666666666666666666666666666666666666666668e-2 + x * (8.3333333333333333333333333333333333333333333333333e-3 + x * (1.3888888888888888888888888888888888888888888888889e-3 + x * (1.984126984126984126984126984126984126984126984127e-4 + x * (2.4801587301587301587301587301587301587301587301587e-5 + x * (2.7557319223985890652557319223985890652557319223986e-6 + x * 2.7557319223985890652557319223985890652557319223986e-7)))))))))\n   [-2.3114271964118761944124253418268474583253955510297e-8;2.7312660755642474420206278018039434042553645532164e-8]\n\nExample 3: \n   > TL1 = taylorform(exp(x), 10, log2(10), [-1,1], absolute);\n   > TL2 = taylorform(exp(x), 10, [log2(10)], [-1,1], absolute);\n   > TL1==TL2;\n   false\n\nExample 4: \n   > TL1 = taylorform(exp(x), 3, 0, [0,1], relative);\n   > TL2 = taylorform(exp(x), 3, 0, relative);\n   > TL1[0]==TL2[0];\n   true\n   > TL1[1]==TL2[1];\n   true\n   > length(TL1);\n   3\n   > length(TL2);\n   2\n\nExample 5: \n   > f = exp(cos(x)); x0 = 0;\n   > TL = taylorform(f, 3, x0);\n   > T1 = TL[0];\n   > T2 = taylor(f, 3, x0);\n   > print(coeff(T1, 2));\n   -1.35914091422952261768014373567633124887862354685\n   > print(coeff(T2, 2));\n   -(0.5 * exp(1))\n\nSee also: diff, autodiff, taylor, remez, chebyshevform\n"
#define HELP_TAYLORRECURSIONS_TEXT "Name: taylorrecursions\n==> controls the number of recursion steps when applying Taylor's rule.\n\nLibrary names:\n   void sollya_lib_set_taylorrecursions_and_print(sollya_obj_t)\n   void sollya_lib_set_taylorrecursions(sollya_obj_t)\n   sollya_obj_t sollya_lib_get_taylorrecursions()\n\nUsage: \n   taylorrecursions = {n} : integer -> void\n   taylorrecursions = {n} ! : integer -> void\n   taylorrecursions : integer\n\nParameters: \n   {n} represents the number of recursions\n\nDescription: \n   * taylorrecursions is a global variable. Its value represents the number of steps\n   of recursion that are used when applying Taylor's rule. This rule is applied\n   by the interval evaluator present in the core of Sollya (and particularly\n   visible in commands like infnorm).\n\n   * To improve the quality of an interval evaluation of a function f, in \n   particular when there are problems of decorrelation), the evaluator of Sollya\n   uses Taylor's rule:  f([a,b]) C f(m) + [a-m, b-m]*f'([a,b]) where m=(a+b)/2.\n   This rule can be applied recursively.\n   The number of step in this recursion process is controlled by taylorrecursions.\n\n   * Setting taylorrecursions to 0 makes Sollya use this rule only once;\n   setting it to 1 makes Sollya use the rule twice, and so on.\n   In particular: the rule is always applied at least once.\n\nExample 1: \n   > f=exp(x);\n   > p=remez(f,3,[0;1]);\n   > taylorrecursions=0;\n   The number of recursions for Taylor evaluation has been set to 0.\n   > evaluate(f-p, [0;1]);\n   [-0.46839364816268368775174657814112460243249079671039;0.46947781754646820647293019728402934746974652584671]\n   > taylorrecursions=1;\n   The number of recursions for Taylor evaluation has been set to 1.\n   > evaluate(f-p, [0;1]);\n   [-0.138131114954063839905475752120786856031651747712954;0.13921528433784835862665937126369160106890747684927]\n\nSee also: hopitalrecursions, evaluate, infnorm\n"
#define HELP_TAYLOR_TEXT "Name: taylor\n==> computes a Taylor expansion of a function in a point\n\nLibrary name:\n   sollya_obj_t sollya_lib_taylor(sollya_obj_t, sollya_obj_t, sollya_obj_t)\n\nUsage: \n   taylor({function}, {degree}, {point}) : (function, integer, constant) -> function\n\nParameters: \n   {function} represents the function to be expanded\n   {degree} represents the degree of the expansion to be delivered\n   {point} represents the point in which the function is to be developed\n\nDescription: \n   * The command taylor returns an expression that is a Taylor expansion\n   of function {function} in point {point} having the degree {degree}.\n    \n   Let f be the function {function}, t be the point {point} and\n   n be the degree {degree}. Then, taylor({function},{degree},{point}) \n   evaluates to an expression mathematically equal to\n        f(t) + f'(t) * x + ... + 1/(n!) * f[n](t) * x^n.\n   In other words, if p(x) denotes the polynomial returned by taylor,\n   p(x-t) is the Taylor polynomial of degree n of f developed at point t.\n    \n   Remark that taylor evaluates to 0 if the degree {degree} is negative.\n\nExample 1: \n   > print(taylor(exp(x),3,1));\n   exp(1) + x * (exp(1) + x * (0.5 * exp(1) + x * exp(1) / 6))\n\nExample 2: \n   > print(taylor(asin(x),7,0));\n   x * (1 + x^2 * (1 / 6 + x^2 * (3 / 40 + x^2 * 5 / 112)))\n\nExample 3: \n   > print(taylor(erf(x),6,0));\n   x * (2 / sqrt(pi) + x^2 * ((2 / sqrt(pi) * (-2)) / 6 + x^2 * (2 / sqrt(pi) * 12) / 120))\n\nSee also: remez, fpminimax, taylorform\n"
#define HELP_TD_TEXT "Name: TD\n==> short form for tripledouble\n\nSee also: tripledouble\n"
#define HELP_TIME_TEXT "Name: time\n==> procedure for timing Sollya code.\n\nUsage: \n   time({code}) : code -> constant\n\nParameters: \n   {code} is the code to be timed.\n\nDescription: \n   * time permits timing a Sollya instruction, resp. a begin-end block\n   of Sollya instructions. The timing value, measured in seconds, is returned\n   as a Sollya constant (and not merely displayed as for timing). This \n   permits performing computations of the timing measurement value inside Sollya.\n\n   * The extended nop command permits executing a defined number of\n   useless instructions. Taking the ratio of the time needed to execute a\n   certain Sollya instruction and the time for executing a nop\n   therefore gives a way to abstract from the speed of a particular \n   machine when evaluating an algorithm's performance.\n\nExample 1: \n   > t = time(p=remez(sin(x),10,[-1;1]));\n   > write(t,\"s were spent computing p = \",p,\"\\n\");\n   4.3901451000000000000000000000000000004134147051842e-2s were spent computing p = 9.0486898749977990986908851357759191711354777014602e-17 * x^10 + 2.68762595115123596299959320959141640012683406736586e-6 * x^9 + -2.4247978492521313349073232289246205727856268698001e-16 * x^8 + -1.98344863020965929701245606503586461226130937598776e-4 * x^7 + 2.2748214757753544349162426281857910162575492126267e-16 * x^6 + 8.3333037186560980567697821420813799547276481409702e-3 * x^5 + -8.574715198972066974170696130354953131211051121887e-17 * x^4 + -0.166666661386013237076216566493953847771564552744173 * x^3 + 1.05699558969863875841493332282097022580493449058156e-17 * x^2 + 0.99999999973628365676559825181776417246038944720795 * x + (-3.1206530956601883024316320853642604562810646600878e-19)\n\nExample 2: \n   > write(time({ p=remez(sin(x),10,[-1;1]); write(\"The error is 2^(\", log2(dirtyinfnorm(p-sin(x),[-1;1])), \")\\n\"); }), \"s were spent\\n\");\n   The error is 2^(log2(2.39601979446524486606649528289933482070294808074097e-11))\n   7.000321699999999999999999999999999999924693731762e-2s were spent\n\nExample 3: \n   > t = time(bashexecute(\"sleep 10\"));\n   > write(~(t-10),\"s of execution overhead.\\n\");\n   2.1002310000000000000000000000000012268797747048674e-3s of execution overhead.\n\nExample 4: \n   > ratio := time(p=remez(sin(x),10,[-1;1]))/time(nop(10));\n   > write(\"This ratio = \", ratio, \" should somehow be independent of the type of machine.\\n\");\n   This ratio = 1.61639530334307906617624517887585127958875499186467 should somehow be independent of the type of machine.\n\nSee also: timing, nop\n"
#define HELP_TIMING_TEXT "Name: timing\n==> global variable controlling timing measures in Sollya.\n\nLibrary names:\n   void sollya_lib_set_timing_and_print(sollya_obj_t)\n   void sollya_lib_set_timing(sollya_obj_t)\n   sollya_obj_t sollya_lib_get_timing()\n\nUsage: \n   timing = {activation value} : on|off -> void\n   timing = {activation value} ! : on|off -> void\n   timing : on|off\n\nParameters: \n   {activation value} controls if timing should be performed or not\n\nDescription: \n   * timing is a global variable. When its value is on, the time spent in each \n   command is measured and displayed (for verbosity levels higher than 1).\n\nExample 1: \n   > verbosity=1!;\n   > timing=on;\n   Timing has been activated.\n   > p=remez(sin(x),10,[-1;1]);\n   Information: Remez: computing the quality of approximation spent 5 ms\n   Information: Remez: computing the quality of approximation spent 5 ms\n   Information: Remez: computing the quality of approximation spent 5 ms\n   Information: computing a minimax approximation spent 28 ms\n   Information: assignment spent 34 ms\n   Information: full execution of the last parse chunk spent 40 ms\n\nSee also: on, off, time\n"
#define HELP_TRIPLEDOUBLE_TEXT "Names: tripledouble, TD\n==> represents a number as the sum of three IEEE doubles.\n\nLibrary names:\n   sollya_obj_t sollya_lib_triple_double(sollya_obj_t)\n   sollya_obj_t sollya_lib_triple_double_obj()\n   int sollya_lib_is_triple_double_obj(sollya_obj_t)\n   sollya_obj_t sollya_lib_build_function_triple_double(sollya_obj_t)\n   #define SOLLYA_TD(x) sollya_lib_build_function_triple_double(x)\n\nDescription: \n   * tripledouble is both a function and a constant.\n\n   * As a function, it rounds its argument to the nearest number that can be written\n   as the sum of three double precision numbers.\n\n   * The algorithm used to compute tripledouble(x) is the following: let xh = double(x),\n   let xm = double(x - xh) and let xl = double(x - xh - xm). \n   Return the number xh + xm + xl. Note that if the\n   current precision is not sufficient to represent exactly xh + xm + xl, a rounding will\n   occur and the result of tripledouble(x) will be useless.\n\n   * As a constant, it symbolizes the triple-double precision format. It is used in \n   contexts when a precision format is necessary, e.g. in the commands \n   roundcoefficients and implementpoly.\n   See the corresponding help pages for examples.\n\nExample 1: \n   > verbosity=1!;\n   > a = 1+ 2^(-55)+2^(-115);\n   > TD(a);\n   Warning: For at least 1 of the constants displayed in decimal, rounding has happened.\n   1.00000000000000002775557561562891353466491600711096\n   > prec=110!;\n   > TD(a);\n   1.0000000000000000277555756156289135346649160071109559756997242823115914817262706026923524404992349445819854736328125\n\nSee also: halfprecision, single, double, doubleextended, doubledouble, quad, roundcoefficients, implementpoly, fpminimax, printexpansion\n"
#define HELP_TRUE_TEXT "Name: true\n==> the boolean value representing the truth.\n\nLibrary names:\n   sollya_obj_t sollya_lib_true()\n   int sollya_lib_is_true(sollya_obj_t)\n\nDescription: \n   * true is the usual boolean value.\n\nExample 1: \n   > true && false;\n   false\n   > 2>1;\n   true\n\nSee also: false, &&, ||\n"
#define HELP_UNSUPPRESSMESSAGE_TEXT "Name: unsuppressmessage\n==> unsuppresses the displaying of messages with a certain number\n\nLibrary names:\n   void sollya_lib_unsuppressmessage(sollya_obj_t, ...);\n   void sollya_lib_v_unsuppressmessage(sollya_obj_t, va_list);\n\nUsage: \n   unsuppressmessage({msg num 1}, ..., {msg num n})   : (integer, ..., integer) -> void\n   unsuppressmessage({msg list})   : list -> void\n\nParameters: \n   {msg num 1} thru {msg num n} represent the numbers of n messages to be suppressed\n   {msg list} represents a list with numbers of messages to be suppressed\n\nDescription: \n   * The unsuppressmessage command allows particular warning and information\n   messages that have been suppressed from message output to be\n   unsuppressed, i.e. activated for display again. Every Sollya warning\n   or information message (that is not fatal to the tool's execution) has\n   a message number. When these message numbers {msg num 1} thru {msg num n} \n   are given to unsuppressmessage, the corresponding message are displayed\n   again, as they are by default at according verbosity levels. Actually,\n   the unsuppressmessage command just reverts the effects of the suppressmessage\n   command.\n\n   * Instead of giving unsuppressmessage several message numbers {msg num 1} thru\n   {msg num n} or calling unsuppressmessage several times, it is possible to give\n   a whole list {msg list} of message numbers to unsuppressmessage.\n\n   * The user should be aware that unsuppressmessage presents sticky behavior for\n   the warning and information messages suppressed from output.  In fact,\n   unsuppressmessage just unsuppresses the warning or information messages given\n   in argument.  All other suppressed messages stay suppressed until they\n   get unsuppressed by subsequent calls to unsuppressmessage or the Sollya tool\n   is restarted. This behavior distinguishes message suppression from\n   other global states of the Sollya tool. The user may use\n   getsuppressedmessages to obtain a list of currently suppressed\n   messages. In particular, in order to unsuppressed all currently\n   suppressed warning or information messages, the user may feed the\n   output of getsuppressedmessages (a list) into unsuppressmessage.\n\n   * The user should also note that unsuppressing warning or information\n   messages with unsuppressmessage just reverts the effects of the suppressmessage\n   command but that other conditions exist that affect the actual displaying \n   of a message, such as global verbosity (see verbosity) and modes\n   like rounding warnings (see roundingwarnings). A message will not just \n   get displayed because it was unsuppressed with unsuppressmessage.\n\n   * When unsuppressmessage is used on message numbers that do not exist in the\n   current version of the tool, a warning is displayed. The call has no\n   other effect though.\n\nExample 1: \n   > verbosity = 1;\n   The verbosity level has been set to 1.\n   > 0.1;\n   Warning: Rounding occurred when converting the constant \"0.1\" to floating-point with 165 bits.\n   If safe computation is needed, try to increase the precision.\n   Warning: For at least 1 of the constants displayed in decimal, rounding has happened.\n   0.1\n   > suppressmessage(174);\n   > 0.1;\n   Warning: For at least 1 of the constants displayed in decimal, rounding has happened.\n   0.1\n   > suppressmessage(174);\n   > 0.1;\n   Warning: For at least 1 of the constants displayed in decimal, rounding has happened.\n   0.1\n\nExample 2: \n   > verbosity = 12;\n   The verbosity level has been set to 12.\n   > showmessagenumbers = on; \n   Displaying of message numbers has been activated.\n   > diff(exp(x * 0.1));\n   Warning (174): Rounding occurred when converting the constant \"0.1\" to floating-point with 165 bits.\n   If safe computation is needed, try to increase the precision.\n   Information (196): formally differentiating a function.\n   Information (197): differentiating the expression 'exp(x * 0.1)'\n   Information (207): no Horner simplification will be performed because the given tree is already in Horner form.\n   Warning (478): For at least 1 of the constants previously displayed in decimal, rounding has happened.\n   Warning (478): For at least 2 of the constants displayed in decimal, rounding has happened.\n   exp(x * 0.1) * 0.1\n   > suppressmessage([| 174, 207, 196 |]);\n   > diff(exp(x * 0.1));\n   Information (197): differentiating the expression 'exp(x * 0.1)'\n   Warning (478): For at least 1 of the constants previously displayed in decimal, rounding has happened.\n   Warning (478): For at least 2 of the constants displayed in decimal, rounding has happened.\n   exp(x * 0.1) * 0.1\n   > unsuppressmessage([| 174, 196 |]);\n\nExample 3: \n   > verbosity = 12;\n   The verbosity level has been set to 12.\n   > showmessagenumbers = on;\n   Displaying of message numbers has been activated.\n   > suppressmessage(207, 387, 390, 388, 391, 196, 195, 197, 205);\n   > getsuppressedmessages();\n   [|195, 196, 197, 205, 207, 387, 388, 390, 391|]\n   > evaluate(x/sin(x) - 1, [-1;1]);\n   Warning (478): For at least 1 of the constants displayed in decimal, rounding has happened.\n   [0;0.8508157176809256179117532413986501934703966550941]\n   > unsuppressmessage(getsuppressedmessages());\n   > getsuppressedmessages();\n   [| |]\n\nSee also: getsuppressedmessages, suppressmessage, unsuppressmessage, verbosity, roundingwarnings\n"
#define HELP_VAR_TEXT "Name: var\n==> declaration of a local variable in a scope\n\nUsage: \n   var {identifier1}, {identifier2},... , {identifiern} : void\n\nParameters: \n   {identifier1}, {identifier2},... , {identifiern} represent variable identifiers\n\nDescription: \n   * The keyword var allows for the declaration of local variables\n   {identifier1} through {identifiern} in a begin-end-block ({}-block).\n   Once declared as a local variable, an identifier will shadow\n   identifiers declared in higher scopes and undeclared identifiers\n   available at top-level.\n    \n   Variable declarations using var are only possible in the\n   beginning of a begin-end-block. Several var statements can be\n   given. Once another statement is given in a begin-end-block, no more\n   var statements can be given.\n    \n   Variables declared by var statements are dereferenced as error\n   until they are assigned a value. \n\nExample 1: \n   > exp(x); \n   exp(x)\n   > a = 3; \n   > {var a, b; a=5; b=3; {var a; var b; b = true; a = 1; a; b;}; a; b; }; \n   1\n   true\n   5\n   3\n   > a;\n   3\n\nSee also: error, proc\n"
#define HELP_VERBOSITY_TEXT "Name: verbosity\n==> global variable controlling the amount of information displayed by commands.\n\nLibrary names:\n   void sollya_lib_set_verbosity_and_print(sollya_obj_t)\n   void sollya_lib_set_verbosity(sollya_obj_t)\n   sollya_obj_t sollya_lib_get_verbosity()\n\nUsage: \n   verbosity = {n} : integer -> void\n   verbosity = {n} ! : integer -> void\n   verbosity : integer\n\nParameters: \n   {n} controls the amount of information to be displayed\n\nDescription: \n   * verbosity accepts any integer value. At level 0, commands do not display anything\n   on standard output. Note that very critical information may however be displayed on\n   standard error.\n\n   * Default level is 1. It displays important information such as warnings when \n   roundings happen.\n\n   * For higher levels more information is displayed depending on the command.\n\nExample 1: \n   > verbosity=0!;\n   > 1.2+\"toto\";\n   error\n   > verbosity=1!;\n   > 1.2+\"toto\";\n   Warning: Rounding occurred when converting the constant \"1.2\" to floating-point with 165 bits.\n   If safe computation is needed, try to increase the precision.\n   Warning: at least one of the given expressions or a subexpression is not correctly typed\n   or its evaluation has failed because of some error on a side-effect.\n   error\n   > verbosity=2!;\n   > 1.2+\"toto\";\n   Warning: Rounding occurred when converting the constant \"1.2\" to floating-point with 165 bits.\n   If safe computation is needed, try to increase the precision.\n   Warning: at least one of the given expressions or a subexpression is not correctly typed\n   or its evaluation has failed because of some error on a side-effect.\n   Information: the expression or a partial evaluation of it has been the following:\n   (1.2) + (\"toto\")\n   Warning: For at least 1 of the constants previously displayed in decimal, rounding has happened.\n   error\n\nSee also: roundingwarnings, suppressmessage, unsuppressmessage, showmessagenumbers, getsuppressedmessages\n"
#define HELP_VOID_TEXT "Name: void\n==> the functional result of a side-effect or empty argument resp. the corresponding type\n\nLibrary names:\n   sollya_obj_t sollya_lib_void()\n   int sollya_lib_is_void(sollya_obj_t)\n   SOLLYA_EXTERNALPROC_TYPE_VOID\n\nUsage: \n   void : void | type type\n\nDescription: \n   * The variable void represents the functional result of a\n   side-effect or an empty argument.  It is used only in combination with\n   the applications of procedures or identifiers bound through\n   externalproc to external procedures.\n    \n   The void result produced by a procedure or an external procedure\n   is not printed at the prompt. However, it is possible to print it out\n   in a print statement or in complex data types such as lists.\n    \n   The void argument is implicit when giving no argument to a\n   procedure or an external procedure when applied. It can nevertheless be given\n   explicitly.  For example, suppose that foo is a procedure or an\n   external procedure with a void argument. Then foo() and foo(void) are\n   correct calls to foo. Here, a distinction must be made for procedures having an\n   arbitrary number of arguments. In this case, an implicit void\n   as the only parameter to a call of such a procedure gets converted into \n   an empty list of arguments, an explicit void gets passed as-is in the\n   formal list of parameters the procedure receives.\n\n   * void is used also as a type identifier for\n   externalproc. Typically, an external procedure taking void as an\n   argument or returning void is bound with a signature void ->\n   some type or some type -> void. See externalproc for more\n   details.\n\nExample 1: \n   > print(void);\n   void\n   > void;\n\nExample 2: \n   > hey = proc() { print(\"Hello world.\"); };\n   > hey;\n   proc()\n   {\n   print(\"Hello world.\");\n   return void;\n   }\n   > hey();\n   Hello world.\n   > hey(void);\n   Hello world.\n   > print(hey());\n   Hello world.\n   void\n\nExample 3: \n   > bashexecute(\"gcc -fPIC -Wall -c externalprocvoidexample.c\");\n   > bashexecute(\"gcc -fPIC -shared -o externalprocvoidexample externalprocvoidexample.o\");\n   > externalproc(foo, \"./externalprocvoidexample\", void -> void);\n   > foo;\n   foo\n   > foo();\n   Hello from the external world.\n   > foo(void);\n   Hello from the external world.\n   > print(foo());\n   Hello from the external world.\n   void\n\nExample 4: \n   > procedure blub(L = ...) { print(\"Argument list:\", L); };\n   > blub(1);\n   Argument list: [|1|]\n   > blub();\n   Argument list: [| |]\n   > blub(void); \n   Argument list: [|void|]\n\nSee also: error, proc, externalproc\n"
#define HELP_WORSTCASE_TEXT "Name: worstcase\n==> searches for hard-to-round cases of a function\n\nLibrary names:\n   void sollya_lib_worstcase(sollya_obj_t, sollya_obj_t, sollya_obj_t,\n                             sollya_obj_t, sollya_obj_t, ...)\n   void sollya_lib_v_worstcase(sollya_obj_t, sollya_obj_t, sollya_obj_t,\n                               sollya_obj_t, sollya_obj_t, va_list)\n\nUsage: \n   worstcase({function}, {preimage precision}, {preimage exponent range}, {image precision}, {error bound}) : (function, integer, range, integer, constant) -> void\n   worstcase({function}, {preimage precision}, {preimage exponent range}, {image precision}, {error bound}, {filename}) : (function, integer, range, integer, constant, string) -> void\n\nParameters: \n   {function} represents the function to be considered\n   {preimage precision} represents the precision of the preimages\n   {preimage exponent range} represents the exponents in the preimage format\n   {image precision} represents the precision of the format the images are to be rounded to\n   {error bound} represents the upper bound for the search w.r.t. the relative rounding error\n   {filename} represents a character sequence containing a filename\n\nDescription: \n   * The worstcase command is deprecated. It searches for hard-to-round cases of\n   a function. The command searchgal has a comparable functionality.\n\nExample 1: \n   > worstcase(exp(x),24,[1,2],24,1b-26);\n   prec = 165\n   x = 1.99999988079071044921875\t\tf(x) = 7.3890552520751953125\t\teps = 4.5998601423446695596184695493764120138001954979037e-9 = 2^(-27.695763) \n   x = 2\t\tf(x) = 7.38905620574951171875\t\teps = 1.44563608749673018122228379395533417878125150587072e-8 = 2^(-26.043720) \n   \n\nSee also: round, searchgal, evaluate\n"
#define HELP_WRITE_TEXT "Name: write\n==> prints an expression without separators\n\nUsage: \n   write({expr1},...,{exprn}) : (any type,..., any type) -> void\n   write({expr1},...,{exprn}) > {filename} : (any type,..., any type, string) -> void\n   write({expr1},...,{exprn}) >> {filename} : (any type,...,any type, string) -> void\n\nParameters: \n   {expr} represents an expression\n   {filename} represents a character sequence indicating a file name\n\nDescription: \n   * write({expr1},...,{exprn}) prints the expressions {expr1} through\n   {exprn}. The character sequences corresponding to the expressions are\n   concatenated without any separator. No newline is displayed at the\n   end.  In contrast to print, write expects the user to give all\n   separators and newlines explicitly.\n    \n   If a second argument {filename} is given after a single \">\", the\n   displaying is not output on the standard output of Sollya but if in\n   the file {filename} that get newly created or overwritten. If a double\n    \">>\" is given, the output will be appended to the file {filename}.\n    \n   The global variables display, midpointmode and fullparentheses have\n   some influence on the formatting of the output (see display,\n   midpointmode and fullparentheses).\n    \n   Remark that if one of the expressions {expri} given in argument is of\n   type string, the character sequence {expri} evaluates to is\n   displayed. However, if {expri} is of type list and this list\n   contains a variable of type string, the expression for the list\n   is displayed, i.e.  all character sequences get displayed surrounded\n   by quotes (\"). Nevertheless, escape sequences used upon defining\n   character sequences are interpreted immediately.\n\nExample 1: \n   > write(x + 2 + exp(sin(x))); \n   > write(\"Hello\\n\");\n   x + 2 + exp(sin(x))Hello\n   > write(\"Hello\",\"world\\n\");\n   Helloworld\n   > write(\"Hello\",\"you\", 4 + 3, \"other persons.\\n\");\n   Helloyou7other persons.\n\nExample 2: \n   > write(\"Hello\",\"\\n\");\n   Hello\n   > write([|\"Hello\"|],\"\\n\");\n   [|\"Hello\"|]\n   > s = \"Hello\";\n   > write(s,[|s|],\"\\n\");\n   Hello[|\"Hello\"|]\n   > t = \"Hello\\tyou\";\n   > write(t,[|t|],\"\\n\");\n   Hello\tyou[|\"Hello\\tyou\"|]\n\nExample 3: \n   > write(x + 2 + exp(sin(x))) > \"foo.sol\";\n   > readfile(\"foo.sol\");\n   x + 2 + exp(sin(x))\n\nExample 4: \n   > write(x + 2 + exp(sin(x))) >> \"foo.sol\";\n\nSee also: print, printexpansion, printdouble, printsingle, printxml, readfile, autosimplify, display, midpointmode, fullparentheses, evaluate, roundingwarnings, autosimplify\n"
#define HELP_XFREEVARIABLE_TEXT "Name: _x_\n==> universal name for the mathematical free variable.\n\nLibrary names:\n   sollya_obj_t sollya_lib_free_variable()\n   sollya_obj_t sollya_lib_build_function_free_variable()\n   #define SOLLYA_X_ (sollya_lib_build_function_free_variable())\n\nDescription: \n   * _x_ is an identifier that always denotes the mathematical free variable.\n   It cannot be assigned.\n\n   * Sollya manipulates mathematical functions of a single variable. The first\n   time that a variable name is used without having been assigned before, this\n   variable name is automatically considered by Sollya as the name of the\n   free variable. Subsequently, any other unassigned variable name will be\n   considered as the free variable with a warning making this conversion\n   explicit. This is convenient for an every-day use of the interactive tool,\n   but it has the drawback that the free variable name can change from a\n   session to another. There are contexts (e.g., within a procedure, or for\n   doing pattern matching) when one might want to refer to the free variable\n   regardless of its name in the current session. For this purpose _x_ is\n   a universal identifier, always available and always denoting the free\n   variable, whatever its name is in the current context.\n\n   * _x_ can be used to retrieve the name of the current free variable as a\n   string by simply concatenating it to \"\".\n\nExample 1: \n   > verbosity=1!;\n   > sin(a);\n   sin(a)\n   > b;\n   Warning: the identifier \"b\" is neither assigned to, nor bound to a library function nor external procedure, nor equal to the current free variable.\n   Will interpret \"b\" as \"a\".\n   a\n   > _x_;\n   a\n\nExample 2: \n   > verbosity=1!;\n   > sin(y);\n   sin(y)\n   > f = proc(a) {\n       return sin(a + _x_);\n     };\n   > rename(y,z);\n   Information: the free variable has been renamed from \"y\" to \"z\".\n   > f(1);\n   sin(1 + z)\n\nExample 3: \n   > f = sin(y);\n   > match f with\n       sin(a) : { print(\"sin of a with a =\", a);\n                  match a with\n                    _x_ : { print(\"a turns out to be the free variable\"); }\n     \t       default : { print(\"a is some expression\"); };\n                }\n       _x_ : { print(\"Free variable\") ; }\n       default: { print(\"Something else\"); };\n   sin of a with a = y\n   a turns out to be the free variable\n\nExample 4: \n   > sin(wurst);\n   sin(wurst)\n   > varname = _x_ @ \"\";\n   > print(\"The current name of the free variable is \" @ varname);\n   The current name of the free variable is wurst\n\nSee also: rename, isbound, proc\n"
#define HELP_PRINTXML_TEXT "Name: printxml\n==> prints an expression as an MathML-Content-Tree\n\nLibrary names:\n   void sollya_lib_printxml(sollya_obj_t)\n   void sollya_lib_printxml_newfile(sollya_obj_t, sollya_obj_t)\n   void sollya_lib_printxml_appendfile(sollya_obj_t, sollya_obj_t)\n\nUsage: \n   printxml({expr}) : function -> void\n   printxml({expr}) > {filename} : (function, string) -> void\n   printxml({expr}) > > {filename} : (function, string) -> void\n\nParameters: \n   {expr} represents a functional expression\n   {filename} represents a character sequence indicating a file name\n\nDescription: \n   * The command printxml is now considered DEPRECATED in Sollya.\n\n   * printxml({expr}) prints the functional expression {expr} as a tree of\n   MathML Content Definition Markups. This XML tree can be re-read in\n   external tools or by usage of the readxml command.\n    \n   If a second argument {filename} is given after a single \">\", the\n   MathML tree is not output on the standard output of Sollya but if in\n   the file {filename} that get newly created or overwritten. If a double\n   \">\" is given, the output will be appended to the file {filename}.\n\nExample 1: \n   > printxml(x + 2 + exp(sin(x)));\n   \n   <?xml version=\"1.0\" encoding=\"UTF-8\"?>\n   <!-- generated by sollya: http://sollya.org/ -->\n   <!-- syntax: printxml(...);   example: printxml(x^2-2*x+5); -->\n   <?xml-stylesheet type=\"text/xsl\" href=\"http://sollya.org/mathmlc2p-web.xsl\"?>\n   <?xml-stylesheet type=\"text/xsl\" href=\"mathmlc2p-web.xsl\"?>\n   <!-- This stylesheet allows direct web browsing of MathML-c XML files (http:// or file://) -->\n   \n   <math xmlns=\"http://www.w3.org/1998/Math/MathML\">\n   <semantics>\n   <annotation-xml encoding=\"MathML-Content\">\n   <lambda>\n   <bvar><ci> x </ci></bvar>\n   <apply>\n   <apply>\n   <plus/>\n   <apply>\n   <plus/>\n   <ci> x </ci>\n   <cn type=\"integer\" base=\"10\"> 2 </cn>\n   </apply>\n   <apply>\n   <exp/>\n   <apply>\n   <sin/>\n   <ci> x </ci>\n   </apply>\n   </apply>\n   </apply>\n   </apply>\n   </lambda>\n   </annotation-xml>\n   <annotation encoding=\"sollya/text\">(x + 1b1) + exp(sin(x))</annotation>\n   </semantics>\n   </math>\n   \n\nExample 2: \n   > printxml(x + 2 + exp(sin(x))) > \"foo.xml\";\n\nExample 3: \n   > printxml(x + 2 + exp(sin(x))) >> \"foo.xml\";\n\nSee also: readxml, print, write\n"
#define HELP_READXML_TEXT "Name: readxml\n==> reads an expression written as a MathML-Content-Tree in a file\n\nLibrary name:\n   sollya_obj_t sollya_lib_readxml(sollya_obj_t)\n\nUsage: \n   readxml({filename}) : string -> function | error\n\nParameters: \n   {filename} represents a character sequence indicating a file name\n\nDescription: \n   * The command readxml is now considered DEPRECATED in Sollya.\n\n   * readxml({filename}) reads the first occurrence of a lambda\n   application with one bounded variable on applications of the supported\n   basic functions in file {filename} and returns it as a Sollya\n   functional expression.\n    \n   If the file {filename} does not contain a valid MathML-Content tree,\n   readxml tries to find an \"annotation encoding\" markup of type\n   \"sollya/text\". If this annotation contains a character sequence\n   that can be parsed by parse, readxml returns that expression.  Otherwise\n   readxml displays a warning and returns an error variable of type\n   error.\n\nExample 1: \n   > readxml(\"readxmlexample.xml\");\n   2 + x + exp(sin(x))\n\nSee also: printxml, readfile, parse, error\n"
#define HELP_SUPNORM_TEXT "Name: supnorm\n==> computes an interval bounding the supremum norm of an approximation error (absolute or relative) between a given polynomial and a function.\n\nLibrary name:\n   sollya_obj_t sollya_lib_supnorm(sollya_obj_t, sollya_obj_t, sollya_obj_t,\n                                   sollya_obj_t, sollya_obj_t)\n\nUsage: \n   supnorm({p}, {f}, {I}, {errorType}, {accuracy}) : (function, function, range, absolute|relative, constant) -> range\n\nParameters: \n   {p} is a polynomial.\n   {f} is a function.\n   {I} is an interval.\n   {errorType} is the type of error to be considered: absolute or relative (see details below).\n   {accuracy} is a constant that controls the relative tightness of the interval returned. \n\nDescription: \n   * supnorm({p}, {f}, {I}, {errorType}, {accuracy}) tries to compute an\n   interval bound r=[l,u] for the supremum norm of the error function\n   epsilon_absolute=p-f (when {errorType} evaluates to absolute)\n   or epsilon_relative=p/f-1 (when {errorType} evaluates to relative),\n   over the interval I, such that sup{|epsilon(x)|, x in I} C r\n   and 0<|u/l-1|< {accuracy}. If supnorm succeeds in computing a suitable\n   interval r, which it returns, that interval is guaranteed to contain the\n   supremum norm value and to satisfy the required quality. Otherwise, supnorm\n   evaluates to error, displaying a corresponding error message. These failure\n   cases are rare and basically happen only for functions which are too\n   complicated.\n\n   * Roughly speaking, supnorm is based on taylorform to obtain a higher\n   degree polynomial approximation for {f}. This process is coupled with\n   an a posteriori validation of a potential supremum norm upper bound. \n   The validation is based on showing a certain polynomial the problem gets\n   reduced to does not vanish. In cases when this process alone does not \n   succeed, for instance because taylorform is unable to compute a \n   sufficiently good approximation to {f}, supnorm falls back to\n   bisecting the working interval until safe supremum norm bounds can be\n   computed with the required accuracy or until the width of the\n   subintervals becomes less than diam times the original interval {I}, \n   in which case supnorm fails.\n\n   * The algorithm used for supnorm is quite complex, which makes it impossible \n   to explain it here in further detail. \n   Please find a complete description in the following article:\n    \n      Sylvain Chevillard, John Harrison, Mioara Joldes, Christoph Lauter\n      Efficient and accurate computation of upper bounds of approximation errors\n      Journal of Theoretical Computer Science (TCS), 2011, 412(16), p.1523-1543\n      https://hal.science/ensl-00445343\n\n   * In practical cases, supnorm should be able to automatically handle\n   removable discontinuities that relative errors might have. This means\n   that usually, if {f} vanishes at a point x0 in the interval\n   considered, the approximation polynomial {p} is designed such that it\n   also vanishes at the same point with a multiplicity large\n   enough. Hence, although {f} vanishes, epsilon_relative=p/f-1 may be \n   defined by continuous extension at such points x0, called \n   removable discontinuities (see Example 3).\n\nExample 1: \n   > p = remez(exp(x), 5, [-1;1]);\n   > midpointmode=on!;\n   > supnorm(p, exp(x), [-1;1], absolute, 2^(-40));\n   0.45205513967~0/2~e-4\n\nExample 2: \n   > prec=200!;\n   > midpointmode=on!;\n   > d = [1;2];\n   > f = exp(cos(x)^2 + 1);\n   > p = remez(1,15,d,1/f,1e-40);\n   > theta=1b-60;\n   > prec=default!;\n   > mode=relative;\n   > supnorm(p,f,d,mode,theta);\n   0.30893006200251428~5/6~e-13\n\nExample 3: \n   > midpointmode=on!;\n   > mode=relative;\n   > theta=1b-135;\n   > d = [-1b-2;1b-2];\n   > f = expm1(x);\n   > p = x * (1 +  x * ( 2097145 * 2^(-22) + x * ( 349527 * 2^(-21) + x * (87609 * 2^(-21) + x * 4369 * 2^(-19))))); \n   > theta=1b-40;\n   > supnorm(p,f,d,mode,theta);\n   0.98349131972~2/3~e-7\n\nSee also: dirtyinfnorm, infnorm, checkinfnorm, absolute, relative, taylorform, autodiff, numberroots, diam\n"
#define HELP_INFNORM_TEXT "Name: infnorm\n==> computes an interval bounding the infinity norm of a function on an interval.\n\nLibrary names:\n   sollya_obj_t sollya_lib_infnorm(sollya_obj_t, sollya_obj_t, ...)\n   sollya_obj_t sollya_lib_v_infnorm(sollya_obj_t, sollya_obj_t, va_list)\n\nUsage: \n   infnorm({f},{I},{filename},{Ilist}) : (function, range, string, list) -> range\n\nParameters: \n   {f} is a function.\n   {I} is an interval.\n   {filename} (optional) is the name of the file into a proof will be saved.\n   {IList} (optional) is a list of intervals to be excluded.\n\nDescription: \n   * infnorm({f},{range}) computes an interval bounding the infinity norm of the \n   given function f on the interval I, e.g. computes an interval J\n   such that max {|f(x)|, x in I} C J.\n\n   * If {filename} is given, a proof in English will be produced (and stored in file\n   called {filename}) proving that  max {|f(x)|, x in I} C J.\n   This feature of English proof generation is considered DEPRECATED in Sollya. The\n   feature will be removed in future versions of Sollya.\n\n   * If a list {IList} of intervals {I1}, ... ,{In} is given, the infinity norm will\n   be computed on I \\ (I1 U ... U I2).\n\n   * The function {f} is assumed to be at least twice continuous on {I}. More \n   generally, if {f} is Ck, global variables hopitalrecursions and\n   taylorrecursions must have values not greater than k.  \n\n   * If the interval is reduced to a single point, the result of infnorm is an \n   interval containing the exact absolute value of {f} at this point.\n\n   * If the interval is not bound, the result will be [0, +Inf] \n   which is correct but perfectly useless. infnorm is not meant to be used with \n   infinite intervals.\n\n   * The result of this command depends on the global variables prec, diam,\n   taylorrecursions and hopitalrecursions. The contribution of each variable is \n   not easy even to analyse.\n    \n      - The algorithm uses interval arithmetic with precision prec. The\n        precision should thus be set high enough to ensure that no critical\n        cancellation will occur.\n      - When an evaluation is performed on an interval [a,b], if the result\n        is considered being too large, the interval is split into [a,(a+b)/2]\n        and [(a+b)/2,b] and so on recursively. This recursion step\n        is  not performed if the (b-a) < d*|I| where d is the value\n        of variable diam. In other words, diam controls the minimum length of an\n        interval during the algorithm.\n      - To perform the evaluation of a function on an interval, Taylor's rule is\n        applied, e.g. f([a,b]) C f(m) + [a-m, b-m]*f'([a,b])\n        where m=(a+b)/2. This rule is recursively applied n times\n        where n is the value of variable taylorrecursions. Roughly speaking,\n        the evaluations will avoid decorrelation up to order n.\n      - When a function of the form g/h has to be evaluated on an\n        interval [a,b] and when g and h vanish at a same point\n        z of the interval, the ratio may be defined even if the expression\n        g(z)/h(z)=0/0 does not make any sense. In this case, L'Hopital's rule\n        may be used and (g/h)([a,b]) C (g'/h')([a,b]).\n        Since the same can occur with the ratio g'/h', the rule is applied\n        recursively. The variable hopitalrecursions controls the number of \n        recursion steps.\n    \n\n   * The algorithm used for this command is quite complex to be explained here. \n   Please find a complete description in the following article:\n        S. Chevillard and C. Lauter\n        A certified infinite norm for the implementation of elementary functions\n        QSIC 2007 - 7th International Conference on Quality Software, p.1-9\n        https://hal.science/hal-02102507v2\n\n   * Users should be aware about the fact that the algorithm behind\n   infnorm is inefficient in most cases and that other, better suited\n   algorithms, such as supnorm, are available inside Sollya. As a\n   matter of fact, while infnorm is maintained for compatibility reasons\n   with legacy Sollya codes, users are advised to avoid using infnorm\n   in new Sollya scripts and to replace it, where possible, by the\n   supnorm command.\n\nExample 1: \n   > infnorm(exp(x),[-2;3]);\n   [20.085536923187667740928529654581717896987907838554;20.0855369231876677409285296545817178969879078385544]\n\nExample 2: \n   > infnorm(exp(x),[-2;3],[| [0;1], [2;2.5] |]);\n   [20.085536923187667740928529654581717896987907838554;20.0855369231876677409285296545817178969879078385544]\n\nExample 3: \n   > infnorm(exp(x),[1;1]);\n   [2.7182818284590452353602874713526624977572470936999;2.7182818284590452353602874713526624977572470937]\n\nExample 4: \n   > infnorm(exp(x), [log(0);log(1)]);\n   [0;infty]\n\nSee also: prec, diam, hopitalrecursions, taylorrecursions, dirtyinfnorm, checkinfnorm, supnorm, findzeros, diff, taylorrecursions, autodiff, numberroots, taylorform\n"
#endif /* ifdef HELP_H*/
